/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.api.util;

import com.jxdinfo.hussar.formdesign.app.frame.api.enums.DateEnum;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.Objects;

public class TimeRangeCalculator {
    public static LocalDateTime[] getTimeRange(DateEnum dateEnum) {
        LocalDate endDate;
        LocalDate startDate;
        LocalTime starTime = LocalTime.of(0, 0, 0);
        LocalTime endTime = LocalTime.of(23, 59, 59);
        LocalDate today = LocalDate.now();
        switch (Objects.requireNonNull(dateEnum)) {
            case TODAY: {
                startDate = today;
                endDate = today;
                break;
            }
            case YESTERDAY: {
                startDate = today.minusDays(1L);
                endDate = today.minusDays(1L);
                break;
            }
            case TOMORROW: {
                startDate = today.plusDays(1L);
                endDate = today.plusDays(1L);
                break;
            }
            case THIS_WEEK: {
                startDate = today.with(TemporalAdjusters.previous(DayOfWeek.MONDAY));
                endDate = today.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
                break;
            }
            case NEXT_WEEK: {
                startDate = today.with(TemporalAdjusters.next(DayOfWeek.MONDAY));
                endDate = startDate.with(TemporalAdjusters.next(DayOfWeek.SUNDAY));
                break;
            }
            case LAST_WEEK: {
                startDate = today.with(TemporalAdjusters.previous(DayOfWeek.MONDAY));
                endDate = startDate.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
                break;
            }
            case THIS_MONTH: {
                startDate = today.withDayOfMonth(1);
                endDate = today.withDayOfMonth(today.lengthOfMonth());
                break;
            }
            case NEXT_MONTH: {
                LocalDate firstDayOfNextMonth = today.plusMonths(1L).withDayOfMonth(1);
                endDate = firstDayOfNextMonth.plusMonths(1L).minusDays(1L);
                startDate = firstDayOfNextMonth;
                break;
            }
            case LAST_MONTH: {
                LocalDate firstDayOfPreviousMonth = today.minusMonths(1L).withDayOfMonth(1);
                endDate = today.withDayOfMonth(1).minusDays(1L);
                startDate = firstDayOfPreviousMonth;
                break;
            }
            case THIS_QUARTER: {
                int currentMonth = today.getMonthValue();
                int startMonth = (currentMonth - 1) / 3 * 3 + 1;
                startDate = today.withMonth(startMonth).withDayOfMonth(1);
                endDate = startDate.plusMonths(2L).with(TemporalAdjusters.lastDayOfMonth());
                break;
            }
            case NEXT_QUARTER: {
                int nextQuarterStartMonth = ((today.getMonthValue() - 1) / 3 + 1) * 3 + 1;
                startDate = nextQuarterStartMonth > 12 ? today.withMonth(1).withDayOfMonth(1).plusYears(1L) : today.withMonth(nextQuarterStartMonth).withDayOfMonth(1);
                endDate = startDate.plusMonths(2L).with(TemporalAdjusters.lastDayOfMonth());
                break;
            }
            case LAST_QUARTER: {
                int previousQuarterStartMonth = ((today.getMonthValue() - 1) / 3 - 1) * 3 + 1;
                startDate = previousQuarterStartMonth < 1 ? today.withMonth(10).withDayOfMonth(1).minusYears(1L) : today.withMonth(previousQuarterStartMonth).withDayOfMonth(1);
                endDate = startDate.plusMonths(2L).with(TemporalAdjusters.lastDayOfMonth());
                break;
            }
            case THIS_YEAR: {
                startDate = today.withDayOfYear(1);
                endDate = today.with(TemporalAdjusters.lastDayOfYear());
                break;
            }
            case NEXT_YEAR: {
                startDate = today.withDayOfYear(1).plusYears(1L);
                endDate = startDate.with(TemporalAdjusters.lastDayOfYear());
                break;
            }
            case LAST_YEAR: {
                startDate = today.withDayOfYear(1).minusYears(1L);
                endDate = startDate.with(TemporalAdjusters.lastDayOfYear());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported query: " + (Object)((Object)dateEnum));
            }
        }
        LocalDateTime startDateTime = startDate.atTime(starTime);
        LocalDateTime endDateTime = endDate.atTime(endTime);
        return new LocalDateTime[]{startDateTime, endDateTime};
    }
}

