/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.api.enums;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;

public enum ExcelImportErrorType {
    USER("1", "\u7528\u6237\u5339\u914d\u9519\u8bef"),
    ORGAN("2", "\u7ec4\u7ec7\u673a\u6784\u5339\u914d\u9519\u8bef"),
    YESORNO("3", "\u662f/\u5426\u5339\u914d\u9519\u8bef"),
    TIME("4", "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef"),
    NUMBER("5", "\u6570\u5b57\u683c\u5f0f\u9519\u8bef"),
    WIDGETNULL("6", "\u672a\u627e\u5230\u5339\u914d\u7684\u6570\u636e\u7c7b\u578b"),
    DATANULL("7", "\u672a\u627e\u5230\u5339\u914d\u7684\u6570\u636e");

    private String errorType;
    private String errorMessage;

    private ExcelImportErrorType(String errorType, String errorMessage) {
        this.errorType = errorType;
        this.errorMessage = errorMessage;
    }

    public static String getErrorMessageByType(String errorType) {
        String message = null;
        if (HussarUtils.isEmpty((Object)errorType)) {
            return message;
        }
        switch (errorType) {
            case "1": {
                message = USER.getErrorMessage();
                break;
            }
            case "2": {
                message = ORGAN.getErrorMessage();
                break;
            }
            case "3": {
                message = YESORNO.getErrorMessage();
                break;
            }
            case "4": {
                message = TIME.getErrorMessage();
                break;
            }
            case "5": {
                message = NUMBER.getErrorMessage();
                break;
            }
            case "6": {
                message = WIDGETNULL.getErrorMessage();
                break;
            }
            case "7": {
                message = DATANULL.getErrorMessage();
                break;
            }
            default: {
                return message;
            }
        }
        return message;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

