/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.feign;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.quote.relation.model.SysQuoteRelation;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formdesign/quote"})
public class QuoteController {
    @Autowired(required=false)
    private SysQuoteRelationService sysQuoteRelationService;

    @GetMapping(value={"/getAllQuote"})
    public ApiResponse<List<SysQuoteRelation>> getAllQuoteList() {
        return this.sysQuoteRelationService.getAllQuoteList();
    }

    @RequestMapping(value={"/addQuote/{referResId}"})
    public ApiResponse<SysQuoteRelation> deleteAndAddQuote(@PathVariable String referResId, @RequestBody List<SysQuoteRelation> sysQuoteRelationList) {
        return this.sysQuoteRelationService.deleteAndAddQuote(referResId, sysQuoteRelationList);
    }

    @GetMapping(value={"/getQuote/{resId}"})
    public ApiResponse<List<SysQuoteRelation>> getQuote(@PathVariable String resId) {
        return this.sysQuoteRelationService.getQuoteRelation(resId);
    }

    @GetMapping(value={"/getQuoteByReferResid/{referResId}"})
    public ApiResponse<List<SysQuoteRelation>> getQuoteRelationByReferResid(@PathVariable String referResId) {
        return this.sysQuoteRelationService.getQuoteRelationByReferResid(referResId);
    }

    @GetMapping(value={"/deleteQuoteByReferResId/{referResId}"})
    public ApiResponse<String> deleteQuoteByReferResId(@PathVariable String referResId) {
        return this.sysQuoteRelationService.deleteQuoteRelationByReferResid(referResId);
    }

    @GetMapping(value={"/copyQuoteByReferResid/{oldReferResId}/{newReferResId}"})
    public ApiResponse<String> copyQuoteByReferResid(@PathVariable String oldReferResId, @PathVariable String newReferResId) {
        return this.sysQuoteRelationService.copyQuoteRelation(oldReferResId, newReferResId);
    }

    @PostMapping(value={"/getQuoteList"})
    public ApiResponse<Map<String, List<SysQuoteRelation>>> getQuoteList(@RequestBody List<String> resIdList) {
        return this.sysQuoteRelationService.getQuoteList(resIdList);
    }

    @GetMapping(value={"/getQuoteIdList/{referResId}/{useType}"})
    public ApiResponse<List<String>> getQuoteIdList(@PathVariable String referResId, @PathVariable String useType) {
        return this.sysQuoteRelationService.getQuoteIdList(referResId, useType);
    }
}

