/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.devtools.gitlab.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.jgit.api.CloneCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.CreateBranchCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.FetchCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.Git;
import com.jxdinfo.hussar.formdesign.jgit.api.PullCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.PushCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.ResetCommand;
import com.jxdinfo.hussar.formdesign.jgit.api.errors.GitAPIException;
import com.jxdinfo.hussar.formdesign.jgit.lib.Ref;
import com.jxdinfo.hussar.formdesign.jgit.lib.StoredConfig;
import com.jxdinfo.hussar.formdesign.jgit.revwalk.RevCommit;
import com.jxdinfo.hussar.formdesign.jgit.transport.CredentialsProvider;
import com.jxdinfo.hussar.formdesign.jgit.transport.RefSpec;
import com.jxdinfo.hussar.formdesign.jgit.transport.URIish;
import com.jxdinfo.hussar.formdesign.jgit.transport.UsernamePasswordCredentialsProvider;
import com.jxdinfo.hussar.formdesign.jgit.util.FileUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.UserApi;
import org.gitlab4j.api.models.AcceptMergeRequestParams;
import org.gitlab4j.api.models.CompareResults;
import org.gitlab4j.api.models.MergeRequest;
import org.gitlab4j.api.models.MergeRequestParams;
import org.gitlab4j.api.models.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevCloudUtil {
    private static final Logger logger = LoggerFactory.getLogger(DevCloudUtil.class);
    private static final String API_V4_PROJECTS = "/api/v4/projects/";
    private static final String PRIVATE_TOKEN_HEADER = "private-token";
    private static final String JSON_KEY_ERROR = "error";

    public static void createProject(File localDir, String gitUrl, String projectName, String commitMsg, String accessToken) {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        try (Git git = null;){
            git = Git.init().setDirectory(localDir).call();
            StoredConfig config = git.getRepository().getConfig();
            config.setString("remote", "origin", "url", gitUrl + projectName + ".git");
            config.save();
            git.commit().setMessage(commitMsg).call();
            ((PushCommand)git.push().setRemote("origin").setCredentialsProvider((CredentialsProvider)provider)).setRefSpecs(new RefSpec[]{new RefSpec("master")}).call();
            git.getRepository().close();
        }
    }

    public static void push(File localDir, String gitUrl, String commitMsg, String accessToken) {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        try (Git git = null;){
            git = Git.init().setDirectory(localDir).call();
            git.add().addFilepattern(".").call();
            git.add().addFilepattern(".").setUpdate(true).call();
            User user = DevCloudUtil.getUser(gitUrl, accessToken);
            git.getRepository().getConfig().setString("user", null, "name", user.getUsername());
            git.commit().setMessage(commitMsg).call();
            String currentBranch = git.getRepository().getBranch();
            ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)provider)).setForce(true).setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec(currentBranch)}).call();
        }
    }

    public static void push(File localDir, String gitUrl, String projectName, String commitMsg, String accessToken, String branch) {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        try (Git git = null;){
            git = Git.init().setDirectory(localDir).call();
            StoredConfig config = git.getRepository().getConfig();
            config.setString("remote", "origin", "url", gitUrl + projectName + ".git");
            config.save();
            String currentBranch = git.getRepository().getBranch();
            git.checkout().setName(branch).call();
            git.add().addFilepattern(".").call();
            git.add().addFilepattern(".").setUpdate(true).call();
            git.commit().setMessage(commitMsg).call();
            ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)provider)).setForce(true).setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec(currentBranch)}).call();
        }
    }

    public static void pushSpecifiedFile(File localDir, String gitUrl, String projectName, String commitMsg, String accessToken, String branch, String path, List<String> filesToAdd) {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        try (Git git = null;){
            git = Git.init().setDirectory(localDir).call();
            StoredConfig config = git.getRepository().getConfig();
            config.setString("remote", "origin", "url", gitUrl + projectName + ".git");
            config.save();
            String currentBranch = git.getRepository().getBranch();
            git.checkout().setName(branch).call();
            for (String file : filesToAdd) {
                String relativePath = ".";
                if (!file.equals(path)) {
                    relativePath = DevCloudUtil.formatToDividePath(file.substring(path.length() + 1));
                }
                git.add().addFilepattern(relativePath).call();
                git.add().addFilepattern(relativePath).setUpdate(true).call();
            }
            git.commit().setMessage(commitMsg).call();
            ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)provider)).setForce(true).setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec(currentBranch)}).call();
        }
    }

    public static void pushSpecifiedFileNotCommit(File localDir, String gitUrl, String projectName, String accessToken, String branch, String path, List<String> filesToAdd) {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        try (Git git = null;){
            git = Git.init().setDirectory(localDir).call();
            StoredConfig config = git.getRepository().getConfig();
            config.setString("remote", "origin", "url", gitUrl + projectName + ".git");
            config.save();
            String currentBranch = git.getRepository().getBranch();
            git.checkout().setName(branch).call();
            StringBuilder paths = new StringBuilder();
            for (String file : filesToAdd) {
                String relativePath = ".";
                if (!file.equals(path)) {
                    relativePath = DevCloudUtil.formatToDividePath(file.substring(path.length() + 1));
                    paths.append(relativePath).append("\uff0c");
                }
                git.add().addFilepattern(relativePath).call();
                git.add().addFilepattern(relativePath).setUpdate(true).call();
            }
            logger.info("====================\u5f00\u59cb\u63a8\u9001\u81f3\u8fdc\u7aef\uff1a{}=======================", (Object)paths);
            ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)provider)).setForce(true).setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec(currentBranch)}).call();
            logger.info("====================\u63a8\u9001\u81f3\u8fdc\u7aef\u7ed3\u675f=======================");
        }
    }

    private static String formatToDividePath(String path) {
        return path.replace("\\", "/").replace("\\\\", "/").replace(File.separator, "/");
    }

    public static void createDevBranch(File localDir, String accessToken, String branch) {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        try (Git git = null;){
            git = Git.init().setDirectory(localDir).call();
            List branches = git.branchList().call();
            boolean branchExists = branches.stream().anyMatch(ref -> ref.getName().equals("refs/heads/" + branch));
            if (!branchExists) {
                git.branchCreate().setName(branch).call();
            }
            git.checkout().setName(branch).call();
            String currentBranch = git.getRepository().getBranch();
            ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)provider)).setForce(true).setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec(currentBranch + ":" + branch)}).call();
        }
    }

    private static User getUser(String uri, String accessToken) {
        User user;
        int index = uri.indexOf("/", uri.indexOf("/") + 2) + 1;
        String hostUrl = uri.substring(0, index);
        try (GitLabApi gitLabApi = new GitLabApi(hostUrl, accessToken);){
            UserApi userApi = gitLabApi.getUserApi();
            user = userApi.getCurrentUser();
        }
        catch (GitLabApiException e) {
            if (e.getHttpStatus() == 401 || e.getHttpStatus() == 400) {
                throw new HussarException("\u8eab\u4efd\u9a8c\u8bc1\u672a\u901a\u8fc7");
            }
            throw new HussarException((Throwable)e);
        }
        return user;
    }

    public static void delProject(String gitUri, String projectName, String accessToken, String groupName) {
        try (GitLabApi gitLabApi = new GitLabApi(gitUri, accessToken);){
            String projectId = DevCloudUtil.getProjectIdByGroupIdAndName(gitUri, projectName, accessToken, groupName);
            gitLabApi.getProjectApi().deleteProject((Object)projectId);
            logger.info("\u9879\u76ee\u5df2\u6210\u529f\u5220\u9664:{}", (Object)projectId);
        }
        catch (GitLabApiException e) {
            logger.info("\u9879\u76ee\u5220\u9664\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    public static void pull(String uri, String localGitPath, String branch, String accessToken) throws HussarException {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        Git git = null;
        if (DevCloudUtil.checkLocalRep(localGitPath)) {
            try {
                Path folder = Paths.get(localGitPath, ".git");
                if (!Files.exists(folder, new LinkOption[0]) || !Files.isDirectory(folder, new LinkOption[0])) {
                    DevCloudUtil.initGit(uri, branch, (CredentialsProvider)provider, new File(localGitPath));
                    return;
                }
                git = Git.open((File)new File(localGitPath));
                ((FetchCommand)git.fetch().setCredentialsProvider((CredentialsProvider)provider)).call();
                String currentBranch = git.getRepository().getBranch();
                String upstreamBranch = git.getRepository().getConfig().getString("branch", currentBranch, "merge");
                if (upstreamBranch == null || !upstreamBranch.equals("refs/heads/" + branch)) {
                    git.getRepository().close();
                    FileUtils.delete((File)new File(localGitPath), (int)1);
                    int index = localGitPath.indexOf(File.separator + ".git");
                    String localPath = localGitPath.substring(0, index);
                    File local = new File(localPath);
                    DevCloudUtil.initGit(uri, branch, (CredentialsProvider)provider, local);
                    return;
                }
                git.reset().setMode(ResetCommand.ResetType.HARD).setRef("origin/" + branch).call();
                ((PullCommand)git.pull().setCredentialsProvider((CredentialsProvider)provider)).setRemoteBranchName(branch).call();
            }
            catch (Exception e) {
                throw new HussarException((Throwable)e);
            }
            finally {
                if (git != null) {
                    git.close();
                }
            }
        }
        String localPath = "";
        int index = localGitPath.indexOf(File.separator + ".git");
        localPath = index > 0 ? localGitPath.substring(0, index) : localGitPath;
        File local = new File(localPath);
        if (local.exists()) {
            DevCloudUtil.initGit(uri, branch, (CredentialsProvider)provider, local);
        } else {
            try {
                git = ((CloneCommand)Git.cloneRepository().setCredentialsProvider((CredentialsProvider)provider)).setURI(uri).setBranch(branch).setDirectory(local).call();
            }
            catch (Exception e) {
                throw new HussarException((Throwable)e);
            }
            finally {
                if (git != null) {
                    git.close();
                }
            }
        }
    }

    public static Boolean createRemoteBranch(String gitUri, String groupId, String branch, String refName, String accessToken) {
        CloseableHttpClient httpclients = null;
        try {
            httpclients = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(gitUri + API_V4_PROJECTS + groupId + "/repository/branches");
            httpPost.setHeader(PRIVATE_TOKEN_HEADER, accessToken);
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            pairs.add(new BasicNameValuePair("branch", branch));
            pairs.add(new BasicNameValuePair("ref", refName));
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(pairs, StandardCharsets.UTF_8);
            httpPost.setEntity((HttpEntity)formEntity);
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject.containsKey((Object)JSON_KEY_ERROR) || jsonObject.containsKey((Object)"message")) {
                String msg = jsonObject.getString(JSON_KEY_ERROR) == null ? jsonObject.getString("message") : jsonObject.getString(JSON_KEY_ERROR);
                throw new HussarException("\u521b\u5efa\u5206\u652f\u5931\u8d25, " + msg);
            }
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new HussarException((Throwable)e);
                }
            }
        }
    }

    public static String checkoutBranch(File localDir, String accessToken, String branch) throws HussarException {
        String currentBranch = "";
        try (Git git = Git.open((File)localDir);){
            if (Boolean.TRUE.equals(DevCloudUtil.branchNameExist(git, branch))) {
                git.checkout().setCreateBranch(false).setName(branch).call();
            } else {
                git.checkout().setCreateBranch(true).setName(branch).setStartPoint("origin/" + branch).call();
            }
            currentBranch = branch;
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
        return currentBranch;
    }

    public static Boolean branchNameExist(Git git, String branchName) throws GitAPIException {
        List refs = git.branchList().call();
        for (Ref ref : refs) {
            if (!ref.getName().contains(branchName)) continue;
            return true;
        }
        return false;
    }

    private static void initGit(String uri, String branch, CredentialsProvider provider, File local) {
        try (Git git = null;){
            git = Git.init().setInitialBranch(branch).setDirectory(local).call();
            git.remoteAdd().setUri(new URIish(uri)).setName("origin").call();
            ((FetchCommand)git.fetch().setCredentialsProvider(provider)).call();
            git.checkout().setCreateBranch(true).setName(branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + branch).setForced(true).call();
        }
    }

    private static boolean checkLocalRep(String localGitPath) {
        return new File(localGitPath).exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean branchExist(String gitUri, String branch, String accessToken, String groupId) {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(gitUri + API_V4_PROJECTS + groupId + "/repository/branches");
            httpGet.setHeader(PRIVATE_TOKEN_HEADER, accessToken);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
            JSONArray jsonArray = JSON.parseArray((String)result);
            ArrayList<String> branchList = new ArrayList<String>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)jsonArray.get(i)));
                String name = jsonObject.get((Object)"name").toString();
                branchList.add(name);
            }
            boolean bl = branchList.stream().anyMatch(ref -> ref.equals(branch));
            return bl;
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getProjectIdByGroupIdAndName(String gitUri, String typeName, String accessToken, String groupId) {
        CloseableHttpClient httpclients = null;
        try {
            httpclients = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(gitUri + "/api/v4/groups/" + groupId + "/projects?search=" + typeName);
            httpGet.setHeader(PRIVATE_TOKEN_HEADER, accessToken);
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
            JSONArray jsonArray = JSON.parseArray((String)result);
            int i = 0;
            while (i < jsonArray.size()) {
                if (typeName.equals(jsonArray.getJSONObject(i).getString("name"))) {
                    String string = jsonArray.getJSONObject(i).getString("id");
                    return string;
                }
                ++i;
            }
            throw new HussarException("\u9879\u76ee\u6216\u7fa4\u7ec4\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new HussarException((Throwable)e);
                }
            }
        }
    }

    public static Boolean setProtectBranch(String gitUri, String projectId, String branchName, String accessToken) {
        logger.info("\u8bbe\u7f6e\u4fdd\u62a4\u5206\u652f\uff1a===projectId--->{},branchName---->{}", (Object)projectId, (Object)branchName);
        CloseableHttpClient httpclients = null;
        try {
            httpclients = HttpClients.createDefault();
            HttpPut httpPut = new HttpPut(gitUri + API_V4_PROJECTS + projectId + "/repository/branches/" + branchName + "/protect");
            httpPut.setHeader(PRIVATE_TOKEN_HEADER, accessToken);
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            pairs.add(new BasicNameValuePair("branch", branchName));
            pairs.add(new BasicNameValuePair("id", projectId));
            pairs.add(new BasicNameValuePair("developers_can_push", "false"));
            pairs.add(new BasicNameValuePair("developers_can_merge", "false"));
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(pairs, StandardCharsets.UTF_8);
            httpPut.setEntity((HttpEntity)formEntity);
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpPut);
            StatusLine statusLine = response.getStatusLine();
            if (200 == statusLine.getStatusCode()) {
                Boolean bl = true;
                return bl;
            }
            try {
                throw new HussarException("\u8bbe\u7f6e\u4fdd\u62a4\u5206\u652f\u5931\u8d25");
            }
            catch (Exception e) {
                throw new HussarException((Throwable)e);
            }
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new HussarException((Throwable)e);
                }
            }
        }
    }

    public static Boolean unProtectBranch(String gitUri, String projectId, String branchName, String accessToken) {
        logger.info("\u53d6\u6d88\u4fdd\u62a4\u5206\u652f\uff1a===projectId--->{},branchName---->{}", (Object)projectId, (Object)branchName);
        CloseableHttpClient httpclients = null;
        try {
            httpclients = HttpClients.createDefault();
            HttpDelete httpDelete = new HttpDelete(gitUri + API_V4_PROJECTS + projectId + "/protected_branches/" + branchName);
            httpDelete.setHeader(PRIVATE_TOKEN_HEADER, accessToken);
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpDelete);
            StatusLine statusLine = response.getStatusLine();
            if (204 == statusLine.getStatusCode()) {
                Boolean bl = true;
                return bl;
            }
            Boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new HussarException((Throwable)e);
                }
            }
        }
    }

    public static void merge(String uri, String gitGroup, String projectName, String sourceBranch, String targetBranch, String title, String accessToken) {
        String path = gitGroup + "/" + projectName;
        try (GitLabApi gitLabApi = new GitLabApi(uri, accessToken);){
            List mergeRequestList = gitLabApi.getMergeRequestApi().getMergeRequests((Object)path, Constants.MergeRequestState.OPENED);
            for (MergeRequest request : mergeRequestList) {
                if (!sourceBranch.equals(request.getSourceBranch()) || !targetBranch.equals(request.getTargetBranch())) continue;
                throw new HussarException("\u5df2\u6709\u5f00\u542f\u4e2d\u7684\u5408\u5e76\u8bf7\u6c42");
            }
            CompareResults compareResults = gitLabApi.getRepositoryApi().compare((Object)path, targetBranch, sourceBranch);
            if (HussarUtils.isEmpty((Object)compareResults.getDiffs())) {
                throw new HussarException("\u5206\u652f\u6ca1\u6709\u5dee\u5f02\uff0c\u65e0\u6cd5\u5408\u5e76");
            }
            MergeRequestParams mergeRequestParams = new MergeRequestParams();
            mergeRequestParams.withTargetBranch(targetBranch).withSourceBranch(sourceBranch).withTitle(title);
            MergeRequest mergeRequest = gitLabApi.getMergeRequestApi().createMergeRequest((Object)path, mergeRequestParams);
            while ("checking".equals(mergeRequest.getMergeStatus())) {
                mergeRequest = gitLabApi.getMergeRequestApi().getMergeRequest((Object)path, mergeRequest.getIid());
            }
            if (Boolean.TRUE.equals(mergeRequest.getHasConflicts())) {
                throw new HussarException("\u5b58\u5728\u51b2\u7a81\uff0c\u8bf7\u524d\u5f80gitlab\u624b\u52a8\u89e3\u51b3");
            }
            logger.info("=================\u5408\u5e76\u8bf7\u6c42\u5df2\u63d0\u4ea4=================");
            AcceptMergeRequestParams acceptMergeRequestParams = new AcceptMergeRequestParams();
            acceptMergeRequestParams.withMergeCommitMessage("\u5408\u5e76[skip ci]");
            acceptMergeRequestParams.withMergeWhenPipelineSucceeds(Boolean.valueOf(false));
            gitLabApi.getMergeRequestApi().acceptMergeRequest((Object)path, mergeRequest.getIid(), acceptMergeRequestParams);
            logger.info("=================\u5408\u5e76\u6267\u884c\u5b8c\u6bd5=================");
        }
        catch (GitLabApiException e) {
            if (e.getHttpStatus() == 401 || e.getHttpStatus() == 400) {
                throw new HussarException("\u8eab\u4efd\u9a8c\u8bc1\u672a\u901a\u8fc7");
            }
            if (e.getHttpStatus() == 405) {
                logger.info("\u5408\u5e76develop\u5230\u4e2a\u4eba\u5f00\u53d1\u5206\u652f\u5931\u8d25\uff1a{}", (Object)"CI/CD\u6d41\u6c34\u7ebf\u5c1a\u672a\u6267\u884c\u6210\u529f");
                throw new HussarException("CI/CD\u6d41\u6c34\u7ebf\u5c1a\u672a\u6267\u884c\u6210\u529f");
            }
            throw new HussarException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkMergeRequest(String uri, String gitGroup, String projectName, String sourceBranch, String accessToken) {
        String path = gitGroup + "/" + projectName;
        try (GitLabApi gitLabApi = new GitLabApi(uri, accessToken);){
            MergeRequest request;
            List mergeRequestList = gitLabApi.getMergeRequestApi().getMergeRequests((Object)path, Constants.MergeRequestState.OPENED);
            if (!HussarUtils.isNotEmpty((Object)mergeRequestList)) return false;
            if (HussarUtils.isBlank((CharSequence)sourceBranch)) {
                boolean bl = true;
                return bl;
            }
            Iterator iterator = mergeRequestList.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!sourceBranch.equals((request = (MergeRequest)iterator.next()).getTargetBranch()));
            boolean bl = true;
            return bl;
        }
        catch (GitLabApiException e) {
            if (e.getHttpStatus() == 401) throw new HussarException("\u8eab\u4efd\u9a8c\u8bc1\u672a\u901a\u8fc7");
            if (e.getHttpStatus() != 400) throw new HussarException((Throwable)e);
            throw new HussarException("\u8eab\u4efd\u9a8c\u8bc1\u672a\u901a\u8fc7");
        }
    }

    public static String getGroupOrProjectId(String gitUri, String typeName, String accessToken, String type) {
        CloseableHttpClient httpclients = null;
        try {
            httpclients = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(gitUri + "/api/v4/" + type + "?search=" + typeName);
            httpGet.setHeader(PRIVATE_TOKEN_HEADER, accessToken);
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
            JSONArray jsonArray = JSON.parseArray((String)result);
            for (int i = 0; i < jsonArray.size(); ++i) {
                if (!typeName.equals(jsonArray.getJSONObject(i).getString("path"))) continue;
                String string = jsonArray.getJSONObject(i).getString("id");
                return string;
            }
            String string = "";
            return string;
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new HussarException((Throwable)e);
                }
            }
        }
    }

    public static void revertOrRemove(File localDir, List<String> fileToRevert) {
        Git git = null;
        if (ObjectUtils.isEmpty(fileToRevert)) {
            return;
        }
        try {
            git = Git.open((File)localDir);
            Iterable commits = git.log().call();
            ArrayList<String> revertFiles = new ArrayList<String>();
            for (RevCommit commit : commits) {
                for (String originFiles : fileToRevert) {
                    boolean pushed;
                    boolean commited = commit.getFullMessage().contains(originFiles);
                    boolean bl = pushed = git.getRepository().resolve(commit.getName() + "^{commit}") != null;
                    if (!commited || !pushed) continue;
                    revertFiles.add(originFiles);
                }
            }
            RevCommit lastCommit = (RevCommit)commits.iterator().next();
            ResetCommand reset = git.reset();
            reset.setRef(lastCommit.getName());
            revertFiles.forEach(arg_0 -> ((ResetCommand)reset).addPath(arg_0));
            reset.setMode(ResetCommand.ResetType.MIXED);
            reset.call();
            List<String> removeFiles = DevCloudUtil.findCollectionC(fileToRevert, revertFiles);
            for (String folderPath : removeFiles) {
                try {
                    FileUtils.delete((File)new File(folderPath), (int)1);
                    logger.info("Folder deleted: {}", (Object)folderPath);
                }
                catch (IOException e) {
                    logger.error("Failed to delete folder: {}", (Object)folderPath);
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
        finally {
            if (git != null) {
                git.close();
            }
        }
    }

    public static void commit(File localDir, String gitUrl, String projectName, String commitMsg, String accessToken, String branch, String path, List<String> filesToAdd) {
        try (Git git = null;){
            git = Git.init().setDirectory(localDir).call();
            StoredConfig config = git.getRepository().getConfig();
            config.setString("remote", "origin", "url", gitUrl + projectName + ".git");
            config.save();
            git.checkout().setName(branch).call();
            for (String file : filesToAdd) {
                String relativePath = ".";
                if (!file.equals(path)) {
                    relativePath = DevCloudUtil.formatToDividePath(file.substring(path.length() + 1));
                }
                git.add().addFilepattern(relativePath).call();
                git.add().addFilepattern(relativePath).setUpdate(true).call();
            }
            logger.info("====================\u5f00\u59cb\u63d0\u4ea4\u81f3\u672c\u5730=======================");
            git.commit().setMessage(commitMsg).call();
            logger.info("====================\u63d0\u4ea4\u81f3\u672c\u5730\u7ed3\u675f=======================");
        }
    }

    public static void pullNotReset(String uri, String localGitPath, String branch, String accessToken) {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        Git git = null;
        if (DevCloudUtil.checkLocalRep(localGitPath)) {
            try {
                Path folder = Paths.get(localGitPath, ".git");
                if (!Files.exists(folder, new LinkOption[0]) || !Files.isDirectory(folder, new LinkOption[0])) {
                    DevCloudUtil.initGit(uri, branch, (CredentialsProvider)provider, new File(localGitPath));
                    return;
                }
                git = Git.open((File)new File(localGitPath));
                ((FetchCommand)git.fetch().setCredentialsProvider((CredentialsProvider)provider)).call();
                String currentBranch = git.getRepository().getBranch();
                String upstreamBranch = git.getRepository().getConfig().getString("branch", currentBranch, "merge");
                if (upstreamBranch == null || !upstreamBranch.equals("refs/heads/" + branch)) {
                    git.getRepository().close();
                    FileUtils.delete((File)new File(localGitPath), (int)1);
                    int index = localGitPath.indexOf(File.separator + ".git");
                    String localPath = localGitPath.substring(0, index);
                    File local = new File(localPath);
                    DevCloudUtil.initGit(uri, branch, (CredentialsProvider)provider, local);
                    return;
                }
                logger.info("====================\u5f00\u59cb\u62c9\u53d6\u4ee3\u7801\u81f3\u672c\u5730=======================");
                ((PullCommand)git.pull().setCredentialsProvider((CredentialsProvider)provider)).setRemoteBranchName(branch).call();
                logger.info("====================\u62c9\u53d6\u4ee3\u7801\u81f3\u672c\u5730\u7ed3\u675f=======================");
            }
            catch (Exception e) {
                throw new HussarException((Throwable)e);
            }
            finally {
                if (git != null) {
                    git.close();
                }
            }
        }
    }

    private static List<String> findCollectionC(List<String> a, List<String> b) {
        ArrayList<String> c = new ArrayList<String>(a);
        CollectionUtils.filter(c, object -> !b.contains(object));
        return c;
    }
}

