/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.devtools.gitlab.util;

import java.net.URI;
import java.net.URISyntaxException;

public class UrlUtils {
    public static String buildUrl(String ... parts) {
        StringBuilder urlBuilder = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part != null && !part.isEmpty()) {
                if (urlBuilder.length() > 0 && urlBuilder.charAt(urlBuilder.length() - 1) != '/' && !part.startsWith("/")) {
                    urlBuilder.append("/");
                }
                urlBuilder.append(part);
            }
            if (i != parts.length - 1 || urlBuilder.toString().endsWith("/")) continue;
            urlBuilder.append("/");
        }
        try {
            URI uri = new URI(null, null, urlBuilder.toString(), null);
            return uri.toString();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getLastPartOfUrl(String url) {
        int lastIndex;
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if ((lastIndex = url.lastIndexOf("/")) == -1) {
            return url;
        }
        return url.substring(lastIndex + 1);
    }
}

