/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.devtools.gitlab.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FileUtils;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.UserApi;
import org.gitlab4j.api.models.AcceptMergeRequestParams;
import org.gitlab4j.api.models.CompareResults;
import org.gitlab4j.api.models.MergeRequest;
import org.gitlab4j.api.models.MergeRequestParams;
import org.gitlab4j.api.models.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevCloudUtil {
    private static final Logger logger = LoggerFactory.getLogger(DevCloudUtil.class);

    public static void createProject(File localDir, String gitUrl, String projectName, String commitMsg, String accessToken) {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        try (Git git = null;){
            git = Git.init().setDirectory(localDir).call();
            StoredConfig config = git.getRepository().getConfig();
            config.setString("remote", "origin", "url", gitUrl + projectName + ".git");
            config.save();
            git.commit().setMessage(commitMsg).call();
            ((PushCommand)git.push().setRemote("origin").setCredentialsProvider((CredentialsProvider)provider)).setRefSpecs(new RefSpec[]{new RefSpec("master")}).call();
            git.getRepository().close();
        }
    }

    public static void push(File localDir, String gitUrl, String commitMsg, String accessToken) {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        try (Git git = null;){
            git = Git.init().setDirectory(localDir).call();
            git.add().addFilepattern(".").call();
            git.add().addFilepattern(".").setUpdate(true).call();
            User user = DevCloudUtil.getUser(gitUrl, accessToken);
            git.getRepository().getConfig().setString("user", null, "name", user.getUsername());
            git.commit().setMessage(commitMsg).call();
            String currentBranch = git.getRepository().getBranch();
            ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)provider)).setForce(true).setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec(currentBranch)}).call();
        }
    }

    public static void push(File localDir, String gitUrl, String projectName, String commitMsg, String accessToken, String branch) {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        try (Git git = null;){
            git = Git.init().setDirectory(localDir).call();
            StoredConfig config = git.getRepository().getConfig();
            config.setString("remote", "origin", "url", gitUrl + projectName + ".git");
            config.save();
            String currentBranch = git.getRepository().getBranch();
            git.checkout().setName(branch).call();
            git.add().addFilepattern(".").call();
            git.add().addFilepattern(".").setUpdate(true).call();
            git.commit().setMessage(commitMsg).call();
            ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)provider)).setForce(true).setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec(currentBranch)}).call();
        }
    }

    public static void pushSpecifiedFile(File localDir, String gitUrl, String projectName, String commitMsg, String accessToken, String branch, String path, List<String> filesToAdd) {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        try (Git git = null;){
            git = Git.init().setDirectory(localDir).call();
            StoredConfig config = git.getRepository().getConfig();
            config.setString("remote", "origin", "url", gitUrl + projectName + ".git");
            config.save();
            String currentBranch = git.getRepository().getBranch();
            git.checkout().setName(branch).call();
            for (String file : filesToAdd) {
                String relativePath = ".";
                if (!file.equals(path)) {
                    relativePath = DevCloudUtil.formatToDividePath(file.substring(path.length() + 1));
                }
                git.add().addFilepattern(relativePath).call();
                git.add().addFilepattern(relativePath).setUpdate(true).call();
            }
            git.commit().setMessage(commitMsg).call();
            ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)provider)).setForce(true).setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec(currentBranch)}).call();
        }
    }

    public static void pushSpecifiedFileNotCommit(File localDir, String gitUrl, String projectName, String accessToken, String branch, String path, List<String> filesToAdd) {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        try (Git git = null;){
            git = Git.init().setDirectory(localDir).call();
            StoredConfig config = git.getRepository().getConfig();
            config.setString("remote", "origin", "url", gitUrl + projectName + ".git");
            config.save();
            String currentBranch = git.getRepository().getBranch();
            git.checkout().setName(branch).call();
            StringBuilder paths = new StringBuilder();
            for (String file : filesToAdd) {
                String relativePath = ".";
                if (!file.equals(path)) {
                    relativePath = DevCloudUtil.formatToDividePath(file.substring(path.length() + 1));
                    paths.append(relativePath).append("\uff0c");
                }
                git.add().addFilepattern(relativePath).call();
                git.add().addFilepattern(relativePath).setUpdate(true).call();
            }
            logger.info("====================\u5f00\u59cb\u63a8\u9001\u81f3\u8fdc\u7aef\uff1a{}=======================", (Object)paths);
            ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)provider)).setForce(true).setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec(currentBranch)}).call();
            logger.info("====================\u63a8\u9001\u81f3\u8fdc\u7aef\u7ed3\u675f=======================");
        }
    }

    private static String formatToDividePath(String path) {
        return path.replace("\\", "/").replace("\\\\", "/").replace(File.separator, "/");
    }

    public static void createDevBranch(File localDir, String accessToken, String branch) {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        try (Git git = null;){
            git = Git.init().setDirectory(localDir).call();
            List branches = git.branchList().call();
            boolean branchExists = branches.stream().anyMatch(ref -> ref.getName().equals("refs/heads/" + branch));
            if (!branchExists) {
                git.branchCreate().setName(branch).call();
            }
            git.checkout().setName(branch).call();
            String currentBranch = git.getRepository().getBranch();
            ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)provider)).setForce(true).setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec(currentBranch + ":" + branch)}).call();
        }
    }

    private static User getUser(String uri, String accessToken) {
        User user;
        int index = uri.indexOf("/", uri.indexOf("/") + 2) + 1;
        String hostUrl = uri.substring(0, index);
        try (GitLabApi gitLabApi = new GitLabApi(hostUrl, accessToken);){
            UserApi userApi = gitLabApi.getUserApi();
            user = userApi.getCurrentUser();
        }
        catch (GitLabApiException e) {
            if (e.getHttpStatus() == 401 || e.getHttpStatus() == 400) {
                throw new HussarException("\u8eab\u4efd\u9a8c\u8bc1\u672a\u901a\u8fc7");
            }
            throw new HussarException((Throwable)e);
        }
        return user;
    }

    public static void pull(String uri, String localGitPath, String branch, String accessToken) {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        Git git = null;
        if (DevCloudUtil.checkLocalRep(localGitPath)) {
            try {
                Path folder = Paths.get(localGitPath, ".git");
                if (!Files.exists(folder, new LinkOption[0]) || !Files.isDirectory(folder, new LinkOption[0])) {
                    DevCloudUtil.initGit(uri, branch, (CredentialsProvider)provider, new File(localGitPath));
                    return;
                }
                git = Git.open((File)new File(localGitPath));
                ((FetchCommand)git.fetch().setCredentialsProvider((CredentialsProvider)provider)).call();
                String currentBranch = git.getRepository().getBranch();
                String upstreamBranch = git.getRepository().getConfig().getString("branch", currentBranch, "merge");
                if (upstreamBranch == null || !upstreamBranch.equals("refs/heads/" + branch)) {
                    git.getRepository().close();
                    FileUtils.delete((File)new File(localGitPath), (int)1);
                    int index = localGitPath.indexOf(File.separator + ".git");
                    String localPath = localGitPath.substring(0, index);
                    File local = new File(localPath);
                    DevCloudUtil.initGit(uri, branch, (CredentialsProvider)provider, local);
                    return;
                }
                git.reset().setMode(ResetCommand.ResetType.HARD).setRef("origin/" + branch).call();
                ((PullCommand)git.pull().setCredentialsProvider((CredentialsProvider)provider)).setRemoteBranchName(branch).call();
            }
            catch (Exception e) {
                throw new HussarException((Throwable)e);
            }
            finally {
                if (git != null) {
                    git.close();
                }
            }
        }
        String localPath = "";
        int index = localGitPath.indexOf(File.separator + ".git");
        localPath = index > 0 ? localGitPath.substring(0, index) : localGitPath;
        File local = new File(localPath);
        if (local.exists()) {
            DevCloudUtil.initGit(uri, branch, (CredentialsProvider)provider, local);
        } else {
            try {
                git = ((CloneCommand)Git.cloneRepository().setCredentialsProvider((CredentialsProvider)provider)).setURI(uri).setBranch(branch).setDirectory(local).call();
            }
            catch (Exception e) {
                throw new HussarException((Throwable)e);
            }
            finally {
                if (git != null) {
                    git.close();
                }
            }
        }
    }

    public static Boolean createRemoteBranch(String gitUri, String groupId, String branch, String refName, String accessToken) {
        CloseableHttpClient httpclients = null;
        try {
            httpclients = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(gitUri + "/api/v4/projects/" + groupId + "/repository/branches");
            httpPost.setHeader("private-token", accessToken);
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            pairs.add(new BasicNameValuePair("branch", branch));
            pairs.add(new BasicNameValuePair("ref", refName));
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(pairs, "UTF-8");
            httpPost.setEntity((HttpEntity)formEntity);
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject.containsKey((Object)"error") || jsonObject.containsKey((Object)"message")) {
                String msg = jsonObject.getString("error") == null ? jsonObject.getString("message") : jsonObject.getString("error");
                throw new HussarException("\u521b\u5efa\u5206\u652f\u5931\u8d25, " + msg);
            }
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new HussarException((Throwable)e);
                }
            }
        }
    }

    public static String checkoutBranch(File localDir, String accessToken, String branch) {
        String currentBranch = "";
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        try (Git git = null;){
            git = Git.open((File)localDir);
            if (DevCloudUtil.branchNameExist(git, branch).booleanValue()) {
                git.checkout().setCreateBranch(false).setName(branch).call();
            } else {
                git.checkout().setCreateBranch(true).setName(branch).setStartPoint("origin/" + branch).call();
            }
            currentBranch = branch;
        }
        return currentBranch;
    }

    public static Boolean branchNameExist(Git git, String branchName) throws GitAPIException {
        List refs = git.branchList().call();
        for (Ref ref : refs) {
            if (!ref.getName().contains(branchName)) continue;
            return true;
        }
        return false;
    }

    private static void initGit(String uri, String branch, CredentialsProvider provider, File local) {
        try (Git git = null;){
            git = Git.init().setInitialBranch(branch).setDirectory(local).call();
            git.remoteAdd().setUri(new URIish(uri)).setName("origin").call();
            ((FetchCommand)git.fetch().setCredentialsProvider(provider)).call();
            git.checkout().setCreateBranch(true).setName(branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + branch).setForced(true).call();
        }
    }

    private static boolean checkLocalRep(String localGitPath) {
        return new File(localGitPath).exists();
    }

    public static boolean branchExist(String gitUri, String branch, String accessToken, String groupId) {
        CloseableHttpClient httpclients = null;
        try {
            httpclients = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(gitUri + "/api/v4/projects/" + groupId + "/repository/branches");
            httpGet.setHeader("private-token", accessToken);
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            JSONArray jsonArray = JSONArray.parseArray((String)result);
            ArrayList<String> branchList = new ArrayList<String>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)jsonArray.get(i)));
                String name = jsonObject.get((Object)"name").toString();
                branchList.add(name);
            }
            return branchList.stream().anyMatch(ref -> ref.equals(branch));
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getProjectIdByGroupIdAndName(String gitUri, String typeName, String accessToken, String groupId) {
        CloseableHttpClient httpclients = null;
        try {
            httpclients = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(gitUri + "/api/v4/groups/" + groupId + "/projects?search=" + typeName);
            httpGet.setHeader("private-token", accessToken);
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            JSONArray jsonArray = JSONArray.parseArray((String)result);
            int i = 0;
            while (i < jsonArray.size()) {
                if (typeName.equals(jsonArray.getJSONObject(i).getString("name"))) {
                    String string = jsonArray.getJSONObject(i).getString("id");
                    return string;
                }
                ++i;
            }
            throw new HussarException("\u9879\u76ee\u6216\u7fa4\u7ec4\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new HussarException((Throwable)e);
                }
            }
        }
    }

    public static Boolean setProtectBranch(String gitUri, String projectId, String branchName, String accessToken) {
        logger.info("\u8bbe\u7f6e\u4fdd\u62a4\u5206\u652f\uff1a===projectId--->{},branchName---->{}", (Object)projectId, (Object)branchName);
        CloseableHttpClient httpclients = null;
        try {
            httpclients = HttpClients.createDefault();
            HttpPut httpPut = new HttpPut(gitUri + "/api/v4/projects/" + projectId + "/repository/branches/" + branchName + "/protect");
            httpPut.setHeader("private-token", accessToken);
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            pairs.add(new BasicNameValuePair("branch", branchName));
            pairs.add(new BasicNameValuePair("id", projectId));
            pairs.add(new BasicNameValuePair("developers_can_push", "false"));
            pairs.add(new BasicNameValuePair("developers_can_merge", "false"));
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(pairs, "UTF-8");
            httpPut.setEntity((HttpEntity)formEntity);
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpPut);
            StatusLine statusLine = response.getStatusLine();
            if (200 == statusLine.getStatusCode()) {
                Boolean bl = true;
                return bl;
            }
            try {
                throw new HussarException("\u8bbe\u7f6e\u4fdd\u62a4\u5206\u652f\u5931\u8d25");
            }
            catch (Exception e) {
                throw new HussarException((Throwable)e);
            }
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new HussarException((Throwable)e);
                }
            }
        }
    }

    public static Boolean unProtectBranch(String gitUri, String projectId, String branchName, String accessToken) {
        logger.info("\u53d6\u6d88\u4fdd\u62a4\u5206\u652f\uff1a===projectId--->{},branchName---->{}", (Object)projectId, (Object)branchName);
        CloseableHttpClient httpclients = null;
        try {
            httpclients = HttpClients.createDefault();
            HttpDelete httpDelete = new HttpDelete(gitUri + "/api/v4/projects/" + projectId + "/protected_branches/" + branchName);
            httpDelete.setHeader("private-token", accessToken);
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpDelete);
            StatusLine statusLine = response.getStatusLine();
            if (204 == statusLine.getStatusCode()) {
                Boolean bl = true;
                return bl;
            }
            Boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new HussarException((Throwable)e);
                }
            }
        }
    }

    public static void merge(String uri, String gitGroup, String projectName, String sourceBranch, String targetBranch, String title, String accessToken) {
        String path = gitGroup + "/" + projectName;
        try (GitLabApi gitLabApi = null;){
            gitLabApi = new GitLabApi(uri, accessToken);
            List mergeRequestList = gitLabApi.getMergeRequestApi().getMergeRequests((Object)path, Constants.MergeRequestState.OPENED);
            for (MergeRequest request : mergeRequestList) {
                if (!sourceBranch.equals(request.getSourceBranch()) || !targetBranch.equals(request.getTargetBranch())) continue;
                throw new HussarException("\u5df2\u6709\u5f00\u542f\u4e2d\u7684\u5408\u5e76\u8bf7\u6c42");
            }
            CompareResults compareResults = gitLabApi.getRepositoryApi().compare((Object)path, targetBranch, sourceBranch);
            if (HussarUtils.isEmpty((Object)compareResults.getDiffs())) {
                throw new HussarException("\u5206\u652f\u6ca1\u6709\u5dee\u5f02\uff0c\u65e0\u6cd5\u5408\u5e76");
            }
            MergeRequestParams mergeRequestParams = new MergeRequestParams();
            mergeRequestParams.withTargetBranch(targetBranch).withSourceBranch(sourceBranch).withTitle(title);
            MergeRequest mergeRequest = gitLabApi.getMergeRequestApi().createMergeRequest((Object)path, mergeRequestParams);
            while ("checking".equals(mergeRequest.getMergeStatus())) {
                mergeRequest = gitLabApi.getMergeRequestApi().getMergeRequest((Object)path, mergeRequest.getIid());
            }
            if (mergeRequest.getHasConflicts().booleanValue()) {
                throw new HussarException("\u5b58\u5728\u51b2\u7a81\uff0c\u8bf7\u524d\u5f80gitlab\u624b\u52a8\u89e3\u51b3");
            }
            AcceptMergeRequestParams acceptMergeRequestParams = new AcceptMergeRequestParams();
            acceptMergeRequestParams.withMergeWhenPipelineSucceeds(Boolean.valueOf(false));
            gitLabApi.getMergeRequestApi().acceptMergeRequest((Object)path, mergeRequest.getIid(), acceptMergeRequestParams);
        }
    }

    public static String getGroupOrProjectId(String gitUri, String typeName, String accessToken, String type) {
        CloseableHttpClient httpclients = null;
        try {
            httpclients = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(gitUri + "/api/v4/" + type + "?search=" + typeName);
            httpGet.setHeader("private-token", accessToken);
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            JSONArray jsonArray = JSONArray.parseArray((String)result);
            for (int i = 0; i < jsonArray.size(); ++i) {
                if (!typeName.equals(jsonArray.getJSONObject(i).getString("path"))) continue;
                String string = jsonArray.getJSONObject(i).getString("id");
                return string;
            }
            String string = "";
            return string;
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new HussarException((Throwable)e);
                }
            }
        }
    }

    public static void revertOrRemove(File localDir, List<String> fileToRevert) {
        Git git = null;
        if (ObjectUtils.isEmpty(fileToRevert)) {
            return;
        }
        try {
            git = Git.open((File)localDir);
            Iterable commits = git.log().call();
            ArrayList<String> revertFiles = new ArrayList<String>();
            for (RevCommit commit : commits) {
                for (String originFiles : fileToRevert) {
                    boolean pushed;
                    boolean commited = commit.getFullMessage().contains(originFiles);
                    boolean bl = pushed = git.getRepository().resolve(commit.getName() + "^{commit}") != null;
                    if (!commited || !pushed) continue;
                    revertFiles.add(originFiles);
                }
            }
            RevCommit lastCommit = (RevCommit)commits.iterator().next();
            ResetCommand reset = git.reset();
            reset.setRef(lastCommit.getName());
            revertFiles.forEach(arg_0 -> ((ResetCommand)reset).addPath(arg_0));
            reset.setMode(ResetCommand.ResetType.MIXED);
            reset.call();
            List<String> removeFiles = DevCloudUtil.findCollectionC(fileToRevert, revertFiles);
            for (String folderPath : removeFiles) {
                try {
                    FileUtils.delete((File)new File(folderPath), (int)1);
                    logger.info("Folder deleted: {}", (Object)folderPath);
                }
                catch (IOException e) {
                    logger.error("Failed to delete folder: {}", (Object)folderPath);
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
        finally {
            if (git != null) {
                git.close();
            }
        }
    }

    public static void commit(File localDir, String gitUrl, String projectName, String commitMsg, String accessToken, String branch, String path, List<String> filesToAdd) {
        try (Git git = null;){
            git = Git.init().setDirectory(localDir).call();
            StoredConfig config = git.getRepository().getConfig();
            config.setString("remote", "origin", "url", gitUrl + projectName + ".git");
            config.save();
            git.checkout().setName(branch).call();
            for (String file : filesToAdd) {
                String relativePath = ".";
                if (!file.equals(path)) {
                    relativePath = DevCloudUtil.formatToDividePath(file.substring(path.length() + 1));
                }
                git.add().addFilepattern(relativePath).call();
                git.add().addFilepattern(relativePath).setUpdate(true).call();
            }
            logger.info("====================\u5f00\u59cb\u63d0\u4ea4\u81f3\u672c\u5730=======================");
            git.commit().setMessage(commitMsg).call();
            logger.info("====================\u63d0\u4ea4\u81f3\u672c\u5730\u7ed3\u675f=======================");
        }
    }

    public static void pullNotReset(String uri, String localGitPath, String branch, String accessToken) {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider("oauth2", accessToken);
        Git git = null;
        if (DevCloudUtil.checkLocalRep(localGitPath)) {
            try {
                Path folder = Paths.get(localGitPath, ".git");
                if (!Files.exists(folder, new LinkOption[0]) || !Files.isDirectory(folder, new LinkOption[0])) {
                    DevCloudUtil.initGit(uri, branch, (CredentialsProvider)provider, new File(localGitPath));
                    return;
                }
                git = Git.open((File)new File(localGitPath));
                ((FetchCommand)git.fetch().setCredentialsProvider((CredentialsProvider)provider)).call();
                String currentBranch = git.getRepository().getBranch();
                String upstreamBranch = git.getRepository().getConfig().getString("branch", currentBranch, "merge");
                if (upstreamBranch == null || !upstreamBranch.equals("refs/heads/" + branch)) {
                    git.getRepository().close();
                    FileUtils.delete((File)new File(localGitPath), (int)1);
                    int index = localGitPath.indexOf(File.separator + ".git");
                    String localPath = localGitPath.substring(0, index);
                    File local = new File(localPath);
                    DevCloudUtil.initGit(uri, branch, (CredentialsProvider)provider, local);
                    return;
                }
                logger.info("====================\u5f00\u59cb\u62c9\u53d6\u4ee3\u7801\u81f3\u672c\u5730=======================");
                ((PullCommand)git.pull().setCredentialsProvider((CredentialsProvider)provider)).setRemoteBranchName(branch).call();
                logger.info("====================\u62c9\u53d6\u4ee3\u7801\u81f3\u672c\u5730\u7ed3\u675f=======================");
            }
            catch (Exception e) {
                throw new HussarException((Throwable)e);
            }
            finally {
                if (git != null) {
                    git.close();
                }
            }
        }
    }

    private static List<String> findCollectionC(List<String> A, List<String> B) {
        ArrayList<String> C = new ArrayList<String>(A);
        CollectionUtils.filter(C, object -> !B.contains(object));
        return C;
    }
}

