/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.file.resource.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.file.resource.dao.AttachmentMapper;
import com.jxdinfo.hussar.file.resource.dto.AttachmentDto;
import com.jxdinfo.hussar.file.resource.service.IAttachmentService;
import com.jxdinfo.hussar.file.resource.vo.AttachmentVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class AttachmentServiceImpl
extends HussarServiceImpl<AttachmentMapper, AttachmentManagerModel>
implements IAttachmentService {
    @Autowired
    private AttachmentMapper attachmentMapper;
    @Autowired
    private ISysUsersService usersService;

    public Page<AttachmentVo> getAccachmentList(AttachmentDto attachmentDto) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (HussarUtils.hasEmpty((Object[])new Object[]{attachmentDto, securityUser})) {
            return null;
        }
        Page page = HussarPageUtils.convert((PageInfo)new PageInfo((long)attachmentDto.getCurrent(), (long)attachmentDto.getSize()));
        Long currentUserId = securityUser.getUserId();
        SysUsers currentUser = this.usersService.getUser(currentUserId);
        if ("1".equals(currentUser.getIsSys())) {
            this.attachmentMapper.selectSysAttachments((Page<AttachmentVo>)page, attachmentDto);
        } else {
            this.attachmentMapper.selectAttachments((Page<AttachmentVo>)page, attachmentDto);
        }
        return page;
    }

    public Page<AttachmentVo> getTenantAttachmentList(AttachmentDto attachmentDto) {
        Page page = HussarPageUtils.convert((PageInfo)new PageInfo((long)attachmentDto.getCurrent(), (long)attachmentDto.getSize()));
        return this.attachmentMapper.selectTenantAttachments((Page<AttachmentVo>)page, attachmentDto);
    }

    public List<AttachmentVo> getAttachmentListByFileIds(List<Long> fileIds) {
        return this.attachmentMapper.selectAttachmentListByFileId(fileIds);
    }

    @HussarDs(value="#connName")
    public Map<Long, String> getUploadPerMap(String connName, List<Long> uploadPerIds) {
        HashMap<Long, String> uploadPerMap = new HashMap();
        uploadPerMap = ((LambdaQueryChainWrapper)this.usersService.lambdaQuery().in(SysUsers::getId, uploadPerIds)).list().stream().collect(Collectors.toMap(SysUsers::getId, SysUsers::getUserName));
        return uploadPerMap;
    }

    @HussarDs(value="#connName")
    public Map<Long, String> getUploadOrganMap(String connName, List<Long> uploadOrganStruIds) {
        return this.attachmentMapper.getUploadOrganMap(uploadOrganStruIds).stream().collect(Collectors.toMap(map -> Long.valueOf(map.getOrDefault("struid", map.get("struId")).toString()), map -> map.getOrDefault("organname", map.get("organName")).toString()));
    }

    @HussarDs(value="#connName")
    public List<Long> getUploadPerIds(String connName, String uploadPerNameLike) {
        if (HussarUtils.isEmpty((Object)uploadPerNameLike)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)this.usersService.lambdaQuery().like(SysUsers::getUserName, (Object)uploadPerNameLike)).list().stream().map(SysUsers::getId).collect(Collectors.toList());
    }
}

