/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.filePreview.controller;

import cn.hutool.core.util.StrUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.io.IORuntimeException;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.plugin.file.properties.OssFileProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.jodconverter.core.DocumentConverter;
import org.jodconverter.core.office.OfficeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="")
@RequestMapping(value={"/gyfile"})
public class GyFilePreviewController {
    private static final Logger log = LoggerFactory.getLogger(GyFilePreviewController.class);
    @Autowired
    private DocumentConverter documentConverter;
    private final OssFileProperties ossFileProperties;
    @Resource
    private AttachmentManagerService attachmentManagerService;

    public GyFilePreviewController(OssFileProperties ossFileProperties) {
        this.ossFileProperties = ossFileProperties;
    }

    @GetMapping(value={"/preview"})
    public ApiResponse<String> preview(@RequestParam(value="fileId") Long fileId) {
        if (!HussarUtils.isEmpty((Object)fileId)) {
            AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.attachmentManagerService.getById((Serializable)fileId);
            if (!HussarUtils.isEmpty((Object)attachmentModel)) {
                String targetFileName;
                String fileName = attachmentModel.getAttachmentName();
                String suffix = this.getSuffix(fileName);
                boolean needConvert = false;
                if (StrUtil.endWithAny((CharSequence)fileName, (CharSequence[])new CharSequence[]{".pdf", ".txt", ".xml", ".json", ".html", ".htm", ".gif", ".jpg", ".jpeg", ".png", ".ico"})) {
                    targetFileName = fileName;
                } else if (StrUtil.endWithAny((CharSequence)fileName, (CharSequence[])new CharSequence[]{".doc", ".docx", ".xls", ".xlsx", ".csv", ".ppt", ".pptx"})) {
                    targetFileName = fileName.substring(0, fileName.lastIndexOf(".")) + ".pdf";
                    needConvert = true;
                } else {
                    throw new HussarException("\u4e0d\u652f\u6301\u6b64\u6587\u4ef6\u7684\u9884\u89c8");
                }
                String path = attachmentModel.getAttachmentDir() + fileId + suffix;
                File sourceFile = new File(path);
                String targetFilePath = this.ossFileProperties.getFileUploadPath() + targetFileName;
                File targetFile = new File(targetFilePath);
                BufferedInputStream inputStream = null;
                BufferedOutputStream outputStream = null;
                if (!targetFile.exists()) {
                    try {
                        targetFile.createNewFile();
                        if (needConvert) {
                            inputStream = new BufferedInputStream(new FileInputStream(sourceFile), 10240);
                            outputStream = new BufferedOutputStream(new FileOutputStream(targetFile), 10240);
                            this.documentConverter.convert((InputStream)inputStream).to((OutputStream)outputStream).as(this.documentConverter.getFormatRegistry().getFormatByExtension("pdf")).execute();
                        } else {
                            FileUtils.copyFile((File)sourceFile, (File)targetFile);
                        }
                    }
                    catch (IOException e) {
                        log.error("\u9644\u4ef6\u9884\u89c8IO\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                        throw new HussarException("\u521b\u5efa\u9884\u89c8\u6587\u4ef6\u5931\u8d25");
                    }
                    catch (IORuntimeException e) {
                        log.error("\u9644\u4ef6\u9884\u89c8IO\u8fd0\u884c\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                        throw new HussarException("\u9644\u4ef6\u9884\u89c8IO\u8fd0\u884c\u5f02\u5e38");
                    }
                    catch (OfficeException e) {
                        log.error("\u9644\u4ef6\u9884\u89c8Office\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                        throw new HussarException("\u9644\u4ef6\u9884\u89c8Office\u5f02\u5e38");
                    }
                    finally {
                        IOUtils.closeQuietly(inputStream);
                        IOUtils.closeQuietly(outputStream);
                    }
                }
                return ApiResponse.success((String)targetFileName);
            }
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
    }

    private String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }
}

