/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.encrypt.file.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.slf4j.Logger;

public class DirectBufferCleaner {
    private static boolean PRE_JAVA_9 = System.getProperty("java.specification.version", "9").startsWith("1.");
    private static Method cleanMethod;
    private static Method attachmentMethod;
    private static Object theUnsafe;

    static void getCleanMethodPrivileged() {
        if (PRE_JAVA_9) {
            try {
                cleanMethod = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
                cleanMethod.setAccessible(true);
                Class<?> directByteBufferClass = Class.forName("sun.nio.ch.DirectBuffer");
                attachmentMethod = directByteBufferClass.getMethod("attachment", new Class[0]);
                attachmentMethod.setAccessible(true);
            }
            catch (Exception directByteBufferClass) {}
        } else {
            try {
                Class<?> unsafeClass;
                try {
                    unsafeClass = Class.forName("sun.misc.Unsafe");
                }
                catch (Exception e) {
                    unsafeClass = Class.forName("jdk.internal.misc.Unsafe");
                }
                cleanMethod = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
                cleanMethod.setAccessible(true);
                Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                theUnsafe = theUnsafeField.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean closeDirectByteBufferPrivileged(ByteBuffer byteBuffer, Logger logger) {
        try {
            if (cleanMethod == null) {
                if (logger != null) {
                    logger.debug("Could not unmap ByteBuffer, cleanMethod == null");
                }
                return false;
            }
            if (PRE_JAVA_9) {
                if (attachmentMethod == null) {
                    if (logger != null) {
                        logger.debug("Could not unmap ByteBuffer, attachmentMethod == null");
                    }
                    return false;
                }
                if (attachmentMethod.invoke((Object)byteBuffer, new Object[0]) != null) {
                    return false;
                }
                Method cleaner = byteBuffer.getClass().getMethod("cleaner", new Class[0]);
                cleaner.setAccessible(true);
                cleanMethod.invoke(cleaner.invoke((Object)byteBuffer, new Object[0]), new Object[0]);
                return true;
            }
            if (theUnsafe == null) {
                if (logger != null) {
                    logger.debug("Could not unmap ByteBuffer, theUnsafe == null");
                }
                return false;
            }
            try {
                cleanMethod.invoke(theUnsafe, byteBuffer);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        catch (Exception e) {
            if (logger != null) {
                logger.debug("Could not unmap ByteBuffer: " + e);
            }
            return false;
        }
    }

    public static boolean closeDirectByteBuffer(final ByteBuffer byteBuffer, final Logger logger) {
        if (byteBuffer != null && byteBuffer.isDirect()) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return DirectBufferCleaner.closeDirectByteBufferPrivileged(byteBuffer, logger);
                }
            });
        }
        if (logger != null) {
            logger.debug("Nothing to unmap, byteBuffer == null");
        }
        return false;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                DirectBufferCleaner.getCleanMethodPrivileged();
                return null;
            }
        });
    }
}

