/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.encrypt.file.thread;

import com.jxdinfo.hussar.encrypt.file.FileEncryptUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptThread
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(EncryptThread.class);
    private static final long SLEEP_TIME = 50L;
    public boolean flag;
    private FileEncryptUtil encoder;
    private int key;
    private long dataIndex;
    private int interval;
    private int regionSize;
    private boolean completed;

    public EncryptThread(FileEncryptUtil encoder, byte key, int interval, int index) {
        this.encoder = encoder;
        this.key = key & 0xFF;
        this.dataIndex = index;
        this.interval = interval;
        this.regionSize = encoder.mappedBuffer.limit();
        this.completed = false;
        this.flag = true;
    }

    public void restart() {
        this.dataIndex -= (long)this.regionSize;
        this.regionSize = this.encoder.mappedBuffer.limit();
        this.completed = false;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public void run() {
        try {
            if (this.encoder.isEncode) {
                logger.debug("Encode thread {} is started!", (Object)this.getName());
                this.encode();
            } else {
                logger.debug("Decode thread {} is started!", (Object)this.getName());
                this.decode();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void encode() throws InterruptedException {
        while (this.flag) {
            if (this.completed) {
                Thread.sleep(50L);
                continue;
            }
            if (this.dataIndex >= (long)this.regionSize) {
                this.completed = true;
                logger.debug("Encode thread {} is completed!", (Object)this.getName());
                continue;
            }
            byte b = this.encoder.mappedBuffer.get((int)this.dataIndex);
            b = (byte)(((b & 0xFF) + this.key) % 256);
            this.encoder.mappedBuffer.put((int)this.dataIndex, b);
            this.dataIndex += (long)this.interval;
        }
    }

    private void decode() throws InterruptedException {
        while (this.flag) {
            if (this.completed) {
                Thread.sleep(50L);
                continue;
            }
            if (this.dataIndex >= (long)this.regionSize) {
                this.completed = true;
                logger.debug("Decode thread {} is completed!", (Object)this.getName());
                continue;
            }
            byte b = this.encoder.mappedBuffer.get((int)this.dataIndex);
            b = (byte)(((b & 0xFF) + 256 - this.key) % 256);
            this.encoder.mappedBuffer.put((int)this.dataIndex, b);
            this.dataIndex += (long)this.interval;
        }
    }
}

