/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.encrypt.file;

import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.support.StrKit;
import com.jxdinfo.hussar.encrypt.file.exceptioin.FileEncryptException;
import com.jxdinfo.hussar.encrypt.file.exceptioin.FileEncryptExceptionEnum;
import com.jxdinfo.hussar.encrypt.file.thread.EncryptThread;
import com.jxdinfo.hussar.encrypt.file.util.DirectBufferCleaner;
import com.jxdinfo.hussar.encrypt.file.util.FileUtil;
import com.jxdinfo.hussar.encrypt.file.util.RandomKeyUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileEncryptUtil {
    private static Logger logger = LoggerFactory.getLogger(FileEncryptUtil.class);
    private static final String DEFAULT_KEY = "123456";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final long SLEEP_TIME = 100L;
    private static final double DEFAULT_MAX_BUFFER_SIZE = Math.ceil(Math.pow(32767.0, 2.0) / 128.0);
    public boolean isEncode;
    public MappedByteBuffer mappedBuffer;
    private byte[] keyBytes;
    private EncryptThread[] workThreads;

    private FileEncryptUtil() {
    }

    public static FileEncryptUtil getInstance() {
        return new FileEncryptUtil();
    }

    private String encrypt(File sourceFile, File targetFile, Boolean whole) {
        return this.exec(sourceFile, targetFile, whole, null);
    }

    private String encrypt(String sourceFile, String targetFile, Boolean whole) {
        File source = new File(sourceFile);
        File target = new File(targetFile);
        return this.encrypt(source, target, whole);
    }

    public String encrypt(File sourceFile, File targetFile) {
        return this.encrypt(sourceFile, targetFile, (Boolean)false);
    }

    public String encrypt(String sourceFile, String targetFile) {
        return this.encrypt(sourceFile, targetFile, (Boolean)false);
    }

    public String encrypt(File sourceFile) {
        return this.encrypt(sourceFile, sourceFile, (Boolean)false);
    }

    public String encrypt(String sourceFile) {
        return this.encrypt(sourceFile, sourceFile, (Boolean)false);
    }

    public Boolean decrypt(String sourceFile, String targetFile, String decryKey) {
        File source = new File(sourceFile);
        File target = new File(targetFile);
        return this.decrypt(source, target, decryKey);
    }

    public Boolean decrypt(File sourceFile, File targetFile, String decryKey) {
        String rtn = this.exec(sourceFile, targetFile, false, decryKey);
        return rtn == null ? false : rtn.equals(decryKey);
    }

    public Boolean decrypt(String sourceFile, String decryKey) {
        return this.decrypt(sourceFile, sourceFile, decryKey);
    }

    /*
     * Unable to fully structure code
     */
    private String exec(File sourceFile, File targetFile, Boolean whole, String decryKey) {
        key = "123456";
        flag = whole;
        try {
            block20: {
                if (!sourceFile.isFile()) {
                    throw new FileEncryptException(FileEncryptExceptionEnum.FILE_NOT_EXIST_ERROR);
                }
                sourceFilePath = sourceFile.getCanonicalPath();
                if (!StrKit.equalsIgnoreCase((String)sourceFilePath, (String)(targetFilePath = targetFile.getCanonicalPath()))) {
                    FileUtil.copyFile(sourceFile, targetFile);
                }
                raf = new RandomAccessFile(targetFile, "rw");
                if (decryKey != null) {
                    fileLength = raf.length();
                    raf.setLength(fileLength - 13L);
                }
                if ((bufferCount = (int)Math.ceil((double)(fileLength = (channel = raf.getChannel()).size()) / FileEncryptUtil.DEFAULT_MAX_BUFFER_SIZE)) == 0) {
                    channel.close();
                    raf.close();
                    return null;
                }
                bufferIndex = 0;
                preLength = 0L;
                regionSize = Math.round(FileEncryptUtil.DEFAULT_MAX_BUFFER_SIZE);
                if (fileLength - preLength < regionSize) {
                    regionSize = fileLength - preLength;
                }
                this.mappedBuffer = channel.map(FileChannel.MapMode.READ_WRITE, preLength, regionSize);
                preLength += regionSize;
                if (decryKey != null) {
                    key = decryKey;
                    flag = key.equals(key.toUpperCase());
                    this.isEncode = false;
                } else {
                    key = RandomKeyUtil.buildKey(bufferCount > 5 ? (bufferCount < 10 ? bufferCount : 10) : bufferCount + 5, whole);
                    this.isEncode = true;
                }
                this.keyBytes = key.getBytes(Charset.forName("UTF-8"));
                threadCount = this.keyBytes.length;
                FileEncryptUtil.logger.debug("File size: {} , buffer count: {} , thread count: {}", new Object[]{fileLength, bufferCount, threadCount});
                startTime = System.currentTimeMillis();
                FileEncryptUtil.logger.debug("Start time: {} ms", (Object)startTime);
                FileEncryptUtil.logger.debug("Buffer {}  start ...", (Object)bufferIndex);
                this.workThreads = new EncryptThread[threadCount];
                for (i = 0; i < threadCount; ++i) {
                    this.workThreads[i] = new EncryptThread(this, this.keyBytes[i], this.keyBytes.length, i);
                    this.workThreads[i].start();
                }
                block3: while (true) {
                    Thread.sleep(100L);
                    completed = true;
                    for (i = 0; i < this.workThreads.length; ++i) {
                        if (this.workThreads[i].isCompleted()) continue;
                        completed = false;
                        break;
                    }
                    if (!completed) continue;
                    if (!flag.booleanValue() || ++bufferIndex >= bufferCount) {
                        for (i = 0; i < this.workThreads.length; ++i) {
                            this.workThreads[i].flag = false;
                        }
                        break block20;
                    }
                    regionSize = Math.round(FileEncryptUtil.DEFAULT_MAX_BUFFER_SIZE);
                    if (fileLength - preLength < regionSize) {
                        regionSize = fileLength - preLength;
                    }
                    this.mappedBuffer = channel.map(FileChannel.MapMode.READ_WRITE, preLength, regionSize);
                    preLength += regionSize;
                    FileEncryptUtil.logger.debug("Buffer {} start ...", (Object)bufferIndex);
                    i = 0;
lbl62:
                    // 2 sources

                    while (true) {
                        if (i < this.workThreads.length) break block3;
                        continue block3;
                        break;
                    }
                    break;
                }
                this.workThreads[i].restart();
                ++i;
                ** continue;
            }
            block7: do {
                Thread.sleep(100L);
                isOver = true;
                for (i = 0; i < this.workThreads.length; ++i) {
                    if (!this.workThreads[i].isAlive()) continue;
                    isOver = false;
                    continue block7;
                }
            } while (!isOver);
            if (decryKey == null) {
                fileLength = raf.length();
                raf.seek(fileLength);
                tail = RandomKeyUtil.complementKey(key, 10);
                tailBytes = tail.getBytes(Charset.forName("UTF-8"));
                for (i = 0; i < tailBytes.length; ++i) {
                    tailBytes[i] = (byte)(((tailBytes[i] & 255) + (i & 255)) % 256);
                }
                raf.writeBytes(new String(tailBytes, Charset.forName("UTF-8")));
                raf.write(new byte[]{-23, -121, -111});
            }
            channel.force(false);
            channel.close();
            raf.close();
            DirectBufferCleaner.closeDirectByteBuffer(this.mappedBuffer, FileEncryptUtil.logger);
            endTime = System.currentTimeMillis();
            FileEncryptUtil.logger.debug("End time:  {}  ms, use time: {} ms", (Object)endTime, (Object)(endTime - startTime));
        }
        catch (HussarException | IOException | InterruptedException e) {
            e.printStackTrace();
            return null;
        }
        return key;
    }
}

