/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.export.formdesign.file.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.export.formdesign.file.service.BaseFileService;
import com.jxdinfo.hussar.export.formdesign.file.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.extend.util.ParsingUtil;
import com.jxdinfo.hussar.workflow.manage.bpm.model.service.GodAxeModelService;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.springframework.context.annotation.Lazy;

public class BaseFileServiceImpl<T extends BaseFile>
implements BaseFileService<T> {
    @Resource
    protected FileMappingService fileMappingService;
    @Resource
    protected FormDesignProperties formDesignProperties;
    @Resource
    protected FormDesignProperties speedCodeProperties;
    @Lazy
    @Resource
    protected GodAxeModelService godAxeModelService;

    protected BaseFileServiceImpl() {
    }

    @Override
    public void create(T baseFile) throws LcdpException, IOException {
        String rootPath = this.formDesignProperties.getProjectAndCodePath();
        String parentPath = "";
        if (!ToolUtil.isEmpty((Object)baseFile.getParentId()) && !"#".equals(baseFile.getParentId())) {
            parentPath = this.getDataPath(baseFile.getParentId());
        }
        File file = "Frame".equals(baseFile.getType()) ? new File(this.relativeToAbsolute("frame" + File.separator + baseFile.getName() + ".fwd", rootPath)) : new File(this.relativeToAbsolute(parentPath + File.separator + baseFile.getDesc() + FileUtil.transFileSuffix(baseFile.getType()), rootPath));
        String metaPath = this.speedCodeProperties.getProjectAndCodePath();
        List metaList = ParsingUtil.getFilePath((String)metaPath, (String)".itd.meta");
        if (file.exists() && file.getPath().equals(file.getCanonicalPath())) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, file.getAbsolutePath());
        }
        File metaFile = new File(file.getAbsolutePath() + ".meta");
        if (metaFile.exists() && metaFile.getPath().equals(metaFile.getCanonicalPath())) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, metaFile.getAbsolutePath());
        }
        for (String pathName : metaList) {
            if (!pathName.contains(metaFile.getName())) continue;
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, file.getAbsolutePath());
        }
        this.fileMappingService.fileMappingCacheEvict();
        this.write(file, (BaseFile)baseFile);
    }

    @Override
    public void updateFile(T baseFile) throws IOException, LcdpException {
        String rootPath = this.formDesignProperties.getProjectAndCodePath();
        String path = this.getDataPath(baseFile.getId());
        File file = new File(this.relativeToAbsolute(path, rootPath));
        File metaFile = new File(this.addMeta(file.getAbsolutePath()));
        if (!file.exists()) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
        }
        if (!metaFile.exists()) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
        }
        boolean needRename = this.justRename((BaseFile)baseFile, metaFile);
        this.writeSingleFile(file, JSONObject.parseObject((String)baseFile.getData()));
        baseFile.setData(null);
        this.writeSingleFile(metaFile, (JSONObject)JSONObject.toJSON(baseFile));
        if (needRename) {
            this.renameTwoFile((BaseFile)baseFile, file, metaFile, rootPath);
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    void writeSingleFile(File file, JSONObject jsonObject) throws LcdpException {
        try {
            if (!file.exists()) {
                throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, file.getAbsolutePath());
            }
            if (ToolUtil.isEmpty((Object)jsonObject)) {
                FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8", (boolean)false);
            } else {
                FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8", (boolean)false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, file.getAbsolutePath());
        }
    }

    protected void write(File file, BaseFile baseFile) throws LcdpException {
        try {
            File fileOfMeta = new File(this.addMeta(file.getAbsolutePath()));
            Object jsonObject = JSONObject.parse((String)baseFile.getData());
            if (ToolUtil.isEmpty((Object)jsonObject)) {
                FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8", (boolean)false);
            } else {
                FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject), (String)"UTF-8", (boolean)false);
            }
            baseFile.setData(null);
            FileUtils.writeStringToFile((File)fileOfMeta, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)baseFile), (String)"UTF-8", (boolean)false);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, file.getAbsolutePath());
        }
    }

    protected boolean fixName(File oldFile, File newFile) {
        return oldFile.renameTo(newFile);
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String addMeta(String absolutePath) {
        String real = absolutePath.replace("/", File.separator).replace("\\", File.separator);
        return real + ".meta";
    }

    private String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath);
    }

    boolean justRename(BaseFile newBaseFile, File oldFile) throws LcdpException {
        boolean needRename = true;
        try {
            BaseFile baseFile = (BaseFile)JSONObject.parseObject((String)FileUtils.readFileToString((File)oldFile, (String)"UTF-8"), BaseFile.class);
            if (newBaseFile.getName().equals(baseFile.getName())) {
                needRename = false;
            }
            if (newBaseFile instanceof WorkflowInfo) {
                baseFile = (BaseFile)JSONObject.parseObject((String)FileUtils.readFileToString((File)oldFile, (String)"UTF-8"), WorkflowInfo.class);
                needRename = !((WorkflowInfo)newBaseFile).geteName().equals(((WorkflowInfo)baseFile).geteName());
                if (needRename) {
                    this.godAxeModelService.updateWorkflowProcessKey(((WorkflowInfo)newBaseFile).geteName(), ((WorkflowInfo)baseFile).geteName());
                }
                newBaseFile.setVersion(baseFile.getVersion());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, oldFile.getAbsolutePath());
        }
        return needRename;
    }

    void renameTwoFile(BaseFile baseFile, File file, File metaFile, String rootPath) throws LcdpException, IOException {
        File newFile;
        String parentPath = "";
        if (!ToolUtil.isEmpty((Object)baseFile.getParentId()) && !"#".equals(baseFile.getParentId())) {
            parentPath = this.getDataPath(baseFile.getParentId());
        }
        String name = baseFile.getName();
        if (baseFile instanceof WorkflowInfo) {
            name = ((WorkflowInfo)baseFile).geteName();
        }
        if ((newFile = new File(rootPath + parentPath + File.separator + name + FileUtil.transFileSuffix(baseFile.getType()))).exists()) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, newFile.getAbsolutePath());
        }
        File newMetaFile = new File(newFile.getAbsolutePath() + ".meta");
        if (newMetaFile.exists()) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, newMetaFile.getAbsolutePath());
        }
        this.fixName(file, newFile);
        this.fixName(metaFile, newMetaFile);
    }

    String getDataPath(String id) throws LcdpException, IOException {
        return this.getMetaPath(id).replace(".meta", "");
    }
}

