/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.export.formdesign.extend.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.export.model.ExtendExportModelInfo;
import com.jxdinfo.hussar.export.model.ExtendExportModelPathVO;
import com.jxdinfo.hussar.export.model.ExtendExportModelVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.extend.constant.ExtendCommonConstant;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class ExtendExportModelUtil {
    public static Map<String, String> getRegisteredVuedPath(List<String> metaPath, ExtendCommonConstant.FrontTypeEnum typeEnum) throws LcdpException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Iterator<String> var3 = metaPath.iterator();
            while (true) {
                if (!var3.hasNext()) {
                    return map;
                }
                String path = var3.next();
                String content = FileUtils.readFileToString((File)new File(path), (String)"UTF-8");
                ExtendExportModelInfo fileInfo = (ExtendExportModelInfo)JSON.parseObject((String)content, ExtendExportModelInfo.class);
                if (typeEnum != ExtendCommonConstant.FrontTypeEnum.Web || !"ImportTemplate".equals(fileInfo.getType())) continue;
                map.put(fileInfo.getFilePath().replaceAll("\\\\", "").replaceAll("/", ""), null);
            }
        }
        catch (IOException var7) {
            var7.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, metaPath.toString());
        }
    }

    public static ExtendExportModelVO getExportFileInformation(String filePath) throws LcdpException {
        ExtendExportModelVO FileVO = new ExtendExportModelVO();
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(new File(filePath).lastModified());
            FileVO.setUpdateTime(cal.getTime().toLocaleString());
            return FileVO;
        }
        catch (Exception var3) {
            var3.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, filePath);
        }
    }

    public static void createBlankDirectory(List<ExtendExportModelPathVO> pathList) {
        for (int i = 0; i < pathList.size(); ++i) {
            ExtendExportModelPathVO pathVO = pathList.get(i);
            if ("0".equals(pathVO.getParentPath()) || "#".equals(pathVO.getParentPath())) continue;
            boolean flag = false;
            for (ExtendExportModelPathVO pathVOTwo : pathList) {
                if (!pathVO.getParentPath().equals(pathVOTwo.getPath())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            ExtendExportModelPathVO BlankVO = new ExtendExportModelPathVO();
            BlankVO.setPath(pathVO.getParentPath());
            BlankVO.setLabel(pathVO.getParentPath().substring(pathVO.getParentPath().lastIndexOf(File.separator) + 1));
            if (pathVO.getParentPath().lastIndexOf(File.separator) < 1) {
                BlankVO.setParentPath("#");
            } else {
                BlankVO.setParentPath(pathVO.getParentPath().substring(0, pathVO.getParentPath().lastIndexOf(File.separator)));
            }
            BlankVO.setListFile(new ArrayList());
            pathList.add(BlankVO);
            ExtendExportModelUtil.createBlankDirectory(pathList);
        }
    }

    public static void addBlankRootDirectory(List<ExtendExportModelPathVO> pathVOList) {
        if (pathVOList.size() > 0) {
            boolean blankFile = true;
            for (ExtendExportModelPathVO pathVO : pathVOList) {
                if (!"0".equals(pathVO.getParentPath())) continue;
                blankFile = false;
                break;
            }
            if (blankFile) {
                ExtendExportModelPathVO pathVO;
                pathVO = new ExtendExportModelPathVO();
                pathVO.setParentPath("0");
                pathVO.setListFile(new ArrayList());
                pathVO.setLabel("#");
                pathVO.setPath("#");
                pathVO.setChildren(new ArrayList());
                pathVOList.add(pathVO);
            }
        }
    }

    public static List<ExtendExportModelPathVO> recursiveFilePath(String id, List<ExtendExportModelPathVO> pathList) {
        ArrayList<ExtendExportModelPathVO> childList = new ArrayList<ExtendExportModelPathVO>();
        for (ExtendExportModelPathVO nav : pathList) {
            if (!nav.getParentPath().equals(id)) continue;
            childList.add(nav);
        }
        for (ExtendExportModelPathVO nav : childList) {
            nav.setChildren(ExtendExportModelUtil.recursiveFilePath(nav.getPath(), pathList));
        }
        return childList.size() == 0 ? new ArrayList<ExtendExportModelPathVO>() : childList;
    }
}

