/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.export.formdesign.extend.util;

import com.jxdinfo.hussar.export.model.ExtendExportModelVO;
import java.util.Comparator;

public class ExportFileComparatorUtil
implements Comparator<ExtendExportModelVO> {
    private String str1;
    private String str2;
    private int pos1;
    private int pos2;
    private int len1;
    private int len2;

    @Override
    public int compare(ExtendExportModelVO s1, ExtendExportModelVO s2) {
        this.str1 = s1.getFileName().replace(".js", "");
        this.str2 = s2.getFileName().replace(".js", "");
        this.len1 = this.str1.length();
        this.len2 = this.str2.length();
        this.pos2 = 0;
        this.pos1 = 0;
        int result = 0;
        while (result == 0 && this.pos1 < this.len1 && this.pos2 < this.len2) {
            char ch1 = this.str1.charAt(this.pos1);
            char ch2 = this.str2.charAt(this.pos2);
            result = Character.isDigit(ch1) ? (Character.isDigit(ch2) ? this.compareNumbers() : -1) : (Character.isLetter(ch1) ? (Character.isLetter(ch2) ? this.compareOther(true) : 1) : (Character.isDigit(ch2) ? 1 : (Character.isLetter(ch2) ? -1 : this.compareOther(false))));
            ++this.pos1;
            ++this.pos2;
        }
        return result == 0 ? this.len1 - this.len2 : result;
    }

    private int compareNumbers() {
        int end2;
        int end1;
        for (end1 = this.pos1 + 1; end1 < this.len1 && Character.isDigit(this.str1.charAt(end1)); ++end1) {
        }
        int fullLen1 = end1 - this.pos1;
        while (this.pos1 < end1 && this.str1.charAt(this.pos1) == '0') {
            ++this.pos1;
        }
        for (end2 = this.pos2 + 1; end2 < this.len2 && Character.isDigit(this.str2.charAt(end2)); ++end2) {
        }
        int fullLen2 = end2 - this.pos2;
        while (this.pos2 < end2 && this.str2.charAt(this.pos2) == '0') {
            ++this.pos2;
        }
        int delta = end1 - this.pos1 - (end2 - this.pos2);
        if (delta != 0) {
            return delta;
        }
        while (this.pos1 < end1 && this.pos2 < end2) {
            if ((delta = this.str1.charAt(this.pos1++) - this.str2.charAt(this.pos2++)) == 0) continue;
            return delta;
        }
        --this.pos1;
        --this.pos2;
        return fullLen2 - fullLen1;
    }

    private int compareOther(boolean isLetters) {
        char ch2;
        char ch1 = this.str1.charAt(this.pos1);
        if (ch1 == (ch2 = this.str2.charAt(this.pos2))) {
            return 0;
        }
        if (isLetters && (ch1 = Character.toUpperCase(ch1)) != (ch2 = Character.toUpperCase(ch2))) {
            ch1 = Character.toLowerCase(ch1);
            ch2 = Character.toLowerCase(ch2);
        }
        return ch1 - ch2;
    }
}

