/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.export.formdesign.extend.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.excel.write.metadata.fill.FillWrapper;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelUtil.class);

    public static void fillReportWithEasyExcel(HttpServletResponse response, Map<String, Object> excelMap, String filename, InputStream inputStream) throws Exception {
        ExcelWriter excelWriter = null;
        ServletOutputStream outputStream = response.getOutputStream();
        response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(filename, "UTF-8"));
        response.setContentType("application/msexcel;charset=UTF-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        excelWriter = EasyExcel.write((OutputStream)outputStream).withTemplate(inputStream).build();
        for (Map.Entry<String, Object> entry : excelMap.entrySet()) {
            Map value = (Map)entry.getValue();
            HashMap sheetMap = new HashMap();
            WriteSheet writeSheet = EasyExcel.writerSheet((String)entry.getKey()).build();
            FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
            ArrayList<FillWrapper> fillWrapperList = new ArrayList<FillWrapper>();
            for (Map.Entry entry2 : value.entrySet()) {
                Map componentsMap = (Map)entry2.getValue();
                String type = (String)componentsMap.get("type");
                if ("form".equals(type)) {
                    sheetMap.putAll((Map)componentsMap.get("data"));
                    continue;
                }
                if (!"table".equals(type)) continue;
                List list = (List)componentsMap.get("data");
                FillWrapper fillWrapper = new FillWrapper((String)entry2.getKey(), (Collection)list);
                fillWrapperList.add(fillWrapper);
            }
            for (FillWrapper f : fillWrapperList) {
                excelWriter.fill((Object)f, fillConfig, writeSheet);
            }
            excelWriter.fill(sheetMap, writeSheet);
        }
        excelWriter.finish();
        inputStream.close();
    }
}

