/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.export.formdesign.extend.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.export.formdesign.extend.constant.ExtendExportModelContant;
import com.jxdinfo.hussar.export.formdesign.extend.util.ExcelUtil;
import com.jxdinfo.hussar.export.formdesign.extend.util.ExportFileComparatorUtil;
import com.jxdinfo.hussar.export.formdesign.extend.util.ExportPathComparatorUtil;
import com.jxdinfo.hussar.export.formdesign.extend.util.ExtendExportModelUtil;
import com.jxdinfo.hussar.export.formdesign.file.service.impl.BaseFileServiceImpl;
import com.jxdinfo.hussar.export.model.ExtendExportModelInfo;
import com.jxdinfo.hussar.export.model.ExtendExportModelPathVO;
import com.jxdinfo.hussar.export.model.ExtendExportModelVO;
import com.jxdinfo.hussar.export.service.ExtendExportModelService;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.extend.constant.ExtendCommonConstant;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsFile;
import com.jxdinfo.hussar.formdesign.extend.util.ParsingUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.stereotype.Service;

@Service(value="extendExportModelServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class})
public class ExtendExportModelServiceImpl
extends BaseFileServiceImpl<ExtendExportModelInfo>
implements ExtendExportModelService {
    @Resource
    protected FormDesignProperties speedCodeProperties;
    @Resource
    protected FileMappingService fileMappingService;
    @Resource
    protected FormDesignProperties formDesignProperties;

    public ApiResponse<List<ExtendExportModelPathVO>> listExportModel() throws LcdpException {
        return ApiResponse.success(this.listExport(this.speedCodeProperties, ExtendCommonConstant.FrontTypeEnum.Web));
    }

    private List<ExtendExportModelPathVO> listExport(FormDesignProperties speedCodeProperties, ExtendCommonConstant.FrontTypeEnum typeEnum) throws LcdpException {
        ArrayList<ExtendExportModelPathVO> pathVOList = new ArrayList<ExtendExportModelPathVO>();
        String metaPath = speedCodeProperties.getProjectAndCodePath();
        List metaList = null;
        String sourcePath = null;
        if (typeEnum == ExtendCommonConstant.FrontTypeEnum.Web) {
            metaList = ParsingUtil.getFilePath((String)metaPath, (String)".itd.meta");
            sourcePath = speedCodeProperties.getBackProjectPath() + ExtendExportModelContant.EXTEND_EXPORT_PATH;
        }
        Map<String, String> vueList = ExtendExportModelUtil.getRegisteredVuedPath(metaList, typeEnum);
        List sourceList = ParsingUtil.getFilePath(sourcePath, (String)".doc");
        sourceList.addAll(ParsingUtil.getFilePath(sourcePath, (String)".docx"));
        sourceList.addAll(ParsingUtil.getFilePath((String)sourcePath, (String)".xls"));
        sourceList.addAll(ParsingUtil.getFilePath((String)sourcePath, (String)".xlsx"));
        Map mapList = ParsingUtil.groupByFile((List)sourceList, (String)sourcePath);
        for (Map.Entry entry : mapList.entrySet()) {
            ExtendExportModelPathVO pathVO = new ExtendExportModelPathVO();
            String[] keys = ((String)entry.getKey()).split(",");
            pathVO.setLabel(keys[0]);
            pathVO.setPath(keys[1]);
            pathVO.setParentPath(keys[2]);
            ArrayList<ExtendExportModelVO> vueFileList = new ArrayList<ExtendExportModelVO>();
            for (ExtendJsFile jsFile : (List)entry.getValue()) {
                ExtendExportModelVO fileVO = ExtendExportModelUtil.getExportFileInformation(sourcePath + jsFile.getFilePath());
                fileVO.setSize(jsFile.getSize());
                fileVO.setFileName(jsFile.getFileName());
                fileVO.setFilePath(jsFile.getFilePath().replaceAll("\\\\", "/"));
                if (vueList.containsKey(jsFile.getFilePath().replaceAll("\\\\", "").replaceAll("/", ""))) {
                    fileVO.setState(Integer.valueOf(1));
                } else {
                    fileVO.setState(Integer.valueOf(0));
                }
                vueFileList.add(fileVO);
            }
            vueFileList.sort(new ExportFileComparatorUtil());
            pathVO.setListFile(vueFileList);
            pathVOList.add(pathVO);
        }
        ExtendExportModelUtil.createBlankDirectory(pathVOList);
        pathVOList.sort(new ExportPathComparatorUtil());
        ExtendExportModelUtil.addBlankRootDirectory(pathVOList);
        return ExtendExportModelUtil.recursiveFilePath("0", pathVOList);
    }

    public ApiResponse<Boolean> saveExportModelInfo(ExtendExportModelInfo fileInfo) throws IOException, LcdpException {
        if (StringUtil.isNotBlank((CharSequence)fileInfo.getId()) && this.fileMappingService.isFileExist(fileInfo.getId())) {
            this.updateFile(fileInfo);
        } else {
            if (!StringUtil.isNotBlank((CharSequence)fileInfo.getFilePath())) {
                return ApiResponse.fail((String)"\u53c2\u6570\u7f3a\u5931");
            }
            if (this.checkExists(fileInfo.getFilePath())) {
                return ApiResponse.fail((String)"\u8be5\u6587\u4ef6\u5df2\u6ce8\u518c");
            }
            this.create(fileInfo);
            this.createExportFilePath(fileInfo);
        }
        return ApiResponse.success((Object)true);
    }

    private void createExportFilePath(ExtendExportModelInfo fileInfo) throws IOException {
        String fileName = fileInfo.getId();
        String fileFullPath = "/template" + fileInfo.getFilePath();
        fileFullPath.replaceAll("\\\\", "/");
        this.writeJson(this.formDesignProperties.getBackProjectPath() + ExtendExportModelContant.EXTEND_EXPORT_PATH + "/exportPath.json", fileName, fileFullPath);
    }

    private void writeJson(String jsonPath, String fileName, String fileFullPath) throws IOException {
        File jsonFile = new File(jsonPath);
        if (!jsonFile.exists()) {
            jsonFile.createNewFile();
        }
        StringBuilder stringToJson = new StringBuilder();
        JSONObject jsonObject = new JSONObject();
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(jsonPath);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));
        while (reader.ready()) {
            stringToJson.append(reader.readLine());
        }
        reader.close();
        ((InputStream)fileInputStream).close();
        if (StringUtils.isNotEmpty((CharSequence)stringToJson.toString())) {
            jsonObject = JSONObject.parseObject((String)stringToJson.toString());
        }
        jsonObject.put(fileName, (Object)fileFullPath);
        FileWriter fileWriter = new FileWriter(jsonFile.getAbsoluteFile(), false);
        BufferedWriter bw = new BufferedWriter(fileWriter);
        bw.write(jsonObject.toString());
        bw.close();
    }

    public void getExportFileByFileName(String fileName, HttpServletResponse response) throws IOException {
        int len;
        StringBuilder stringToJson = new StringBuilder();
        org.springframework.core.io.Resource resources = new DefaultResourceLoader().getResource("classpath:template/exportPath.json");
        JSONObject jsonObject = new JSONObject();
        InputStream fileInputStream = null;
        if (resources.exists()) {
            fileInputStream = resources.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(fileInputStream, StandardCharsets.UTF_8));
            while (reader.ready()) {
                stringToJson.append(reader.readLine());
            }
            reader.close();
            fileInputStream.close();
        }
        if (StringUtils.isNotEmpty((CharSequence)stringToJson.toString())) {
            jsonObject = JSONObject.parseObject((String)stringToJson.toString());
        }
        String filePath = jsonObject.getString(fileName);
        org.springframework.core.io.Resource resource = new DefaultResourceLoader().getResource("classpath:" + filePath);
        InputStream inputStream = null;
        if (resource.exists()) {
            inputStream = resource.getInputStream();
        }
        response.reset();
        response.setContentType("application/octet-stream");
        String filename = new File(filePath).getName();
        response.addHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(filename, "UTF-8"));
        ServletOutputStream outputStream = response.getOutputStream();
        byte[] b = new byte[1024];
        while ((len = inputStream.read(b)) > 0) {
            outputStream.write(b, 0, len);
        }
        inputStream.close();
    }

    public void exportByExcel(HttpServletResponse response, HttpServletRequest request, Map<String, Object> map) throws Exception {
        String templateName = String.valueOf(map.get("templateName"));
        String templateId = String.valueOf(map.get("templateId"));
        StringBuilder stringToJson = new StringBuilder();
        org.springframework.core.io.Resource resources = new DefaultResourceLoader().getResource("classpath:template/exportPath.json");
        JSONObject jsonObject = new JSONObject();
        InputStream fileInputStream = null;
        if (resources.exists()) {
            fileInputStream = resources.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(fileInputStream, StandardCharsets.UTF_8));
            while (reader.ready()) {
                stringToJson.append(reader.readLine());
            }
            reader.close();
            fileInputStream.close();
        }
        if (StringUtils.isNotEmpty((CharSequence)stringToJson.toString())) {
            jsonObject = JSONObject.parseObject((String)stringToJson.toString());
        }
        String filePath = jsonObject.getString(templateId);
        org.springframework.core.io.Resource resource = new DefaultResourceLoader().getResource("classpath:" + filePath);
        InputStream inputStream = resource.getInputStream();
        Map dataMap = (Map)map.get("data");
        HashMap<String, Object> excelMap = new HashMap<String, Object>();
        for (Map.Entry entry : dataMap.entrySet()) {
            Map sheetMap = (Map)entry.getValue();
            String sheetName = (String)entry.getKey();
            excelMap.put(sheetName, sheetMap);
        }
        ExcelUtil.fillReportWithEasyExcel(response, excelMap, templateName, inputStream);
    }

    private boolean checkExists(String filePath) throws LcdpException {
        String metaPath = this.speedCodeProperties.getProjectAndCodePath();
        List metaList = ParsingUtil.getFilePath((String)metaPath, (String)".cpd.meta");
        try {
            ExtendExportModelInfo fileInfo;
            Iterator var4 = metaList.iterator();
            do {
                if (!var4.hasNext()) {
                    return false;
                }
                String path = (String)var4.next();
                String content = FileUtils.readFileToString((File)new File(path), (String)"UTF-8");
                fileInfo = (ExtendExportModelInfo)JSON.parseObject((String)content, ExtendExportModelInfo.class);
            } while (!filePath.replaceAll("\\\\", "/").equals(fileInfo.getFilePath().replaceAll("\\\\", "/")) || !fileInfo.getType().equals("CustomPage"));
            return true;
        }
        catch (IOException var8) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, filePath);
        }
    }
}

