/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.listener;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.base.HussarBaseMultipartFile;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.excel.enums.TipConstantsEnum;
import com.jxdinfo.hussar.excel.handler.CommentErrorWriteHandler;
import com.jxdinfo.hussar.excel.handler.CommentNewWriteHandler;
import com.jxdinfo.hussar.excel.handler.CommentUpdateWriteHandler;
import com.jxdinfo.hussar.excel.handler.DataValidationSheetWriteHandler;
import com.jxdinfo.hussar.excel.model.ExcelCheckResult;
import com.jxdinfo.hussar.excel.model.ExcelImportMsg;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.service.IHussarBaseCustomExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.excel.util.HussarBaseExcelWriteUtils;
import com.jxdinfo.hussar.lang.enums.LangEnum;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.multipart.MultipartFile;

public class HussarBaseExcelListener<T>
extends AnalysisEventListener<T> {
    private static final String SYSTEM_TEMP_DIR = "java.io.tmpdir";
    private static final String XLSX_SUFFIX = ".xlsx";
    private static final String ROOT_NUM = "rootNum";
    private static final String NEW_NUM = "newNum";
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarBaseExcelListener.class);
    private SysExcelTask task;
    private List<Object> otherParams;
    private List rootDataList = new ArrayList();
    private List successDataList = new ArrayList();
    private List<ExcelImportMsg<T>> errDataList = new ArrayList<ExcelImportMsg<T>>();
    private List<ExcelImportMsg<T>> newDataList = new ArrayList<ExcelImportMsg<T>>();
    private List<ExcelImportMsg<T>> updateDataList = new ArrayList<ExcelImportMsg<T>>();
    private List<ExcelImportMsg<T>> existDataList = new ArrayList<ExcelImportMsg<T>>();
    private Object customExcelCheckResult = null;
    private ISysExcelTaskService excelTaskService;
    private IHussarBaseCustomExcelService customExcelService;
    private OssService ossService;
    private List list = new ArrayList();
    private Class<T> clazz;
    private Map<Integer, String> indexNameMap;
    private int headLineNumber = 0;
    private int lineNumber = 0;
    private String scenario;
    private Long checkFile;
    private final Map<String, Integer> excludeColumnIndexesMap;
    private Map<Integer, List<String>> selectParamMap;

    public HussarBaseExcelListener(SysExcelTask task, List<Object> otherParams, ISysExcelTaskService excelTaskService, OssService ossService, IHussarBaseCustomExcelService customExcelService, Class clazz, String scenario, Map<String, Integer> excludeColumnIndexesMap, Map<Integer, List<String>> selectParamMap) throws NoSuchFieldException {
        this.task = task;
        this.excelTaskService = excelTaskService;
        this.ossService = ossService;
        this.customExcelService = customExcelService;
        this.clazz = clazz;
        this.scenario = scenario;
        this.indexNameMap = this.getIndexNameMap(clazz);
        this.excludeColumnIndexesMap = excludeColumnIndexesMap;
        this.selectParamMap = selectParamMap;
        this.otherParams = otherParams;
    }

    public HussarBaseExcelListener(SysExcelTask task, ISysExcelTaskService excelTaskService, OssService ossService, IHussarBaseCustomExcelService customExcelService, Class clazz, String scenario, Map<String, Integer> excludeColumnIndexesMap, Map<Integer, List<String>> selectParamMap) throws NoSuchFieldException {
        this.task = task;
        this.excelTaskService = excelTaskService;
        this.ossService = ossService;
        this.customExcelService = customExcelService;
        this.clazz = clazz;
        this.scenario = scenario;
        this.indexNameMap = this.getIndexNameMap(clazz);
        this.excludeColumnIndexesMap = excludeColumnIndexesMap;
        this.selectParamMap = selectParamMap;
    }

    public HussarBaseExcelListener(SysExcelTask task, ISysExcelTaskService excelTaskService, OssService ossService, IHussarBaseCustomExcelService customExcelService, Class clazz, String scenario, Map<String, Integer> excludeColumnIndexesMap) throws NoSuchFieldException {
        this.task = task;
        this.excelTaskService = excelTaskService;
        this.ossService = ossService;
        this.customExcelService = customExcelService;
        this.clazz = clazz;
        this.scenario = scenario;
        this.indexNameMap = this.getIndexNameMap(clazz);
        this.excludeColumnIndexesMap = excludeColumnIndexesMap;
    }

    public void invoke(T data, AnalysisContext context) {
        ++this.lineNumber;
        Map indexDataMap = HussarUtils.toMap(data);
        List<String> indexNameList = new ArrayList<String>(this.indexNameMap.values());
        ArrayList rowDataList = new ArrayList(indexDataMap.values());
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (!LangEnum.ZH_CN.getLangValue().equals(lang)) {
            indexNameList = this.translate(indexNameList);
        }
        for (int i = 0; i < rowDataList.size(); ++i) {
            String cellData = (String)rowDataList.get(i);
            if (cellData != null && cellData.contains("*")) {
                cellData = cellData.replace("*", "");
                rowDataList.set(i, cellData);
                continue;
            }
            if (cellData != null) continue;
            rowDataList.remove(i);
            --i;
        }
        if (HussarUtils.equals((Object)0, (Object)this.headLineNumber) && rowDataList.size() > 1) {
            for (Map.Entry<String, Integer> entry : this.excludeColumnIndexesMap.entrySet()) {
                if (rowDataList.contains(entry.getKey())) continue;
                rowDataList.add(entry.getValue(), entry.getKey());
            }
        }
        if (indexNameList.equals(rowDataList)) {
            this.headLineNumber = this.lineNumber;
        }
        this.list.add(data);
    }

    private List<String> translate(List<String> list) {
        HashMap<String, String> translateMap = new HashMap<String, String>();
        translateMap.put(TipConstantsEnum.EXCEL_ORGAN_CODE.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_ORGAN_CODE.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_ORGAN_NAME.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_ORGAN_NAME.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_ORGAN_TYPE.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_ORGAN_TYPE.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_PARENT_ORGAN.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_PARENT_ORGAN.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_ORGAN_SHORT_NAME.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_ORGAN_SHORT_NAME.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_ORGAN_ALIAS.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_ORGAN_ALIAS.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_ORGAN_DESC.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_ORGAN_DESC.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_CONTACT_ADDRESS.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_CONTACT_ADDRESS.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_RESPONSIBLE_PERSON.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_RESPONSIBLE_PERSON.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_ORGAN_ATTRIBUTE.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_ORGAN_ATTRIBUTE.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_ORGAN_TIME_TYPE.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_ORGAN_TIME_TYPE.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_SORT_ORDER.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_SORT_ORDER.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_PRIMARY_KEY.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_PRIMARY_KEY.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_USER_ACCOUNT.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_USER_ACCOUNT.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_PERSON_NAME.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_PERSON_NAME.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_ORGAN.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_ORGAN.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_MAX_SESSION.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_MAX_SESSION.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_GENDER.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_GENDER.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_EMPLOYEE_ID.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EMPLOYEE_ID.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_POSITION.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_POSITION.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_EMAIL.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EMAIL.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_MOBILE.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_MOBILE.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_WECHAT.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_WECHAT.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_PHONE_NUMBER.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_PHONE_NUMBER.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_ACCOUNT_STATUS.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_ACCOUNT_STATUS.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_ACCOUNT_TYPE.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_ACCOUNT_TYPE.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_START_DATE.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_START_DATE.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_END_DATE.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_END_DATE.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_PERSON_CODE.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_PERSON_CODE.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_ID_NUMBER.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_ID_NUMBER.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_BIRTH.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_BIRTH.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_HOME_ADDRESS.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_HOME_ADDRESS.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_HIRE_DATE.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_HIRE_DATE.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_GRADUATION_DATE.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_GRADUATION_DATE.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_GRADUATION_SCHOOL.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_GRADUATION_SCHOOL.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_REMARKS.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_REMARKS.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_SECURITY_LEVEL.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_SECURITY_LEVEL.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_DIC_NAME.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_DIC_NAME.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_DIC_IDENTIFICATION.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_DIC_IDENTIFICATION.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_FIELD_NAME.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_FIELD_NAME.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_FIELD_VALUE.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_FIELD_VALUE.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_SUPERIOR_FIELD.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_SUPERIOR_FIELD.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_ENABLE_STATUS.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_ENABLE_STATUS.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_FIELD_PRIMARY_KEY.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_FIELD_PRIMARY_KEY.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_DIC_PRIMARY_KEY.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_DIC_PRIMARY_KEY.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_CONTACT_ID.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_CONTACT_ID.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_CONTACT_TYPE.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_CONTACT_TYPE.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_CONTACT_NAME.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_CONTACT_NAME.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_TAGS.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_TAGS.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_DELIVERY_TYPE_CODE.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_DELIVERY_TYPE_CODE.getMessage()));
        translateMap.put(TipConstantsEnum.EXCEL_MAILING_ADDRESS.getMessage(), TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_MAILING_ADDRESS.getMessage()));
        ArrayList<String> translateList = new ArrayList<String>();
        for (String s : list) {
            String translate = (String)translateMap.get(s);
            if (translate == null) continue;
            translateList.add(translate);
        }
        return translateList;
    }

    @HussarTransactional
    public void doAfterAllAnalysed(AnalysisContext context) {
        block13: {
            if (this.headLineNumber == 0) {
                this.task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_FORMAT_ERROR.getMessage()));
                this.task.setTaskStatus(Integer.valueOf(3));
                this.excelTaskService.updateById((Object)this.task);
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_FORMAT_ERROR.getMessage()));
            }
            this.list.subList(0, this.headLineNumber).clear();
            List handleDataList = this.customExcelService.handleDataBeforeImport(this.list, this.task.getId());
            if (!HussarUtils.isNull((Object)handleDataList)) {
                this.list = handleDataList;
            }
            try {
                if (this.list.size() != 0) {
                    ExcelCheckResult result = this.customExcelService.check(this.list, this.task.getId(), this.otherParams);
                    this.rootDataList = result.getRootDatas();
                    this.successDataList = result.getSuccessDatas();
                    this.errDataList = result.getErrDatas();
                    this.newDataList = result.getNewDatas();
                    this.existDataList = result.getExistDatas();
                    this.updateDataList = result.getUpdateDatas();
                    this.customExcelCheckResult = result.getCheckMsg();
                    if (HussarUtils.isNotEmpty(this.errDataList)) {
                        this.makeErrMsgExcel(this.task, this.errDataList);
                        this.task.setTaskStatus(Integer.valueOf(3));
                        this.task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_IMPORT_FILL_ERROR.getMessage()));
                        this.excelTaskService.updateById((Object)this.task);
                    } else if ("1".equals(this.scenario)) {
                        if (this.newDataList.size() != 0 || this.existDataList.size() != 0) {
                            this.makeNewAndExistMsgExcel(this.task, this.newDataList, this.existDataList);
                        }
                        this.task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_IMPORT_PASS.getMessage()));
                        this.task.setTaskStatus(Integer.valueOf(2));
                        this.excelTaskService.updateById((Object)this.task);
                    } else if ("2".equals(this.scenario)) {
                        if (this.newDataList.size() != 0 || this.updateDataList.size() != 0 || this.existDataList.size() != 0) {
                            this.makeNewAndUpdateMsgExcel(this.task, this.newDataList, this.updateDataList, this.existDataList);
                        }
                        this.task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_IMPORT_PASS.getMessage()));
                        this.task.setTaskStatus(Integer.valueOf(2));
                        this.excelTaskService.updateById((Object)this.task);
                    } else {
                        this.saveOrUpdate(this.task);
                    }
                    break block13;
                }
                this.task.setTaskStatus(Integer.valueOf(3));
                this.task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_FILE_DATA_EMPTY.getMessage()));
                this.excelTaskService.updateById((Object)this.task);
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_FILE_DATA_EMPTY.getMessage()));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        this.list.clear();
    }

    public void saveOrUpdate(SysExcelTask task) {
        List newData;
        HussarFixedCacheUtil.evict((String)"excel_check_info", (Object)("hussar-excel" + task.getId() + ":checkResult"));
        if ("3".equals(this.scenario)) {
            if (this.newDataList.size() != 0) {
                newData = this.newDataList.stream().map(ExcelImportMsg::getObject).collect(Collectors.toList());
                this.customExcelService.saveData(newData, this.otherParams);
            }
            task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_IMPORT_SUCCESS.getMessage()));
            task.setTaskStatus(Integer.valueOf(5));
            this.excelTaskService.updateById((Object)task);
        }
        if ("4".equals(this.scenario)) {
            if (this.newDataList.size() != 0) {
                newData = this.newDataList.stream().map(ExcelImportMsg::getObject).collect(Collectors.toList());
                this.customExcelService.saveData(newData, this.otherParams);
            }
            if (this.updateDataList.size() != 0) {
                List updateData = this.updateDataList.stream().map(ExcelImportMsg::getObject).collect(Collectors.toList());
                this.customExcelService.updateData(updateData, this.otherParams);
            }
            task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_IMPORT_SUCCESS.getMessage()));
            task.setTaskStatus(Integer.valueOf(5));
            this.excelTaskService.updateById((Object)task);
        }
    }

    private void makeErrMsgExcel(SysExcelTask task, List<ExcelImportMsg<T>> errorList) throws IOException {
        List<Map<Integer, Map<Integer, String>>> errorMsgList = errorList.stream().map(excelImportErr -> excelImportErr.getCellMap()).collect(Collectors.toList());
        String dir = System.getProperty(SYSTEM_TEMP_DIR);
        String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + XLSX_SUFFIX;
        FileOutputStream os = new FileOutputStream(tempFileName);
        List<Map<String, String>> commentList = HussarBaseExcelListener.writeHandlerList(errorMsgList, TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_INFO_ERROR.getMessage()));
        CommentErrorWriteHandler commentErrorWriteHandler = new CommentErrorWriteHandler(commentList, "xlsx");
        ArrayList<Object> writeHandlerList = new ArrayList<Object>();
        writeHandlerList.add(commentErrorWriteHandler);
        if (HussarUtils.isNotEmpty(this.selectParamMap)) {
            writeHandlerList.add(new DataValidationSheetWriteHandler(this.selectParamMap));
        }
        HussarBaseExcelWriteUtils.writeMsgExcel((OutputStream)os, (List)this.rootDataList, this.clazz, writeHandlerList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_INFO_ERROR.getMessage()));
        FileInputStream inputStream = new FileInputStream(tempFileName);
        HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile(tempFileName.replace(XLSX_SUFFIX, ""), tempFileName.replace(XLSX_SUFFIX, ""), "application/octet-stream", (InputStream)inputStream);
        ApiResponse errorFileResponse = this.ossService.backgroundUpload((MultipartFile)multipartFile);
        this.checkFile = (Long)errorFileResponse.getData();
        task.setCheckFile(this.checkFile);
    }

    private void makeNewAndExistMsgExcel(SysExcelTask task, List<ExcelImportMsg<T>> newList, List<ExcelImportMsg<T>> existList) throws IOException {
        ArrayList<Object> writeHandlerList = new ArrayList<Object>();
        if (HussarUtils.isNotEmpty(newList)) {
            List<Map<Integer, Map<Integer, String>>> newMsgList = newList.stream().map(excelImportErr -> excelImportErr.getCellMap()).collect(Collectors.toList());
            List<Map<String, String>> newCommentList = HussarBaseExcelListener.writeHandlerList(newMsgList, TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_MARK_NEW_EXIST.getMessage()));
            CommentNewWriteHandler commentNewWriteHandler = new CommentNewWriteHandler(newCommentList, "xlsx");
            writeHandlerList.add(commentNewWriteHandler);
        }
        String dir = System.getProperty(SYSTEM_TEMP_DIR);
        String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + XLSX_SUFFIX;
        FileOutputStream os = new FileOutputStream(tempFileName);
        if (HussarUtils.isNotEmpty(this.selectParamMap)) {
            writeHandlerList.add(new DataValidationSheetWriteHandler(this.selectParamMap));
        }
        HussarBaseExcelWriteUtils.writeMsgExcel((OutputStream)os, (List)this.rootDataList, this.clazz, writeHandlerList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_MARK_NEW_EXIST.getMessage()));
        FileInputStream inputStream = new FileInputStream(tempFileName);
        HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile(tempFileName.replace(XLSX_SUFFIX, ""), tempFileName.replace(XLSX_SUFFIX, ""), "application/octet-stream", (InputStream)inputStream);
        ApiResponse checkFileResponse = this.ossService.backgroundUpload((MultipartFile)multipartFile);
        task.setCheckFile((Long)checkFileResponse.getData());
        this.checkFile = (Long)checkFileResponse.getData();
    }

    private void makeNewAndUpdateMsgExcel(SysExcelTask task, List<ExcelImportMsg<T>> newList, List<ExcelImportMsg<T>> updateList, List<ExcelImportMsg<T>> existList) throws IOException {
        String updateMsg = "\u6807\u8bb0\u65b0\u589e\u548c\u66f4\u65b0\u6570\u636e\u4fe1\u606f";
        ArrayList<Object> writeHandlerList = new ArrayList<Object>();
        if (HussarUtils.isNotEmpty(newList)) {
            List<Map<Integer, Map<Integer, String>>> newMsgList = newList.stream().map(excelImportErr -> excelImportErr.getCellMap()).collect(Collectors.toList());
            List<Map<String, String>> newCommentList = HussarBaseExcelListener.writeHandlerList(newMsgList, TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_MARK_NEW_UPDATE.getMessage()));
            CommentNewWriteHandler commentNewWriteHandler = new CommentNewWriteHandler(newCommentList, "xlsx");
            writeHandlerList.add(commentNewWriteHandler);
        }
        if (HussarUtils.isNotEmpty(this.selectParamMap)) {
            writeHandlerList.add(new DataValidationSheetWriteHandler(this.selectParamMap));
        }
        if (HussarUtils.isNotEmpty(updateList)) {
            List<Map<Integer, Map<Integer, String>>> updateMsgList = updateList.stream().map(excelImportErr -> excelImportErr.getCellMap()).collect(Collectors.toList());
            List<Map<String, String>> updateCommentList = HussarBaseExcelListener.writeHandlerList(updateMsgList, TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_MARK_NEW_UPDATE.getMessage()));
            CommentUpdateWriteHandler commentUpdateWriteHandler = new CommentUpdateWriteHandler(updateCommentList, "xlsx");
            writeHandlerList.add(commentUpdateWriteHandler);
        }
        String dir = System.getProperty(SYSTEM_TEMP_DIR);
        String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + XLSX_SUFFIX;
        FileOutputStream os = new FileOutputStream(tempFileName);
        HussarBaseExcelWriteUtils.writeMsgExcel((OutputStream)os, (List)this.rootDataList, this.clazz, writeHandlerList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_MARK_NEW_UPDATE.getMessage()));
        FileInputStream inputStream = new FileInputStream(tempFileName);
        HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile(tempFileName.replace(XLSX_SUFFIX, ""), tempFileName.replace(XLSX_SUFFIX, ""), "application/octet-stream", (InputStream)inputStream);
        ApiResponse checkFileResponse = this.ossService.backgroundUpload((MultipartFile)multipartFile);
        task.setCheckFile((Long)checkFileResponse.getData());
        this.checkFile = (Long)checkFileResponse.getData();
    }

    private static List<Map<String, String>> writeHandlerList(List<Map<Integer, Map<Integer, String>>> msgList, String sheetName) {
        ArrayList<Map<String, String>> commentList = new ArrayList<Map<String, String>>();
        msgList.forEach(map -> {
            int rowIndex = -1;
            int colIndex = -1;
            String commentMsg = "";
            for (Integer key : map.keySet()) {
                rowIndex = key;
                Map comMap = (Map)map.get(key);
                for (Integer comKey : comMap.keySet()) {
                    colIndex = comKey;
                    commentMsg = (String)comMap.get(comKey);
                    LOGGER.info("sheetName = {}\uff0crowIndex = {}\uff0ccolIndex = {}\uff0c\u5bfc\u5165\u8868\u683c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{sheetName, rowIndex, colIndex, commentMsg});
                    commentList.add(CommentErrorWriteHandler.createCommentMap((String)sheetName, (int)rowIndex, (int)colIndex, (String)commentMsg));
                }
            }
        });
        return commentList;
    }

    private Map<Integer, String> getIndexNameMap(Class clazz) throws NoSuchFieldException {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = clazz.getDeclaredField(fields[i].getName());
            field.setAccessible(true);
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            if (excelProperty == null) continue;
            int index = excelProperty.index();
            index = index == -1 ? i : index;
            String[] values = excelProperty.value();
            StringBuilder value = new StringBuilder();
            for (String v : values) {
                value.append(v);
            }
            result.put(index, value.toString());
        }
        return result;
    }

    public JSONObject getInitNum() {
        JSONObject json = new JSONObject();
        int rootDataNum = this.rootDataList.size();
        if (HussarUtils.isNotEmpty((Object)rootDataNum)) {
            json.put(ROOT_NUM, (Object)rootDataNum);
        } else {
            json.put(ROOT_NUM, (Object)"null");
        }
        int newDataNum = this.newDataList.size();
        if (HussarUtils.isNotEmpty((Object)newDataNum)) {
            json.put(NEW_NUM, (Object)newDataNum);
        } else {
            json.put(NEW_NUM, (Object)"null");
        }
        int existDataNum = this.existDataList.size();
        if (HussarUtils.isNotEmpty((Object)existDataNum)) {
            json.put("existNum", (Object)existDataNum);
        } else {
            json.put("existNum", (Object)"null");
        }
        int errNum = this.errDataList.size();
        if (HussarUtils.isNotEmpty((Object)errNum)) {
            json.put("errNum", (Object)errNum);
        }
        if (HussarUtils.isNotEmpty((Object)this.customExcelCheckResult)) {
            json.put("customExcelCheckResult", this.customExcelCheckResult);
        }
        if (HussarUtils.isNotEmpty((Object)this.checkFile)) {
            json.put("checkFileId", (Object)this.checkFile);
        }
        return json;
    }

    public JSONObject getNotInitNum() {
        JSONObject json = new JSONObject();
        int rootDataNum = this.rootDataList.size();
        if (HussarUtils.isNotEmpty((Object)rootDataNum)) {
            json.put(ROOT_NUM, (Object)rootDataNum);
        } else {
            json.put(ROOT_NUM, (Object)"null");
        }
        int newDataNum = this.newDataList.size();
        if (HussarUtils.isNotEmpty((Object)newDataNum)) {
            json.put(NEW_NUM, (Object)newDataNum);
        } else {
            json.put(NEW_NUM, (Object)"null");
        }
        int updateDataNum = this.updateDataList.size();
        if (HussarUtils.isNotEmpty((Object)updateDataNum)) {
            json.put("updateNum", (Object)updateDataNum);
        } else {
            json.put("updateNum", (Object)"null");
        }
        int errNum = this.errDataList.size();
        if (HussarUtils.isNotEmpty((Object)errNum)) {
            json.put("errNum", (Object)errNum);
        }
        if (HussarUtils.isNotEmpty((Object)this.customExcelCheckResult)) {
            json.put("customExcelCheckResult", this.customExcelCheckResult);
        }
        if (HussarUtils.isNotEmpty((Object)this.checkFile)) {
            json.put("checkFileId", (Object)this.checkFile);
        }
        return json;
    }
}

