/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.util;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.jxdinfo.hussar.excel.MyEasyExcel.MyExcelFactory;
import com.jxdinfo.hussar.excel.MyEasyExcel.MyExcelWriterSheetBuilder;
import com.jxdinfo.hussar.excel.builder.I18nHeaderBuilder;
import com.jxdinfo.hussar.excel.constants.ExcelConstants;
import com.jxdinfo.hussar.excel.handler.CommentErrorWriteHandler;
import com.jxdinfo.hussar.excel.model.ClassSheetMsg;
import com.jxdinfo.hussar.excel.model.TplSheetMsg;
import com.jxdinfo.hussar.lang.enums.LangEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.beans.ClassPathResource;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.context.i18n.LocaleContextHolder;

public class HussarBaseExcelWriteUtils {
    public static void writeMsgExcel(OutputStream outputStream, List objects, Class clazz, List<WriteHandler> writeHandlerList, String sheetName) throws IOException {
        try {
            WriteCellStyle headWriteCellStyle = new WriteCellStyle();
            headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.WHITE.getIndex()));
            WriteFont headWriteFont = new WriteFont();
            headWriteFont.setFontHeightInPoints(Short.valueOf((short)14));
            headWriteFont.setBold(Boolean.valueOf(true));
            headWriteCellStyle.setWriteFont(headWriteFont);
            headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
            WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
            WriteFont contentWriteFont = new WriteFont();
            contentWriteFont.setFontHeightInPoints(Short.valueOf((short)12));
            contentWriteFont.setFontName("\u5b8b\u4f53");
            contentWriteCellStyle.setWriteFont(contentWriteFont);
            contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
            contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
            contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
            contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
            contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
            contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
            ExcelWriterBuilder write = EasyExcelFactory.write((OutputStream)outputStream, (Class)clazz);
            Locale locale = LocaleContextHolder.getLocale();
            String lang = locale.toLanguageTag();
            if (TranslateUtil.getIsEnable() && !HussarUtils.equals((Object)lang, (Object)LangEnum.ZH_CN.getLangValue())) {
                I18nHeaderBuilder i18nHeaderBuilder = new I18nHeaderBuilder();
                write = (ExcelWriterBuilder)i18nHeaderBuilder.buildI18nHeader(write, clazz).useDefaultStyle(Boolean.valueOf(true));
            } else {
                write = (ExcelWriterBuilder)write.useDefaultStyle(Boolean.valueOf(true));
            }
            if (writeHandlerList != null) {
                write.inMemory(Boolean.TRUE);
                for (int i = 0; i < writeHandlerList.size(); ++i) {
                    write.registerWriteHandler(writeHandlerList.get(i));
                }
            }
            ((ExcelWriterBuilder)write.registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).sheet(sheetName).doWrite((Collection)objects);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5199\u5165excel\u51fa\u9519,\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public static void writeClassSheet(FileOutputStream fileOutputStream, ClassSheetMsg classSheetMsg) {
        ExcelWriterSheetBuilder writer = ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcelFactory.write((OutputStream)fileOutputStream).head(classSheetMsg.getClazz())).excludeColumnIndexes(classSheetMsg.getExcludeColumnIndexes())).relativeHeadRowIndex(Integer.valueOf(classSheetMsg.getUpHeadRowNumber()))).sheet(Integer.valueOf(classSheetMsg.getSheetNumber()), classSheetMsg.getSheetName());
        if (HussarUtils.isNotEmpty(classSheetMsg.getHandlerList())) {
            int size = classSheetMsg.getHandlerList().size();
            for (int i = 0; i < size; ++i) {
                writer.registerWriteHandler(classSheetMsg.getHandlerList().get(i));
            }
        }
        writer.doWrite((Collection)classSheetMsg.getDatas());
    }

    public static void writeI18nClassSheet(FileOutputStream fileOutputStream, ClassSheetMsg classSheetMsg, I18nHeaderBuilder i18nHeaderBuilder) {
        ExcelWriterBuilder writerBuilder = EasyExcelFactory.write((OutputStream)fileOutputStream);
        writerBuilder = (ExcelWriterBuilder)((ExcelWriterBuilder)i18nHeaderBuilder.buildI18nHeader(writerBuilder, classSheetMsg.getClazz()).excludeColumnIndexes(classSheetMsg.getExcludeColumnIndexes())).relativeHeadRowIndex(Integer.valueOf(classSheetMsg.getUpHeadRowNumber()));
        ExcelWriterSheetBuilder sheetBuilder = writerBuilder.sheet(Integer.valueOf(classSheetMsg.getSheetNumber()), classSheetMsg.getSheetName());
        if (HussarUtils.isNotEmpty(classSheetMsg.getHandlerList())) {
            int size = classSheetMsg.getHandlerList().size();
            for (int i = 0; i < size; ++i) {
                sheetBuilder.registerWriteHandler(classSheetMsg.getHandlerList().get(i));
            }
        }
        sheetBuilder.doWrite((Collection)classSheetMsg.getDatas());
    }

    public static void writeTplSheet(FileOutputStream fileOutputStream, TplSheetMsg tplSheetMsg) throws IOException {
        ClassPathResource resource = new ClassPathResource(ExcelConstants.TemplateMap.get(tplSheetMsg.getTplFileName()));
        InputStream inputStream = resource.getStream();
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        workbook.setSheetName(0, tplSheetMsg.getSheetName());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        workbook.write((OutputStream)byteArrayOutputStream);
        byte[] bytes = byteArrayOutputStream.toByteArray();
        inputStream = new ByteArrayInputStream(bytes);
        MyExcelWriterSheetBuilder writer = MyExcelFactory.write(fileOutputStream).withTemplate(inputStream).sheet(0, tplSheetMsg.getSheetName());
        if (HussarUtils.isNotEmpty(tplSheetMsg.getHandlerList())) {
            int size = tplSheetMsg.getHandlerList().size();
            for (int i = 0; i < size; ++i) {
                writer.registerWriteHandler(tplSheetMsg.getHandlerList().get(i));
            }
        }
        if (tplSheetMsg.getMap() != null) {
            FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
            writer.doFill(tplSheetMsg.getDatas(), fillConfig);
            writer.doFill(tplSheetMsg.getMap());
            writer.finish();
        } else {
            FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.FALSE).build();
            writer.doFill(tplSheetMsg.getDatas(), fillConfig);
            writer.finish();
        }
        byteArrayOutputStream.close();
        inputStream.close();
        workbook.close();
    }

    public static void writeClassSheets(FileOutputStream fileOutputStream, List<ClassSheetMsg> classSheetMsgs) {
        try {
            WriteCellStyle headWriteCellStyle = new WriteCellStyle();
            headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
            for (int i = 0; i < classSheetMsgs.size(); ++i) {
                ClassSheetMsg classSheetMsg = classSheetMsgs.get(i);
                ExcelWriterSheetBuilder writer = ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcelFactory.write((OutputStream)fileOutputStream).head(classSheetMsg.getClazz())).relativeHeadRowIndex(Integer.valueOf(classSheetMsg.getUpHeadRowNumber()))).sheet(Integer.valueOf(classSheetMsg.getSheetNumber()), classSheetMsg.getSheetName());
                int size = classSheetMsg.getHandlerList().size();
                for (int j = 0; j < size; ++j) {
                    writer.registerWriteHandler(classSheetMsg.getHandlerList().get(i));
                }
                writer.doWrite((Collection)classSheetMsg.getDatas());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5199\u5165excel\u51fa\u9519,\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
        }
    }

    private static List<List<String>> getHeader(Class clazz) throws NoSuchFieldException {
        Map<Integer, String> indexNameMap = HussarBaseExcelWriteUtils.getIndexNameMap(clazz);
        String first = "\u5bfc\u5165\u4fe1\u606f\u5b58\u5728\u9519\u8bef\uff01\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165";
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        Set<Integer> keySet = indexNameMap.keySet();
        for (Integer key : keySet) {
            ArrayList<String> head0 = new ArrayList<String>();
            head0.add(first);
            head0.add(indexNameMap.get(key));
            list.add(head0);
        }
        return list;
    }

    private static List<Map<String, String>> writeHandlerList(List<Map<Integer, Map<Integer, String>>> errMsgList, String sheetName) {
        ArrayList<Map<String, String>> commentList = new ArrayList<Map<String, String>>();
        errMsgList.forEach(map -> {
            int rowIndex = -1;
            int colIndex = -1;
            String commentMsg = "";
            for (Integer key : map.keySet()) {
                rowIndex = key;
                Map comMap = (Map)map.get(key);
                for (Integer comKey : comMap.keySet()) {
                    colIndex = comKey;
                    commentMsg = (String)comMap.get(comKey);
                    commentList.add(CommentErrorWriteHandler.createCommentMap(sheetName, rowIndex, colIndex, commentMsg));
                }
            }
        });
        return commentList;
    }

    public static Map<Integer, String> getIndexNameMap(Class clazz) throws NoSuchFieldException {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = clazz.getDeclaredField(fields[i].getName());
            field.setAccessible(true);
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            if (excelProperty == null) continue;
            int index = excelProperty.index();
            index = index == -1 ? i : index;
            String[] values = excelProperty.value();
            StringBuilder value = new StringBuilder();
            for (String v : values) {
                value.append(v);
            }
            result.put(index, value.toString());
        }
        return result;
    }

    public static Workbook judegExcelEdition(String fileName, InputStream inputStream) throws IOException {
        HSSFWorkbook workbook = null;
        if (fileName.matches("^.+\\.(?i)(xls)$")) {
            workbook = new HSSFWorkbook(inputStream);
            return workbook;
        }
        workbook = new XSSFWorkbook(inputStream);
        return workbook;
    }
}

