/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.builder;

import com.jxdinfo.hussar.excel.builder.ExcelBuilder;
import com.jxdinfo.hussar.excel.builder.ExcelProduct;
import com.jxdinfo.hussar.excel.enums.TipConstantsEnum;
import com.jxdinfo.hussar.excel.model.ClassSheetMsg;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.model.TplSheetMsg;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.util.MergeExcelSheetUtil;
import com.jxdinfo.hussar.lang.enums.LangEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.File;
import java.util.Locale;
import java.util.UUID;
import org.springframework.context.i18n.LocaleContextHolder;

public class ConcreteExcelBuilder
extends ExcelBuilder {
    private static final String SYSTEM_TEMP_DIR = "java.io.tmpdir";
    private static final String XLSX_SUFFIX = ".xlsx";
    private static ExcelProduct excelProduct;
    private IHussarBaseExcelService hussarBaseExcelServiceImpl;

    public ConcreteExcelBuilder() {
    }

    public ConcreteExcelBuilder(String excelName, Long taskId, IHussarBaseExcelService hussarBaseExcelServiceImpl) {
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        excelProduct = new ExcelProduct(excelName, task);
        this.hussarBaseExcelServiceImpl = hussarBaseExcelServiceImpl;
    }

    @Override
    public ExcelBuilder makeClassSheet(ClassSheetMsg classSheetMsg) {
        String dir = System.getProperty(SYSTEM_TEMP_DIR);
        String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + XLSX_SUFFIX;
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (TranslateUtil.getIsEnable() && !HussarUtils.equals((Object)lang, (Object)LangEnum.ZH_CN.getLangValue())) {
            this.hussarBaseExcelServiceImpl.makeI18nClassSheetFile(tempFileName, classSheetMsg, excelProduct.getTask());
        } else {
            this.hussarBaseExcelServiceImpl.makeClassSheetFile(tempFileName, classSheetMsg, excelProduct.getTask());
        }
        excelProduct.addTempFileNameList(tempFileName);
        return this;
    }

    @Override
    public ExcelBuilder makeTplSheet(TplSheetMsg tplSheetMsg) {
        String dir = System.getProperty(SYSTEM_TEMP_DIR);
        String tempFileNameForTpl = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + XLSX_SUFFIX;
        this.hussarBaseExcelServiceImpl.makeTplSheetFile(tempFileNameForTpl, tplSheetMsg, excelProduct.getTask());
        excelProduct.addTempFileNameList(tempFileNameForTpl);
        return this;
    }

    @Override
    public ExcelProduct buildExcelProduct() {
        String dir = System.getProperty(SYSTEM_TEMP_DIR);
        String excelTempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + XLSX_SUFFIX;
        excelProduct.setExcelTempFileName(excelTempFileName);
        if (HussarUtils.isNotEmpty(excelProduct.getTempFileNameList())) {
            MergeExcelSheetUtil.mergeExcel(excelProduct.getTempFileNameList(), excelTempFileName);
        }
        Long ossId = this.hussarBaseExcelServiceImpl.sendFileToOss(excelTempFileName);
        excelProduct.getTask().setTaskFile(ossId);
        excelProduct.getTask().setFileName(excelProduct.getExcelName());
        excelProduct.getTask().setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_SUCCESS.getMessage()));
        excelProduct.getTask().setTaskStatus(8);
        return excelProduct;
    }
}

