/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.handler;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class DataValidationSheetWriteHandler
implements SheetWriteHandler {
    private final Map<Integer, List<String>> selectParamMap;

    public DataValidationSheetWriteHandler(Map<Integer, List<String>> selectParamMap) {
        this.selectParamMap = selectParamMap;
    }

    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        Sheet sheet = writeSheetHolder.getCachedSheet();
        DataValidationHelper helper = sheet.getDataValidationHelper();
        Workbook workbook = writeWorkbookHolder.getWorkbook();
        int index = 1;
        for (Map.Entry<Integer, List<String>> entry : this.selectParamMap.entrySet()) {
            String dictSheetName = "dict_hide_sheet" + index;
            Sheet dictSheet = workbook.createSheet(dictSheetName);
            workbook.setSheetHidden(index++, true);
            CellRangeAddressList infoList = new CellRangeAddressList(1, 1048575, entry.getKey().intValue(), entry.getKey().intValue());
            int rowLen = entry.getValue().size();
            for (int i = 0; i < rowLen; ++i) {
                dictSheet.createRow(i).createCell(0).setCellValue(entry.getValue().get(i));
            }
            String refers = dictSheetName + "!$A$1:$A$" + (entry.getValue().isEmpty() ? 1 : entry.getValue().size());
            Name name = workbook.createName();
            name.setNameName(dictSheetName);
            name.setRefersToFormula(refers);
            DataValidationConstraint constraint = helper.createFormulaListConstraint(dictSheetName);
            DataValidation dataValidation = helper.createValidation(constraint, infoList);
            sheet.addValidationData(dataValidation);
        }
    }
}

