/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.validate;

import com.alibaba.excel.annotation.ExcelProperty;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class HussarBaseExcelValidateHelper {
    private static Validator validator = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).addProperty("hibernate.validator.fail_fast", "false")).buildValidatorFactory().getValidator();

    public static <T> Map<Integer, Map<Integer, String>> validateEntity(T obj, Integer rowIndex) {
        HashMap<Integer, Map<Integer, String>> resultMapNum = new HashMap<Integer, Map<Integer, String>>();
        HashMap<Integer, String> resultMap = new HashMap<Integer, String>();
        Set set = validator.validate(obj, new Class[]{Default.class});
        if (set != null && set.size() != 0) {
            int i = 0;
            for (ConstraintViolation cv : set) {
                Field declaredField = null;
                try {
                    declaredField = obj.getClass().getDeclaredField(cv.getPropertyPath().toString());
                }
                catch (NoSuchFieldException e) {
                    throw new BaseException("NoSuchFieldException\uff1a" + cv.getPropertyPath().toString());
                }
                ExcelProperty annotation = declaredField.getAnnotation(ExcelProperty.class);
                int index = annotation.index();
                if (index == -1) {
                    index = i;
                }
                if (resultMap.get(index) != null) {
                    resultMap.put(index, (String)resultMap.get(index) + ";" + cv.getMessage());
                } else {
                    resultMap.put(index, cv.getMessage());
                }
                ++i;
            }
            resultMapNum.put(rowIndex, resultMap);
        }
        return resultMapNum;
    }

    public static void addErrorMsg(int rowIndex, int index, String errorMsg, Map<Integer, Map<Integer, String>> resultMapNum) {
        Map<Object, Object> resultMap = new HashMap();
        if (resultMapNum.get(rowIndex) != null) {
            resultMap = resultMapNum.get(rowIndex);
        }
        if (resultMap.get(index) != null) {
            resultMap.put(index, (String)resultMap.get(index) + ";" + errorMsg);
        } else {
            resultMap.put(index, errorMsg);
        }
        resultMapNum.put(rowIndex, resultMap);
    }

    public static void addExistMsg(int rowIndex, int index, String errorMsg, Map<Integer, Map<Integer, String>> resultMapNum) {
        Map<Object, Object> resultMap = new HashMap();
        if (resultMapNum.get(rowIndex) != null) {
            resultMap = resultMapNum.get(rowIndex);
        }
        if (resultMap.get(index) != null) {
            resultMap.put(index, (String)resultMap.get(index) + ";" + errorMsg);
        } else {
            resultMap.put(index, errorMsg);
        }
        resultMapNum.put(rowIndex, resultMap);
    }

    public static void addUpdateMsg(int rowIndex, int index, String errorMsg, Map<Integer, Map<Integer, String>> resultMapNum) {
        Map<Object, Object> resultMap = new HashMap();
        if (resultMapNum.get(rowIndex) != null) {
            resultMap = resultMapNum.get(rowIndex);
        }
        if (resultMap.get(index) != null) {
            resultMap.put(index, (String)resultMap.get(index) + ";" + errorMsg);
        } else {
            resultMap.put(index, errorMsg);
        }
        resultMapNum.put(rowIndex, resultMap);
    }

    public static void addNewMsg(int rowIndex, int index, String errorMsg, Map<Integer, Map<Integer, String>> resultMapNum) {
        Map<Object, Object> resultMap = new HashMap();
        if (resultMapNum.get(rowIndex) != null) {
            resultMap = resultMapNum.get(rowIndex);
        }
        if (resultMap.get(index) != null) {
            resultMap.put(index, (String)resultMap.get(index) + ";" + errorMsg);
        } else {
            resultMap.put(index, errorMsg);
        }
        resultMapNum.put(rowIndex, resultMap);
    }

    public static void addMsgBatch(int rowIndex, String msgType, Map<Integer, Map<Integer, String>> resultMapNum, int[] indexArr, Class clazz) {
        Map<Object, Object> resultMap = new HashMap();
        if (resultMapNum.get(rowIndex) != null) {
            resultMap = resultMapNum.get(rowIndex);
        }
        try {
            Map<Integer, String> indexNameMap = HussarBaseExcelValidateHelper.getIndexNameMap(clazz);
            for (int index : indexArr) {
                String name = indexNameMap.get(index);
                String msg = "";
                if (HussarUtils.equals((Object)msgType, (Object)"add")) {
                    msg = "\u5f53\u524d" + name + "\u4e3a\u65b0\u589e\u6570\u636e";
                }
                if (HussarUtils.equals((Object)msgType, (Object)"exit")) {
                    msg = "\u5f53\u524d" + name + "\u4e3a\u5df2\u5b58\u5728\u6570\u636e";
                }
                if (resultMap.get(index) != null) {
                    resultMap.put(index, (String)resultMap.get(index) + ";" + msg);
                    continue;
                }
                resultMap.put(index, msg);
            }
        }
        catch (NoSuchFieldException e) {
            throw new BaseException((Throwable)e);
        }
        resultMapNum.put(rowIndex, resultMap);
    }

    private static Map<Integer, String> getIndexNameMap(Class clazz) throws NoSuchFieldException {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = clazz.getDeclaredField(fields[i].getName());
            field.setAccessible(true);
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            if (excelProperty == null) continue;
            int index = excelProperty.index();
            index = index == -1 ? i : index;
            String[] values = excelProperty.value();
            StringBuilder value = new StringBuilder();
            for (String v : values) {
                value.append(v);
            }
            result.put(index, value.toString());
        }
        return result;
    }
}

