/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.builder;

import com.jxdinfo.hussar.excel.builder.ExcelBuilder;
import com.jxdinfo.hussar.excel.builder.ExcelProduct;
import com.jxdinfo.hussar.excel.model.ClassSheetMsg;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.model.TplSheetMsg;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.util.MergeExcelSheetUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.util.UUID;

public class ConcreteExcelBuilder
extends ExcelBuilder {
    private static ExcelProduct excelProduct;
    private IHussarBaseExcelService hussarBaseExcelServiceImpl;

    public ConcreteExcelBuilder() {
    }

    public ConcreteExcelBuilder(String excelName, Long taskId, IHussarBaseExcelService hussarBaseExcelServiceImpl) {
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        excelProduct = new ExcelProduct(excelName, task);
        this.hussarBaseExcelServiceImpl = hussarBaseExcelServiceImpl;
    }

    @Override
    public ExcelBuilder makeClassSheet(ClassSheetMsg classSheetMsg) {
        String dir = System.getProperty("java.io.tmpdir");
        String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + ".xlsx";
        this.hussarBaseExcelServiceImpl.makeClassSheetFile(tempFileName, classSheetMsg, excelProduct.getTask());
        excelProduct.addTempFileNameList(tempFileName);
        return this;
    }

    @Override
    public ExcelBuilder makeTplSheet(TplSheetMsg tplSheetMsg) {
        String dir = System.getProperty("java.io.tmpdir");
        String tempFileNameForTpl = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + ".xlsx";
        this.hussarBaseExcelServiceImpl.makeTplSheetFile(tempFileNameForTpl, tplSheetMsg, excelProduct.getTask());
        excelProduct.addTempFileNameList(tempFileNameForTpl);
        return this;
    }

    @Override
    public ExcelProduct buildExcelProduct() {
        String dir = System.getProperty("java.io.tmpdir");
        String excelTempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + ".xlsx";
        excelProduct.setExcelTempFileName(excelTempFileName);
        if (HussarUtils.isNotEmpty(excelProduct.getTempFileNameList())) {
            MergeExcelSheetUtil.mergeExcel(excelProduct.getTempFileNameList(), excelTempFileName);
        }
        Long ossId = this.hussarBaseExcelServiceImpl.sendFileToOss(excelTempFileName);
        excelProduct.getTask().setTaskFile(ossId);
        excelProduct.getTask().setFileName(excelProduct.getExcelName());
        excelProduct.getTask().setShowMsg("\u5bfc\u51fa\u6210\u529f");
        excelProduct.getTask().setTaskStatus(8);
        return excelProduct;
    }
}

