/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.handler;

import com.alibaba.excel.write.handler.AbstractRowWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class CommentUpdateWriteHandler
extends AbstractRowWriteHandler {
    public static final String SHEETNAME_NAME = "sheetName";
    private String extension;
    public static final String COLINDEX_NAME = "colIndex";
    public static final String ROWINDEX_NAME = "rowIndex";
    public static final String COMMENTCONTENT_NAME = "commentContent";
    private List<String> sheetNameList;
    List<Map<String, String>> commentList = new ArrayList<Map<String, String>>();

    public CommentUpdateWriteHandler(List<Map<String, String>> commentList, String extension) {
        this.commentList = commentList != null && commentList.size() > 0 ? commentList.stream().filter(x -> x.keySet().contains(SHEETNAME_NAME) && x.get(SHEETNAME_NAME) != null && HussarUtils.isNotBlank((CharSequence)((String)x.get(SHEETNAME_NAME)).toString()) && x.keySet().contains(COLINDEX_NAME) && x.get(COLINDEX_NAME) != null && HussarUtils.isNotBlank((CharSequence)((String)x.get(COLINDEX_NAME)).toString()) && x.keySet().contains(ROWINDEX_NAME) && x.get(ROWINDEX_NAME) != null && HussarUtils.isNotBlank((CharSequence)((String)x.get(ROWINDEX_NAME)).toString()) && x.keySet().contains(COMMENTCONTENT_NAME) && x.get(COMMENTCONTENT_NAME) != null && HussarUtils.isNotBlank((CharSequence)((String)x.get(COMMENTCONTENT_NAME)).toString())).collect(Collectors.toList()) : new ArrayList<Map<String, String>>();
        this.sheetNameList = this.commentList.stream().map(x -> ((String)x.get(SHEETNAME_NAME)).toString()).collect(Collectors.toList());
        this.extension = extension;
    }

    public static Map<String, String> createCommentMap(String sheetName, int rowIndex, int columnIndex, String commentContent) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(SHEETNAME_NAME, sheetName);
        map.put(ROWINDEX_NAME, rowIndex + "");
        map.put(COLINDEX_NAME, columnIndex + "");
        map.put(COMMENTCONTENT_NAME, commentContent);
        return map;
    }

    public void afterRowDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Integer relativeRowIndex, Boolean isHead) {
        Sheet sheet = writeSheetHolder.getSheet();
        if (this.commentList == null || this.commentList.size() <= 0 || !this.sheetNameList.contains(sheet.getSheetName())) {
            return;
        }
        List rowCommentList = this.commentList.stream().filter(x -> HussarUtils.equals((Object)((String)x.get(SHEETNAME_NAME)).toString(), (Object)sheet.getSheetName()) && relativeRowIndex == Integer.parseInt((String)x.get(ROWINDEX_NAME))).collect(Collectors.toList());
        if (rowCommentList == null || rowCommentList.size() <= 0) {
            return;
        }
        List colIndexList = rowCommentList.stream().map(x -> (String)x.get(COLINDEX_NAME)).distinct().collect(Collectors.toList());
        Workbook workbook = sheet.getWorkbook();
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(IndexedColors.ORANGE.getIndex());
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        for (String colIndex : colIndexList) {
            List cellCommentList = rowCommentList.stream().filter(x -> HussarUtils.equals((Object)colIndex, x.get(COLINDEX_NAME))).collect(Collectors.toList());
            if (HussarUtils.isEmpty(cellCommentList) || isHead.booleanValue()) continue;
            String commentContent = cellCommentList.stream().map(x -> (String)x.get(COMMENTCONTENT_NAME)).collect(Collectors.joining());
            Cell cell = row.getCell(Integer.parseInt(colIndex));
            cell.setCellStyle(cellStyle);
            CommentUpdateWriteHandler.addComment(cell, commentContent, this.extension);
        }
        this.commentList.remove(rowCommentList);
        this.sheetNameList = this.commentList.stream().map(x -> ((String)x.get(SHEETNAME_NAME)).toString()).collect(Collectors.toList());
    }

    public static void addComment(Cell cell, String value, String extension) {
        Sheet sheet = cell.getSheet();
        cell.removeCellComment();
        if ("xls".equals(extension)) {
            HSSFClientAnchor anchor = new HSSFClientAnchor();
            anchor.setDx1(0);
            anchor.setDx2(0);
            anchor.setDy1(0);
            anchor.setDy2(0);
            anchor.setCol1(cell.getColumnIndex());
            anchor.setRow1(cell.getRowIndex());
            anchor.setCol2(cell.getColumnIndex() + 5);
            anchor.setRow2(cell.getRowIndex() + 6);
            Drawing drawing = sheet.createDrawingPatriarch();
            Comment comment = drawing.createCellComment((ClientAnchor)anchor);
            comment.setString((RichTextString)new HSSFRichTextString(value));
            cell.setCellComment(comment);
        } else if ("xlsx".equals(extension)) {
            XSSFClientAnchor anchor = new XSSFClientAnchor();
            anchor.setDx1(0);
            anchor.setDx2(0);
            anchor.setDy1(0);
            anchor.setDy2(0);
            anchor.setCol1(cell.getColumnIndex());
            anchor.setRow1(cell.getRowIndex());
            anchor.setCol2(cell.getColumnIndex() + 5);
            anchor.setRow2(cell.getRowIndex() + 6);
            Drawing drawing = sheet.createDrawingPatriarch();
            Comment comment = drawing.createCellComment((ClientAnchor)anchor);
            comment.setString((RichTextString)new XSSFRichTextString(value));
            cell.setCellComment(comment);
        }
    }
}

