/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class MergeExcelSheetUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeExcel(List<String> files, String mergedFileName) {
        XSSFWorkbook newExcelCreat = new XSSFWorkbook();
        XSSFWorkbook fromExcel = new XSSFWorkbook();
        for (String fromExcelName : files) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(fromExcelName);
                fromExcel = new XSSFWorkbook((InputStream)fileInputStream);
                int length = fromExcel.getNumberOfSheets();
                if (length <= 1) {
                    XSSFSheet oldSheet = fromExcel.getSheetAt(0);
                    XSSFSheet newSheet = newExcelCreat.createSheet(oldSheet.getSheetName());
                    MergeExcelSheetUtil.copySheet(newExcelCreat, oldSheet, newSheet);
                    continue;
                }
                for (int i = 0; i < length; ++i) {
                    XSSFSheet oldSheet = fromExcel.getSheetAt(i);
                    XSSFSheet newSheet = newExcelCreat.createSheet(oldSheet.getSheetName());
                    MergeExcelSheetUtil.copySheet(newExcelCreat, oldSheet, newSheet);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (FileOutputStream fileOut = new FileOutputStream(mergedFileName);){
            newExcelCreat.write((OutputStream)fileOut);
            fileOut.flush();
            fromExcel.close();
            newExcelCreat.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                newExcelCreat.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void mergeSheetAllRegion(XSSFSheet fromSheet, XSSFSheet toSheet) {
        int num = fromSheet.getNumMergedRegions();
        CellRangeAddress cellR = null;
        for (int i = 0; i < num; ++i) {
            cellR = fromSheet.getMergedRegion(i);
            toSheet.addMergedRegion(cellR);
        }
    }

    private static void copyCell(XSSFWorkbook wb, XSSFCell fromCell, XSSFCell toCell) {
        XSSFCellStyle newstyle = wb.createCellStyle();
        newstyle.cloneStyleFrom((CellStyle)fromCell.getCellStyle());
        toCell.setCellStyle((CellStyle)newstyle);
        if (fromCell.getCellComment() != null) {
            toCell.setCellComment((Comment)fromCell.getCellComment());
        }
        CellType fromCellType = fromCell.getCellType();
        toCell.setCellType(fromCellType);
        if (fromCellType == CellType.NUMERIC) {
            if (DateUtil.isCellDateFormatted((Cell)fromCell)) {
                toCell.setCellValue(fromCell.getDateCellValue());
            } else {
                toCell.setCellValue(fromCell.getNumericCellValue());
            }
        } else if (fromCellType == CellType.STRING) {
            toCell.setCellValue((RichTextString)fromCell.getRichStringCellValue());
        } else if (fromCellType != CellType.BLANK) {
            if (fromCellType == CellType.BOOLEAN) {
                toCell.setCellValue(fromCell.getBooleanCellValue());
            } else if (fromCellType == CellType.ERROR) {
                toCell.setCellErrorValue(fromCell.getErrorCellValue());
            } else if (fromCellType == CellType.FORMULA) {
                toCell.setCellFormula(fromCell.getCellFormula());
            }
        }
    }

    private static void copyRow(XSSFWorkbook wb, XSSFRow oldRow, XSSFRow toRow) {
        toRow.setHeight(oldRow.getHeight());
        Iterator cellIt = oldRow.cellIterator();
        while (cellIt.hasNext()) {
            XSSFCell tmpCell = (XSSFCell)cellIt.next();
            XSSFCell newCell = toRow.createCell(tmpCell.getColumnIndex());
            MergeExcelSheetUtil.copyCell(wb, tmpCell, newCell);
        }
    }

    private static void copySheet(XSSFWorkbook wb, XSSFSheet fromSheet, XSSFSheet toSheet) {
        MergeExcelSheetUtil.mergeSheetAllRegion(fromSheet, toSheet);
        int length = fromSheet.getRow(fromSheet.getFirstRowNum()).getLastCellNum();
        for (int i = 0; i <= length; ++i) {
            toSheet.setColumnWidth(i, fromSheet.getColumnWidth(i));
        }
        Iterator rowIt = fromSheet.rowIterator();
        while (rowIt.hasNext()) {
            XSSFRow oldRow = (XSSFRow)rowIt.next();
            XSSFRow newRow = toSheet.createRow(oldRow.getRowNum());
            MergeExcelSheetUtil.copyRow(wb, oldRow, newRow);
        }
    }
}

