/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.handler;

import com.alibaba.excel.write.handler.AbstractRowWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class HussarBaseErrorSheetWriteHandler
extends AbstractRowWriteHandler {
    private List<Map<Integer, String>> errMsgList;

    public HussarBaseErrorSheetWriteHandler(List<Map<Integer, String>> errMsgList) {
        this.errMsgList = errMsgList;
    }

    public void afterRowDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Integer relativeRowIndex, Boolean isHead) {
        if (!isHead.booleanValue()) {
            Sheet sheet = writeSheetHolder.getSheet();
            Map<Integer, String> rowErrMap = this.errMsgList.get(relativeRowIndex);
            for (Map.Entry<Integer, String> cellMap : rowErrMap.entrySet()) {
                this.setPostil(sheet, relativeRowIndex, cellMap.getKey(), cellMap.getValue());
            }
        }
    }

    private void setPostil(Sheet sheet, Integer relativeRowIndex, Integer i, String msg) {
        Workbook workbook = sheet.getWorkbook();
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(IndexedColors.RED.getIndex());
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        Drawing drawingPatriarch = sheet.createDrawingPatriarch();
        Comment comment = drawingPatriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, 0, 0, 2, 2));
        comment.setString((RichTextString)new XSSFRichTextString(msg));
        sheet.getRow(relativeRowIndex + 1).getCell(i.intValue()).setCellComment(comment);
        sheet.getRow(relativeRowIndex + 1).getCell(i.intValue()).setCellStyle(cellStyle);
    }
}

