/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.util;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.merge.AbstractMergeStrategy;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class CustomMergeStrategy
extends AbstractMergeStrategy {
    private List<List<Integer>> mergeColDataGroupCountList;
    private List<Integer> targetColumnIndex;
    private Integer rowIndex;

    public CustomMergeStrategy(List<List<String>> mergeColDataList, List<Integer> targetColumnIndex) {
        this.mergeColDataGroupCountList = this.getGroupCountList(mergeColDataList);
        this.targetColumnIndex = targetColumnIndex;
    }

    protected void merge(Sheet sheet, Cell cell, Head head, Integer relativeRowIndex) {
        if (null == this.rowIndex) {
            this.rowIndex = cell.getRowIndex();
        }
        if (cell.getRowIndex() == this.rowIndex.intValue() && this.targetColumnIndex.contains(cell.getColumnIndex())) {
            AtomicInteger i = new AtomicInteger(0);
            Optional<Integer> first = this.targetColumnIndex.stream().filter(col -> {
                i.getAndIncrement();
                return col.intValue() == cell.getColumnIndex();
            }).findFirst();
            this.mergeGroupColumn(sheet, first.get());
        }
    }

    private void mergeGroupColumn(Sheet sheet, Integer index) {
        int rowCount = this.rowIndex;
        for (Integer count : this.mergeColDataGroupCountList.get(index)) {
            if (count == 1) {
                rowCount += count.intValue();
                continue;
            }
            CellRangeAddress cellRangeAddress = new CellRangeAddress(rowCount, rowCount + count - 1, this.targetColumnIndex.get(index).intValue(), this.targetColumnIndex.get(index).intValue());
            sheet.addMergedRegionUnsafe(cellRangeAddress);
            rowCount += count.intValue();
        }
    }

    private List<List<Integer>> getGroupCountList(List<List<String>> exportDataList) {
        if (HussarUtils.isEmpty(exportDataList)) {
            return new ArrayList<List<Integer>>();
        }
        ArrayList<List<Integer>> groupCountListList = new ArrayList<List<Integer>>();
        exportDataList.forEach(dataList -> {
            ArrayList<Integer> groupCountList = new ArrayList<Integer>();
            int count = 1;
            for (int i = 1; i < dataList.size(); ++i) {
                if (((String)dataList.get(i)).equals(dataList.get(i - 1))) {
                    ++count;
                    continue;
                }
                groupCountList.add(count);
                count = 1;
            }
            groupCountList.add(count);
            groupCountListList.add(groupCountList);
        });
        return groupCountListList;
    }
}

