/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.validate;

import com.alibaba.excel.annotation.ExcelProperty;
import com.jxdinfo.hussar.common.exception.BaseException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class HussarBaseExcelValidateHelper {
    private static Validator validator = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).addProperty("hibernate.validator.fail_fast", "false")).buildValidatorFactory().getValidator();

    public static <T> Map<Integer, Map<Integer, String>> validateEntity(T obj, Integer rowIndex) {
        HashMap<Integer, Map<Integer, String>> resultMapNum = new HashMap<Integer, Map<Integer, String>>();
        HashMap<Integer, String> resultMap = new HashMap<Integer, String>();
        Set set = validator.validate(obj, new Class[]{Default.class});
        if (set != null && set.size() != 0) {
            int i = 0;
            for (ConstraintViolation cv : set) {
                Field declaredField = null;
                try {
                    declaredField = obj.getClass().getDeclaredField(cv.getPropertyPath().toString());
                }
                catch (NoSuchFieldException e) {
                    throw new BaseException("NoSuchFieldException\uff1a" + cv.getPropertyPath().toString());
                }
                ExcelProperty annotation = declaredField.getAnnotation(ExcelProperty.class);
                int index = annotation.index();
                if (index == -1) {
                    index = i;
                }
                if (resultMap.get(index) != null) {
                    resultMap.put(index, (String)resultMap.get(index) + ";" + cv.getMessage());
                } else {
                    resultMap.put(index, cv.getMessage());
                }
                ++i;
            }
            resultMapNum.put(rowIndex, resultMap);
        }
        return resultMapNum;
    }

    public static void addErrorMsg(int rowIndex, int index, String errorMsg, Map<Integer, Map<Integer, String>> resultMapNum) {
        Map<Object, Object> resultMap = new HashMap();
        if (resultMapNum.get(rowIndex) != null) {
            resultMap = resultMapNum.get(rowIndex);
        }
        if (resultMap.get(index) != null) {
            resultMap.put(index, (String)resultMap.get(index) + ";" + errorMsg);
        } else {
            resultMap.put(index, errorMsg);
        }
        resultMapNum.put(rowIndex, resultMap);
    }
}

