/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.jxdinfo.hussar.excel.util.CommentWriteHandler;
import com.jxdinfo.hussar.excel.util.CustomMergeStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class HussarBaseExcelUtils {
    public static void writeExcel(OutputStream outputStream, List objects, Class clazz, List<Map<Integer, Map<Integer, String>>> errMsgList, String sheetName) {
        try {
            WriteCellStyle headWriteCellStyle = new WriteCellStyle();
            headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.WHITE.getIndex()));
            WriteFont headWriteFont = new WriteFont();
            headWriteFont.setFontHeightInPoints(Short.valueOf((short)14));
            headWriteFont.setBold(Boolean.valueOf(true));
            headWriteCellStyle.setWriteFont(headWriteFont);
            headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
            WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
            WriteFont contentWriteFont = new WriteFont();
            contentWriteFont.setFontHeightInPoints(Short.valueOf((short)12));
            contentWriteFont.setFontName("\u5b8b\u4f53");
            contentWriteCellStyle.setWriteFont(contentWriteFont);
            contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
            contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
            List<Map<String, String>> commentList = HussarBaseExcelUtils.writeHandlerList(errMsgList, sheetName);
            ExcelWriterBuilder write = (ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)outputStream, (Class)clazz).useDefaultStyle(Boolean.valueOf(true))).relativeHeadRowIndex(Integer.valueOf(1));
            if (errMsgList != null) {
                ((ExcelWriterBuilder)write.inMemory(Boolean.TRUE).registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).registerWriteHandler((WriteHandler)new CommentWriteHandler(commentList, "xlsx"));
            }
            ((ExcelWriterBuilder)write.registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).sheet(sheetName).doWrite((Collection)objects);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5199\u5165excel\u51fa\u9519,\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            if (outputStream != null) {
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
        }
    }

    public static void writeExcel(OutputStream outputStream, List objects, Class clazz, List<Map<Integer, Map<Integer, String>>> errMsgList, String sheetName, CustomMergeStrategy customMergeStrategy) {
        try {
            WriteCellStyle headWriteCellStyle = new WriteCellStyle();
            headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.WHITE.getIndex()));
            WriteFont headWriteFont = new WriteFont();
            headWriteFont.setFontHeightInPoints(Short.valueOf((short)14));
            headWriteFont.setBold(Boolean.valueOf(true));
            headWriteCellStyle.setWriteFont(headWriteFont);
            headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
            WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
            WriteFont contentWriteFont = new WriteFont();
            contentWriteFont.setFontHeightInPoints(Short.valueOf((short)12));
            contentWriteFont.setFontName("\u5b8b\u4f53");
            contentWriteCellStyle.setWriteFont(contentWriteFont);
            contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
            contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
            List<Map<String, String>> commentList = HussarBaseExcelUtils.writeHandlerList(errMsgList, sheetName);
            ExcelWriterBuilder write = (ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)outputStream, (Class)clazz).useDefaultStyle(Boolean.valueOf(true))).relativeHeadRowIndex(Integer.valueOf(1))).registerWriteHandler((WriteHandler)customMergeStrategy);
            if (errMsgList != null) {
                ((ExcelWriterBuilder)write.inMemory(Boolean.TRUE).registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).registerWriteHandler((WriteHandler)new CommentWriteHandler(commentList, "xlsx"));
            }
            ((ExcelWriterBuilder)write.registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).sheet(sheetName).doWrite((Collection)objects);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5199\u5165excel\u51fa\u9519,\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            if (outputStream != null) {
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
        }
    }

    private static List<List<String>> getHeader(Class clazz) throws NoSuchFieldException {
        Map<Integer, String> indexNameMap = HussarBaseExcelUtils.getIndexNameMap(clazz);
        String first = "\u5bfc\u5165\u4fe1\u606f\u5b58\u5728\u9519\u8bef\uff01\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165";
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        Set<Integer> keySet = indexNameMap.keySet();
        for (Integer key : keySet) {
            ArrayList<String> head0 = new ArrayList<String>();
            head0.add(first);
            head0.add(indexNameMap.get(key));
            list.add(head0);
        }
        return list;
    }

    public static Map<Integer, String> getIndexNameMap(Class clazz) throws NoSuchFieldException {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = clazz.getDeclaredField(fields[i].getName());
            field.setAccessible(true);
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            if (excelProperty == null) continue;
            int index = excelProperty.index();
            index = index == -1 ? i : index;
            String[] values = excelProperty.value();
            StringBuilder value = new StringBuilder();
            for (String v : values) {
                value.append(v);
            }
            result.put(index, value.toString());
        }
        return result;
    }

    private static List<Map<String, String>> writeHandlerList(List<Map<Integer, Map<Integer, String>>> errMsgList, String sheetName) {
        ArrayList<Map<String, String>> commentList = new ArrayList<Map<String, String>>();
        errMsgList.forEach(map -> {
            int rowIndex = -1;
            int colIndex = -1;
            String commentMsg = "";
            for (Integer key : map.keySet()) {
                rowIndex = key;
                Map comMap = (Map)map.get(key);
                for (Integer comKey : comMap.keySet()) {
                    colIndex = comKey;
                    commentMsg = (String)comMap.get(comKey);
                    commentList.add(CommentWriteHandler.createCommentMap(sheetName, rowIndex, colIndex, commentMsg));
                }
            }
        });
        return commentList;
    }

    public static void writeExcel(OutputStream outputStream, List objects, Class clazz, String sheetName) {
        try {
            ExcelWriterBuilder write = EasyExcel.write((OutputStream)outputStream, (Class)clazz);
            ((ExcelWriterBuilder)write.registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName).doWrite((Collection)objects);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5199\u5165excel\u51fa\u9519,\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            if (outputStream != null) {
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
        }
    }

    public static void writeExcelNum(OutputStream outputStream, List objects, List objects2, Class clazz, Class clazz2, String sheetName, String sheetName2) {
        try {
            WriteCellStyle headWriteCellStyle = new WriteCellStyle();
            headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
            WriteFont headWriteFont = new WriteFont();
            headWriteFont.setFontHeightInPoints(Short.valueOf((short)13));
            headWriteFont.setBold(Boolean.valueOf(true));
            headWriteCellStyle.setWriteFont(headWriteFont);
            headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
            WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
            contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
            HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
            ExcelWriter excelWriter = EasyExcel.write((OutputStream)outputStream).build();
            WriteSheet writeSheet1 = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)0, (String)sheetName2).head(clazz2)).registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).relativeHeadRowIndex(Integer.valueOf(1))).build();
            WriteSheet writeSheet2 = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)1, (String)sheetName).head(clazz)).registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).build();
            excelWriter.write((Collection)objects2, writeSheet1);
            excelWriter.write((Collection)objects, writeSheet2);
            excelWriter.finish();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5199\u5165excel\u51fa\u9519,\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            if (outputStream != null) {
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
        }
    }

    public static void writeExcelNum(OutputStream outputStream, List objects, List objects2, Class clazz, Class clazz2, String sheetName, String sheetName2, CustomMergeStrategy customMergeStrategy) {
        try {
            WriteCellStyle headWriteCellStyle = new WriteCellStyle();
            headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
            WriteFont headWriteFont = new WriteFont();
            headWriteFont.setFontHeightInPoints(Short.valueOf((short)13));
            headWriteFont.setBold(Boolean.valueOf(true));
            headWriteCellStyle.setWriteFont(headWriteFont);
            headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
            WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
            contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
            HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
            ExcelWriter excelWriter = EasyExcel.write((OutputStream)outputStream).build();
            WriteSheet writeSheet1 = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)0, (String)sheetName2).head(clazz2)).registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).registerWriteHandler((WriteHandler)customMergeStrategy)).relativeHeadRowIndex(Integer.valueOf(1))).build();
            WriteSheet writeSheet2 = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)1, (String)sheetName).head(clazz)).registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).build();
            excelWriter.write((Collection)objects2, writeSheet1);
            excelWriter.write((Collection)objects, writeSheet2);
            excelWriter.finish();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5199\u5165excel\u51fa\u9519,\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            if (outputStream != null) {
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
        }
    }

    public static Workbook judegExcelEdition(String fileName, InputStream inputStream) throws IOException {
        HSSFWorkbook workbook = null;
        if (fileName.matches("^.+\\.(?i)(xls)$")) {
            workbook = new HSSFWorkbook(inputStream);
            return workbook;
        }
        workbook = new XSSFWorkbook(inputStream);
        return workbook;
    }
}

