/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eryuanregister.service.impl;

import com.jxdinfo.hussar.common.constant.ServerConstants;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.eryuanregister.dao.SysServerInfoMapper;
import com.jxdinfo.hussar.eryuanregister.service.IHussarBaseRefEryuanRegisterService;
import com.jxdinfo.hussar.eryuanregister.vo.SysServerInfoVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eryuanregister.service.impl.sussarBaseRefEryuanRegisterServiceImpl")
@HussarDs(value="master")
public class HussarBaseRefEryuanRegisterServiceImpl
implements IHussarBaseRefEryuanRegisterService {
    @Resource
    private SysServerInfoMapper serverInfoMapper;
    private List<Long> systemUsers = new ArrayList<Long>(Arrays.asList(ServerConstants.SYSTEM_ADMIM_USER, ServerConstants.SECURITY_ADMIN_USER, ServerConstants.SECURITY_AUDIT_USER));

    public List<SysServerInfoVo> getServerList(String serverName, String groupName, String serverCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("serverName", serverName);
        params.put("groupName", groupName);
        params.put("serverCode", serverCode);
        Collection<Long> struIdList = this.getAllStruIdsByUser();
        params.put("struIdList", struIdList);
        return this.serverInfoMapper.getServerList(params);
    }

    private Collection<Long> getAllStruIdsByUser() {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getId();
        if (this.systemUsers.contains(userId)) {
            return null;
        }
        String fDeptId = this.serverInfoMapper.getUserDeptfId(userId);
        Set<Long> struCollection = Arrays.stream(fDeptId.split("/")).filter(HussarUtils::isNotBlank).map(Long::parseLong).collect(Collectors.toSet());
        return struCollection;
    }

    public List<SysServerInfoVo> getServerInfoByUserId(Long userId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!this.systemUsers.contains(userId)) {
            String fDeptId = this.serverInfoMapper.getUserDeptfId(userId);
            Set struCollection = Arrays.stream(fDeptId.split("/")).filter(HussarUtils::isNotBlank).map(Long::parseLong).collect(Collectors.toSet());
            struCollection.addAll(this.serverInfoMapper.getSubStruIdList(fDeptId));
            params.put("struIdList", struCollection);
        }
        List<SysServerInfoVo> serverList = this.serverInfoMapper.getServerList(params);
        return serverList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SysServerInfoVo>(Comparator.comparing(SysServerInfoVo::getServerId))), ArrayList::new));
    }

    public SysServerInfoVo getServerInfoByServerId(Long serverId) {
        return this.serverInfoMapper.getServerById(serverId);
    }

    public SysServerInfoVo getServerInfoByServerName(String serverName) {
        return this.serverInfoMapper.getServerByName(serverName);
    }

    public SysServerInfoVo getServerInfoByServerCode(String serverCode) {
        return this.serverInfoMapper.getServerByCode(serverCode);
    }
}

