/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eryuanregister.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceBoService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseStruRoleBoService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserRoleBoService;
import com.jxdinfo.hussar.base.cloud.dto.ResourceGrantedAuthority;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarServerProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.eryuanregister.dao.SysServerInfoMapper;
import com.jxdinfo.hussar.eryuanregister.dto.ServerStruRelationDto;
import com.jxdinfo.hussar.eryuanregister.model.SysRoleServer;
import com.jxdinfo.hussar.eryuanregister.model.SysServerInfo;
import com.jxdinfo.hussar.eryuanregister.model.SysServerStru;
import com.jxdinfo.hussar.eryuanregister.service.IHussarBaseEryuanRegisterService;
import com.jxdinfo.hussar.eryuanregister.service.IHussarBaseRefEryuanRegisterService;
import com.jxdinfo.hussar.eryuanregister.service.ISysRoleServerService;
import com.jxdinfo.hussar.eryuanregister.service.ISysServerInfoService;
import com.jxdinfo.hussar.eryuanregister.service.ISysServerStruService;
import com.jxdinfo.hussar.eryuanregister.vo.EditInfoVo;
import com.jxdinfo.hussar.eryuanregister.vo.OrganTreeVo;
import com.jxdinfo.hussar.eryuanregister.vo.ServerDetailVo;
import com.jxdinfo.hussar.eryuanregister.vo.SysServerInfoVo;
import com.jxdinfo.hussar.example.plugin.feign.HussarCommonFeignServiceImpl;
import com.jxdinfo.hussar.example.plugin.feign.HussarDynamicFeignClientFactory;
import com.jxdinfo.hussar.formerlycommon.util.datasource.DataSourceUtil;
import com.jxdinfo.hussar.identity.organ.dao.AssigneeChooseEyMapper;
import com.jxdinfo.hussar.identity.organ.model.BpmTreeModel;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eryuanregister.service.impl.hussarBaseEryuanRegisterServiceImpl")
@HussarDs(value="master")
public class HussarBaseEryuanRegisterServiceImpl
implements IHussarBaseEryuanRegisterService {
    @Value(value="${hussar.cloud.enable}")
    private Boolean cloud;
    @Autowired
    private ISysServerInfoService serverInfoService;
    @Autowired
    private ISysServerStruService serverStruService;
    @Resource
    private SysServerInfoMapper serverInfoMapper;
    @Resource
    private ISysRoleServerService sysRoleServerService;
    @Resource
    private SysDataSourceService dataSourceService;
    @Autowired
    private IHussarBaseRefEryuanRegisterService hussarBaseRefEryuanRegisterService;
    @Resource
    private HussarServerProperties hussarServerProperties;
    @Resource
    private AssigneeChooseEyMapper assigneeChooseEyMapper;
    @Resource
    private IHussarBaseResourceBoService hussarBaseResourceBoService;
    @Resource
    private IHussarBaseUserRoleBoService hussarBaseUserRoleBoService;
    @Resource
    private IHussarBaseStruRoleBoService hussarBaseStruRoleBoService;
    @Autowired
    private DiscoveryClient discoveryClient;

    public Long addServer(SysServerInfo sysServerInfo) {
        this.checkServer(sysServerInfo);
        Integer sort = sysServerInfo.getSort();
        if (sort == null) {
            Integer maxSort = this.serverInfoMapper.getMaxSort();
            sort = maxSort == null ? 1 : maxSort + 1;
            sysServerInfo.setSort(sort);
        }
        this.serverInfoService.save((Object)sysServerInfo);
        return sysServerInfo.getServerId();
    }

    public String updateServer(SysServerInfo sysServerInfo) {
        this.checkServer(sysServerInfo);
        this.serverInfoService.updateById((Object)sysServerInfo);
        return "\u4fee\u6539\u6210\u529f\uff01";
    }

    public String deleteServer(String serverIds) {
        AssertUtil.isNotEmpty((String)serverIds, (String)"\u8981\u5220\u9664\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        Set serverIdSet = Arrays.stream(serverIds.split(",")).map(Long::parseLong).collect(Collectors.toSet());
        List sysServerInfoList = this.serverInfoService.listByIds(serverIdSet);
        for (SysServerInfo item : sysServerInfoList) {
            item.setDelFlag("1");
        }
        this.serverInfoService.updateBatchById((Collection)sysServerInfoList);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysServerStru::getServerId, serverIdSet);
        this.serverStruService.remove((Wrapper)queryWrapper);
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    public Page<SysServerInfoVo> getServerListPage(PageInfo pageInfo, String serverName, String groupName, String serverCode) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("serverName", serverName);
        params.put("groupName", groupName);
        params.put("serverCode", serverCode);
        List<SysServerInfoVo> serverPage = this.serverInfoMapper.getServerPage((Page<SysServerInfoVo>)page, params);
        if (!serverPage.isEmpty()) {
            for (SysServerInfoVo infoVo : serverPage) {
                if (!HussarUtils.isEmpty((Object)infoVo.getDataSourceId())) continue;
                infoVo.setDbName("master");
            }
        }
        page.setRecords(serverPage);
        return page;
    }

    public String saveServerStruRelation(ServerStruRelationDto serverStruRelationDto) {
        Long serverId = serverStruRelationDto.getServerId();
        if (HussarUtils.isEmpty((Object)serverId)) {
            throw new BaseException("\u670d\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.checkOrganRelations(serverStruRelationDto.getStruIdList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysServerStru::getServerId, (Object)serverId);
        this.serverStruService.remove((Wrapper)queryWrapper);
        List struIdList = serverStruRelationDto.getStruIdList();
        if (HussarUtils.isNotEmpty((Object)struIdList)) {
            ArrayList<SysServerStru> serverStruList = new ArrayList<SysServerStru>();
            for (Long struId : struIdList) {
                SysServerStru sysServerStru = new SysServerStru();
                sysServerStru.setServerId(serverId);
                sysServerStru.setStruId(struId);
                serverStruList.add(sysServerStru);
            }
            this.serverStruService.saveBatch(serverStruList);
            if (this.cloud.booleanValue()) {
                SysServerInfo serverInfo = (SysServerInfo)this.serverInfoService.getById((Serializable)serverStruRelationDto.getServerId());
                List services = this.discoveryClient.getServices();
                if (services.contains(serverInfo.getServerCode())) {
                    List organCodeId = this.assigneeChooseEyMapper.getOrgCodeIdByServerCode(serverInfo.getServerCode());
                    List user = this.assigneeChooseEyMapper.getUserListByParentId(null, null, organCodeId);
                    List list = user.stream().map(BpmTreeModel::getId).collect(Collectors.toList());
                    HussarDynamicFeignClientFactory hussarDynamicFeignClientFactory = (HussarDynamicFeignClientFactory)SpringContextUtil.getBean(HussarDynamicFeignClientFactory.class);
                    HussarCommonFeignServiceImpl testFeignService = (HussarCommonFeignServiceImpl)hussarDynamicFeignClientFactory.getFeignClient(HussarCommonFeignServiceImpl.class, serverInfo.getServerCode());
                    try {
                        testFeignService.saveUserRole(list);
                    }
                    catch (Exception e) {
                        throw new BaseException("\u4fdd\u5b58\u6210\u529f\uff0c\u521d\u59cb\u5316\u89d2\u8272\u5931\u8d25\uff08\u8bf7\u6c42\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff09");
                    }
                }
            }
        }
        return "\u6210\u529f\uff01";
    }

    public ServerDetailVo getServerDetail(Long serverId) {
        SysServerInfoVo serverInfo = this.serverInfoMapper.getServerById(serverId);
        Collection<Long> struIds = this.getStruIdsByServerId(serverId);
        List<Object> organTreeVoList = new ArrayList();
        if (HussarUtils.isNotEmpty(struIds)) {
            organTreeVoList = this.getOrganTree(struIds);
        }
        ServerDetailVo serverDetailVo = new ServerDetailVo();
        if (HussarUtils.isEmpty((Object)serverInfo.getDataSourceId())) {
            serverInfo.setDbName("master");
        }
        serverDetailVo.setServerInfo(serverInfo);
        serverDetailVo.setOrganTree(organTreeVoList);
        return serverDetailVo;
    }

    public EditInfoVo getEditInfo(Long serverId) {
        SysServerInfo serverInfo = (SysServerInfo)this.serverInfoService.getById((Serializable)serverId);
        Collection<Long> struIds = this.getStruIdsByServerId(serverId);
        List<OrganTreeVo> organTreeVoList = this.getOrganTree(null);
        EditInfoVo editInfoVo = new EditInfoVo();
        editInfoVo.setServerInfo(serverInfo);
        editInfoVo.setOrganIds(struIds);
        editInfoVo.setOrganTree(organTreeVoList);
        return editInfoVo;
    }

    public List<OrganTreeVo> getOrganTree(Collection<Long> struIdList) {
        return HussarTreeParser.getTreeList(this.serverInfoMapper.getOrganTree(struIdList));
    }

    public List<Long> getStruIdsByServerName(String serverName) {
        return null;
    }

    public List<Long> getLowerStruIdsByServerName(String serverName) {
        return null;
    }

    public List<SysDataSource> getServerDataSource(String dbName) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysDataSource::getDatasourceType, (Object)"3");
        if (HussarUtils.isNotBlank((CharSequence)dbName)) {
            queryWrapper.like(SysDataSource::getDbName, (Object)dbName);
        }
        return this.dataSourceService.list((Wrapper)queryWrapper);
    }

    public Page<SysDataSource> getServerDataSourcePage(PageInfo pageInfo, String dbName) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysDataSource::getDatasourceType, (Object)"3");
        if (HussarUtils.isNotBlank((CharSequence)dbName)) {
            queryWrapper.like(SysDataSource::getDbName, (Object)dbName);
        }
        return (Page)this.dataSourceService.page((IPage)page, (Wrapper)queryWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean changeServer(String serverName) {
        if (HussarUtils.isNotBlank((CharSequence)serverName)) {
            SysServerInfoVo sysServerInfoVo = this.hussarBaseRefEryuanRegisterService.getServerInfoByServerName(serverName);
            if (HussarUtils.isNotEmpty((Object)serverName)) {
                UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
                HussarSecurityUtils.putSessionExtend((String)"dbName", (Object)sysServerInfoVo.getDbName());
                HussarSecurityUtils.putSessionExtend((String)"serverId", (Object)sysServerInfoVo.getServerId());
                HussarSecurityUtils.putSessionExtend((String)"serverCode", (Object)sysServerInfoVo.getServerCode());
                HussarSecurityUtils.putSessionExtend((String)"serverName", (Object)sysServerInfoVo.getServerName());
                if (this.cloud.booleanValue()) {
                    HussarCacheUtil.evict((String)"login_user_info", (Object)(userDetails.getAccessToken() + sysServerInfoVo.getServerId()));
                }
                try {
                    DataSourceUtil.changeTempDs((String)sysServerInfoVo.getDbName());
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIN);
                    auditLogModel.setEventDesc("\u767b\u5f55\u6210\u529f\uff01");
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    List rolesList = this.hussarBaseUserRoleBoService.getRolesByUserId(userDetails.getUserId());
                    HussarSecurityUtils.putSessionExtend((String)"gradeAdmin", (Object)(ToolUtil.isNotEmpty((Object)rolesList) && rolesList.contains(SysUserAndRole.GRADEADMIN_ROLE.getValue()) ? 1 : 0));
                    Long employeeId = (Long)userDetails.getExtendUserMap("employeeId");
                    Long departmentId = userDetails.getDeptId();
                    if (ToolUtil.isNotEmpty((Object)employeeId) && ToolUtil.isNotEmpty((Object)departmentId)) {
                        List roleList = this.hussarBaseStruRoleBoService.getRolesByStruId(userDetails.getDeptId());
                        if (HussarUtils.isNotEmpty((Object)rolesList)) {
                            rolesList.addAll(roleList);
                        }
                    }
                    HussarSecurityUtils.putSessionExtend((String)"rolesList", (Object)rolesList);
                    ResourceGrantedAuthority resourceGrantedAuthority = this.getPermissionByRoleIds(rolesList, userDetails.getUserId());
                    HussarSecurityUtils.putSessionExtend((String)"permissions", (Object)resourceGrantedAuthority.getGrantAuthorityList());
                }
                finally {
                    DataSourceUtil.poll();
                }
            } else {
                throw new BaseException("\u6240\u9009\u670d\u52a1\u4e0d\u5b58\u5728");
            }
        }
        return true;
    }

    private ResourceGrantedAuthority getPermissionByRoleIds(List<Long> roleList, Long userId) {
        List<String> resourcePermissions;
        ResourceGrantedAuthority resourceGrantedAuthority = new ResourceGrantedAuthority();
        if (roleList.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue()) || roleList.contains(SysUserAndRole.DEVELOP_ROLE.getValue())) {
            List resourcesList = this.hussarBaseResourceBoService.list();
            resourcePermissions = new ArrayList();
            for (SysResources resources : resourcesList) {
                resourcePermissions.add(resources.getPermissions());
            }
        } else {
            resourcePermissions = this.hussarBaseResourceBoService.queryPermissionsByRoleIds(roleList);
        }
        if (HussarUtils.isNotEmpty(resourcePermissions)) {
            resourceGrantedAuthority.setGrantAuthorityList(resourcePermissions);
        }
        return resourceGrantedAuthority;
    }

    public ApiResponse<Object> deleteSourceVerify(String[] ids) {
        List idList = Arrays.stream(ids).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List sysServerInfoList = this.serverInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysServerInfo::getDelFlag, (Object)"0")).in(SysServerInfo::getDataSourceId, idList));
        if (ToolUtil.isNotEmpty((Object)sysServerInfoList)) {
            throw new HussarException("\u6570\u636e\u6e90\u5df2\u5173\u8054\u670d\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        return ApiResponse.success();
    }

    public List<JSTreeModel> serverTree(Long roleId) {
        ArrayList jsTreeModels = Lists.newArrayList();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setCode("GROUP");
        jsTreeModel.setText("\u670d\u52a1\u6811");
        jsTreeModel.setId(Constants.RES_NODE_ID);
        jsTreeModel.setType("isRoot");
        jsTreeModels.add(jsTreeModel);
        List<JSTreeModel> allGroup = this.serverInfoMapper.getServerInfoTree();
        List roleServerList = this.sysRoleServerService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoleServer::getRoleId, (Object)roleId));
        List serverIds = roleServerList.stream().map(SysRoleServer::getServerId).filter(ToolUtil::isNotEmpty).distinct().collect(Collectors.toList());
        for (JSTreeModel model : allGroup) {
            if (serverIds.contains(model.getId())) {
                model.setState(true, true, false);
                continue;
            }
            model.setState(false, false, false);
        }
        jsTreeModels.addAll(allGroup);
        return TreeModelUtils.merge((List)jsTreeModels);
    }

    public List<SysServerInfoVo> queryServerInfo(String serverName, String groupName, String serverCode) {
        List serverList = this.hussarBaseRefEryuanRegisterService.getServerList(serverName, groupName, serverCode);
        SecurityUser user = BaseSecurityUtil.getUser();
        Object serverIdObject = user.getExtendUserMap("serverId");
        if (HussarUtils.isEmpty((Object)serverIdObject)) {
            return serverList;
        }
        String code = (String)user.getExtendUserMap("serverCode");
        for (SysServerInfoVo item : serverList) {
            if (!Objects.equals(item.getServerCode(), code)) continue;
            item.setCurrentServer("1");
            break;
        }
        return serverList;
    }

    private void checkServer(SysServerInfo sysServerInfo) {
        AssertUtil.isNotEmpty((String)sysServerInfo.getGroupName(), (String)"\u670d\u52a1\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkDataSource(sysServerInfo);
        this.checkServerCode(sysServerInfo);
        this.checkServerName(sysServerInfo);
    }

    private void checkServerCode(SysServerInfo sysServerInfo) {
        List serverInfos;
        AssertUtil.isNotEmpty((String)sysServerInfo.getServerCode(), (String)"\u670d\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysServerInfo::getServerCode, (Object)sysServerInfo.getServerCode())).ne(SysServerInfo::getDelFlag, (Object)"1");
        if (HussarUtils.isNotEmpty((Object)sysServerInfo.getServerId())) {
            queryWrapper.ne(SysServerInfo::getServerId, (Object)sysServerInfo.getServerId());
        }
        if ((serverInfos = this.serverInfoService.list((Wrapper)queryWrapper)).size() > 0) {
            throw new BaseException("\u670d\u52a1\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
    }

    private void checkServerName(SysServerInfo sysServerInfo) {
        List serverInfos;
        AssertUtil.isNotEmpty((String)sysServerInfo.getServerName(), (String)"\u670d\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysServerInfo::getGroupName, (Object)sysServerInfo.getGroupName())).eq(SysServerInfo::getServerName, (Object)sysServerInfo.getServerName())).ne(SysServerInfo::getDelFlag, (Object)"1");
        if (HussarUtils.isNotEmpty((Object)sysServerInfo.getServerId())) {
            queryWrapper.ne(SysServerInfo::getServerId, (Object)sysServerInfo.getServerId());
        }
        if ((serverInfos = this.serverInfoService.list((Wrapper)queryWrapper)).size() > 0) {
            throw new BaseException("\u540c\u4e00\u5206\u7ec4\u4e0b\uff0c\u670d\u52a1\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
    }

    private void checkDataSource(SysServerInfo sysServerInfo) {
        List serverInfos;
        SysDataSource sysDataSource;
        if (HussarUtils.isEmpty((Object)sysServerInfo.getDataSourceId())) {
            return;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysServerInfo::getDataSourceId, (Object)sysServerInfo.getDataSourceId())).ne(SysServerInfo::getDelFlag, (Object)"1");
        if (HussarUtils.isNotEmpty((Object)sysServerInfo.getServerId())) {
            queryWrapper.ne(SysServerInfo::getServerId, (Object)sysServerInfo.getServerId());
        }
        if (this.hussarServerProperties.isEnable() && HussarUtils.isNotEmpty((Object)(sysDataSource = (SysDataSource)this.dataSourceService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDataSource::getDbName, (Object)"master"))))) {
            queryWrapper.ne(SysServerInfo::getDataSourceId, (Object)sysDataSource.getId());
        }
        if ((serverInfos = this.serverInfoService.list((Wrapper)queryWrapper)).size() > 0) {
            throw new BaseException("\u6570\u636e\u6e90\u4e0d\u80fd\u91cd\u590d");
        }
    }

    private Collection<Long> getStruIdsByServerId(Long serverId) {
        ArrayList<Long> struIds = new ArrayList<Long>();
        List serverStruList = this.serverStruService.list((Wrapper)new LambdaQueryWrapper().eq(SysServerStru::getServerId, (Object)serverId));
        if (HussarUtils.isNotEmpty((Object)serverStruList)) {
            Set struIdSet = serverStruList.stream().map(SysServerStru::getStruId).collect(Collectors.toSet());
            struIds.addAll(struIdSet);
        }
        return struIds;
    }

    private Collection<Long> getParentStruIds(Collection<Long> struIds) {
        if (HussarUtils.isEmpty(struIds)) {
            return new ArrayList<Long>();
        }
        List<String> fIds = this.serverInfoMapper.getFidByStruId(struIds);
        HashSet<Long> struIdSet = new HashSet<Long>();
        for (String fId : fIds) {
            String[] ids = fId.split("/");
            Set idSet = Arrays.stream(ids).filter(HussarUtils::isNotBlank).map(Long::parseLong).collect(Collectors.toSet());
            struIdSet.addAll(idSet);
        }
        return struIdSet;
    }

    private void checkOrganRelations(Collection<Long> struIds) {
        if (HussarUtils.isEmpty(struIds)) {
            return;
        }
        struIds.forEach(item -> {
            if ("11".equals(item.toString()) && struIds.size() > 1) {
                throw new BaseException("\u6240\u9009\u7ec4\u7ec7\u673a\u6784\u4e0d\u80fd\u5b58\u5728\u4e0a\u4e0b\u7ea7\u5173\u7cfb");
            }
        });
        List<String> fIds = this.serverInfoMapper.getFidByStruId(struIds);
        for (String fid : fIds) {
            int count = 0;
            Set parents = Arrays.stream(fid.split("/")).filter(HussarUtils::isNotBlank).map(Long::parseLong).collect(Collectors.toSet());
            for (Long id : struIds) {
                if (!parents.contains(id)) continue;
                ++count;
            }
            if (count < 2) continue;
            throw new BaseException("\u6240\u9009\u7ec4\u7ec7\u673a\u6784\u4e0d\u80fd\u5b58\u5728\u4e0a\u4e0b\u7ea7\u5173\u7cfb");
        }
    }
}

