/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eryuanregister.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.eryuanregister.dto.ServerStruRelationDto;
import com.jxdinfo.hussar.eryuanregister.model.SysServerInfo;
import com.jxdinfo.hussar.eryuanregister.service.IHussarBaseEryuanRegisterService;
import com.jxdinfo.hussar.eryuanregister.service.IHussarBaseRefEryuanRegisterService;
import com.jxdinfo.hussar.eryuanregister.vo.EditInfoVo;
import com.jxdinfo.hussar.eryuanregister.vo.OrganTreeVo;
import com.jxdinfo.hussar.eryuanregister.vo.ServerDetailVo;
import com.jxdinfo.hussar.eryuanregister.vo.SysServerInfoVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.jxdinfo.hussar.eryuanregister.controller.hussarBaseEryuanRegisterController")
@RequestMapping(value={"hussarbase/eryuanregister/server"})
public class HussarBaseEryuanRegisterController {
    @Autowired
    private IHussarBaseEryuanRegisterService eryuanRegisterService;
    @Autowired
    private IHussarBaseRefEryuanRegisterService refEryuanRegisterService;

    @ApiOperation(value="\u65b0\u589e\u670d\u52a1", notes="\u65b0\u589e\u670d\u52a1")
    @PostMapping(value={"/addServer"})
    @AuditLog(moduleName="\u65b0\u589e\u670d\u52a1", eventDesc="\u65b0\u589e\u670d\u52a1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> addServer(@RequestBody SysServerInfo sysServerInfo) {
        return ApiResponse.success((Object)this.eryuanRegisterService.addServer(sysServerInfo));
    }

    @ApiOperation(value="\u4fee\u6539\u670d\u52a1", notes="\u4fee\u6539\u670d\u52a1")
    @PostMapping(value={"/updateServer"})
    @AuditLog(moduleName="\u4fee\u6539\u670d\u52a1", eventDesc="\u4fee\u6539\u670d\u52a1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> updateServer(@RequestBody SysServerInfo sysServerInfo) {
        return ApiResponse.success((String)this.eryuanRegisterService.updateServer(sysServerInfo));
    }

    @ApiOperation(value="\u5220\u9664\u670d\u52a1", notes="\u5220\u9664\u670d\u52a1")
    @PostMapping(value={"/deleteServer"})
    @AuditLog(moduleName="\u5220\u9664\u670d\u52a1", eventDesc="\u5220\u9664\u670d\u52a1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> deleteServer(@RequestBody String serverIds) {
        return ApiResponse.success((String)this.eryuanRegisterService.deleteServer(serverIds));
    }

    @ApiOperation(value="\u67e5\u8be2\u670d\u52a1\uff08\u5206\u9875\uff09", notes="\u67e5\u8be2\u670d\u52a1\uff08\u5206\u9875\uff09")
    @GetMapping(value={"/queryServerInfoPage"})
    @AuditLog(moduleName="\u67e5\u8be2\u670d\u52a1\uff08\u5206\u9875\uff09", eventDesc="\u67e5\u8be2\u670d\u52a1\uff08\u5206\u9875\uff09", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SysServerInfoVo>> queryServerInfoPage(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @RequestParam(required=false) String serverName, @RequestParam(required=false) String groupName, @RequestParam(required=false) String serverCode) {
        return ApiResponse.success((Object)this.eryuanRegisterService.getServerListPage(pageInfo, serverName, groupName, serverCode));
    }

    @ApiOperation(value="\u67e5\u8be2\u670d\u52a1", notes="\u67e5\u8be2\u670d\u52a1")
    @GetMapping(value={"/queryServerInfo"})
    @AuditLog(moduleName="\u67e5\u8be2\u670d\u52a1", eventDesc="\u67e5\u8be2\u670d\u52a1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysServerInfoVo>> queryServerInfo(@RequestParam(required=false) String serverName, @RequestParam(required=false) String groupName, @RequestParam(required=false) String serverCode) {
        return ApiResponse.success((Object)this.eryuanRegisterService.queryServerInfo(serverName, groupName, serverCode));
    }

    @ApiOperation(value="\u4fdd\u5b58\u670d\u52a1\u7ec4\u7ec7\u5173\u8054\u5173\u7cfb", notes="\u4fdd\u5b58\u670d\u52a1\u7ec4\u7ec7\u5173\u8054\u5173\u7cfb")
    @PostMapping(value={"saveServerStruRelation"})
    @AuditLog(moduleName="\u4fdd\u5b58\u670d\u52a1\u7ec4\u7ec7\u5173\u8054\u5173\u7cfb\uff09", eventDesc="\u4fdd\u5b58\u670d\u52a1\u7ec4\u7ec7\u5173\u8054\u5173\u7cfb\uff09", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> saveServerStruRelation(@RequestBody ServerStruRelationDto serverStruRelationDto) {
        return ApiResponse.success((String)this.eryuanRegisterService.saveServerStruRelation(serverStruRelationDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u8be6\u60c5", notes="\u83b7\u53d6\u670d\u52a1\u8be6\u60c5")
    @GetMapping(value={"getServerDetail"})
    @AuditLog(moduleName="\u83b7\u53d6\u670d\u52a1\u8be6\u60c5", eventDesc="\u83b7\u53d6\u670d\u52a1\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<ServerDetailVo> getServerDetail(@RequestParam Long serverId) {
        return ApiResponse.success((Object)this.eryuanRegisterService.getServerDetail(serverId));
    }

    @ApiOperation(value="\u83b7\u53d6\u4fee\u6539\u4fe1\u606f", notes="\u83b7\u53d6\u4fee\u6539\u4fe1\u606f")
    @GetMapping(value={"getEditInfo"})
    @AuditLog(moduleName="\u83b7\u53d6\u4fee\u6539\u4fe1\u606f", eventDesc="\u83b7\u53d6\u4fee\u6539\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<EditInfoVo> getEditInfo(@RequestParam Long serverId) {
        return ApiResponse.success((Object)this.eryuanRegisterService.getEditInfo(serverId));
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u6811", notes="\u83b7\u53d6\u7ec4\u7ec7\u6811")
    @GetMapping(value={"getOrganTree"})
    @AuditLog(moduleName="\u83b7\u53d6\u7ec4\u7ec7\u6811", eventDesc="\u83b7\u53d6\u7ec4\u7ec7\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganTreeVo>> getOrganTree() {
        return ApiResponse.success((Object)this.eryuanRegisterService.getOrganTree(null));
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u6811", notes="\u83b7\u53d6\u7ec4\u7ec7\u6811")
    @GetMapping(value={"getServerDataSource"})
    @AuditLog(moduleName="\u83b7\u53d6\u7ec4\u7ec7\u6811", eventDesc="\u83b7\u53d6\u7ec4\u7ec7\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysDataSource>> getServerDataSource(@RequestParam(required=false) String dbName) {
        return ApiResponse.success((Object)this.eryuanRegisterService.getServerDataSource(dbName));
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u6811", notes="\u83b7\u53d6\u7ec4\u7ec7\u6811")
    @GetMapping(value={"getServerDataSourcePage"})
    @AuditLog(moduleName="\u83b7\u53d6\u7ec4\u7ec7\u6811", eventDesc="\u83b7\u53d6\u7ec4\u7ec7\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SysDataSource>> getServerDataSourcePage(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @RequestParam(required=false) String dbName) {
        return ApiResponse.success((Object)this.eryuanRegisterService.getServerDataSourcePage(pageInfo, dbName));
    }

    @ApiOperation(value="\u5207\u6362\u670d\u52a1", notes="\u5207\u6362\u670d\u52a1")
    @GetMapping(value={"changeServer"})
    @AuditLog(moduleName="\u5207\u6362\u670d\u52a1", eventDesc="\u5207\u6362\u670d\u52a1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CacheEvict(value={"resource_info"}, allEntries=true)
    public ApiResponse<Boolean> changeServer(@RequestParam String serverName) {
        return ApiResponse.success((Object)this.eryuanRegisterService.changeServer(serverName));
    }

    @ApiOperation(value="\u9a8c\u8bc1\u6570\u636e\u6e90\u662f\u5426\u5173\u8054\u670d\u52a1", notes="\u9a8c\u8bc1\u6570\u636e\u6e90\u662f\u5426\u5173\u8054\u670d\u52a1")
    @PostMapping(value={"/deleteSourceVerify"})
    @AuditLog(moduleName="\u9a8c\u8bc1\u6570\u636e\u6e90\u662f\u5426\u5173\u8054\u670d\u52a1\uff09", eventDesc="\u9a8c\u8bc1\u6570\u636e\u6e90\u662f\u5426\u5173\u8054\u670d\u52a1\uff09", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Object> deleteSourceVerify(@RequestBody String[] ids) {
        return this.eryuanRegisterService.deleteSourceVerify(ids);
    }

    @ApiOperation(value="\u670d\u52a1\u6811\u67e5\u8be2", notes="\u670d\u52a1\u6811\u67e5\u8be2")
    @GetMapping(value={"/serverTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u670d\u52a1\u6811\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> serverTree(@RequestParam Long roleId) {
        return ApiResponse.success((Object)this.eryuanRegisterService.serverTree(roleId));
    }
}

