/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine.rvm.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.engine.common.util.EngineTenantUtil;
import com.jxdinfo.hussar.engine.rvm.dao.RvmContentMapper;
import com.jxdinfo.hussar.engine.rvm.dao.RvmResourceMapper;
import com.jxdinfo.hussar.engine.rvm.dao.RvmVersionMapper;
import com.jxdinfo.hussar.engine.rvm.model.Coordinates;
import com.jxdinfo.hussar.engine.rvm.model.EngineContent;
import com.jxdinfo.hussar.engine.rvm.model.EngineResource;
import com.jxdinfo.hussar.engine.rvm.model.EngineVersion;
import com.jxdinfo.hussar.engine.rvm.model.VersionResource;
import com.jxdinfo.hussar.engine.rvm.model.VersionStrategy;
import com.jxdinfo.hussar.engine.rvm.service.NamedLockManagerService;
import com.jxdinfo.hussar.engine.rvm.service.ResourceVersionManageService;
import com.jxdinfo.hussar.engine.rvm.util.VersioningException;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@HussarDs(value="master")
public class ResourceVersionManageServiceImpl
implements ResourceVersionManageService {
    private final NamedLockManagerService lockManager;
    private final RvmContentMapper contentMapper;
    private static final String LOCK_TYPE_VERSION_INSERTION = "ver";
    private final RvmResourceMapper resourceMapper;
    private static final Logger logger = LoggerFactory.getLogger(ResourceVersionManageServiceImpl.class);
    private static final int MAX_SAVE_RETRY = 10;
    private final RvmVersionMapper versionMapper;

    @Override
    public List<Coordinates> listCoordinatesByType(String a) {
        ResourceVersionManageServiceImpl a2;
        if (a == null) {
            throw new NullPointerException();
        }
        logger.debug(VersionResource.implements("Z\u001dE\u0000u\u001bY\u0006R\u001dX\u0015B\u0011E6O O\u0004S\\B\rF\u0011\u000b\u000fK]"), (Object)a);
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a2;
        return resourceVersionManageServiceImpl.true(a2.resourceMapper.selectResourcesByType(resourceVersionManageServiceImpl.true(), a));
    }

    public void ensureResourceExists(EngineResource a) {
        ResourceVersionManageServiceImpl a2;
        EngineResource engineResource = a;
        engineResource.setId(a2.resourceMapper.selectResourceId(engineResource));
        if (engineResource.getId() != null) {
            logger.debug(VersionResource.implements("\u0001E\u0011\u0016\u0000^\u0011\u0016\u0011N\u001dE\u0000_\u001aQTD\u0011E\u001bC\u0006U\u0011\fTM\t"), (Object)a);
            return;
        }
        try {
            a2.trySaveResource(a);
            return;
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            EngineResource engineResource2 = a;
            engineResource2.setId(a2.resourceMapper.selectResourceId(engineResource2));
            logger.debug(VersionResource.implements("\u0000D\u001dS\u0010\u0016\u0000YTD\u0011B\u0006_\u0011@\u0011\u0016\u0006S\u0007Y\u0001D\u0017ST_\u0010\fTM\t"), (Object)a);
            if (engineResource2.getId() == null) {
                VersioningException versioningException = new VersioningException(VersionResource.implements("\u0012W\u001dZ\u0011RTB\u001b\u0016\u0006S\u0000D\u001dS\u0002STD\u0011E\u001bC\u0006U\u0011\u0016\u001dRX\u0016\u0019W\u001fSTE\u0001D\u0011\u0016\u001aYTX\u0011E\u0000S\u0010\u0016\u0000D\u0015X\u0007W\u0017B\u001dY\u001a\u0016\u001dETC\u0007S\u0010"), dataIntegrityViolationException);
                versioningException.coordinates().setType(a.getType());
                versioningException.coordinates().setName(a.getName());
                versioningException.coordinates().setLabel(a.getLabel());
                logger.debug(VersionResource.implements("P\u0015_\u0018S\u0010\u0016\u0000YTS\u001aE\u0001D\u0011\u0016\u0006S\u0007Y\u0001D\u0017STS\f_\u0007B\u0007\fTM\t"), (Object)a);
                throw versioningException;
            }
            return;
        }
    }

    @Override
    public List<Coordinates> listCoordinates(String a, String a2, String a3) {
        Coordinates coordinates;
        ResourceVersionManageServiceImpl a4;
        if (a2 == null && a3 == null) {
            return a4.listCoordinatesByType((String)a);
        }
        if (a2 == null) {
            return a4.listCoordinatesByTypeAndLabel((String)a, a3);
        }
        if (a3 == null) {
            return a4.listCoordinatesByTypeAndName((String)a, a2);
        }
        Coordinates coordinates2 = coordinates = new Coordinates();
        coordinates.setType((String)a);
        coordinates2.setName(a2);
        coordinates2.setLabel(a3);
        a = a4.get(coordinates2, true);
        if (a == null) {
            return Collections.emptyList();
        }
        Coordinates coordinates3 = coordinates;
        Object object = a;
        coordinates.setMajor(((VersionResource)object).getMajor());
        coordinates3.setMinor(((VersionResource)object).getMinor());
        coordinates3.setPatch(((VersionResource)a).getPatch());
        return Collections.singletonList(coordinates);
    }

    private /* synthetic */ Long true() {
        return EngineTenantUtil.getUserId();
    }

    private /* synthetic */ NamedLockManagerService.Handle true(long a) {
        ResourceVersionManageServiceImpl a2;
        return a2.lockManager.acquire(LOCK_TYPE_VERSION_INSERTION, String.valueOf(a), true);
    }

    @Override
    public List<VersionResource> list(Coordinates a, boolean a222) {
        Iterator a222;
        ResourceVersionManageServiceImpl a3;
        logger.debug(VersionResource.implements("Z\u001dE\u0000\u001e\u0017Y\u001bD\u0010_\u001aW\u0000S\u0007\u000b\u000fKX\u0016\u001aY7Y\u001aB\u0011X\u0000\u000b\u000fK]"), (Object)a, (Object)a222);
        if (((Coordinates)((Object)a)).getType() == null || ((Coordinates)((Object)a)).getName() == null || ((Coordinates)((Object)a)).getLabel() == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        EngineResource engineResource2 = engineResource;
        Coordinates coordinates = a;
        engineResource.setType(coordinates.getType());
        engineResource2.setName(coordinates.getName());
        engineResource2.setLabel(((Coordinates)((Object)a)).getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.true());
        Object object = resourceVersionManageServiceImpl.resourceMapper.selectResourceId(engineResource);
        if (object == null) {
            logger.debug(VersionResource.implements("P\u0015_\u0018S\u0010\u0016\u0000YTZ\u001dE\u0000\u001aTX\u001b\u0016\u0007C\u0017^TD\u0011E\u001bC\u0006U\u0011\fTM\t"), (Object)a);
            return null;
        }
        if ((object = a3.true((Long)object, ((Coordinates)((Object)a)).getMajor(), ((Coordinates)((Object)a)).getMinor(), ((Coordinates)((Object)a)).getPatch(), true)) == null || object.size() == 0) {
            logger.debug(VersionResource.implements("X\u001b\u0016\u0019W\u0000U\u001cS\u0010\u0016\u0002S\u0006E\u001dY\u001a\u0016\u0006S\u0000D\u001dS\u0002S\u0010\fTM\t"), (Object)a);
            return new ArrayList<VersionResource>();
        }
        if (!a222) {
            ArrayList<VersionResource> arrayList = a = object.iterator();
            while (arrayList.hasNext()) {
                EngineVersion a222 = (EngineVersion)((Object)a.next());
                a222.setContent(Optional.ofNullable(a222.getContentId()).map(arg_0 -> ((RvmContentMapper)a3.contentMapper).selectById(arg_0)).orElse(null));
                arrayList = a;
            }
        }
        a = new ArrayList<VersionResource>(object.size());
        Iterator iterator = a222 = object.iterator();
        while (iterator.hasNext()) {
            VersionResource versionResource;
            object = (EngineVersion)((Object)a222.next());
            VersionResource versionResource2 = versionResource = new VersionResource();
            Object object2 = object;
            VersionResource versionResource3 = versionResource;
            VersionResource versionResource4 = versionResource;
            EngineResource engineResource3 = engineResource;
            versionResource.setType(engineResource3.getType());
            versionResource4.setName(engineResource3.getName());
            versionResource4.setLabel(engineResource.getLabel());
            versionResource3.setMajor(((EngineVersion)((Object)object)).getMajor());
            versionResource3.setMinor(((EngineVersion)((Object)object)).getMinor());
            versionResource.setPatch(((EngineVersion)((Object)object2)).getPatch());
            versionResource2.setDescription(((EngineVersion)((Object)object2)).getDescription());
            versionResource2.setContent(Optional.of(object).map(EngineVersion::getContent).map(EngineContent::getData).orElse(null));
            iterator = a222;
            a.add(versionResource);
        }
        logger.debug(VersionResource.implements("\u0018_\u0007B\u0011RT@\u0011D\u0007_\u001bX\u0007\fTM\t"), a);
        return a;
    }

    @Override
    public List<Coordinates> deleteAll(Coordinates a) {
        Object object;
        ResourceVersionManageServiceImpl a2;
        logger.debug(VersionResource.implements("\u0010S\u0018S\u0000S5Z\u0018\u001e\u0017Y\u001bD\u0010_\u001aW\u0000S\u0007\u000b\u000fK]"), (Object)a);
        if (((Coordinates)((Object)a)).getType() == null || ((Coordinates)((Object)a)).getName() == null || ((Coordinates)((Object)a)).getLabel() == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a2;
        EngineResource engineResource2 = engineResource;
        Coordinates coordinates = a;
        engineResource.setType(coordinates.getType());
        engineResource2.setName(coordinates.getName());
        engineResource2.setLabel(((Coordinates)((Object)a)).getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.true());
        Object object2 = resourceVersionManageServiceImpl.resourceMapper.selectResourceId(engineResource);
        if (object2 == null) {
            logger.debug(VersionResource.implements("P\u0015_\u0018S\u0010\u0016\u0000YTR\u0011Z\u0011B\u0011\u001aTX\u001b\u0016\u0007C\u0017^TD\u0011E\u001bC\u0006U\u0011\fTM\t"), (Object)a);
            return null;
        }
        if ((object2 = a2.true((Long)object2, ((Coordinates)((Object)a)).getMajor(), ((Coordinates)((Object)a)).getMinor(), ((Coordinates)((Object)a)).getPatch(), true)) == null || object2.size() == 0) {
            logger.debug(VersionResource.implements("X\u001b\u0016\u0019W\u0000U\u001cS\u0010\u0016\u0002S\u0006E\u001dY\u001a\u0016\u0006S\u0000D\u001dS\u0002S\u0010\fTM\t"), (Object)a);
            return new ArrayList<Coordinates>();
        }
        ArrayList<Coordinates> arrayList = a = object2.iterator();
        while (arrayList.hasNext()) {
            object = (EngineVersion)((Object)a.next());
            arrayList = a;
            a2.versionMapper.updateDataStatusById(((EngineVersion)((Object)object)).getId(), 1, String.valueOf(a2.true()), a2.true());
        }
        a = new ArrayList<Coordinates>();
        object = object2.iterator();
        Object object3 = object;
        while (object3.hasNext()) {
            object2 = (EngineVersion)((Object)object.next());
            Coordinates coordinates2 = new Coordinates();
            object3 = object;
            Coordinates coordinates3 = coordinates2;
            Object object4 = object2;
            Coordinates coordinates4 = coordinates2;
            EngineResource engineResource3 = engineResource;
            coordinates2.setType(engineResource3.getType());
            coordinates4.setName(engineResource3.getName());
            coordinates4.setLabel(engineResource.getLabel());
            coordinates2.setMajor(((EngineVersion)((Object)object4)).getMajor());
            coordinates3.setMinor(((EngineVersion)((Object)object4)).getMinor());
            coordinates3.setPatch(((EngineVersion)((Object)object2)).getPatch());
            a.add(coordinates3);
        }
        logger.debug(VersionResource.implements("R\u0011Z\u0011B\u0011RT@\u0011D\u0007_\u001bXTZ\u001dE\u0000\fTM\t"), a);
        return a;
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public ResourceVersionManageServiceImpl(RvmResourceMapper rvmResourceMapper, RvmVersionMapper rvmVersionMapper, RvmContentMapper rvmContentMapper, NamedLockManagerService namedLockManagerService) {
        void a;
        void a2;
        void a3;
        void a4;
        ResourceVersionManageServiceImpl a5;
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a5;
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl2 = a5;
        resourceVersionManageServiceImpl2.resourceMapper = a4;
        resourceVersionManageServiceImpl2.versionMapper = a3;
        resourceVersionManageServiceImpl.contentMapper = a2;
        resourceVersionManageServiceImpl.lockManager = a;
    }

    @Override
    public VersionResource get(Coordinates a, boolean a222) {
        VersionResource a222;
        ResourceVersionManageServiceImpl a3;
        logger.debug(VersionResource.implements("\u0013S\u0000\u001e\u0017Y\u001bD\u0010_\u001aW\u0000S\u0007\u000b\u000fKX\u0016\u001aY7Y\u001aB\u0011X\u0000\u000b\u000fK]"), a, (Object)a222);
        if (((Coordinates)a).getType() == null || ((Coordinates)a).getName() == null || ((Coordinates)a).getLabel() == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        EngineResource engineResource2 = engineResource;
        Coordinates coordinates = a;
        engineResource.setType(coordinates.getType());
        engineResource2.setName(coordinates.getName());
        engineResource2.setLabel(((Coordinates)a).getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.true());
        Object object = resourceVersionManageServiceImpl.resourceMapper.selectResourceId(engineResource);
        if (object == null) {
            logger.debug(VersionResource.implements("\u0012W\u001dZ\u0011RTB\u001b\u0016\u0013S\u0000\u001aTX\u001b\u0016\u0007C\u0017^TD\u0011E\u001bC\u0006U\u0011\fTM\t"), a);
            return null;
        }
        if ((object = a3.true((Long)object, ((Coordinates)a).getMajor(), ((Coordinates)a).getMinor(), ((Coordinates)a).getPatch(), true)) == null) {
            logger.debug(VersionResource.implements("X\u001b\u0016\u0019W\u0000U\u001cS\u0010\u0016\u0002S\u0006E\u001dY\u001a\u0016\u0006S\u0000D\u001dS\u0002S\u0010\fTM\t"), a);
            return null;
        }
        a = null;
        if (!a222 && ((EngineVersion)((Object)object)).getContentId() != null) {
            EngineContent a222 = (EngineContent)a3.contentMapper.selectById(((EngineVersion)((Object)object)).getContentId());
            a = a222 != null ? a222.getData() : null;
        }
        VersionResource versionResource = a222 = new VersionResource();
        Object object2 = object;
        VersionResource versionResource2 = a222;
        VersionResource versionResource3 = a222;
        EngineResource engineResource3 = engineResource;
        a222.setType(engineResource3.getType());
        versionResource3.setName(engineResource3.getName());
        versionResource3.setLabel(engineResource.getLabel());
        versionResource2.setMajor(((EngineVersion)((Object)object)).getMajor());
        versionResource2.setMinor(((EngineVersion)((Object)object)).getMinor());
        a222.setPatch(((EngineVersion)((Object)object2)).getPatch());
        versionResource.setDescription(((EngineVersion)((Object)object2)).getDescription());
        versionResource.setContent((String)a);
        logger.debug(VersionResource.implements("\u0013Y\u0000\u0016\u0002S\u0006E\u001dY\u001a\fTM\t"), (Object)a222);
        return versionResource;
    }

    @Override
    public List<Coordinates> listCoordinatesByTypeAndLabel(String a, String a2) {
        ResourceVersionManageServiceImpl a3;
        if (a == null || a2 == null) {
            throw new NullPointerException();
        }
        logger.debug(VersionResource.implements("Z\u001dE\u0000u\u001bY\u0006R\u001dX\u0015B\u0011E6O O\u0004S5X\u0010z\u0015T\u0011Z\\B\rF\u0011\u000b\u000fKX\u0016\u0018W\u0016S\u0018\u000b\u000fK]"), (Object)a, (Object)a2);
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        return resourceVersionManageServiceImpl.true(a3.resourceMapper.selectResourcesByTypeAndLabel(resourceVersionManageServiceImpl.true(), a, a2));
    }

    @Override
    public List<Coordinates> listCoordinatesByTypeAndName(String a, String a2) {
        ResourceVersionManageServiceImpl a3;
        if (a == null || a2 == null) {
            throw new NullPointerException();
        }
        logger.debug(VersionResource.implements("\u0018_\u0007B7Y\u001bD\u0010_\u001aW\u0000S\u0007t\rb\rF\u0011w\u001aR8W\u0016S\u0018\u001e\u0000O\u0004SIM\t\u001aTX\u0015[\u0011\u000b\u000fK]"), (Object)a, (Object)a2);
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        return resourceVersionManageServiceImpl.true(a3.resourceMapper.selectResourcesByTypeAndName(resourceVersionManageServiceImpl.true(), a, a2));
    }

    private /* synthetic */ EngineVersion true(Coordinates a) {
        ResourceVersionManageServiceImpl a2;
        if (a.getType() == null || a.getName() == null || a.getLabel() == null) {
            throw new NullPointerException();
        }
        Object object = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a2;
        EngineResource engineResource = object;
        Coordinates coordinates = a;
        ((EngineResource)object).setType(coordinates.getType());
        engineResource.setName(coordinates.getName());
        engineResource.setLabel(a.getLabel());
        ((EngineResource)object).setTenantId(resourceVersionManageServiceImpl.true());
        object = resourceVersionManageServiceImpl.resourceMapper.selectResourceId((EngineResource)object);
        if (object == null) {
            return null;
        }
        return a2.true((Long)object, a.getMajor(), a.getMinor(), a.getPatch(), true);
    }

    @Override
    public Coordinates save(VersionResource versionResource, VersionStrategy versionStrategy) {
        EngineVersion engineVersion;
        ResourceVersionManageServiceImpl a;
        EngineContent a2;
        Coordinates a3;
        logger.debug(VersionResource.implements("E\u0015@\u0011\u001e\u0006S\u0007Y\u0001D\u0017SIM\t\u001aTE\u0000D\u0015B\u0011Q\r\u000b\u000fK]"), (Object)a3, (Object)a2);
        if (a3 == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a;
        EngineResource engineResource2 = engineResource;
        void v2 = a3;
        engineResource.setType(v2.getType());
        engineResource2.setName(v2.getName());
        engineResource2.setLabel(((VersionResource)((Object)a3)).getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.true());
        resourceVersionManageServiceImpl.ensureResourceExists(engineResource);
        EngineVersion engineVersion2 = engineVersion = new EngineVersion();
        void v4 = a3;
        EngineVersion engineVersion3 = engineVersion;
        engineVersion.setResourceId(engineResource.getId());
        engineVersion3.setMajor(((VersionResource)((Object)a3)).getMajor());
        engineVersion3.setMinor(((VersionResource)((Object)a3)).getMinor());
        engineVersion.setPatch(v4.getPatch());
        engineVersion2.setDescription(v4.getDescription());
        engineVersion = resourceVersionManageServiceImpl.saveVersion(engineVersion2, (VersionStrategy)((Object)(a2 != null ? a2 : VersionStrategy.EXACT)));
        EngineContent engineContent = a2 = new EngineContent();
        engineContent.setRefCount(1L);
        engineContent.setData(((VersionResource)((Object)a3)).getContent());
        a.contentMapper.insert(a2);
        logger.debug(VersionResource.implements("_\u001aE\u0011D\u0000S\u0010\u0016\u0017Y\u001aB\u0011X\u0000\fTM\t"), (Object)a2);
        a.versionMapper.updateContentById(engineVersion.getId(), a2.getId());
        logger.debug(VersionResource.implements("C\u0004R\u0015B\u0011RT@\u0011D\u0007_\u001bXTD\u0011Z\u0015B\u0011RTU\u001bX\u0000S\u001aBT_\u0010\fTM\t"), (Object)engineVersion.getId());
        Coordinates coordinates = a3 = new Coordinates();
        EngineVersion engineVersion4 = engineVersion;
        Coordinates coordinates2 = a3;
        EngineResource engineResource3 = engineResource;
        a3.setType(engineResource3.getType());
        coordinates2.setName(engineResource3.getName());
        coordinates2.setLabel(engineResource.getLabel());
        a3.setMajor(engineVersion4.getMajor());
        coordinates.setMinor(engineVersion4.getMinor());
        coordinates.setPatch(engineVersion.getPatch());
        logger.debug(VersionResource.implements("\u0007W\u0002S\u0010\u0016\u0002S\u0006E\u001dY\u001a\fTM\t"), (Object)a3);
        return a3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ List<EngineVersion> true(long a, Integer a2, Integer a3, Integer a4, boolean a5) {
        List<EngineVersion> list;
        Integer n;
        int n2;
        if (a2 != null) {
            n2 = 4;
            n = a3;
        } else {
            n2 = 0;
            n = a3;
        }
        switch (n2 | (n != null ? 2 : 0) | (a4 != null ? 1 : 0)) {
            case 0: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersions(null, a, a5);
                break;
            }
            case 4: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMajor(null, a, a2, a5);
                break;
            }
            case 2: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMinor(null, a, a3, a5);
                break;
            }
            case 1: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchPatch(null, a, a4, a5);
                break;
            }
            case 6: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMajorAndMinor(null, a, a2, a3, a5);
                break;
            }
            case 5: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMajorAndPatch(null, a, a2, a4, a5);
                break;
            }
            case 3: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMinorAndPatch(null, a, a3, a4, a5);
                break;
            }
            default: {
                ResourceVersionManageServiceImpl a6;
                return Optional.ofNullable(a6.versionMapper.selectExactVersion(a, a2, a3, a4, a5)).map(Collections::singletonList).orElse(Collections.emptyList());
            }
        }
        Object[] objectArray = new Object[6];
        objectArray[0] = a;
        objectArray[1] = a2;
        objectArray[2] = a3;
        objectArray[3] = a4;
        objectArray[4] = a5;
        objectArray[5] = list;
        logger.debug(VersionResource.implements("\u0006S\u0000D\u001dS\u0002S\u0010\u0016\u0002S\u0006E\u001dY\u001a\u0016\u0018_\u0007BN\u0016\u0006S\u0007Y\u0001D\u0017S=RIM\t\u001aT@\u0011D\u0007_\u001bXIM\t\u0018\u000fKZM\t\u001aTX\u001bD\u0019W\u0018\u000b\u000fKX\u0016\u0006Y\u0003EIM\t"), objectArray);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    private /* synthetic */ boolean true(Integer a, int a2) {
        return a == null || a < a2;
    }

    private /* synthetic */ EngineVersion true(EngineVersion a, EngineVersion a2) {
        if (a2.getMajor() == null || a2.getMinor() == null || a2.getPatch() == null) {
            throw new NullPointerException();
        }
        NamedLockManagerService.Handle handle = null;
        try {
            ResourceVersionManageServiceImpl a3;
            ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
            handle = resourceVersionManageServiceImpl.true(a2.getResourceId());
            EngineVersion engineVersion = a;
            EngineVersion engineVersion2 = a2;
            a.setMajor(engineVersion2.getMajor());
            engineVersion.setMinor(engineVersion2.getMinor());
            engineVersion.setPatch(a2.getPatch());
            resourceVersionManageServiceImpl.tryInsertVersion(engineVersion);
            EngineVersion engineVersion3 = a;
            return engineVersion3;
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            VersioningException versioningException = new VersioningException(VersionResource.implements("U\u0015X\u001aY\u0000\u0016\u0007W\u0002STU\u001bX\u0012Z\u001dU\u0000S\u0010\u0016\u0002S\u0006E\u001dY\u001a"), dataIntegrityViolationException);
            versioningException.coordinates().setMajor(a.getMajor());
            versioningException.coordinates().setMinor(a.getMinor());
            versioningException.coordinates().setPatch(a.getPatch());
            logger.debug(VersionResource.implements("P\u0015_\u0018S\u0010\u0016\u0000YT_\u001aE\u0011D\u0000\u0016\u0002S\u0006E\u001dY\u001a\fTM\t"), (Object)a2);
            throw versioningException;
        }
        finally {
            if (handle != null) {
                handle.release();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ void true(EngineVersion a, EngineVersion a22, VersionStrategy a3, Integer a4, Integer a52, Integer a62) {
        int n;
        int a62;
        int a52;
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl;
        ResourceVersionManageServiceImpl a7;
        a4 = a7.true(a22.getResourceId(), (Integer)a4, a52, a62, false);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (a3) {
            case MAJOR: {
                n2 = 1;
                if (a4 != null) {
                    resourceVersionManageServiceImpl = a7;
                    a52 = ((EngineVersion)((Object)a4)).getMajor() + n2;
                    a62 = 0;
                    n = 0;
                    break;
                }
                a52 = 1;
                a62 = 0;
                n = 0;
                resourceVersionManageServiceImpl = a7;
                break;
            }
            case MINOR: {
                n3 = 1;
                if (a4 != null) {
                    resourceVersionManageServiceImpl = a7;
                    Object object = a4;
                    a52 = ((EngineVersion)((Object)object)).getMajor();
                    a62 = ((EngineVersion)((Object)object)).getMinor() + n3;
                    n = 0;
                    break;
                }
                if (a22.getMajor() != null) {
                    resourceVersionManageServiceImpl = a7;
                    a52 = a22.getMajor();
                    a62 = 1;
                    n = 0;
                    break;
                }
                a52 = 0;
                a62 = 1;
                n = 0;
                resourceVersionManageServiceImpl = a7;
                break;
            }
            case PATCH: {
                n4 = 1;
                if (a4 != null) {
                    resourceVersionManageServiceImpl = a7;
                    Object object = a4;
                    a52 = ((EngineVersion)((Object)object)).getMajor();
                    a62 = ((EngineVersion)((Object)object)).getMinor();
                    n = ((EngineVersion)((Object)object)).getPatch() + n4;
                    break;
                }
                if (a22.getMajor() != null && a22.getMinor() != null) {
                    resourceVersionManageServiceImpl = a7;
                    EngineVersion engineVersion = a22;
                    a52 = engineVersion.getMajor();
                    a62 = engineVersion.getMinor();
                    n = 1;
                    break;
                }
                if (a22.getMajor() != null) {
                    resourceVersionManageServiceImpl = a7;
                    a52 = a22.getMajor();
                    a62 = 0;
                    n = 1;
                    break;
                }
                a52 = 0;
                a62 = 0;
                n = 1;
                resourceVersionManageServiceImpl = a7;
                break;
            }
            default: {
                throw new UnsupportedOperationException(new StringBuilder().insert(0, VersionResource.implements("C\u001aS\fF\u0011U\u0000S\u0010\u0016\u0007B\u0006W\u0000S\u0013OT")).append((Object)a3).toString());
            }
        }
        boolean a22 = resourceVersionManageServiceImpl.true(a.getMajor(), a52) || a7.true(a.getMinor(), a62) || a7.true(a.getPatch(), n);
        Object[] objectArray = new Object[4];
        objectArray[0] = a52;
        objectArray[1] = a62;
        objectArray[2] = n;
        objectArray[3] = a22;
        logger.debug(VersionResource.implements("U\u0015Z\u0017C\u0018W\u0000S\u0010\u0016\u0002S\u0006E\u001dY\u001a\u0016\u0012D\u001b[TB\u001cSTZ\u0015B\u0011E\u0000\fTX\u0011N\u0000\u000b\u000fKZM\t\u0018\u000fKX\u0016\u0010_\u0012P\u0011D\u0011X\u0017SIM\t"), objectArray);
        if (!a22) {
            ResourceVersionManageServiceImpl resourceVersionManageServiceImpl2 = a7;
            EngineVersion engineVersion = a;
            a52 = a7.true(engineVersion.getMajor(), a52 + n2);
            a62 = resourceVersionManageServiceImpl2.true(engineVersion.getMinor(), a62 + n3);
            n = resourceVersionManageServiceImpl2.true(a.getPatch(), n + n4);
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = a52;
            objectArray2[1] = a62;
            objectArray2[2] = n;
            logger.debug(VersionResource.implements("\u001dX\u0017D\u0011W\u0007S\u0010\u0016\u0002S\u0006E\u001dY\u001a\u0016\u0016S\u0017W\u0001E\u0011\u0016\u001bPTX\u001b\u0016\u0010_\u0012P\u0011D\u0011X\u0017SN\u0016\u001aS\fBIM\t\u0018\u000fKZM\t"), objectArray2);
        }
        EngineVersion engineVersion = a;
        engineVersion.setMajor(a52);
        engineVersion.setMinor(a62);
        a.setPatch(n);
        logger.debug(VersionResource.implements("\u0006S\u0012D\u0011E\u001cS\u0010\u0016\u0002S\u0006E\u001dY\u001a\u0016\u001bPTB\u001cSTX\u0011N\u0000\u0016\u001dX\u0007S\u0006B\u001dY\u001a\fT_\u001aE\u0011D\u0000`\u0011D\u0007_\u001bXIM\t"), (Object)a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ EngineVersion true(EngineVersion a, EngineVersion a2, VersionStrategy a3, Integer a4, Integer a5, Integer a6) {
        int n;
        boolean bl = false;
        DataIntegrityViolationException dataIntegrityViolationException = null;
        NamedLockManagerService.Handle handle = null;
        int n2 = n = 0;
        while (n2 < 10) {
            try {
                ResourceVersionManageServiceImpl a7;
                if (!bl) {
                    handle = a7.true(a2.getResourceId());
                }
                bl = false;
                EngineVersion engineVersion = a;
                a7.true(a, a2, a3, a4, a5, a6);
                a7.tryInsertVersion(engineVersion);
                EngineVersion engineVersion2 = engineVersion;
                return engineVersion2;
            }
            catch (DataIntegrityViolationException dataIntegrityViolationException2) {
                bl = true;
                dataIntegrityViolationException = dataIntegrityViolationException2;
                if (n + 1 < 10) {
                    logger.debug(VersionResource.implements("D\u0011B\u0006OT@\u0011D\u0007_\u001bXTU\u0015Z\u0017C\u0018W\u0000_\u001bXTW\u001aRT_\u001aE\u0011D\u0000_\u001bXN\u0016\u0000_\u0019S\u0007\u000b\u000fKX\u0016\u0012W\u001dZ\u0011RIM\t"), (Object)n, (Object)a);
                }
            }
            finally {
                if (!bl && handle != null) {
                    handle.release();
                }
            }
            n2 = ++n;
        }
        if (handle != null) {
            handle.release();
        }
        VersioningException versioningException = new VersioningException(VersionResource.implements("\u0011N\u0017S\u0011RT[\u0015NTD\u0011B\u0006OX\u0016\u0019W\u001fSTE\u0001D\u0011\u0016\u001aYTX\u0011E\u0000S\u0010\u0016\u0000D\u0015X\u0007W\u0017B\u001dY\u001a\u0016\u001dETC\u0007S\u0010"), dataIntegrityViolationException);
        versioningException.coordinates().setMajor(a.getMajor());
        versioningException.coordinates().setMinor(a.getMinor());
        versioningException.coordinates().setPatch(a.getPatch());
        logger.debug(VersionResource.implements("P\u0015_\u0018S\u0010\u0016\u0000YT_\u001aE\u0011D\u0000\u0016\u0002S\u0006E\u001dY\u001a\fTM\t"), (Object)a2);
        throw versioningException;
    }

    private /* synthetic */ String true() {
        return EngineTenantUtil.getTenantId();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ EngineVersion true(long a, Integer a2, Integer a3, Integer a4, boolean a5) {
        void var7_15;
        List<EngineVersion> list;
        Integer n;
        int n2;
        if (a2 != null) {
            n2 = 4;
            n = a3;
        } else {
            n2 = 0;
            n = a3;
        }
        int n3 = n2 | (n != null ? 2 : 0) | (a4 != null ? 1 : 0);
        Page page = new Page(1L, 1L, false);
        switch (n3) {
            case 0: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list2;
                list = list2 = a6.versionMapper.selectVersions((Page<EngineVersion>)page, a, a5);
                break;
            }
            case 4: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list3 = a6.versionMapper.selectVersionsMatchMajor((Page<EngineVersion>)page, a, a2, a5);
                list = list3;
                break;
            }
            case 2: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list4 = a6.versionMapper.selectVersionsMatchMinor((Page<EngineVersion>)page, a, a3, a5);
                list = list4;
                break;
            }
            case 1: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list5 = a6.versionMapper.selectVersionsMatchPatch((Page<EngineVersion>)page, a, a4, a5);
                list = list5;
                break;
            }
            case 6: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list6 = a6.versionMapper.selectVersionsMatchMajorAndMinor((Page<EngineVersion>)page, a, a2, a3, a5);
                list = list6;
                break;
            }
            case 5: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list7 = a6.versionMapper.selectVersionsMatchMajorAndPatch((Page<EngineVersion>)page, a, a2, a4, a5);
                list = list7;
                break;
            }
            case 3: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list8 = a6.versionMapper.selectVersionsMatchMinorAndPatch((Page<EngineVersion>)page, a, a3, a4, a5);
                list = list8;
                break;
            }
            default: {
                ResourceVersionManageServiceImpl a6;
                return a6.versionMapper.selectExactVersion(a, a2, a3, a4, a5);
            }
        }
        if (list == null || var7_15.size() == 0) {
            return null;
        }
        if (var7_15.size() > 1) {
            throw new TooManyResultsException(VersionResource.implements("\u0004W\u0013_\u001aW\u0000_\u001bXTX\u001bBTA\u001bD\u001fS\u0010"));
        }
        EngineVersion engineVersion = (EngineVersion)((Object)var7_15.get(0));
        Object[] objectArray = new Object[6];
        objectArray[0] = a;
        objectArray[1] = a2;
        objectArray[2] = a3;
        objectArray[3] = a4;
        objectArray[4] = a5;
        objectArray[5] = engineVersion;
        logger.debug(VersionResource.implements("D\u0011B\u0006_\u0011@\u0011RTZ\u0015B\u0011E\u0000\u0016\u0002S\u0006E\u001dY\u001a\fTD\u0011E\u001bC\u0006U\u0011\u007f\u0010\u000b\u000fKX\u0016\u0002S\u0006E\u001dY\u001a\u000b\u000fKZM\t\u0018\u000fKX\u0016\u001aY\u0006[\u0015ZIM\t\u001aTD\u001bAIM\t"), objectArray);
        return engineVersion;
    }

    public void tryInsertVersion(EngineVersion a) {
        ResourceVersionManageServiceImpl a2;
        a2.versionMapper.insert((Object)a);
        logger.debug(VersionResource.implements("_\u001aE\u0011D\u0000S\u0010\u0016\u0002S\u0006E\u001dY\u001a\fTM\t"), (Object)a);
    }

    private /* synthetic */ Date true() {
        return new Date();
    }

    /*
     * WARNING - void declaration
     */
    public void trySaveResource(EngineResource engineResource) {
        void a;
        ResourceVersionManageServiceImpl a2;
        a2.resourceMapper.insert(a);
        logger.debug(VersionResource.implements("\u0006S\u0007Y\u0001D\u0017ST_\u001aE\u0011D\u0000S\u0010\fTM\t"), (Object)a);
    }

    @Override
    public Coordinates copy(Coordinates a, VersionResource a2, VersionStrategy a3) {
        EngineVersion engineVersion;
        ResourceVersionManageServiceImpl a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a;
        objectArray[1] = a2;
        objectArray[2] = a3;
        logger.debug(VersionResource.implements("U\u001bF\r\u001e\u0007Y\u0001D\u0017SIM\t\u001aTR\u0011E\u0000_\u001aOIM\t\u001aTE\u0000D\u0015B\u0011Q\r\u000b\u000fK]"), objectArray);
        EngineVersion engineVersion2 = a4.true((Coordinates)a);
        if (engineVersion2 == null || engineVersion2.getContentId() == null) {
            logger.debug(VersionResource.implements("P\u0015_\u0018S\u0010\u0016\u0000YTU\u001bF\r\u001aTX\u001b\u0016\u0007C\u0017^TE\u001bC\u0006U\u0011\u0016\u0002S\u0006E\u001dY\u001a\fTM\t"), a);
            return null;
        }
        a = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a4;
        Object object = a;
        VersionResource versionResource = a2;
        ((EngineResource)a).setType(versionResource.getType());
        ((EngineResource)object).setName(versionResource.getName());
        ((EngineResource)object).setLabel(((VersionResource)a2).getLabel());
        ((EngineResource)a).setTenantId(resourceVersionManageServiceImpl.true());
        resourceVersionManageServiceImpl.ensureResourceExists((EngineResource)a);
        resourceVersionManageServiceImpl.contentMapper.increaseRefCountById(engineVersion2.getContentId());
        logger.debug(VersionResource.implements("\u001dX\u0017D\u0011W\u0007S\u0010\u0016\u0017Y\u001aB\u0011X\u0000\u0016\u0006S\u0012\u0016\u0017Y\u0001X\u0000\fTU\u001bX\u0000S\u001aB=RIM\t"), (Object)engineVersion2.getContentId());
        EngineVersion engineVersion3 = engineVersion = new EngineVersion();
        VersionResource versionResource2 = a2;
        EngineVersion engineVersion4 = engineVersion;
        engineVersion4.setResourceId(((EngineResource)a).getId());
        engineVersion4.setContentId(engineVersion2.getContentId());
        engineVersion.setMajor(versionResource2.getMajor());
        engineVersion3.setMinor(versionResource2.getMinor());
        engineVersion3.setPatch(((VersionResource)a2).getPatch());
        engineVersion.setDescription(((VersionResource)a2).getDescription() != null ? ((VersionResource)a2).getDescription() : engineVersion2.getDescription());
        engineVersion = a4.saveVersion(engineVersion, a3 != null ? a3 : VersionStrategy.EXACT);
        Object object2 = a2 = new Coordinates();
        EngineVersion engineVersion5 = engineVersion;
        Object object3 = a2;
        Object object4 = a;
        ((Coordinates)a2).setType(((EngineResource)object4).getType());
        ((Coordinates)object3).setName(((EngineResource)object4).getName());
        ((Coordinates)object3).setLabel(((EngineResource)a).getLabel());
        ((Coordinates)a2).setMajor(engineVersion5.getMajor());
        ((Coordinates)object2).setMinor(engineVersion5.getMinor());
        ((Coordinates)object2).setPatch(engineVersion.getPatch());
        logger.debug(VersionResource.implements("U\u001bF\u001dS\u0010\u0016\u0002S\u0006E\u001dY\u001a\fTM\t"), a2);
        return object2;
    }

    @Override
    public Coordinates delete(Coordinates a) {
        ResourceVersionManageServiceImpl a2;
        logger.debug(VersionResource.implements("R\u0011Z\u0011B\u0011\u001e\u0017Y\u001bD\u0010_\u001aW\u0000S\u0007\u000b\u000fK]"), (Object)a);
        if (a.getType() == null || a.getName() == null || a.getLabel() == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a2;
        EngineResource engineResource2 = engineResource;
        Coordinates coordinates = a;
        engineResource.setType(coordinates.getType());
        engineResource2.setName(coordinates.getName());
        engineResource2.setLabel(a.getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.true());
        Object object = resourceVersionManageServiceImpl.resourceMapper.selectResourceId(engineResource);
        if (object == null) {
            logger.debug(VersionResource.implements("P\u0015_\u0018S\u0010\u0016\u0000YTR\u0011Z\u0011B\u0011\u001aTX\u001b\u0016\u0007C\u0017^TD\u0011E\u001bC\u0006U\u0011\fTM\t"), (Object)a);
            return null;
        }
        if ((object = a2.true((Long)object, a.getMajor(), a.getMinor(), a.getPatch(), true)) == null) {
            logger.debug(VersionResource.implements("\u0012W\u001dZ\u0011RTB\u001b\u0016\u0010S\u0018S\u0000SX\u0016\u001aYTE\u0001U\u001c\u0016\u0002S\u0006E\u001dY\u001a\fTM\t"), (Object)a);
            return null;
        }
        a2.versionMapper.updateDataStatusById(((EngineVersion)((Object)object)).getId(), 1, String.valueOf(a2.true()), a2.true());
        Coordinates coordinates2 = a = new Coordinates();
        Object object2 = object;
        Coordinates coordinates3 = a;
        EngineResource engineResource3 = engineResource;
        a.setType(engineResource3.getType());
        coordinates3.setName(engineResource3.getName());
        coordinates3.setLabel(engineResource.getLabel());
        a.setMajor(((EngineVersion)((Object)object2)).getMajor());
        coordinates2.setMinor(((EngineVersion)((Object)object2)).getMinor());
        coordinates2.setPatch(((EngineVersion)((Object)object)).getPatch());
        logger.debug(VersionResource.implements("\u0010S\u0018S\u0000S\u0010\u0016\u0002S\u0006E\u001dY\u001a\fTM\t"), (Object)a);
        return a;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EngineVersion saveVersion(EngineVersion a, VersionStrategy a2) {
        ResourceVersionManageServiceImpl a3;
        EngineVersion engineVersion;
        if (a.getResourceId() == null) {
            throw new NullPointerException();
        }
        EngineVersion engineVersion2 = engineVersion = new EngineVersion();
        EngineVersion engineVersion3 = engineVersion;
        EngineVersion engineVersion4 = engineVersion;
        EngineVersion engineVersion5 = a;
        engineVersion.setResourceId(engineVersion5.getResourceId());
        engineVersion4.setContentId(engineVersion5.getContentId());
        engineVersion4.setDescription(a.getDescription());
        engineVersion3.setDataStatus(VersionResource.implements("D"));
        engineVersion3.setCreator(a3.true());
        engineVersion2.setCreateTime(LocalDateTime.now());
        engineVersion2.setLastEditor(a3.true());
        engineVersion2.setLastTime(LocalDateTime.now());
        boolean bl = false;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        switch (a2) {
            case MAJOR: {
                if (a.getMajor() == null && a.getMinor() == null && a.getPatch() == null) break;
                Object[] objectArray = new Object[7];
                objectArray[0] = a2;
                objectArray[1] = a.getMajor();
                objectArray[2] = a.getMinor();
                objectArray[3] = a.getPatch();
                objectArray[4] = n;
                objectArray[5] = n2;
                objectArray[6] = n3;
                logger.warn(VersionResource.implements("T\u0015RTE\u0015@\u0011\u0016\u0007B\u0006W\u0000S\u0013OTW\u0006Q\u0001[\u0011X\u0000EN\u0016\u0007B\u0006W\u0000S\u0013OIM\t\u001aT_\u001aF\u0001B\"S\u0006E\u001dY\u001a\u000b\u000fKZM\t\u0018\u000fKT\u000bJ\u0016\u0005C\u0011D\r`\u0011D\u0007_\u001bXIM\t\u0018\u000fKZM\t"), objectArray);
                break;
            }
            case MINOR: {
                EngineVersion engineVersion6 = a;
                n = engineVersion6.getMajor();
                if (engineVersion6.getMinor() == null && a.getPatch() == null) break;
                Object[] objectArray = new Object[7];
                objectArray[0] = a2;
                objectArray[1] = a.getMajor();
                objectArray[2] = a.getMinor();
                objectArray[3] = a.getPatch();
                objectArray[4] = n;
                objectArray[5] = n2;
                objectArray[6] = n3;
                logger.warn(VersionResource.implements("T\u0015RTE\u0015@\u0011\u0016\u0007B\u0006W\u0000S\u0013OTW\u0006Q\u0001[\u0011X\u0000EN\u0016\u0007B\u0006W\u0000S\u0013OIM\t\u001aT_\u001aF\u0001B\"S\u0006E\u001dY\u001a\u000b\u000fKZM\t\u0018\u000fKT\u000bJ\u0016\u0005C\u0011D\r`\u0011D\u0007_\u001bXIM\t\u0018\u000fKZM\t"), objectArray);
                break;
            }
            case PATCH: {
                EngineVersion engineVersion7 = a;
                n = engineVersion7.getMajor();
                Integer n4 = n2 = engineVersion7.getMajor() != null ? a.getMinor() : null;
                if ((a.getMajor() != null || a.getMinor() == null) && a.getPatch() == null) break;
                Object[] objectArray = new Object[7];
                objectArray[0] = a2;
                objectArray[1] = a.getMajor();
                objectArray[2] = a.getMinor();
                objectArray[3] = a.getPatch();
                objectArray[4] = n;
                objectArray[5] = n2;
                objectArray[6] = n3;
                logger.warn(VersionResource.implements("T\u0015RTE\u0015@\u0011\u0016\u0007B\u0006W\u0000S\u0013OTW\u0006Q\u0001[\u0011X\u0000EN\u0016\u0007B\u0006W\u0000S\u0013OIM\t\u001aT_\u001aF\u0001B\"S\u0006E\u001dY\u001a\u000b\u000fKZM\t\u0018\u000fKT\u000bJ\u0016\u0005C\u0011D\r`\u0011D\u0007_\u001bXIM\t\u0018\u000fKZM\t"), objectArray);
                break;
            }
            case EXACT: {
                bl = true;
                if (a.getMajor() != null && a.getMinor() != null && a.getPatch() != null) break;
                Object[] objectArray = new Object[4];
                objectArray[0] = a2;
                objectArray[1] = a.getMajor();
                objectArray[2] = a.getMinor();
                objectArray[3] = a.getPatch();
                logger.warn(VersionResource.implements("\u0016W\u0010\u0016\u0007W\u0002STE\u0000D\u0015B\u0011Q\r\u0016\u0015D\u0013C\u0019S\u001aB\u0007\fTE\u0000D\u0015B\u0011Q\r\u000b\u000fKX\u0016\u001dX\u0004C\u0000`\u0011D\u0007_\u001bXIM\t\u0018\u000fKZM\t"), objectArray);
                break;
            }
            default: {
                throw new UnsupportedOperationException(new StringBuilder().insert(0, VersionResource.implements("\u0001X\u0007C\u0004F\u001bD\u0000S\u0010\u0016\u0007W\u0002STE\u0000D\u0015B\u0011Q\r\fT")).append((Object)a2).toString());
            }
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = bl;
        objectArray[1] = n;
        objectArray[2] = n2;
        objectArray[3] = n3;
        logger.debug(VersionResource.implements("U\u0015Z\u0017C\u0018W\u0000S\u0010\u0016\u0002S\u0006E\u001dY\u001a\u0016\u001dX\u0007S\u0006B\u001dY\u001a\u0016\u0004Z\u0015XN\u0016\u001dE1N\u0015U\u0000e\u0000D\u0015B\u0011Q\r\u000b\u000fKX\u0016\u0005C\u0011D\r`\u0011D\u0007_\u001bXIM\t\u0018\u000fKZM\t"), objectArray);
        if (bl) {
            return a3.true(engineVersion, a);
        }
        return a3.true(engineVersion, a, a2, n, n2, n3);
    }

    private /* synthetic */ List<Coordinates> true(List<EngineResource> a) {
        ArrayList<Coordinates> arrayList = new ArrayList<Coordinates>();
        Object object = a = a.iterator();
        while (object.hasNext()) {
            ResourceVersionManageServiceImpl a2;
            EngineResource engineResource = (EngineResource)a.next();
            EngineVersion engineVersion = a2.true(engineResource.getId(), null, null, null, true);
            if (engineVersion == null) {
                object = a;
                continue;
            }
            Coordinates coordinates = new Coordinates();
            object = a;
            Coordinates coordinates2 = coordinates;
            EngineVersion engineVersion2 = engineVersion;
            Coordinates coordinates3 = coordinates;
            EngineResource engineResource2 = engineResource;
            coordinates.setType(engineResource2.getType());
            coordinates3.setName(engineResource2.getName());
            coordinates3.setLabel(engineResource.getLabel());
            coordinates.setMajor(engineVersion2.getMajor());
            coordinates2.setMinor(engineVersion2.getMinor());
            coordinates2.setPatch(engineVersion.getPatch());
            arrayList.add(coordinates2);
        }
        return arrayList;
    }

    private /* synthetic */ int true(Integer a, int a2) {
        if (a == null) {
            return a2;
        }
        return Integer.max(a, a2);
    }
}

