/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine.rvm.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.engine.common.util.EngineTenantUtil;
import com.jxdinfo.hussar.engine.rvm.dao.RvmContentMapper;
import com.jxdinfo.hussar.engine.rvm.dao.RvmResourceMapper;
import com.jxdinfo.hussar.engine.rvm.dao.RvmVersionMapper;
import com.jxdinfo.hussar.engine.rvm.model.Coordinates;
import com.jxdinfo.hussar.engine.rvm.model.EngineContent;
import com.jxdinfo.hussar.engine.rvm.model.EngineResource;
import com.jxdinfo.hussar.engine.rvm.model.EngineVersion;
import com.jxdinfo.hussar.engine.rvm.model.VersionResource;
import com.jxdinfo.hussar.engine.rvm.model.VersionStrategy;
import com.jxdinfo.hussar.engine.rvm.service.NamedLockManagerService;
import com.jxdinfo.hussar.engine.rvm.service.ResourceVersionManageService;
import com.jxdinfo.hussar.engine.rvm.util.VersioningException;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@HussarDs(value="master")
public class ResourceVersionManageServiceImpl
implements ResourceVersionManageService {
    private static final Logger logger = LoggerFactory.getLogger(ResourceVersionManageServiceImpl.class);
    private static final int MAX_SAVE_RETRY = 10;
    private final RvmContentMapper contentMapper;
    private final RvmVersionMapper versionMapper;
    private static final String LOCK_TYPE_VERSION_INSERTION = "ver";
    private final RvmResourceMapper resourceMapper;
    private final NamedLockManagerService lockManager;

    public void ensureResourceExists(EngineResource a) {
        ResourceVersionManageServiceImpl a2;
        EngineResource engineResource = a;
        engineResource.setId(a2.resourceMapper.selectResourceId(engineResource));
        if (engineResource.getId() != null) {
            logger.debug(VersionResource.double("dUt\u0006eNt\u0006t^xUeO\u007fA1TtU~ScEt\u001c1]l"), (Object)a);
            return;
        }
        try {
            a2.trySaveResource(a);
            return;
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            EngineResource engineResource2 = a;
            engineResource2.setId(a2.resourceMapper.selectResourceId(engineResource2));
            logger.debug(VersionResource.double("eTxCu\u0006eI1TtRcOtPt\u0006cCbIdTrC1Ou\u001c1]l"), (Object)a);
            if (engineResource2.getId() == null) {
                VersioningException versioningException = new VersioningException(VersionResource.double("wGxJtB1R~\u0006cCeTxCgC1TtU~ScEt\u0006xB=\u0006|GzC1UdTt\u0006\u007fI1HtUeCu\u0006eTpHbGrRxI\u007f\u0006xU1SbCu"), dataIntegrityViolationException);
                versioningException.coordinates().setType(a.getType());
                versioningException.coordinates().setName(a.getName());
                versioningException.coordinates().setLabel(a.getLabel());
                logger.debug(VersionResource.double("@pO}Cu\u0006eI1C\u007fUdTt\u0006cCbIdTrC1CiObRb\u001c1]l"), (Object)a);
                throw versioningException;
            }
            return;
        }
    }

    @Override
    public VersionResource get(Coordinates a, boolean a222) {
        VersionResource a222;
        ResourceVersionManageServiceImpl a3;
        logger.debug(VersionResource.double("vCe\u000erI~TuO\u007fGeCb\u001bj[=\u0006\u007fIRI\u007fRtHe\u001bj[8"), a, (Object)a222);
        if (((Coordinates)a).getType() == null || ((Coordinates)a).getName() == null || ((Coordinates)a).getLabel() == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        EngineResource engineResource2 = engineResource;
        Coordinates coordinates = a;
        engineResource.setType(coordinates.getType());
        engineResource2.setName(coordinates.getName());
        engineResource2.setLabel(((Coordinates)a).getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.null());
        Object object = resourceVersionManageServiceImpl.resourceMapper.selectResourceId(engineResource);
        if (object == null) {
            logger.debug(VersionResource.double("wGxJtB1R~\u0006vCe\n1H~\u0006bSrN1TtU~ScEt\u001c1]l"), a);
            return null;
        }
        if ((object = a3.null((Long)object, ((Coordinates)a).getMajor(), ((Coordinates)a).getMinor(), ((Coordinates)a).getPatch(), true)) == null) {
            logger.debug(VersionResource.double("H~\u0006|GeEyCu\u0006gCcUxI\u007f\u0006cCeTxCgCu\u001c1]l"), a);
            return null;
        }
        a = null;
        if (!a222 && ((EngineVersion)((Object)object)).getContentId() != null) {
            EngineContent a222 = (EngineContent)a3.contentMapper.selectById(((EngineVersion)((Object)object)).getContentId());
            a = a222 != null ? a222.getData() : null;
        }
        VersionResource versionResource = a222 = new VersionResource();
        Object object2 = object;
        VersionResource versionResource2 = a222;
        VersionResource versionResource3 = a222;
        EngineResource engineResource3 = engineResource;
        a222.setType(engineResource3.getType());
        versionResource3.setName(engineResource3.getName());
        versionResource3.setLabel(engineResource.getLabel());
        versionResource2.setMajor(((EngineVersion)((Object)object)).getMajor());
        versionResource2.setMinor(((EngineVersion)((Object)object)).getMinor());
        a222.setPatch(((EngineVersion)((Object)object2)).getPatch());
        versionResource.setDescription(((EngineVersion)((Object)object2)).getDescription());
        versionResource.setContent((String)a);
        logger.debug(VersionResource.double("vIe\u0006gCcUxI\u007f\u001c1]l"), (Object)a222);
        return versionResource;
    }

    private /* synthetic */ NamedLockManagerService.Handle null(long a) {
        ResourceVersionManageServiceImpl a2;
        return a2.lockManager.acquire(LOCK_TYPE_VERSION_INSERTION, String.valueOf(a), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ EngineVersion null(EngineVersion a, EngineVersion a2, VersionStrategy a3, Integer a4, Integer a5, Integer a6) {
        int n;
        boolean bl = false;
        DataIntegrityViolationException dataIntegrityViolationException = null;
        NamedLockManagerService.Handle handle = null;
        int n2 = n = 0;
        while (n2 < 10) {
            try {
                ResourceVersionManageServiceImpl a7;
                if (!bl) {
                    handle = a7.null(a2.getResourceId());
                }
                bl = false;
                EngineVersion engineVersion = a;
                a7.null(a, a2, a3, a4, a5, a6);
                a7.tryInsertVersion(engineVersion);
                EngineVersion engineVersion2 = engineVersion;
                return engineVersion2;
            }
            catch (DataIntegrityViolationException dataIntegrityViolationException2) {
                bl = true;
                dataIntegrityViolationException = dataIntegrityViolationException2;
                if (n + 1 < 10) {
                    logger.debug(VersionResource.double("TtRc_1PtTbO~H1EpJrS}GeO~H1G\u007fB1O\u007fUtTeO~H+\u0006eO|Cb\u001bj[=\u0006wGxJtB,]l"), (Object)n, (Object)a);
                }
            }
            finally {
                if (!bl && handle != null) {
                    handle.release();
                }
            }
            n2 = ++n;
        }
        if (handle != null) {
            handle.release();
        }
        VersioningException versioningException = new VersioningException(VersionResource.double("t^rCtB1Kp^1TtRc_=\u0006|GzC1UdTt\u0006\u007fI1HtUeCu\u0006eTpHbGrRxI\u007f\u0006xU1SbCu"), dataIntegrityViolationException);
        versioningException.coordinates().setMajor(a.getMajor());
        versioningException.coordinates().setMinor(a.getMinor());
        versioningException.coordinates().setPatch(a.getPatch());
        logger.debug(VersionResource.double("@pO}Cu\u0006eI1O\u007fUtTe\u0006gCcUxI\u007f\u001c1]l"), (Object)a2);
        throw versioningException;
    }

    @Override
    public List<Coordinates> listCoordinates(String a, String a2, String a3) {
        Coordinates coordinates;
        ResourceVersionManageServiceImpl a4;
        if (a2 == null && a3 == null) {
            return a4.listCoordinatesByType((String)a);
        }
        if (a2 == null) {
            return a4.listCoordinatesByTypeAndLabel((String)a, a3);
        }
        if (a3 == null) {
            return a4.listCoordinatesByTypeAndName((String)a, a2);
        }
        Coordinates coordinates2 = coordinates = new Coordinates();
        coordinates.setType((String)a);
        coordinates2.setName(a2);
        coordinates2.setLabel(a3);
        a = a4.get(coordinates2, true);
        if (a == null) {
            return Collections.emptyList();
        }
        Coordinates coordinates3 = coordinates;
        Object object = a;
        coordinates.setMajor(((VersionResource)object).getMajor());
        coordinates3.setMinor(((VersionResource)object).getMinor());
        coordinates3.setPatch(((VersionResource)a).getPatch());
        return Collections.singletonList(coordinates);
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ List<EngineVersion> null(long a, Integer a2, Integer a3, Integer a4, boolean a5) {
        List<EngineVersion> list;
        Integer n;
        int n2;
        if (a2 != null) {
            n2 = 4;
            n = a3;
        } else {
            n2 = 0;
            n = a3;
        }
        switch (n2 | (n != null ? 2 : 0) | (a4 != null ? 1 : 0)) {
            case 0: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersions(null, a, a5);
                break;
            }
            case 4: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMajor(null, a, a2, a5);
                break;
            }
            case 2: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMinor(null, a, a3, a5);
                break;
            }
            case 1: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchPatch(null, a, a4, a5);
                break;
            }
            case 6: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMajorAndMinor(null, a, a2, a3, a5);
                break;
            }
            case 5: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMajorAndPatch(null, a, a2, a4, a5);
                break;
            }
            case 3: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMinorAndPatch(null, a, a3, a4, a5);
                break;
            }
            default: {
                ResourceVersionManageServiceImpl a6;
                return Optional.ofNullable(a6.versionMapper.selectExactVersion(a, a2, a3, a4, a5)).map(Collections::singletonList).orElse(Collections.emptyList());
            }
        }
        Object[] objectArray = new Object[6];
        objectArray[0] = a;
        objectArray[1] = a2;
        objectArray[2] = a3;
        objectArray[3] = a4;
        objectArray[4] = a5;
        objectArray[5] = list;
        logger.debug(VersionResource.double("cCeTxCgCu\u0006gCcUxI\u007f\u0006}ObR+\u0006cCbIdTrCXB,]l\n1PtTbO~H,]l\bj[?]l\n1H~T|G}\u001bj[=\u0006cIfU,]l"), objectArray);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EngineVersion saveVersion(EngineVersion a, VersionStrategy a2) {
        ResourceVersionManageServiceImpl a3;
        EngineVersion engineVersion;
        if (a.getResourceId() == null) {
            throw new NullPointerException();
        }
        EngineVersion engineVersion2 = engineVersion = new EngineVersion();
        EngineVersion engineVersion3 = engineVersion;
        EngineVersion engineVersion4 = engineVersion;
        EngineVersion engineVersion5 = a;
        engineVersion.setResourceId(engineVersion5.getResourceId());
        engineVersion4.setContentId(engineVersion5.getContentId());
        engineVersion4.setDescription(a.getDescription());
        engineVersion3.setDataStatus(VersionResource.double("!"));
        engineVersion3.setCreator(a3.null());
        engineVersion2.setCreateTime(LocalDateTime.now());
        engineVersion2.setLastEditor(a3.null());
        engineVersion2.setLastTime(LocalDateTime.now());
        boolean bl = false;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        switch (a2) {
            case MAJOR: {
                if (a.getMajor() == null && a.getMinor() == null && a.getPatch() == null) break;
                Object[] objectArray = new Object[7];
                objectArray[0] = a2;
                objectArray[1] = a.getMajor();
                objectArray[2] = a.getMinor();
                objectArray[3] = a.getPatch();
                objectArray[4] = n;
                objectArray[5] = n2;
                objectArray[6] = n3;
                logger.warn(VersionResource.double("DpB1UpPt\u0006bRcGeCv_1GcAdKtHeU+\u0006bRcGeCv_,]l\n1O\u007fVdRGCcUxI\u007f\u001bj[?]l\bj[1\u001b/\u0006`StThptTbO~H,]l\bj[?]l"), objectArray);
                break;
            }
            case MINOR: {
                EngineVersion engineVersion6 = a;
                n = engineVersion6.getMajor();
                if (engineVersion6.getMinor() == null && a.getPatch() == null) break;
                Object[] objectArray = new Object[7];
                objectArray[0] = a2;
                objectArray[1] = a.getMajor();
                objectArray[2] = a.getMinor();
                objectArray[3] = a.getPatch();
                objectArray[4] = n;
                objectArray[5] = n2;
                objectArray[6] = n3;
                logger.warn(VersionResource.double("DpB1UpPt\u0006bRcGeCv_1GcAdKtHeU+\u0006bRcGeCv_,]l\n1O\u007fVdRGCcUxI\u007f\u001bj[?]l\bj[1\u001b/\u0006`StThptTbO~H,]l\bj[?]l"), objectArray);
                break;
            }
            case PATCH: {
                EngineVersion engineVersion7 = a;
                n = engineVersion7.getMajor();
                Integer n4 = n2 = engineVersion7.getMajor() != null ? a.getMinor() : null;
                if ((a.getMajor() != null || a.getMinor() == null) && a.getPatch() == null) break;
                Object[] objectArray = new Object[7];
                objectArray[0] = a2;
                objectArray[1] = a.getMajor();
                objectArray[2] = a.getMinor();
                objectArray[3] = a.getPatch();
                objectArray[4] = n;
                objectArray[5] = n2;
                objectArray[6] = n3;
                logger.warn(VersionResource.double("DpB1UpPt\u0006bRcGeCv_1GcAdKtHeU+\u0006bRcGeCv_,]l\n1O\u007fVdRGCcUxI\u007f\u001bj[?]l\bj[1\u001b/\u0006`StThptTbO~H,]l\bj[?]l"), objectArray);
                break;
            }
            case EXACT: {
                bl = true;
                if (a.getMajor() != null && a.getMinor() != null && a.getPatch() != null) break;
                Object[] objectArray = new Object[4];
                objectArray[0] = a2;
                objectArray[1] = a.getMajor();
                objectArray[2] = a.getMinor();
                objectArray[3] = a.getPatch();
                logger.warn(VersionResource.double("sGu\u0006bGgC1UeTpRtAh\u0006pTvS|C\u007fRb\u001c1UeTpRtAh\u001bj[=\u0006xHaSeptTbO~H,]l\bj[?]l"), objectArray);
                break;
            }
            default: {
                throw new UnsupportedOperationException(new StringBuilder().insert(0, VersionResource.double("dHbSaV~TeCu\u0006bGgC1UeTpRtAh\u001c1")).append((Object)a2).toString());
            }
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = bl;
        objectArray[1] = n;
        objectArray[2] = n2;
        objectArray[3] = n3;
        logger.debug(VersionResource.double("EpJrS}GeCu\u0006gCcUxI\u007f\u0006xHbCcRxI\u007f\u0006aJpH+\u0006xUT^pEeueTpRtAh\u001bj[=\u0006`StThptTbO~H,]l\bj[?]l"), objectArray);
        if (bl) {
            return a3.null(engineVersion, a);
        }
        return a3.null(engineVersion, a, a2, n, n2, n3);
    }

    @Override
    public List<Coordinates> listCoordinatesByTypeAndName(String a, String a2) {
        ResourceVersionManageServiceImpl a3;
        if (a == null || a2 == null) {
            throw new NullPointerException();
        }
        logger.debug(VersionResource.double("}ObRRI~TuO\u007fGeCbdhrhVtg\u007fB]GsC}\u000ee_aC,]l\n1HpKt\u001bj[8"), (Object)a, (Object)a2);
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        return resourceVersionManageServiceImpl.null(a3.resourceMapper.selectResourcesByTypeAndName(resourceVersionManageServiceImpl.null(), a, a2));
    }

    private /* synthetic */ Long null() {
        return EngineTenantUtil.getUserId();
    }

    @Override
    public List<Coordinates> deleteAll(Coordinates a) {
        Object object;
        ResourceVersionManageServiceImpl a2;
        logger.debug(VersionResource.double("uC}CeCPJ}\u000erI~TuO\u007fGeCb\u001bj[8"), (Object)a);
        if (((Coordinates)((Object)a)).getType() == null || ((Coordinates)((Object)a)).getName() == null || ((Coordinates)((Object)a)).getLabel() == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a2;
        EngineResource engineResource2 = engineResource;
        Coordinates coordinates = a;
        engineResource.setType(coordinates.getType());
        engineResource2.setName(coordinates.getName());
        engineResource2.setLabel(((Coordinates)((Object)a)).getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.null());
        Object object2 = resourceVersionManageServiceImpl.resourceMapper.selectResourceId(engineResource);
        if (object2 == null) {
            logger.debug(VersionResource.double("@pO}Cu\u0006eI1BtJtRt\n1H~\u0006bSrN1TtU~ScEt\u001c1]l"), (Object)a);
            return null;
        }
        if ((object2 = a2.null((Long)object2, ((Coordinates)((Object)a)).getMajor(), ((Coordinates)((Object)a)).getMinor(), ((Coordinates)((Object)a)).getPatch(), true)) == null || object2.size() == 0) {
            logger.debug(VersionResource.double("H~\u0006|GeEyCu\u0006gCcUxI\u007f\u0006cCeTxCgCu\u001c1]l"), (Object)a);
            return new ArrayList<Coordinates>();
        }
        ArrayList<Coordinates> arrayList = a = object2.iterator();
        while (arrayList.hasNext()) {
            object = (EngineVersion)((Object)a.next());
            arrayList = a;
            a2.versionMapper.updateDataStatusById(((EngineVersion)((Object)object)).getId(), 1, String.valueOf(a2.null()), a2.null());
        }
        a = new ArrayList<Coordinates>();
        object = object2.iterator();
        Object object3 = object;
        while (object3.hasNext()) {
            object2 = (EngineVersion)((Object)object.next());
            Coordinates coordinates2 = new Coordinates();
            object3 = object;
            Coordinates coordinates3 = coordinates2;
            Object object4 = object2;
            Coordinates coordinates4 = coordinates2;
            EngineResource engineResource3 = engineResource;
            coordinates2.setType(engineResource3.getType());
            coordinates4.setName(engineResource3.getName());
            coordinates4.setLabel(engineResource.getLabel());
            coordinates2.setMajor(((EngineVersion)((Object)object4)).getMajor());
            coordinates3.setMinor(((EngineVersion)((Object)object4)).getMinor());
            coordinates3.setPatch(((EngineVersion)((Object)object2)).getPatch());
            a.add(coordinates3);
        }
        logger.debug(VersionResource.double("BtJtRtB1PtTbO~H1JxUe\u001c1]l"), a);
        return a;
    }

    public void trySaveResource(EngineResource a) {
        ResourceVersionManageServiceImpl a2;
        a2.resourceMapper.insert(a);
        logger.debug(VersionResource.double("cCbIdTrC1O\u007fUtTeCu\u001c1]l"), (Object)a);
    }

    /*
     * WARNING - void declaration
     */
    public void tryInsertVersion(EngineVersion engineVersion) {
        void a;
        ResourceVersionManageServiceImpl a2;
        a2.versionMapper.insert(a);
        logger.debug(VersionResource.double("O\u007fUtTeCu\u0006gCcUxI\u007f\u001c1]l"), (Object)a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ EngineVersion null(EngineVersion engineVersion, EngineVersion engineVersion2) {
        void a;
        void a2;
        if (a2.getMajor() == null || a2.getMinor() == null || a2.getPatch() == null) {
            throw new NullPointerException();
        }
        NamedLockManagerService.Handle handle = null;
        try {
            ResourceVersionManageServiceImpl a3;
            ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
            handle = resourceVersionManageServiceImpl.null(a2.getResourceId());
            void v1 = a;
            void v2 = a2;
            a.setMajor(v2.getMajor());
            v1.setMinor(v2.getMinor());
            v1.setPatch(a2.getPatch());
            resourceVersionManageServiceImpl.tryInsertVersion((EngineVersion)v1);
            void var4_4 = a;
            return var4_4;
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            VersioningException versioningException = new VersioningException(VersionResource.double("EpH\u007fIe\u0006bGgC1E~HwJxEeCu\u0006gCcUxI\u007f"), dataIntegrityViolationException);
            versioningException.coordinates().setMajor(a.getMajor());
            versioningException.coordinates().setMinor(a.getMinor());
            versioningException.coordinates().setPatch(a.getPatch());
            logger.debug(VersionResource.double("@pO}Cu\u0006eI1O\u007fUtTe\u0006gCcUxI\u007f\u001c1]l"), (Object)a2);
            throw versioningException;
        }
        finally {
            if (handle != null) {
                handle.release();
            }
        }
    }

    private /* synthetic */ String null() {
        return EngineTenantUtil.getTenantId();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean null(Integer n, int n2) {
        void a;
        void a2;
        return a2 == null || a2.intValue() < a;
    }

    private /* synthetic */ EngineVersion null(Coordinates a) {
        ResourceVersionManageServiceImpl a2;
        if (a.getType() == null || a.getName() == null || a.getLabel() == null) {
            throw new NullPointerException();
        }
        Object object = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a2;
        EngineResource engineResource = object;
        Coordinates coordinates = a;
        ((EngineResource)object).setType(coordinates.getType());
        engineResource.setName(coordinates.getName());
        engineResource.setLabel(a.getLabel());
        ((EngineResource)object).setTenantId(resourceVersionManageServiceImpl.null());
        object = resourceVersionManageServiceImpl.resourceMapper.selectResourceId((EngineResource)object);
        if (object == null) {
            return null;
        }
        return a2.null((Long)object, a.getMajor(), a.getMinor(), a.getPatch(), true);
    }

    @Override
    public Coordinates copy(Coordinates a, VersionResource a2, VersionStrategy a3) {
        EngineVersion engineVersion;
        ResourceVersionManageServiceImpl a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a;
        objectArray[1] = a2;
        objectArray[2] = a3;
        logger.debug(VersionResource.double("E~Vh\u000ebIdTrC,]l\n1BtUeO\u007f_,]l\n1UeTpRtAh\u001bj[8"), objectArray);
        EngineVersion engineVersion2 = a4.null((Coordinates)a);
        if (engineVersion2 == null || engineVersion2.getContentId() == null) {
            logger.debug(VersionResource.double("@pO}Cu\u0006eI1E~Vh\n1H~\u0006bSrN1U~ScEt\u0006gCcUxI\u007f\u001c1]l"), a);
            return null;
        }
        a = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a4;
        Object object = a;
        VersionResource versionResource = a2;
        ((EngineResource)a).setType(versionResource.getType());
        ((EngineResource)object).setName(versionResource.getName());
        ((EngineResource)object).setLabel(((VersionResource)a2).getLabel());
        ((EngineResource)a).setTenantId(resourceVersionManageServiceImpl.null());
        resourceVersionManageServiceImpl.ensureResourceExists((EngineResource)a);
        resourceVersionManageServiceImpl.contentMapper.increaseRefCountById(engineVersion2.getContentId());
        logger.debug(VersionResource.double("xHrTtGbCu\u0006rI\u007fRtHe\u0006cCw\u0006rIdHe\u001c1E~HeC\u007fRXB,]l"), (Object)engineVersion2.getContentId());
        EngineVersion engineVersion3 = engineVersion = new EngineVersion();
        VersionResource versionResource2 = a2;
        EngineVersion engineVersion4 = engineVersion;
        engineVersion4.setResourceId(((EngineResource)a).getId());
        engineVersion4.setContentId(engineVersion2.getContentId());
        engineVersion.setMajor(versionResource2.getMajor());
        engineVersion3.setMinor(versionResource2.getMinor());
        engineVersion3.setPatch(((VersionResource)a2).getPatch());
        engineVersion.setDescription(((VersionResource)a2).getDescription() != null ? ((VersionResource)a2).getDescription() : engineVersion2.getDescription());
        engineVersion = a4.saveVersion(engineVersion, a3 != null ? a3 : VersionStrategy.EXACT);
        Object object2 = a2 = new Coordinates();
        EngineVersion engineVersion5 = engineVersion;
        Object object3 = a2;
        Object object4 = a;
        ((Coordinates)a2).setType(((EngineResource)object4).getType());
        ((Coordinates)object3).setName(((EngineResource)object4).getName());
        ((Coordinates)object3).setLabel(((EngineResource)a).getLabel());
        ((Coordinates)a2).setMajor(engineVersion5.getMajor());
        ((Coordinates)object2).setMinor(engineVersion5.getMinor());
        ((Coordinates)object2).setPatch(engineVersion.getPatch());
        logger.debug(VersionResource.double("E~VxCu\u0006gCcUxI\u007f\u001c1]l"), a2);
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public ResourceVersionManageServiceImpl(RvmResourceMapper rvmResourceMapper, RvmVersionMapper rvmVersionMapper, RvmContentMapper rvmContentMapper, NamedLockManagerService namedLockManagerService) {
        void a;
        void a2;
        void a3;
        void a4;
        ResourceVersionManageServiceImpl a5;
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a5;
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl2 = a5;
        resourceVersionManageServiceImpl2.resourceMapper = a4;
        resourceVersionManageServiceImpl2.versionMapper = a3;
        resourceVersionManageServiceImpl.contentMapper = a2;
        resourceVersionManageServiceImpl.lockManager = a;
    }

    @Override
    public Coordinates delete(Coordinates a) {
        ResourceVersionManageServiceImpl a2;
        logger.debug(VersionResource.double("BtJtRt\u000erI~TuO\u007fGeCb\u001bj[8"), (Object)a);
        if (a.getType() == null || a.getName() == null || a.getLabel() == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a2;
        EngineResource engineResource2 = engineResource;
        Coordinates coordinates = a;
        engineResource.setType(coordinates.getType());
        engineResource2.setName(coordinates.getName());
        engineResource2.setLabel(a.getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.null());
        Object object = resourceVersionManageServiceImpl.resourceMapper.selectResourceId(engineResource);
        if (object == null) {
            logger.debug(VersionResource.double("@pO}Cu\u0006eI1BtJtRt\n1H~\u0006bSrN1TtU~ScEt\u001c1]l"), (Object)a);
            return null;
        }
        if ((object = a2.null((Long)object, a.getMajor(), a.getMinor(), a.getPatch(), true)) == null) {
            logger.debug(VersionResource.double("wGxJtB1R~\u0006uC}CeC=\u0006\u007fI1UdEy\u0006gCcUxI\u007f\u001c1]l"), (Object)a);
            return null;
        }
        a2.versionMapper.updateDataStatusById(((EngineVersion)((Object)object)).getId(), 1, String.valueOf(a2.null()), a2.null());
        Coordinates coordinates2 = a = new Coordinates();
        Object object2 = object;
        Coordinates coordinates3 = a;
        EngineResource engineResource3 = engineResource;
        a.setType(engineResource3.getType());
        coordinates3.setName(engineResource3.getName());
        coordinates3.setLabel(engineResource.getLabel());
        a.setMajor(((EngineVersion)((Object)object2)).getMajor());
        coordinates2.setMinor(((EngineVersion)((Object)object2)).getMinor());
        coordinates2.setPatch(((EngineVersion)((Object)object)).getPatch());
        logger.debug(VersionResource.double("uC}CeCu\u0006gCcUxI\u007f\u001c1]l"), (Object)a);
        return a;
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ void null(EngineVersion a, EngineVersion a22, VersionStrategy a3, Integer a4, Integer a52, Integer a62) {
        int n;
        int a62;
        int a52;
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl;
        ResourceVersionManageServiceImpl a7;
        a4 = a7.null(a22.getResourceId(), (Integer)a4, a52, a62, false);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (a3) {
            case MAJOR: {
                n2 = 1;
                if (a4 != null) {
                    resourceVersionManageServiceImpl = a7;
                    a52 = ((EngineVersion)((Object)a4)).getMajor() + n2;
                    a62 = 0;
                    n = 0;
                    break;
                }
                a52 = 1;
                a62 = 0;
                n = 0;
                resourceVersionManageServiceImpl = a7;
                break;
            }
            case MINOR: {
                n3 = 1;
                if (a4 != null) {
                    resourceVersionManageServiceImpl = a7;
                    Object object = a4;
                    a52 = ((EngineVersion)((Object)object)).getMajor();
                    a62 = ((EngineVersion)((Object)object)).getMinor() + n3;
                    n = 0;
                    break;
                }
                if (a22.getMajor() != null) {
                    resourceVersionManageServiceImpl = a7;
                    a52 = a22.getMajor();
                    a62 = 1;
                    n = 0;
                    break;
                }
                a52 = 0;
                a62 = 1;
                n = 0;
                resourceVersionManageServiceImpl = a7;
                break;
            }
            case PATCH: {
                n4 = 1;
                if (a4 != null) {
                    resourceVersionManageServiceImpl = a7;
                    Object object = a4;
                    a52 = ((EngineVersion)((Object)object)).getMajor();
                    a62 = ((EngineVersion)((Object)object)).getMinor();
                    n = ((EngineVersion)((Object)object)).getPatch() + n4;
                    break;
                }
                if (a22.getMajor() != null && a22.getMinor() != null) {
                    resourceVersionManageServiceImpl = a7;
                    EngineVersion engineVersion = a22;
                    a52 = engineVersion.getMajor();
                    a62 = engineVersion.getMinor();
                    n = 1;
                    break;
                }
                if (a22.getMajor() != null) {
                    resourceVersionManageServiceImpl = a7;
                    a52 = a22.getMajor();
                    a62 = 0;
                    n = 1;
                    break;
                }
                a52 = 0;
                a62 = 0;
                n = 1;
                resourceVersionManageServiceImpl = a7;
                break;
            }
            default: {
                throw new UnsupportedOperationException(new StringBuilder().insert(0, VersionResource.double("S\u007fCiVtEeCu\u0006bRcGeCv_1")).append((Object)a3).toString());
            }
        }
        boolean a22 = resourceVersionManageServiceImpl.null(a.getMajor(), a52) || a7.null(a.getMinor(), a62) || a7.null(a.getPatch(), n);
        Object[] objectArray = new Object[4];
        objectArray[0] = a52;
        objectArray[1] = a62;
        objectArray[2] = n;
        objectArray[3] = a22;
        logger.debug(VersionResource.double("EpJrS}GeCu\u0006gCcUxI\u007f\u0006wT~K1RyC1JpRtUe\u001c1Ht^e\u001bj[?]l\bj[=\u0006uOw@tTtHrC,]l"), objectArray);
        if (!a22) {
            ResourceVersionManageServiceImpl resourceVersionManageServiceImpl2 = a7;
            EngineVersion engineVersion = a;
            a52 = a7.null(engineVersion.getMajor(), a52 + n2);
            a62 = resourceVersionManageServiceImpl2.null(engineVersion.getMinor(), a62 + n3);
            n = resourceVersionManageServiceImpl2.null(a.getPatch(), n + n4);
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = a52;
            objectArray2[1] = a62;
            objectArray2[2] = n;
            logger.debug(VersionResource.double("xHrTtGbCu\u0006gCcUxI\u007f\u0006sCrGdUt\u0006~@1H~\u0006uOw@tTtHrC+\u0006\u007fCiR,]l\bj[?]l"), objectArray2);
        }
        EngineVersion engineVersion = a;
        engineVersion.setMajor(a52);
        engineVersion.setMinor(a62);
        a.setPatch(n);
        logger.debug(VersionResource.double("cCwTtUyCu\u0006gCcUxI\u007f\u0006~@1RyC1Ht^e\u0006xHbCcRxI\u007f\u001c1O\u007fUtTeptTbO~H,]l"), (Object)a);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Coordinates> listCoordinatesByTypeAndLabel(String string, String string2) {
        ResourceVersionManageServiceImpl a;
        void a2;
        void a3;
        if (a3 == null || a2 == null) {
            throw new NullPointerException();
        }
        logger.debug(VersionResource.double("JxUee~IcBxHpRtUS_E_aCPHujpDtJ9RhVt\u001bj[=\u0006}GsC}\u001bj[8"), (Object)a3, (Object)a2);
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a;
        return resourceVersionManageServiceImpl.null(a.resourceMapper.selectResourcesByTypeAndLabel(resourceVersionManageServiceImpl.null(), (String)a3, (String)a2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Coordinates> listCoordinatesByType(String string) {
        ResourceVersionManageServiceImpl a;
        void a2;
        if (a2 == null) {
            throw new NullPointerException();
        }
        logger.debug(VersionResource.double("JxUee~IcBxHpRtUS_E_aC9RhVt\u001bj[8"), (Object)a2);
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a;
        return resourceVersionManageServiceImpl.null(a.resourceMapper.selectResourcesByType(resourceVersionManageServiceImpl.null(), (String)a2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ EngineVersion null(long a, Integer a2, Integer a3, Integer a4, boolean a5) {
        void var7_15;
        List<EngineVersion> list;
        Integer n;
        int n2;
        if (a2 != null) {
            n2 = 4;
            n = a3;
        } else {
            n2 = 0;
            n = a3;
        }
        int n3 = n2 | (n != null ? 2 : 0) | (a4 != null ? 1 : 0);
        Page page = new Page(1L, 1L, false);
        switch (n3) {
            case 0: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list2;
                list = list2 = a6.versionMapper.selectVersions((Page<EngineVersion>)page, a, a5);
                break;
            }
            case 4: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list3 = a6.versionMapper.selectVersionsMatchMajor((Page<EngineVersion>)page, a, a2, a5);
                list = list3;
                break;
            }
            case 2: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list4 = a6.versionMapper.selectVersionsMatchMinor((Page<EngineVersion>)page, a, a3, a5);
                list = list4;
                break;
            }
            case 1: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list5 = a6.versionMapper.selectVersionsMatchPatch((Page<EngineVersion>)page, a, a4, a5);
                list = list5;
                break;
            }
            case 6: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list6 = a6.versionMapper.selectVersionsMatchMajorAndMinor((Page<EngineVersion>)page, a, a2, a3, a5);
                list = list6;
                break;
            }
            case 5: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list7 = a6.versionMapper.selectVersionsMatchMajorAndPatch((Page<EngineVersion>)page, a, a2, a4, a5);
                list = list7;
                break;
            }
            case 3: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list8 = a6.versionMapper.selectVersionsMatchMinorAndPatch((Page<EngineVersion>)page, a, a3, a4, a5);
                list = list8;
                break;
            }
            default: {
                ResourceVersionManageServiceImpl a6;
                return a6.versionMapper.selectExactVersion(a, a2, a3, a4, a5);
            }
        }
        if (list == null || var7_15.size() == 0) {
            return null;
        }
        if (var7_15.size() > 1) {
            throw new TooManyResultsException(VersionResource.double("aGvO\u007fGeO~H1H~R1Q~TzCu"));
        }
        EngineVersion engineVersion = (EngineVersion)((Object)var7_15.get(0));
        Object[] objectArray = new Object[6];
        objectArray[0] = a;
        objectArray[1] = a2;
        objectArray[2] = a3;
        objectArray[3] = a4;
        objectArray[4] = a5;
        objectArray[5] = engineVersion;
        logger.debug(VersionResource.double("TtRcOtPtB1JpRtUe\u0006gCcUxI\u007f\u001c1TtU~ScEtou\u001bj[=\u0006gCcUxI\u007f\u001bj[?]l\bj[=\u0006\u007fIcKpJ,]l\n1T~Q,]l"), objectArray);
        return engineVersion;
    }

    @Override
    public List<VersionResource> list(Coordinates a, boolean a222) {
        Iterator a222;
        ResourceVersionManageServiceImpl a3;
        logger.debug(VersionResource.double("JxUe\u000erI~TuO\u007fGeCb\u001bj[=\u0006\u007fIRI\u007fRtHe\u001bj[8"), (Object)a, (Object)a222);
        if (((Coordinates)((Object)a)).getType() == null || ((Coordinates)((Object)a)).getName() == null || ((Coordinates)((Object)a)).getLabel() == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        EngineResource engineResource2 = engineResource;
        Coordinates coordinates = a;
        engineResource.setType(coordinates.getType());
        engineResource2.setName(coordinates.getName());
        engineResource2.setLabel(((Coordinates)((Object)a)).getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.null());
        Object object = resourceVersionManageServiceImpl.resourceMapper.selectResourceId(engineResource);
        if (object == null) {
            logger.debug(VersionResource.double("@pO}Cu\u0006eI1JxUe\n1H~\u0006bSrN1TtU~ScEt\u001c1]l"), (Object)a);
            return null;
        }
        if ((object = a3.null((Long)object, ((Coordinates)((Object)a)).getMajor(), ((Coordinates)((Object)a)).getMinor(), ((Coordinates)((Object)a)).getPatch(), true)) == null || object.size() == 0) {
            logger.debug(VersionResource.double("H~\u0006|GeEyCu\u0006gCcUxI\u007f\u0006cCeTxCgCu\u001c1]l"), (Object)a);
            return new ArrayList<VersionResource>();
        }
        if (!a222) {
            ArrayList<VersionResource> arrayList = a = object.iterator();
            while (arrayList.hasNext()) {
                EngineVersion a222 = (EngineVersion)((Object)a.next());
                a222.setContent(Optional.ofNullable(a222.getContentId()).map(arg_0 -> ((RvmContentMapper)a3.contentMapper).selectById(arg_0)).orElse(null));
                arrayList = a;
            }
        }
        a = new ArrayList<VersionResource>(object.size());
        Iterator iterator = a222 = object.iterator();
        while (iterator.hasNext()) {
            VersionResource versionResource;
            object = (EngineVersion)((Object)a222.next());
            VersionResource versionResource2 = versionResource = new VersionResource();
            Object object2 = object;
            VersionResource versionResource3 = versionResource;
            VersionResource versionResource4 = versionResource;
            EngineResource engineResource3 = engineResource;
            versionResource.setType(engineResource3.getType());
            versionResource4.setName(engineResource3.getName());
            versionResource4.setLabel(engineResource.getLabel());
            versionResource3.setMajor(((EngineVersion)((Object)object)).getMajor());
            versionResource3.setMinor(((EngineVersion)((Object)object)).getMinor());
            versionResource.setPatch(((EngineVersion)((Object)object2)).getPatch());
            versionResource2.setDescription(((EngineVersion)((Object)object2)).getDescription());
            versionResource2.setContent(Optional.of(object).map(EngineVersion::getContent).map(EngineContent::getData).orElse(null));
            iterator = a222;
            a.add(versionResource);
        }
        logger.debug(VersionResource.double("}ObRtB1PtTbO~Hb\u001c1]l"), a);
        return a;
    }

    private /* synthetic */ int null(Integer a, int a2) {
        if (a == null) {
            return a2;
        }
        return Integer.max(a, a2);
    }

    private /* synthetic */ Date null() {
        return new Date();
    }

    @Override
    public Coordinates save(VersionResource versionResource, VersionStrategy versionStrategy) {
        EngineVersion engineVersion;
        ResourceVersionManageServiceImpl a;
        EngineContent a2;
        Coordinates a3;
        logger.debug(VersionResource.double("UpPt\u000ecCbIdTrC,]l\n1UeTpRtAh\u001bj[8"), (Object)a3, (Object)a2);
        if (a3 == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a;
        EngineResource engineResource2 = engineResource;
        void v2 = a3;
        engineResource.setType(v2.getType());
        engineResource2.setName(v2.getName());
        engineResource2.setLabel(((VersionResource)((Object)a3)).getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.null());
        resourceVersionManageServiceImpl.ensureResourceExists(engineResource);
        EngineVersion engineVersion2 = engineVersion = new EngineVersion();
        void v4 = a3;
        EngineVersion engineVersion3 = engineVersion;
        engineVersion.setResourceId(engineResource.getId());
        engineVersion3.setMajor(((VersionResource)((Object)a3)).getMajor());
        engineVersion3.setMinor(((VersionResource)((Object)a3)).getMinor());
        engineVersion.setPatch(v4.getPatch());
        engineVersion2.setDescription(v4.getDescription());
        engineVersion = resourceVersionManageServiceImpl.saveVersion(engineVersion2, (VersionStrategy)((Object)(a2 != null ? a2 : VersionStrategy.EXACT)));
        EngineContent engineContent = a2 = new EngineContent();
        engineContent.setRefCount(1L);
        engineContent.setData(((VersionResource)((Object)a3)).getContent());
        a.contentMapper.insert(a2);
        logger.debug(VersionResource.double("O\u007fUtTeCu\u0006rI\u007fRtHe\u001c1]l"), (Object)a2);
        a.versionMapper.updateContentById(engineVersion.getId(), a2.getId());
        logger.debug(VersionResource.double("SaBpRtB1PtTbO~H1TtJpRtB1E~HeC\u007fR1Ou\u001c1]l"), (Object)engineVersion.getId());
        Coordinates coordinates = a3 = new Coordinates();
        EngineVersion engineVersion4 = engineVersion;
        Coordinates coordinates2 = a3;
        EngineResource engineResource3 = engineResource;
        a3.setType(engineResource3.getType());
        coordinates2.setName(engineResource3.getName());
        coordinates2.setLabel(engineResource.getLabel());
        a3.setMajor(engineVersion4.getMajor());
        coordinates.setMinor(engineVersion4.getMinor());
        coordinates.setPatch(engineVersion.getPatch());
        logger.debug(VersionResource.double("bGgCu\u0006gCcUxI\u007f\u001c1]l"), (Object)a3);
        return a3;
    }

    private /* synthetic */ List<Coordinates> null(List<EngineResource> a) {
        ArrayList<Coordinates> arrayList = new ArrayList<Coordinates>();
        Object object = a = a.iterator();
        while (object.hasNext()) {
            ResourceVersionManageServiceImpl a2;
            EngineResource engineResource = (EngineResource)a.next();
            EngineVersion engineVersion = a2.null(engineResource.getId(), null, null, null, true);
            if (engineVersion == null) {
                object = a;
                continue;
            }
            Coordinates coordinates = new Coordinates();
            object = a;
            Coordinates coordinates2 = coordinates;
            EngineVersion engineVersion2 = engineVersion;
            Coordinates coordinates3 = coordinates;
            EngineResource engineResource2 = engineResource;
            coordinates.setType(engineResource2.getType());
            coordinates3.setName(engineResource2.getName());
            coordinates3.setLabel(engineResource.getLabel());
            coordinates.setMajor(engineVersion2.getMajor());
            coordinates2.setMinor(engineVersion2.getMinor());
            coordinates2.setPatch(engineVersion.getPatch());
            arrayList.add(coordinates2);
        }
        return arrayList;
    }
}

