/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine.rvm.service.impl;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.engine.common.util.EngineTenantUtil;
import com.jxdinfo.hussar.engine.rvm.dao.RvmContentMapper;
import com.jxdinfo.hussar.engine.rvm.dao.RvmResourceMapper;
import com.jxdinfo.hussar.engine.rvm.dao.RvmVersionMapper;
import com.jxdinfo.hussar.engine.rvm.model.Coordinates;
import com.jxdinfo.hussar.engine.rvm.model.EngineContent;
import com.jxdinfo.hussar.engine.rvm.model.EngineResource;
import com.jxdinfo.hussar.engine.rvm.model.EngineVersion;
import com.jxdinfo.hussar.engine.rvm.model.VersionResource;
import com.jxdinfo.hussar.engine.rvm.model.VersionStrategy;
import com.jxdinfo.hussar.engine.rvm.service.NamedLockManagerService;
import com.jxdinfo.hussar.engine.rvm.service.ResourceVersionManageService;
import com.jxdinfo.hussar.engine.rvm.util.VersioningException;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@HussarDs(value="master")
public class ResourceVersionManageServiceImpl
implements ResourceVersionManageService {
    @Resource
    private RvmResourceMapper resourceMapper;
    private static final String LOCK_TYPE_VERSION_INSERTION = "ver";
    private final NamedLockManagerService lockManager;
    private static final Logger logger = LoggerFactory.getLogger(ResourceVersionManageServiceImpl.class);
    private static final int MAX_SAVE_RETRY = 10;
    @Resource
    private RvmContentMapper contentMapper;
    @Resource
    private RvmVersionMapper versionMapper;
    private final DynamicDatasourceService datasourceService;

    public void ensureResourceExists(EngineResource a) {
        ResourceVersionManageServiceImpl a2;
        EngineResource engineResource = a;
        engineResource.setId(a2.resourceMapper.selectResourceId(engineResource));
        if (engineResource.getId() != null) {
            logger.debug(VersionResource.import("Q.A}P5A}A%M.P4J:\u0004/A.K(V>Ag\u0004&Y"), (Object)a);
            return;
        }
        try {
            a2.trySaveResource(a);
            return;
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            EngineResource engineResource2 = a;
            engineResource2.setId(a2.resourceMapper.selectResourceId(engineResource2));
            logger.debug(VersionResource.import("P/M8@}P2\u0004/A)V4A+A}V8W2Q/G8\u00044@g\u0004&Y"), (Object)a);
            if (engineResource2.getId() == null) {
                VersioningException versioningException = new VersioningException(VersionResource.import("B<M1A9\u0004)K}V8P/M8R8\u0004/A.K(V>A}M9\b}I<O8\u0004.Q/A}J2\u00043A.P8@}P/E3W<G)M2J}M.\u0004(W8@"), dataIntegrityViolationException);
                versioningException.coordinates().setType(a.getType());
                versioningException.coordinates().setName(a.getName());
                versioningException.coordinates().setLabel(a.getLabel());
                logger.debug(VersionResource.import(";E4H8@}P2\u00048J.Q/A}V8W2Q/G8\u00048\\4W)Wg\u0004&Y"), (Object)a);
                throw versioningException;
            }
            return;
        }
    }

    private /* synthetic */ DbType catch() {
        ResourceVersionManageServiceImpl a;
        return a.datasourceService.getCurrentDatasource().getDbType();
    }

    @Override
    public List<Coordinates> listCoordinatesByTypeAndName(String a, String a2) {
        ResourceVersionManageServiceImpl a3;
        if (a == null || a2 == null) {
            throw new NullPointerException();
        }
        logger.debug(VersionResource.import("H4W)g2K/@4J<P8W\u001f]\t]-A\u001cJ9h<F8HuP$T8\u0019&Yq\u00043E0A`_ \r"), (Object)a, (Object)a2);
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        return resourceVersionManageServiceImpl.do(a3.resourceMapper.selectResourcesByTypeAndName(resourceVersionManageServiceImpl.volatile(), a, a2));
    }

    @Override
    public List<Coordinates> deleteAll(Coordinates a) {
        Object object;
        ResourceVersionManageServiceImpl a2;
        logger.debug(VersionResource.import("@8H8P8e1HuG2K/@4J<P8W`_ \r"), (Object)a);
        if (((Coordinates)((Object)a)).getType() == null || ((Coordinates)((Object)a)).getName() == null || ((Coordinates)((Object)a)).getLabel() == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a2;
        EngineResource engineResource2 = engineResource;
        Coordinates coordinates = a;
        engineResource.setType(coordinates.getType());
        engineResource2.setName(coordinates.getName());
        engineResource2.setLabel(((Coordinates)((Object)a)).getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.volatile());
        Object object2 = resourceVersionManageServiceImpl.resourceMapper.selectResourceId(engineResource);
        if (object2 == null) {
            logger.debug(VersionResource.import(";E4H8@}P2\u00049A1A)Aq\u00043K}W(G5\u0004/A.K(V>Ag\u0004&Y"), (Object)a);
            return null;
        }
        if ((object2 = a2.else((Long)object2, ((Coordinates)((Object)a)).getMajor(), ((Coordinates)((Object)a)).getMinor(), ((Coordinates)((Object)a)).getPatch(), true)) == null || object2.size() == 0) {
            logger.debug(VersionResource.import("3K}I<P>L8@}R8V.M2J}V8P/M8R8@g\u0004&Y"), (Object)a);
            return new ArrayList<Coordinates>();
        }
        ArrayList<Coordinates> arrayList = a = object2.iterator();
        while (arrayList.hasNext()) {
            object = (EngineVersion)((Object)a.next());
            arrayList = a;
            a2.versionMapper.updateDataStatusById(((EngineVersion)((Object)object)).getId(), 1, String.valueOf(a2.interface()), a2.transient());
        }
        a = new ArrayList<Coordinates>();
        object = object2.iterator();
        Object object3 = object;
        while (object3.hasNext()) {
            object2 = (EngineVersion)((Object)object.next());
            Coordinates coordinates2 = new Coordinates();
            object3 = object;
            Coordinates coordinates3 = coordinates2;
            Object object4 = object2;
            Coordinates coordinates4 = coordinates2;
            EngineResource engineResource3 = engineResource;
            coordinates2.setType(engineResource3.getType());
            coordinates4.setName(engineResource3.getName());
            coordinates4.setLabel(engineResource.getLabel());
            coordinates2.setMajor(((EngineVersion)((Object)object4)).getMajor());
            coordinates3.setMinor(((EngineVersion)((Object)object4)).getMinor());
            coordinates3.setPatch(((EngineVersion)((Object)object2)).getPatch());
            a.add(coordinates3);
        }
        logger.debug(VersionResource.import("9A1A)A9\u0004+A/W4K3\u00041M.Pg\u0004&Y"), a);
        return a;
    }

    public void trySaveResource(EngineResource a) {
        ResourceVersionManageServiceImpl a2;
        a2.resourceMapper.insert(a);
        logger.debug(VersionResource.import("V8W2Q/G8\u00044J.A/P8@g\u0004&Y"), (Object)a);
    }

    @Override
    public List<VersionResource> list(Coordinates a, boolean a222) {
        Iterator a222;
        ResourceVersionManageServiceImpl a3;
        logger.debug(VersionResource.import("1M.PuG2K/@4J<P8W`_ \b}J2g2J)A3P`_ \r"), (Object)a, (Object)a222);
        if (((Coordinates)((Object)a)).getType() == null || ((Coordinates)((Object)a)).getName() == null || ((Coordinates)((Object)a)).getLabel() == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        EngineResource engineResource2 = engineResource;
        Coordinates coordinates = a;
        engineResource.setType(coordinates.getType());
        engineResource2.setName(coordinates.getName());
        engineResource2.setLabel(((Coordinates)((Object)a)).getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.volatile());
        Object object = resourceVersionManageServiceImpl.resourceMapper.selectResourceId(engineResource);
        if (object == null) {
            logger.debug(VersionResource.import(";E4H8@}P2\u00041M.Pq\u00043K}W(G5\u0004/A.K(V>Ag\u0004&Y"), (Object)a);
            return null;
        }
        if ((object = a3.else((Long)object, ((Coordinates)((Object)a)).getMajor(), ((Coordinates)((Object)a)).getMinor(), ((Coordinates)((Object)a)).getPatch(), true)) == null || object.size() == 0) {
            logger.debug(VersionResource.import("3K}I<P>L8@}R8V.M2J}V8P/M8R8@g\u0004&Y"), (Object)a);
            return new ArrayList<VersionResource>();
        }
        if (!a222) {
            ArrayList<VersionResource> arrayList = a = object.iterator();
            while (arrayList.hasNext()) {
                EngineVersion a222 = (EngineVersion)((Object)a.next());
                a222.setContent(Optional.ofNullable(a222.getContentId()).map(arg_0 -> ((RvmContentMapper)a3.contentMapper).selectById(arg_0)).orElse(null));
                arrayList = a;
            }
        }
        a = new ArrayList<VersionResource>(object.size());
        Iterator iterator = a222 = object.iterator();
        while (iterator.hasNext()) {
            VersionResource versionResource;
            object = (EngineVersion)((Object)a222.next());
            VersionResource versionResource2 = versionResource = new VersionResource();
            Object object2 = object;
            VersionResource versionResource3 = versionResource;
            VersionResource versionResource4 = versionResource;
            EngineResource engineResource3 = engineResource;
            versionResource.setType(engineResource3.getType());
            versionResource4.setName(engineResource3.getName());
            versionResource4.setLabel(engineResource.getLabel());
            versionResource3.setMajor(((EngineVersion)((Object)object)).getMajor());
            versionResource3.setMinor(((EngineVersion)((Object)object)).getMinor());
            versionResource.setPatch(((EngineVersion)((Object)object2)).getPatch());
            versionResource2.setDescription(((EngineVersion)((Object)object2)).getDescription());
            versionResource2.setContent(Optional.of(object).map(EngineVersion::getContent).map(EngineContent::getData).orElse(null));
            iterator = a222;
            a.add(versionResource);
        }
        logger.debug(VersionResource.import("H4W)A9\u0004+A/W4K3Wg\u0004&Y"), a);
        return a;
    }

    @Override
    public List<Coordinates> listCoordinatesByType(String a) {
        ResourceVersionManageServiceImpl a2;
        if (a == null) {
            throw new NullPointerException();
        }
        logger.debug(VersionResource.import("1M.P\u001eK2V9M3E)A.f$p$T8\f)]-A`_ \r"), (Object)a);
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a2;
        return resourceVersionManageServiceImpl.do(a2.resourceMapper.selectResourcesByType(resourceVersionManageServiceImpl.volatile(), a));
    }

    private /* synthetic */ Long interface() {
        return EngineTenantUtil.getUserId();
    }

    private /* synthetic */ boolean boolean(Integer a, int a2) {
        return a == null || a < a2;
    }

    private /* synthetic */ int const(Integer a, int a2) {
        if (a == null) {
            return a2;
        }
        return Integer.max(a, a2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ List<EngineVersion> else(long a, Integer a2, Integer a3, Integer a4, boolean a5) {
        List<EngineVersion> list;
        Integer n;
        int n2;
        if (a2 != null) {
            n2 = 4;
            n = a3;
        } else {
            n2 = 0;
            n = a3;
        }
        switch (n2 | (n != null ? 2 : 0) | (a4 != null ? 1 : 0)) {
            case 0: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersions(null, a, a5);
                break;
            }
            case 4: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMajor(null, a, a2, a5);
                break;
            }
            case 2: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMinor(null, a, a3, a5);
                break;
            }
            case 1: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchPatch(null, a, a4, a5);
                break;
            }
            case 6: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMajorAndMinor(null, a, a2, a3, a5);
                break;
            }
            case 5: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMajorAndPatch(null, a, a2, a4, a5);
                break;
            }
            case 3: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMinorAndPatch(null, a, a3, a4, a5);
                break;
            }
            default: {
                ResourceVersionManageServiceImpl a6;
                return Optional.ofNullable(a6.versionMapper.selectExactVersion(a, a2, a3, a4, a5)).map(Collections::singletonList).orElse(Collections.emptyList());
            }
        }
        Object[] objectArray = new Object[6];
        objectArray[0] = a;
        objectArray[1] = a2;
        objectArray[2] = a3;
        objectArray[3] = a4;
        objectArray[4] = a5;
        objectArray[5] = list;
        logger.debug(VersionResource.import("V8P/M8R8@}R8V.M2J}H4W)\u001e}V8W2Q/G8m9\u0019&Yq\u0004+A/W4K3\u0019&Ys_ \n&Yq\u00043K/I<H`_ \b}V2S.\u0019&Y"), objectArray);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public Coordinates delete(Coordinates a) {
        ResourceVersionManageServiceImpl a2;
        logger.debug(VersionResource.import("9A1A)AuG2K/@4J<P8W`_ \r"), (Object)a);
        if (a.getType() == null || a.getName() == null || a.getLabel() == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a2;
        EngineResource engineResource2 = engineResource;
        Coordinates coordinates = a;
        engineResource.setType(coordinates.getType());
        engineResource2.setName(coordinates.getName());
        engineResource2.setLabel(a.getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.volatile());
        Object object = resourceVersionManageServiceImpl.resourceMapper.selectResourceId(engineResource);
        if (object == null) {
            logger.debug(VersionResource.import(";E4H8@}P2\u00049A1A)Aq\u00043K}W(G5\u0004/A.K(V>Ag\u0004&Y"), (Object)a);
            return null;
        }
        if ((object = a2.static((Long)object, a.getMajor(), a.getMinor(), a.getPatch(), true)) == null) {
            logger.debug(VersionResource.import("B<M1A9\u0004)K}@8H8P8\b}J2\u0004.Q>L}R8V.M2Jg\u0004&Y"), (Object)a);
            return null;
        }
        a2.versionMapper.updateDataStatusById(((EngineVersion)((Object)object)).getId(), 1, String.valueOf(a2.interface()), a2.transient());
        Coordinates coordinates2 = a = new Coordinates();
        Object object2 = object;
        Coordinates coordinates3 = a;
        EngineResource engineResource3 = engineResource;
        a.setType(engineResource3.getType());
        coordinates3.setName(engineResource3.getName());
        coordinates3.setLabel(engineResource.getLabel());
        a.setMajor(((EngineVersion)((Object)object2)).getMajor());
        coordinates2.setMinor(((EngineVersion)((Object)object2)).getMinor());
        coordinates2.setPatch(((EngineVersion)((Object)object)).getPatch());
        logger.debug(VersionResource.import("@8H8P8@}R8V.M2Jg\u0004&Y"), (Object)a);
        return a;
    }

    @Override
    public Coordinates save(VersionResource a, VersionStrategy a2) {
        EngineVersion engineVersion;
        ResourceVersionManageServiceImpl a3;
        logger.debug(VersionResource.import(".E+AuV8W2Q/G8\u0019&Yq\u0004.P/E)A:]`_ \r"), a, a2);
        if (a == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        EngineResource engineResource2 = engineResource;
        VersionResource versionResource = a;
        engineResource.setType(versionResource.getType());
        engineResource2.setName(versionResource.getName());
        engineResource2.setLabel(((VersionResource)a).getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.volatile());
        resourceVersionManageServiceImpl.ensureResourceExists(engineResource);
        EngineVersion engineVersion2 = engineVersion = new EngineVersion();
        VersionResource versionResource2 = a;
        EngineVersion engineVersion3 = engineVersion;
        engineVersion.setResourceId(engineResource.getId());
        engineVersion3.setMajor(((VersionResource)a).getMajor());
        engineVersion3.setMinor(((VersionResource)a).getMinor());
        engineVersion.setPatch(versionResource2.getPatch());
        engineVersion2.setDescription(versionResource2.getDescription());
        engineVersion = resourceVersionManageServiceImpl.saveVersion(engineVersion2, (VersionStrategy)((Object)(a2 != null ? a2 : VersionStrategy.EXACT)));
        a2 = new EngineContent();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl2 = a3;
        Object object = a2;
        ((EngineContent)object).setRefCount(1L);
        ((EngineContent)object).setData(((VersionResource)a).getContent());
        resourceVersionManageServiceImpl2.throws((EngineContent)a2);
        logger.debug(VersionResource.import("4J.A/P8@}G2J)A3Pg\u0004&Y"), a2);
        resourceVersionManageServiceImpl2.versionMapper.updateContentById(engineVersion.getId(), ((EngineContent)a2).getId());
        logger.debug(VersionResource.import("(T9E)A9\u0004+A/W4K3\u0004/A1E)A9\u0004>K3P8J)\u00044@g\u0004&Y"), (Object)engineVersion.getId());
        Object object2 = a = new Coordinates();
        EngineVersion engineVersion4 = engineVersion;
        Object object3 = a;
        EngineResource engineResource3 = engineResource;
        ((Coordinates)a).setType(engineResource3.getType());
        ((Coordinates)object3).setName(engineResource3.getName());
        ((Coordinates)object3).setLabel(engineResource.getLabel());
        ((Coordinates)a).setMajor(engineVersion4.getMajor());
        ((Coordinates)object2).setMinor(engineVersion4.getMinor());
        ((Coordinates)object2).setPatch(engineVersion.getPatch());
        logger.debug(VersionResource.import("W<R8@}R8V.M2Jg\u0004&Y"), a);
        return a;
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ void enum(EngineVersion a, EngineVersion a22, VersionStrategy a3, Integer a4, Integer a52, Integer a62) {
        int n;
        int a62;
        int a52;
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl;
        ResourceVersionManageServiceImpl a7;
        a4 = a7.static(a22.getResourceId(), (Integer)a4, a52, a62, false);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (a3) {
            case MAJOR: {
                n2 = 1;
                if (a4 != null) {
                    resourceVersionManageServiceImpl = a7;
                    a52 = ((EngineVersion)((Object)a4)).getMajor() + n2;
                    a62 = 0;
                    n = 0;
                    break;
                }
                a52 = 1;
                a62 = 0;
                n = 0;
                resourceVersionManageServiceImpl = a7;
                break;
            }
            case MINOR: {
                n3 = 1;
                if (a4 != null) {
                    resourceVersionManageServiceImpl = a7;
                    Object object = a4;
                    a52 = ((EngineVersion)((Object)object)).getMajor();
                    a62 = ((EngineVersion)((Object)object)).getMinor() + n3;
                    n = 0;
                    break;
                }
                if (a22.getMajor() != null) {
                    resourceVersionManageServiceImpl = a7;
                    a52 = a22.getMajor();
                    a62 = 1;
                    n = 0;
                    break;
                }
                a52 = 0;
                a62 = 1;
                n = 0;
                resourceVersionManageServiceImpl = a7;
                break;
            }
            case PATCH: {
                n4 = 1;
                if (a4 != null) {
                    resourceVersionManageServiceImpl = a7;
                    Object object = a4;
                    a52 = ((EngineVersion)((Object)object)).getMajor();
                    a62 = ((EngineVersion)((Object)object)).getMinor();
                    n = ((EngineVersion)((Object)object)).getPatch() + n4;
                    break;
                }
                if (a22.getMajor() != null && a22.getMinor() != null) {
                    resourceVersionManageServiceImpl = a7;
                    EngineVersion engineVersion = a22;
                    a52 = engineVersion.getMajor();
                    a62 = engineVersion.getMinor();
                    n = 1;
                    break;
                }
                if (a22.getMajor() != null) {
                    resourceVersionManageServiceImpl = a7;
                    a52 = a22.getMajor();
                    a62 = 0;
                    n = 1;
                    break;
                }
                a52 = 0;
                a62 = 0;
                n = 1;
                resourceVersionManageServiceImpl = a7;
                break;
            }
            default: {
                throw new UnsupportedOperationException(new StringBuilder().insert(0, VersionResource.import("(J8\\-A>P8@}W)V<P8C$\u0004")).append((Object)a3).toString());
            }
        }
        boolean a22 = resourceVersionManageServiceImpl.boolean(a.getMajor(), a52) || a7.boolean(a.getMinor(), a62) || a7.boolean(a.getPatch(), n);
        Object[] objectArray = new Object[4];
        objectArray[0] = a52;
        objectArray[1] = a62;
        objectArray[2] = n;
        objectArray[3] = a22;
        logger.debug(VersionResource.import(">E1G(H<P8@}R8V.M2J}B/K0\u0004)L8\u00041E)A.Pg\u00043A%P`_ \n&Ys_ \b}@4B;A/A3G8\u0019&Y"), objectArray);
        if (!a22) {
            ResourceVersionManageServiceImpl resourceVersionManageServiceImpl2 = a7;
            EngineVersion engineVersion = a;
            a52 = a7.const(engineVersion.getMajor(), a52 + n2);
            a62 = resourceVersionManageServiceImpl2.const(engineVersion.getMinor(), a62 + n3);
            n = resourceVersionManageServiceImpl2.const(a.getPatch(), n + n4);
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = a52;
            objectArray2[1] = a62;
            objectArray2[2] = n;
            logger.debug(VersionResource.import("M3G/A<W8@}R8V.M2J}F8G<Q.A}K;\u00043K}@4B;A/A3G8\u001e}J8\\)\u0019&Ys_ \n&Y"), objectArray2);
        }
        EngineVersion engineVersion = a;
        engineVersion.setMajor(a52);
        engineVersion.setMinor(a62);
        a.setPatch(n);
        logger.debug(VersionResource.import("V8B/A.L8@}R8V.M2J}K;\u0004)L8\u00043A%P}M3W8V)M2Jg\u00044J.A/P\u000bA/W4K3\u0019&Y"), (Object)a);
    }

    @Override
    public VersionResource get(Coordinates a, boolean a222) {
        VersionResource a222;
        ResourceVersionManageServiceImpl a3;
        logger.debug(VersionResource.import("C8PuG2K/@4J<P8W`_ \b}J2g2J)A3P`_ \r"), a, (Object)a222);
        if (((Coordinates)a).getType() == null || ((Coordinates)a).getName() == null || ((Coordinates)a).getLabel() == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        EngineResource engineResource2 = engineResource;
        Coordinates coordinates = a;
        engineResource.setType(coordinates.getType());
        engineResource2.setName(coordinates.getName());
        engineResource2.setLabel(((Coordinates)a).getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.volatile());
        Object object = resourceVersionManageServiceImpl.resourceMapper.selectResourceId(engineResource);
        if (object == null) {
            logger.debug(VersionResource.import("B<M1A9\u0004)K}C8Pq\u00043K}W(G5\u0004/A.K(V>Ag\u0004&Y"), a);
            return null;
        }
        if ((object = a3.static((Long)object, ((Coordinates)a).getMajor(), ((Coordinates)a).getMinor(), ((Coordinates)a).getPatch(), true)) == null) {
            logger.debug(VersionResource.import("3K}I<P>L8@}R8V.M2J}V8P/M8R8@g\u0004&Y"), a);
            return null;
        }
        a = null;
        if (!a222 && ((EngineVersion)((Object)object)).getContentId() != null) {
            EngineContent a222 = (EngineContent)a3.contentMapper.selectById(((EngineVersion)((Object)object)).getContentId());
            a = a222 != null ? a222.getData() : null;
        }
        VersionResource versionResource = a222 = new VersionResource();
        Object object2 = object;
        VersionResource versionResource2 = a222;
        VersionResource versionResource3 = a222;
        EngineResource engineResource3 = engineResource;
        a222.setType(engineResource3.getType());
        versionResource3.setName(engineResource3.getName());
        versionResource3.setLabel(engineResource.getLabel());
        versionResource2.setMajor(((EngineVersion)((Object)object)).getMajor());
        versionResource2.setMinor(((EngineVersion)((Object)object)).getMinor());
        a222.setPatch(((EngineVersion)((Object)object2)).getPatch());
        versionResource.setDescription(((EngineVersion)((Object)object2)).getDescription());
        versionResource.setContent((String)a);
        logger.debug(VersionResource.import("C2P}R8V.M2Jg\u0004&Y"), (Object)a222);
        return versionResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ EngineVersion short(EngineVersion a, EngineVersion a2, VersionStrategy a3, Integer a4, Integer a5, Integer a6) {
        int n;
        boolean bl = false;
        DataIntegrityViolationException dataIntegrityViolationException = null;
        NamedLockManagerService.Handle handle = null;
        int n2 = n = 0;
        while (n2 < 10) {
            try {
                ResourceVersionManageServiceImpl a7;
                if (!bl) {
                    handle = a7.throws(a2.getResourceId());
                }
                bl = false;
                EngineVersion engineVersion = a;
                a7.enum(a, a2, a3, a4, a5, a6);
                a7.tryInsertVersion(engineVersion);
                EngineVersion engineVersion2 = engineVersion;
                return engineVersion2;
            }
            catch (DataIntegrityViolationException dataIntegrityViolationException2) {
                bl = true;
                dataIntegrityViolationException = dataIntegrityViolationException2;
                if (n + 1 < 10) {
                    logger.debug(VersionResource.import("/A)V$\u0004+A/W4K3\u0004>E1G(H<P4K3\u0004<J9\u00044J.A/P4K3\u001e}P4I8W`_ \b}B<M1A9\u0019&Y"), (Object)n, (Object)a);
                }
            }
            finally {
                if (!bl && handle != null) {
                    handle.release();
                }
            }
            n2 = ++n;
        }
        if (handle != null) {
            handle.release();
        }
        VersioningException versioningException = new VersioningException(VersionResource.import("A%G8A9\u00040E%\u0004/A)V$\b}I<O8\u0004.Q/A}J2\u00043A.P8@}P/E3W<G)M2J}M.\u0004(W8@"), dataIntegrityViolationException);
        versioningException.coordinates().setMajor(a.getMajor());
        versioningException.coordinates().setMinor(a.getMinor());
        versioningException.coordinates().setPatch(a.getPatch());
        logger.debug(VersionResource.import(";E4H8@}P2\u00044J.A/P}R8V.M2Jg\u0004&Y"), (Object)a2);
        throw versioningException;
    }

    private /* synthetic */ String volatile() {
        return EngineTenantUtil.getTenantId();
    }

    @Override
    public List<Coordinates> listCoordinates(String a, String a2, String a3) {
        Coordinates coordinates;
        ResourceVersionManageServiceImpl a4;
        if (a2 == null && a3 == null) {
            return a4.listCoordinatesByType((String)a);
        }
        if (a2 == null) {
            return a4.listCoordinatesByTypeAndLabel((String)a, a3);
        }
        if (a3 == null) {
            return a4.listCoordinatesByTypeAndName((String)a, a2);
        }
        Coordinates coordinates2 = coordinates = new Coordinates();
        coordinates.setType((String)a);
        coordinates2.setName(a2);
        coordinates2.setLabel(a3);
        a = a4.get(coordinates2, true);
        if (a == null) {
            return Collections.emptyList();
        }
        Coordinates coordinates3 = coordinates;
        Object object = a;
        coordinates.setMajor(((VersionResource)object).getMajor());
        coordinates3.setMinor(((VersionResource)object).getMinor());
        coordinates3.setPatch(((VersionResource)a).getPatch());
        return Collections.singletonList(coordinates);
    }

    @Override
    public List<Coordinates> listCoordinatesByTypeAndLabel(String a, String a2) {
        ResourceVersionManageServiceImpl a3;
        if (a == null || a2 == null) {
            throw new NullPointerException();
        }
        logger.debug(VersionResource.import("1M.P\u001eK2V9M3E)A.f$p$T8e3@\u0011E?A1\f)]-A`_ \b}H<F8H`_ \r"), (Object)a, (Object)a2);
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        return resourceVersionManageServiceImpl.do(a3.resourceMapper.selectResourcesByTypeAndLabel(resourceVersionManageServiceImpl.volatile(), a, a2));
    }

    private /* synthetic */ Date transient() {
        return new Date();
    }

    private /* synthetic */ EngineVersion throws(Coordinates a) {
        ResourceVersionManageServiceImpl a2;
        if (a.getType() == null || a.getName() == null || a.getLabel() == null) {
            throw new NullPointerException();
        }
        Object object = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a2;
        EngineResource engineResource = object;
        Coordinates coordinates = a;
        ((EngineResource)object).setType(coordinates.getType());
        engineResource.setName(coordinates.getName());
        engineResource.setLabel(a.getLabel());
        ((EngineResource)object).setTenantId(resourceVersionManageServiceImpl.volatile());
        object = resourceVersionManageServiceImpl.resourceMapper.selectResourceId((EngineResource)object);
        if (object == null) {
            return null;
        }
        return a2.static((Long)object, a.getMajor(), a.getMinor(), a.getPatch(), true);
    }

    private /* synthetic */ EngineVersion implements(EngineVersion a, EngineVersion a2) {
        if (a2.getMajor() == null || a2.getMinor() == null || a2.getPatch() == null) {
            throw new NullPointerException();
        }
        NamedLockManagerService.Handle handle = null;
        try {
            ResourceVersionManageServiceImpl a3;
            ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
            handle = resourceVersionManageServiceImpl.throws(a2.getResourceId());
            EngineVersion engineVersion = a;
            EngineVersion engineVersion2 = a2;
            a.setMajor(engineVersion2.getMajor());
            engineVersion.setMinor(engineVersion2.getMinor());
            engineVersion.setPatch(a2.getPatch());
            resourceVersionManageServiceImpl.tryInsertVersion(engineVersion);
            EngineVersion engineVersion3 = a;
            return engineVersion3;
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            VersioningException versioningException = new VersioningException(VersionResource.import(">E3J2P}W<R8\u0004>K3B1M>P8@}R8V.M2J"), dataIntegrityViolationException);
            versioningException.coordinates().setMajor(a.getMajor());
            versioningException.coordinates().setMinor(a.getMinor());
            versioningException.coordinates().setPatch(a.getPatch());
            logger.debug(VersionResource.import(";E4H8@}P2\u00044J.A/P}R8V.M2Jg\u0004&Y"), (Object)a2);
            throw versioningException;
        }
        finally {
            if (handle != null) {
                handle.release();
            }
        }
    }

    @Autowired
    public ResourceVersionManageServiceImpl(NamedLockManagerService a, DynamicDatasourceService a2) {
        ResourceVersionManageServiceImpl a3;
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        resourceVersionManageServiceImpl.lockManager = a;
        resourceVersionManageServiceImpl.datasourceService = a2;
    }

    @Override
    public Coordinates copy(Coordinates a, VersionResource a2, VersionStrategy a3) {
        EngineVersion engineVersion;
        ResourceVersionManageServiceImpl a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a;
        objectArray[1] = a2;
        objectArray[2] = a3;
        logger.debug(VersionResource.import(">K-]uW2Q/G8\u0019&Yq\u00049A.P4J$\u0019&Yq\u0004.P/E)A:]`_ \r"), objectArray);
        EngineVersion engineVersion2 = a4.throws((Coordinates)a);
        if (engineVersion2 == null || engineVersion2.getContentId() == null) {
            logger.debug(VersionResource.import(";E4H8@}P2\u0004>K-]q\u00043K}W(G5\u0004.K(V>A}R8V.M2Jg\u0004&Y"), a);
            return null;
        }
        a = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a4;
        Object object = a;
        VersionResource versionResource = a2;
        ((EngineResource)a).setType(versionResource.getType());
        ((EngineResource)object).setName(versionResource.getName());
        ((EngineResource)object).setLabel(((VersionResource)a2).getLabel());
        ((EngineResource)a).setTenantId(resourceVersionManageServiceImpl.volatile());
        resourceVersionManageServiceImpl.ensureResourceExists((EngineResource)a);
        resourceVersionManageServiceImpl.contentMapper.increaseRefCountById(engineVersion2.getContentId());
        logger.debug(VersionResource.import("M3G/A<W8@}G2J)A3P}V8B}G2Q3Pg\u0004>K3P8J)m9\u0019&Y"), (Object)engineVersion2.getContentId());
        EngineVersion engineVersion3 = engineVersion = new EngineVersion();
        VersionResource versionResource2 = a2;
        EngineVersion engineVersion4 = engineVersion;
        engineVersion4.setResourceId(((EngineResource)a).getId());
        engineVersion4.setContentId(engineVersion2.getContentId());
        engineVersion.setMajor(versionResource2.getMajor());
        engineVersion3.setMinor(versionResource2.getMinor());
        engineVersion3.setPatch(((VersionResource)a2).getPatch());
        engineVersion.setDescription(((VersionResource)a2).getDescription() != null ? ((VersionResource)a2).getDescription() : engineVersion2.getDescription());
        engineVersion = a4.saveVersion(engineVersion, a3 != null ? a3 : VersionStrategy.EXACT);
        Object object2 = a2 = new Coordinates();
        EngineVersion engineVersion5 = engineVersion;
        Object object3 = a2;
        Object object4 = a;
        ((Coordinates)a2).setType(((EngineResource)object4).getType());
        ((Coordinates)object3).setName(((EngineResource)object4).getName());
        ((Coordinates)object3).setLabel(((EngineResource)a).getLabel());
        ((Coordinates)a2).setMajor(engineVersion5.getMajor());
        ((Coordinates)object2).setMinor(engineVersion5.getMinor());
        ((Coordinates)object2).setPatch(engineVersion.getPatch());
        logger.debug(VersionResource.import(">K-M8@}R8V.M2Jg\u0004&Y"), a2);
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void throws(EngineContent engineContent) {
        void a;
        ResourceVersionManageServiceImpl a2;
        DbType dbType = a2.catch();
        if (DbType.ORACLE.equals((Object)dbType) || DbType.OSCAR.equals((Object)dbType) || DbType.POSTGRE_SQL.equals((Object)dbType)) {
            a.setId(a2.contentMapper.getKeyGenerator(VersionResource.import(">K3P8J){4@"), dbType.getDb()));
            a2.contentMapper.insertNew((EngineContent)a);
            return;
        }
        a2.contentMapper.insert(a);
    }

    private /* synthetic */ NamedLockManagerService.Handle throws(long a) {
        ResourceVersionManageServiceImpl a2;
        return a2.lockManager.acquire(LOCK_TYPE_VERSION_INSERTION, String.valueOf(a), true);
    }

    public void tryInsertVersion(EngineVersion a) {
        ResourceVersionManageServiceImpl a2;
        DbType dbType = a2.catch();
        if (DbType.ORACLE.equals((Object)dbType) || DbType.OSCAR.equals((Object)dbType) || DbType.POSTGRE_SQL.equals((Object)dbType)) {
            a.setId(a2.contentMapper.getKeyGenerator(VersionResource.import("+A/W4K3{4@"), dbType.getDb()));
            a2.versionMapper.insertNew(a);
            return;
        }
        a2.versionMapper.insert((Object)a);
        logger.debug(VersionResource.import("4J.A/P8@}R8V.M2Jg\u0004&Y"), (Object)a);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ EngineVersion static(long a, Integer a2, Integer a3, Integer a4, boolean a5) {
        void var7_15;
        List<EngineVersion> list;
        Integer n;
        int n2;
        if (a2 != null) {
            n2 = 4;
            n = a3;
        } else {
            n2 = 0;
            n = a3;
        }
        int n3 = n2 | (n != null ? 2 : 0) | (a4 != null ? 1 : 0);
        Page page = new Page(1L, 1L, false);
        switch (n3) {
            case 0: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list2;
                list = list2 = a6.versionMapper.selectVersions((Page<EngineVersion>)page, a, a5);
                break;
            }
            case 4: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list3 = a6.versionMapper.selectVersionsMatchMajor((Page<EngineVersion>)page, a, a2, a5);
                list = list3;
                break;
            }
            case 2: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list4 = a6.versionMapper.selectVersionsMatchMinor((Page<EngineVersion>)page, a, a3, a5);
                list = list4;
                break;
            }
            case 1: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list5 = a6.versionMapper.selectVersionsMatchPatch((Page<EngineVersion>)page, a, a4, a5);
                list = list5;
                break;
            }
            case 6: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list6 = a6.versionMapper.selectVersionsMatchMajorAndMinor((Page<EngineVersion>)page, a, a2, a3, a5);
                list = list6;
                break;
            }
            case 5: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list7 = a6.versionMapper.selectVersionsMatchMajorAndPatch((Page<EngineVersion>)page, a, a2, a4, a5);
                list = list7;
                break;
            }
            case 3: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list8 = a6.versionMapper.selectVersionsMatchMinorAndPatch((Page<EngineVersion>)page, a, a3, a4, a5);
                list = list8;
                break;
            }
            default: {
                ResourceVersionManageServiceImpl a6;
                return a6.versionMapper.selectExactVersion(a, a2, a3, a4, a5);
            }
        }
        if (list == null || var7_15.size() == 0) {
            return null;
        }
        if (var7_15.size() > 1) {
            throw new TooManyResultsException(VersionResource.import("T<C4J<P4K3\u00043K)\u0004*K/O8@"));
        }
        EngineVersion engineVersion = (EngineVersion)((Object)var7_15.get(0));
        Object[] objectArray = new Object[6];
        objectArray[0] = a;
        objectArray[1] = a2;
        objectArray[2] = a3;
        objectArray[3] = a4;
        objectArray[4] = a5;
        objectArray[5] = engineVersion;
        logger.debug(VersionResource.import("/A)V4A+A9\u00041E)A.P}R8V.M2Jg\u0004/A.K(V>A\u0014@`_ \b}R8V.M2J`_ \n&Ys_ \b}J2V0E1\u0019&Yq\u0004/K*\u0019&Y"), objectArray);
        return engineVersion;
    }

    private /* synthetic */ List<Coordinates> do(List<EngineResource> a) {
        ArrayList<Coordinates> arrayList = new ArrayList<Coordinates>();
        Object object = a = a.iterator();
        while (object.hasNext()) {
            ResourceVersionManageServiceImpl a2;
            EngineResource engineResource = (EngineResource)a.next();
            EngineVersion engineVersion = a2.static(engineResource.getId(), null, null, null, true);
            if (engineVersion == null) {
                object = a;
                continue;
            }
            Coordinates coordinates = new Coordinates();
            object = a;
            Coordinates coordinates2 = coordinates;
            EngineVersion engineVersion2 = engineVersion;
            Coordinates coordinates3 = coordinates;
            EngineResource engineResource2 = engineResource;
            coordinates.setType(engineResource2.getType());
            coordinates3.setName(engineResource2.getName());
            coordinates3.setLabel(engineResource.getLabel());
            coordinates.setMajor(engineVersion2.getMajor());
            coordinates2.setMinor(engineVersion2.getMinor());
            coordinates2.setPatch(engineVersion.getPatch());
            arrayList.add(coordinates2);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EngineVersion saveVersion(EngineVersion a, VersionStrategy a2) {
        ResourceVersionManageServiceImpl a3;
        EngineVersion engineVersion;
        if (a.getResourceId() == null) {
            throw new NullPointerException();
        }
        EngineVersion engineVersion2 = engineVersion = new EngineVersion();
        EngineVersion engineVersion3 = engineVersion;
        EngineVersion engineVersion4 = engineVersion;
        EngineVersion engineVersion5 = a;
        engineVersion.setResourceId(engineVersion5.getResourceId());
        engineVersion4.setContentId(engineVersion5.getContentId());
        engineVersion4.setDescription(a.getDescription());
        engineVersion3.setDataStatus(VersionResource.import("\u0014"));
        engineVersion3.setCreator(a3.interface());
        engineVersion2.setCreateTime(LocalDateTime.now());
        engineVersion2.setLastEditor(a3.interface());
        engineVersion2.setLastTime(LocalDateTime.now());
        boolean bl = false;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        switch (a2) {
            case MAJOR: {
                if (a.getMajor() == null && a.getMinor() == null && a.getPatch() == null) break;
                Object[] objectArray = new Object[7];
                objectArray[0] = a2;
                objectArray[1] = a.getMajor();
                objectArray[2] = a.getMinor();
                objectArray[3] = a.getPatch();
                objectArray[4] = n;
                objectArray[5] = n2;
                objectArray[6] = n3;
                logger.warn(VersionResource.import("?E9\u0004.E+A}W)V<P8C$\u0004<V:Q0A3P.\u001e}W)V<P8C$\u0019&Yq\u00044J-Q)r8V.M2J`_ \n&Ys_ \u0004`\u001a}U(A/]\u000bA/W4K3\u0019&Ys_ \n&Y"), objectArray);
                break;
            }
            case MINOR: {
                EngineVersion engineVersion6 = a;
                n = engineVersion6.getMajor();
                if (engineVersion6.getMinor() == null && a.getPatch() == null) break;
                Object[] objectArray = new Object[7];
                objectArray[0] = a2;
                objectArray[1] = a.getMajor();
                objectArray[2] = a.getMinor();
                objectArray[3] = a.getPatch();
                objectArray[4] = n;
                objectArray[5] = n2;
                objectArray[6] = n3;
                logger.warn(VersionResource.import("?E9\u0004.E+A}W)V<P8C$\u0004<V:Q0A3P.\u001e}W)V<P8C$\u0019&Yq\u00044J-Q)r8V.M2J`_ \n&Ys_ \u0004`\u001a}U(A/]\u000bA/W4K3\u0019&Ys_ \n&Y"), objectArray);
                break;
            }
            case PATCH: {
                EngineVersion engineVersion7 = a;
                n = engineVersion7.getMajor();
                Integer n4 = n2 = engineVersion7.getMajor() != null ? a.getMinor() : null;
                if ((a.getMajor() != null || a.getMinor() == null) && a.getPatch() == null) break;
                Object[] objectArray = new Object[7];
                objectArray[0] = a2;
                objectArray[1] = a.getMajor();
                objectArray[2] = a.getMinor();
                objectArray[3] = a.getPatch();
                objectArray[4] = n;
                objectArray[5] = n2;
                objectArray[6] = n3;
                logger.warn(VersionResource.import("?E9\u0004.E+A}W)V<P8C$\u0004<V:Q0A3P.\u001e}W)V<P8C$\u0019&Yq\u00044J-Q)r8V.M2J`_ \n&Ys_ \u0004`\u001a}U(A/]\u000bA/W4K3\u0019&Ys_ \n&Y"), objectArray);
                break;
            }
            case EXACT: {
                bl = true;
                if (a.getMajor() != null && a.getMinor() != null && a.getPatch() != null) break;
                Object[] objectArray = new Object[4];
                objectArray[0] = a2;
                objectArray[1] = a.getMajor();
                objectArray[2] = a.getMinor();
                objectArray[3] = a.getPatch();
                logger.warn(VersionResource.import("F<@}W<R8\u0004.P/E)A:]}E/C(I8J)Wg\u0004.P/E)A:]`_ \b}M3T(P\u000bA/W4K3\u0019&Ys_ \n&Y"), objectArray);
                break;
            }
            default: {
                throw new UnsupportedOperationException(new StringBuilder().insert(0, VersionResource.import("Q3W(T-K/P8@}W<R8\u0004.P/E)A:]g\u0004")).append((Object)a2).toString());
            }
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = bl;
        objectArray[1] = n;
        objectArray[2] = n2;
        objectArray[3] = n3;
        logger.debug(VersionResource.import(">E1G(H<P8@}R8V.M2J}M3W8V)M2J}T1E3\u001e}M.a%E>P\u000eP/E)A:]`_ \b}U(A/]\u000bA/W4K3\u0019&Ys_ \n&Y"), objectArray);
        if (bl) {
            return a3.implements(engineVersion, a);
        }
        return a3.short(engineVersion, a, a2, n, n2, n3);
    }
}

