/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine.rvm.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.engine.common.util.EngineTenantUtil;
import com.jxdinfo.hussar.engine.rvm.dao.RvmContentMapper;
import com.jxdinfo.hussar.engine.rvm.dao.RvmResourceMapper;
import com.jxdinfo.hussar.engine.rvm.dao.RvmVersionMapper;
import com.jxdinfo.hussar.engine.rvm.model.Coordinates;
import com.jxdinfo.hussar.engine.rvm.model.EngineContent;
import com.jxdinfo.hussar.engine.rvm.model.EngineResource;
import com.jxdinfo.hussar.engine.rvm.model.EngineVersion;
import com.jxdinfo.hussar.engine.rvm.model.VersionResource;
import com.jxdinfo.hussar.engine.rvm.model.VersionStrategy;
import com.jxdinfo.hussar.engine.rvm.service.NamedLockManagerService;
import com.jxdinfo.hussar.engine.rvm.service.ResourceVersionManageService;
import com.jxdinfo.hussar.engine.rvm.util.VersioningException;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@HussarDs(value="master")
public class ResourceVersionManageServiceImpl
implements ResourceVersionManageService {
    private final NamedLockManagerService lockManager;
    private static final int MAX_SAVE_RETRY = 10;
    private final RvmResourceMapper resourceMapper;
    private static final String LOCK_TYPE_VERSION_INSERTION = "ver";
    private static final Logger logger = LoggerFactory.getLogger(ResourceVersionManageServiceImpl.class);
    private final RvmVersionMapper versionMapper;
    private final RvmContentMapper contentMapper;

    private /* synthetic */ int boolean(Integer a, int a2) {
        if (a == null) {
            return a2;
        }
        return Integer.max(a, a2);
    }

    private /* synthetic */ Date boolean() {
        return new Date();
    }

    @Override
    public List<Coordinates> listCoordinatesByTypeAndLabel(String a, String a2) {
        ResourceVersionManageServiceImpl a3;
        if (a == null || a2 == null) {
            throw new NullPointerException();
        }
        logger.debug(VersionResource.byte("S-L0|+P6[-Q%K!L\u0006F\u0010F4Z\u0005Q s%]!SlK=O!\u0002?Bh\u001f(^&Z(\u0002?Bm"), (Object)a, (Object)a2);
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        return resourceVersionManageServiceImpl.boolean(a3.resourceMapper.selectResourcesByTypeAndLabel(resourceVersionManageServiceImpl.boolean(), a, a2));
    }

    private /* synthetic */ NamedLockManagerService.Handle boolean(long a) {
        ResourceVersionManageServiceImpl a2;
        return a2.lockManager.acquire(LOCK_TYPE_VERSION_INSERTION, String.valueOf(a), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ EngineVersion boolean(EngineVersion a, EngineVersion a2, VersionStrategy a3, Integer a4, Integer a5, Integer a6) {
        int n;
        boolean bl = false;
        DataIntegrityViolationException dataIntegrityViolationException = null;
        NamedLockManagerService.Handle handle = null;
        int n2 = n = 0;
        while (n2 < 10) {
            try {
                ResourceVersionManageServiceImpl a7;
                if (!bl) {
                    handle = a7.boolean(a2.getResourceId());
                }
                bl = false;
                EngineVersion engineVersion = a;
                a7.boolean(a, a2, a3, a4, a5, a6);
                a7.tryInsertVersion(engineVersion);
                EngineVersion engineVersion2 = engineVersion;
                return engineVersion2;
            }
            catch (DataIntegrityViolationException dataIntegrityViolationException2) {
                bl = true;
                dataIntegrityViolationException = dataIntegrityViolationException2;
                if (n + 1 < 10) {
                    logger.debug(VersionResource.byte("M!K6FdI!M7V+Qd\\%S'J(^0V+Qd^*[dV*L!M0V+Q~\u001f0V)Z7\u0002?Bh\u001f\"^-S![yD9"), (Object)n, (Object)a);
                }
            }
            finally {
                if (!bl && handle != null) {
                    handle.release();
                }
            }
            n2 = ++n;
        }
        if (handle != null) {
            handle.release();
        }
        VersioningException versioningException = new VersioningException(VersionResource.byte("!G'Z![dR%GdM!K6Fh\u001f)^/ZdL1M!\u001f*PdQ!L0Z \u001f0M%Q7^'K-P*\u001f-LdJ7Z "), dataIntegrityViolationException);
        versioningException.coordinates().setMajor(a.getMajor());
        versioningException.coordinates().setMinor(a.getMinor());
        versioningException.coordinates().setPatch(a.getPatch());
        logger.debug(VersionResource.byte("Y%V(Z \u001f0PdV*L!M0\u001f2Z6L-P*\u0005dD9"), (Object)a2);
        throw versioningException;
    }

    @Override
    public VersionResource get(Coordinates a, boolean a222) {
        VersionResource a222;
        ResourceVersionManageServiceImpl a3;
        logger.debug(VersionResource.byte("#Z0\u0017'P+M V*^0Z7\u0002?Bh\u001f*P\u0007P*K!Q0\u0002?Bm"), a, (Object)a222);
        if (((Coordinates)a).getType() == null || ((Coordinates)a).getName() == null || ((Coordinates)a).getLabel() == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        EngineResource engineResource2 = engineResource;
        Coordinates coordinates = a;
        engineResource.setType(coordinates.getType());
        engineResource2.setName(coordinates.getName());
        engineResource2.setLabel(((Coordinates)a).getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.boolean());
        Object object = resourceVersionManageServiceImpl.resourceMapper.selectResourceId(engineResource);
        if (object == null) {
            logger.debug(VersionResource.byte("\"^-S![dK+\u001f#Z0\u0013dQ+\u001f7J'WdM!L+J6\\!\u0005dD9"), a);
            return null;
        }
        if ((object = a3.boolean((Long)object, ((Coordinates)a).getMajor(), ((Coordinates)a).getMinor(), ((Coordinates)a).getPatch(), true)) == null) {
            logger.debug(VersionResource.byte("Q+\u001f)^0\\,Z \u001f2Z6L-P*\u001f6Z0M-Z2Z \u0005dD9"), a);
            return null;
        }
        a = null;
        if (!a222 && ((EngineVersion)((Object)object)).getContentId() != null) {
            EngineContent a222 = (EngineContent)a3.contentMapper.selectById(((EngineVersion)((Object)object)).getContentId());
            a = a222 != null ? a222.getData() : null;
        }
        VersionResource versionResource = a222 = new VersionResource();
        Object object2 = object;
        VersionResource versionResource2 = a222;
        VersionResource versionResource3 = a222;
        EngineResource engineResource3 = engineResource;
        a222.setType(engineResource3.getType());
        versionResource3.setName(engineResource3.getName());
        versionResource3.setLabel(engineResource.getLabel());
        versionResource2.setMajor(((EngineVersion)((Object)object)).getMajor());
        versionResource2.setMinor(((EngineVersion)((Object)object)).getMinor());
        a222.setPatch(((EngineVersion)((Object)object2)).getPatch());
        versionResource.setDescription(((EngineVersion)((Object)object2)).getDescription());
        versionResource.setContent((String)a);
        logger.debug(VersionResource.byte("#P0\u001f2Z6L-P*\u0005dD9"), (Object)a222);
        return versionResource;
    }

    private /* synthetic */ Long boolean() {
        return EngineTenantUtil.getUserId();
    }

    @Override
    public List<Coordinates> listCoordinatesByTypeAndName(String a, String a2) {
        ResourceVersionManageServiceImpl a3;
        if (a == null || a2 == null) {
            throw new NullPointerException();
        }
        logger.debug(VersionResource.byte("(V7K\u0007P+M V*^0Z7}=k=O!~*[\b^&Z(\u00170F4ZyD9\u0013dQ%R!\u0002?Bm"), (Object)a, (Object)a2);
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        return resourceVersionManageServiceImpl.boolean(a3.resourceMapper.selectResourcesByTypeAndName(resourceVersionManageServiceImpl.boolean(), a, a2));
    }

    private /* synthetic */ String boolean() {
        return EngineTenantUtil.getTenantId();
    }

    private /* synthetic */ EngineVersion boolean(EngineVersion a, EngineVersion a2) {
        if (a2.getMajor() == null || a2.getMinor() == null || a2.getPatch() == null) {
            throw new NullPointerException();
        }
        NamedLockManagerService.Handle handle = null;
        try {
            ResourceVersionManageServiceImpl a3;
            ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
            handle = resourceVersionManageServiceImpl.boolean(a2.getResourceId());
            EngineVersion engineVersion = a;
            EngineVersion engineVersion2 = a2;
            a.setMajor(engineVersion2.getMajor());
            engineVersion.setMinor(engineVersion2.getMinor());
            engineVersion.setPatch(a2.getPatch());
            resourceVersionManageServiceImpl.tryInsertVersion(engineVersion);
            EngineVersion engineVersion3 = a;
            return engineVersion3;
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            VersioningException versioningException = new VersioningException(VersionResource.byte("\\%Q*P0\u001f7^2Zd\\+Q\"S-\\0Z \u001f2Z6L-P*"), dataIntegrityViolationException);
            versioningException.coordinates().setMajor(a.getMajor());
            versioningException.coordinates().setMinor(a.getMinor());
            versioningException.coordinates().setPatch(a.getPatch());
            logger.debug(VersionResource.byte("Y%V(Z \u001f0PdV*L!M0\u001f2Z6L-P*\u0005dD9"), (Object)a2);
            throw versioningException;
        }
        finally {
            if (handle != null) {
                handle.release();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ List<EngineVersion> boolean(long a, Integer a2, Integer a3, Integer a4, boolean a5) {
        List<EngineVersion> list;
        Integer n;
        int n2;
        if (a2 != null) {
            n2 = 4;
            n = a3;
        } else {
            n2 = 0;
            n = a3;
        }
        switch (n2 | (n != null ? 2 : 0) | (a4 != null ? 1 : 0)) {
            case 0: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersions(null, a, a5);
                break;
            }
            case 4: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMajor(null, a, a2, a5);
                break;
            }
            case 2: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMinor(null, a, a3, a5);
                break;
            }
            case 1: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchPatch(null, a, a4, a5);
                break;
            }
            case 6: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMajorAndMinor(null, a, a2, a3, a5);
                break;
            }
            case 5: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMajorAndPatch(null, a, a2, a4, a5);
                break;
            }
            case 3: {
                ResourceVersionManageServiceImpl a6;
                list = a6.versionMapper.selectVersionsMatchMinorAndPatch(null, a, a3, a4, a5);
                break;
            }
            default: {
                ResourceVersionManageServiceImpl a6;
                return Optional.ofNullable(a6.versionMapper.selectExactVersion(a, a2, a3, a4, a5)).map(Collections::singletonList).orElse(Collections.emptyList());
            }
        }
        Object[] objectArray = new Object[6];
        objectArray[0] = a;
        objectArray[1] = a2;
        objectArray[2] = a3;
        objectArray[3] = a4;
        objectArray[4] = a5;
        objectArray[5] = list;
        logger.debug(VersionResource.byte("6Z0M-Z2Z \u001f2Z6L-P*\u001f(V7K~\u001f6Z7P1M'Z\r[yD9\u0013dI!M7V+QyD9\u0011?BjD9\u0013dQ+M)^(\u0002?Bh\u001f6P3LyD9"), objectArray);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public List<Coordinates> deleteAll(Coordinates a) {
        Object object;
        ResourceVersionManageServiceImpl a2;
        logger.debug(VersionResource.byte(" Z(Z0Z\u0005S(\u0017'P+M V*^0Z7\u0002?Bm"), (Object)a);
        if (((Coordinates)((Object)a)).getType() == null || ((Coordinates)((Object)a)).getName() == null || ((Coordinates)((Object)a)).getLabel() == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a2;
        EngineResource engineResource2 = engineResource;
        Coordinates coordinates = a;
        engineResource.setType(coordinates.getType());
        engineResource2.setName(coordinates.getName());
        engineResource2.setLabel(((Coordinates)((Object)a)).getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.boolean());
        Object object2 = resourceVersionManageServiceImpl.resourceMapper.selectResourceId(engineResource);
        if (object2 == null) {
            logger.debug(VersionResource.byte("Y%V(Z \u001f0Pd[!S!K!\u0013dQ+\u001f7J'WdM!L+J6\\!\u0005dD9"), (Object)a);
            return null;
        }
        if ((object2 = a2.boolean((Long)object2, ((Coordinates)((Object)a)).getMajor(), ((Coordinates)((Object)a)).getMinor(), ((Coordinates)((Object)a)).getPatch(), true)) == null || object2.size() == 0) {
            logger.debug(VersionResource.byte("Q+\u001f)^0\\,Z \u001f2Z6L-P*\u001f6Z0M-Z2Z \u0005dD9"), (Object)a);
            return new ArrayList<Coordinates>();
        }
        ArrayList<Coordinates> arrayList = a = object2.iterator();
        while (arrayList.hasNext()) {
            object = (EngineVersion)((Object)a.next());
            arrayList = a;
            a2.versionMapper.updateDataStatusById(((EngineVersion)((Object)object)).getId(), 1, String.valueOf(a2.boolean()), a2.boolean());
        }
        a = new ArrayList<Coordinates>();
        object = object2.iterator();
        Object object3 = object;
        while (object3.hasNext()) {
            object2 = (EngineVersion)((Object)object.next());
            Coordinates coordinates2 = new Coordinates();
            object3 = object;
            Coordinates coordinates3 = coordinates2;
            Object object4 = object2;
            Coordinates coordinates4 = coordinates2;
            EngineResource engineResource3 = engineResource;
            coordinates2.setType(engineResource3.getType());
            coordinates4.setName(engineResource3.getName());
            coordinates4.setLabel(engineResource.getLabel());
            coordinates2.setMajor(((EngineVersion)((Object)object4)).getMajor());
            coordinates3.setMinor(((EngineVersion)((Object)object4)).getMinor());
            coordinates3.setPatch(((EngineVersion)((Object)object2)).getPatch());
            a.add(coordinates3);
        }
        logger.debug(VersionResource.byte("[!S!K![dI!M7V+QdS-L0\u0005dD9"), a);
        return a;
    }

    @Override
    public Coordinates copy(Coordinates a, VersionResource a2, VersionStrategy a3) {
        EngineVersion engineVersion;
        ResourceVersionManageServiceImpl a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a;
        objectArray[1] = a2;
        objectArray[2] = a3;
        logger.debug(VersionResource.byte("\\+O=\u00177P1M'ZyD9\u0013d[!L0V*FyD9\u0013dL0M%K!X=\u0002?Bm"), objectArray);
        EngineVersion engineVersion2 = a4.boolean((Coordinates)a);
        if (engineVersion2 == null || engineVersion2.getContentId() == null) {
            logger.debug(VersionResource.byte("Y%V(Z \u001f0Pd\\+O=\u0013dQ+\u001f7J'WdL+J6\\!\u001f2Z6L-P*\u0005dD9"), a);
            return null;
        }
        a = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a4;
        Object object = a;
        VersionResource versionResource = a2;
        ((EngineResource)a).setType(versionResource.getType());
        ((EngineResource)object).setName(versionResource.getName());
        ((EngineResource)object).setLabel(((VersionResource)a2).getLabel());
        ((EngineResource)a).setTenantId(resourceVersionManageServiceImpl.boolean());
        resourceVersionManageServiceImpl.ensureResourceExists((EngineResource)a);
        resourceVersionManageServiceImpl.contentMapper.increaseRefCountById(engineVersion2.getContentId());
        logger.debug(VersionResource.byte("-Q'M!^7Z \u001f'P*K!Q0\u001f6Z\"\u001f'P1Q0\u0005d\\+Q0Z*K\r[yD9"), (Object)engineVersion2.getContentId());
        EngineVersion engineVersion3 = engineVersion = new EngineVersion();
        VersionResource versionResource2 = a2;
        EngineVersion engineVersion4 = engineVersion;
        engineVersion4.setResourceId(((EngineResource)a).getId());
        engineVersion4.setContentId(engineVersion2.getContentId());
        engineVersion.setMajor(versionResource2.getMajor());
        engineVersion3.setMinor(versionResource2.getMinor());
        engineVersion3.setPatch(((VersionResource)a2).getPatch());
        engineVersion.setDescription(((VersionResource)a2).getDescription() != null ? ((VersionResource)a2).getDescription() : engineVersion2.getDescription());
        engineVersion = a4.saveVersion(engineVersion, a3 != null ? a3 : VersionStrategy.EXACT);
        Object object2 = a2 = new Coordinates();
        EngineVersion engineVersion5 = engineVersion;
        Object object3 = a2;
        Object object4 = a;
        ((Coordinates)a2).setType(((EngineResource)object4).getType());
        ((Coordinates)object3).setName(((EngineResource)object4).getName());
        ((Coordinates)object3).setLabel(((EngineResource)a).getLabel());
        ((Coordinates)a2).setMajor(engineVersion5.getMajor());
        ((Coordinates)object2).setMinor(engineVersion5.getMinor());
        ((Coordinates)object2).setPatch(engineVersion.getPatch());
        logger.debug(VersionResource.byte("\\+O-Z \u001f2Z6L-P*\u0005dD9"), a2);
        return object2;
    }

    @Override
    public List<Coordinates> listCoordinatesByType(String a) {
        ResourceVersionManageServiceImpl a2;
        if (a == null) {
            throw new NullPointerException();
        }
        logger.debug(VersionResource.byte("S-L0|+P6[-Q%K!L\u0006F\u0010F4ZlK=O!\u0002?Bm"), (Object)a);
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a2;
        return resourceVersionManageServiceImpl.boolean(a2.resourceMapper.selectResourcesByType(resourceVersionManageServiceImpl.boolean(), a));
    }

    /*
     * WARNING - void declaration
     */
    public void tryInsertVersion(EngineVersion engineVersion) {
        void a;
        ResourceVersionManageServiceImpl a2;
        a2.versionMapper.insert(a);
        logger.debug(VersionResource.byte("V*L!M0Z \u001f2Z6L-P*\u0005dD9"), (Object)a);
    }

    private /* synthetic */ EngineVersion boolean(Coordinates a) {
        ResourceVersionManageServiceImpl a2;
        if (a.getType() == null || a.getName() == null || a.getLabel() == null) {
            throw new NullPointerException();
        }
        Object object = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a2;
        EngineResource engineResource = object;
        Coordinates coordinates = a;
        ((EngineResource)object).setType(coordinates.getType());
        engineResource.setName(coordinates.getName());
        engineResource.setLabel(a.getLabel());
        ((EngineResource)object).setTenantId(resourceVersionManageServiceImpl.boolean());
        object = resourceVersionManageServiceImpl.resourceMapper.selectResourceId((EngineResource)object);
        if (object == null) {
            return null;
        }
        return a2.boolean((Long)object, a.getMajor(), a.getMinor(), a.getPatch(), true);
    }

    private /* synthetic */ boolean boolean(Integer a, int a2) {
        return a == null || a < a2;
    }

    private /* synthetic */ List<Coordinates> boolean(List<EngineResource> a) {
        ArrayList<Coordinates> arrayList = new ArrayList<Coordinates>();
        Object object = a = a.iterator();
        while (object.hasNext()) {
            ResourceVersionManageServiceImpl a2;
            EngineResource engineResource = (EngineResource)a.next();
            EngineVersion engineVersion = a2.boolean(engineResource.getId(), null, null, null, true);
            if (engineVersion == null) {
                object = a;
                continue;
            }
            Coordinates coordinates = new Coordinates();
            object = a;
            Coordinates coordinates2 = coordinates;
            EngineVersion engineVersion2 = engineVersion;
            Coordinates coordinates3 = coordinates;
            EngineResource engineResource2 = engineResource;
            coordinates.setType(engineResource2.getType());
            coordinates3.setName(engineResource2.getName());
            coordinates3.setLabel(engineResource.getLabel());
            coordinates.setMajor(engineVersion2.getMajor());
            coordinates2.setMinor(engineVersion2.getMinor());
            coordinates2.setPatch(engineVersion.getPatch());
            arrayList.add(coordinates2);
        }
        return arrayList;
    }

    public void trySaveResource(EngineResource a) {
        ResourceVersionManageServiceImpl a2;
        a2.resourceMapper.insert(a);
        logger.debug(VersionResource.byte("6Z7P1M'ZdV*L!M0Z \u0005dD9"), (Object)a);
    }

    @Override
    public Coordinates save(VersionResource a, VersionStrategy a2) {
        EngineVersion engineVersion;
        ResourceVersionManageServiceImpl a3;
        logger.debug(VersionResource.byte("L%I!\u00176Z7P1M'ZyD9\u0013dL0M%K!X=\u0002?Bm"), a, a2);
        if (a == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        EngineResource engineResource2 = engineResource;
        VersionResource versionResource = a;
        engineResource.setType(versionResource.getType());
        engineResource2.setName(versionResource.getName());
        engineResource2.setLabel(((VersionResource)a).getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.boolean());
        resourceVersionManageServiceImpl.ensureResourceExists(engineResource);
        EngineVersion engineVersion2 = engineVersion = new EngineVersion();
        VersionResource versionResource2 = a;
        EngineVersion engineVersion3 = engineVersion;
        engineVersion.setResourceId(engineResource.getId());
        engineVersion3.setMajor(((VersionResource)a).getMajor());
        engineVersion3.setMinor(((VersionResource)a).getMinor());
        engineVersion.setPatch(versionResource2.getPatch());
        engineVersion2.setDescription(versionResource2.getDescription());
        engineVersion = resourceVersionManageServiceImpl.saveVersion(engineVersion2, (VersionStrategy)((Object)(a2 != null ? a2 : VersionStrategy.EXACT)));
        Object object = a2 = new EngineContent();
        ((EngineContent)object).setRefCount(1L);
        ((EngineContent)object).setData(((VersionResource)a).getContent());
        a3.contentMapper.insert(a2);
        logger.debug(VersionResource.byte("V*L!M0Z \u001f'P*K!Q0\u0005dD9"), a2);
        a3.versionMapper.updateContentById(engineVersion.getId(), ((EngineContent)a2).getId());
        logger.debug(VersionResource.byte("J4[%K![dI!M7V+QdM!S%K![d\\+Q0Z*KdV \u0005dD9"), (Object)engineVersion.getId());
        Object object2 = a = new Coordinates();
        EngineVersion engineVersion4 = engineVersion;
        Object object3 = a;
        EngineResource engineResource3 = engineResource;
        ((Coordinates)a).setType(engineResource3.getType());
        ((Coordinates)object3).setName(engineResource3.getName());
        ((Coordinates)object3).setLabel(engineResource.getLabel());
        ((Coordinates)a).setMajor(engineVersion4.getMajor());
        ((Coordinates)object2).setMinor(engineVersion4.getMinor());
        ((Coordinates)object2).setPatch(engineVersion.getPatch());
        logger.debug(VersionResource.byte("7^2Z \u001f2Z6L-P*\u0005dD9"), a);
        return a;
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ void boolean(EngineVersion a, EngineVersion a22, VersionStrategy a3, Integer a4, Integer a52, Integer a62) {
        int n;
        int a62;
        int a52;
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl;
        ResourceVersionManageServiceImpl a7;
        a4 = a7.boolean(a22.getResourceId(), (Integer)a4, a52, a62, false);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (a3) {
            case MAJOR: {
                n2 = 1;
                if (a4 != null) {
                    resourceVersionManageServiceImpl = a7;
                    a52 = ((EngineVersion)((Object)a4)).getMajor() + n2;
                    a62 = 0;
                    n = 0;
                    break;
                }
                a52 = 1;
                a62 = 0;
                n = 0;
                resourceVersionManageServiceImpl = a7;
                break;
            }
            case MINOR: {
                n3 = 1;
                if (a4 != null) {
                    resourceVersionManageServiceImpl = a7;
                    Object object = a4;
                    a52 = ((EngineVersion)((Object)object)).getMajor();
                    a62 = ((EngineVersion)((Object)object)).getMinor() + n3;
                    n = 0;
                    break;
                }
                if (a22.getMajor() != null) {
                    resourceVersionManageServiceImpl = a7;
                    a52 = a22.getMajor();
                    a62 = 1;
                    n = 0;
                    break;
                }
                a52 = 0;
                a62 = 1;
                n = 0;
                resourceVersionManageServiceImpl = a7;
                break;
            }
            case PATCH: {
                n4 = 1;
                if (a4 != null) {
                    resourceVersionManageServiceImpl = a7;
                    Object object = a4;
                    a52 = ((EngineVersion)((Object)object)).getMajor();
                    a62 = ((EngineVersion)((Object)object)).getMinor();
                    n = ((EngineVersion)((Object)object)).getPatch() + n4;
                    break;
                }
                if (a22.getMajor() != null && a22.getMinor() != null) {
                    resourceVersionManageServiceImpl = a7;
                    EngineVersion engineVersion = a22;
                    a52 = engineVersion.getMajor();
                    a62 = engineVersion.getMinor();
                    n = 1;
                    break;
                }
                if (a22.getMajor() != null) {
                    resourceVersionManageServiceImpl = a7;
                    a52 = a22.getMajor();
                    a62 = 0;
                    n = 1;
                    break;
                }
                a52 = 0;
                a62 = 0;
                n = 1;
                resourceVersionManageServiceImpl = a7;
                break;
            }
            default: {
                throw new UnsupportedOperationException(new StringBuilder().insert(0, VersionResource.byte("J*Z<O!\\0Z \u001f7K6^0Z#Fd")).append((Object)a3).toString());
            }
        }
        boolean a22 = resourceVersionManageServiceImpl.boolean(a.getMajor(), a52) || a7.boolean(a.getMinor(), a62) || a7.boolean(a.getPatch(), n);
        Object[] objectArray = new Object[4];
        objectArray[0] = a52;
        objectArray[1] = a62;
        objectArray[2] = n;
        objectArray[3] = a22;
        logger.debug(VersionResource.byte("\\%S'J(^0Z \u001f2Z6L-P*\u001f\"M+RdK,ZdS%K!L0\u0005dQ!G0\u0002?BjD9\u0011?Bh\u001f V\"Y!M!Q'ZyD9"), objectArray);
        if (!a22) {
            ResourceVersionManageServiceImpl resourceVersionManageServiceImpl2 = a7;
            EngineVersion engineVersion = a;
            a52 = a7.boolean(engineVersion.getMajor(), a52 + n2);
            a62 = resourceVersionManageServiceImpl2.boolean(engineVersion.getMinor(), a62 + n3);
            n = resourceVersionManageServiceImpl2.boolean(a.getPatch(), n + n4);
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = a52;
            objectArray2[1] = a62;
            objectArray2[2] = n;
            logger.debug(VersionResource.byte("-Q'M!^7Z \u001f2Z6L-P*\u001f&Z'^1L!\u001f+YdQ+\u001f V\"Y!M!Q'Z~\u001f*Z<KyD9\u0011?BjD9"), objectArray2);
        }
        EngineVersion engineVersion = a;
        engineVersion.setMajor(a52);
        engineVersion.setMinor(a62);
        a.setPatch(n);
        logger.debug(VersionResource.byte("6Z\"M!L,Z \u001f2Z6L-P*\u001f+YdK,ZdQ!G0\u001f-Q7Z6K-P*\u0005dV*L!M0i!M7V+QyD9"), (Object)a);
    }

    @Override
    public List<Coordinates> listCoordinates(String a, String a2, String a3) {
        Coordinates coordinates;
        ResourceVersionManageServiceImpl a4;
        if (a2 == null && a3 == null) {
            return a4.listCoordinatesByType((String)a);
        }
        if (a2 == null) {
            return a4.listCoordinatesByTypeAndLabel((String)a, a3);
        }
        if (a3 == null) {
            return a4.listCoordinatesByTypeAndName((String)a, a2);
        }
        Coordinates coordinates2 = coordinates = new Coordinates();
        coordinates.setType((String)a);
        coordinates2.setName(a2);
        coordinates2.setLabel(a3);
        a = a4.get(coordinates2, true);
        if (a == null) {
            return Collections.emptyList();
        }
        Coordinates coordinates3 = coordinates;
        Object object = a;
        coordinates.setMajor(((VersionResource)object).getMajor());
        coordinates3.setMinor(((VersionResource)object).getMinor());
        coordinates3.setPatch(((VersionResource)a).getPatch());
        return Collections.singletonList(coordinates);
    }

    @Override
    public Coordinates delete(Coordinates a) {
        ResourceVersionManageServiceImpl a2;
        logger.debug(VersionResource.byte("[!S!K!\u0017'P+M V*^0Z7\u0002?Bm"), (Object)a);
        if (a.getType() == null || a.getName() == null || a.getLabel() == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a2;
        EngineResource engineResource2 = engineResource;
        Coordinates coordinates = a;
        engineResource.setType(coordinates.getType());
        engineResource2.setName(coordinates.getName());
        engineResource2.setLabel(a.getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.boolean());
        Object object = resourceVersionManageServiceImpl.resourceMapper.selectResourceId(engineResource);
        if (object == null) {
            logger.debug(VersionResource.byte("Y%V(Z \u001f0Pd[!S!K!\u0013dQ+\u001f7J'WdM!L+J6\\!\u0005dD9"), (Object)a);
            return null;
        }
        if ((object = a2.boolean((Long)object, a.getMajor(), a.getMinor(), a.getPatch(), true)) == null) {
            logger.debug(VersionResource.byte("\"^-S![dK+\u001f Z(Z0Zh\u001f*PdL1\\,\u001f2Z6L-P*\u0005dD9"), (Object)a);
            return null;
        }
        a2.versionMapper.updateDataStatusById(((EngineVersion)((Object)object)).getId(), 1, String.valueOf(a2.boolean()), a2.boolean());
        Coordinates coordinates2 = a = new Coordinates();
        Object object2 = object;
        Coordinates coordinates3 = a;
        EngineResource engineResource3 = engineResource;
        a.setType(engineResource3.getType());
        coordinates3.setName(engineResource3.getName());
        coordinates3.setLabel(engineResource.getLabel());
        a.setMajor(((EngineVersion)((Object)object2)).getMajor());
        coordinates2.setMinor(((EngineVersion)((Object)object2)).getMinor());
        coordinates2.setPatch(((EngineVersion)((Object)object)).getPatch());
        logger.debug(VersionResource.byte(" Z(Z0Z \u001f2Z6L-P*\u0005dD9"), (Object)a);
        return a;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ EngineVersion boolean(long a, Integer a2, Integer a3, Integer a4, boolean a5) {
        void var7_15;
        List<EngineVersion> list;
        Integer n;
        int n2;
        if (a2 != null) {
            n2 = 4;
            n = a3;
        } else {
            n2 = 0;
            n = a3;
        }
        int n3 = n2 | (n != null ? 2 : 0) | (a4 != null ? 1 : 0);
        Page page = new Page(1L, 1L, false);
        switch (n3) {
            case 0: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list2;
                list = list2 = a6.versionMapper.selectVersions((Page<EngineVersion>)page, a, a5);
                break;
            }
            case 4: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list3 = a6.versionMapper.selectVersionsMatchMajor((Page<EngineVersion>)page, a, a2, a5);
                list = list3;
                break;
            }
            case 2: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list4 = a6.versionMapper.selectVersionsMatchMinor((Page<EngineVersion>)page, a, a3, a5);
                list = list4;
                break;
            }
            case 1: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list5 = a6.versionMapper.selectVersionsMatchPatch((Page<EngineVersion>)page, a, a4, a5);
                list = list5;
                break;
            }
            case 6: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list6 = a6.versionMapper.selectVersionsMatchMajorAndMinor((Page<EngineVersion>)page, a, a2, a3, a5);
                list = list6;
                break;
            }
            case 5: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list7 = a6.versionMapper.selectVersionsMatchMajorAndPatch((Page<EngineVersion>)page, a, a2, a4, a5);
                list = list7;
                break;
            }
            case 3: {
                ResourceVersionManageServiceImpl a6;
                List<EngineVersion> list8 = a6.versionMapper.selectVersionsMatchMinorAndPatch((Page<EngineVersion>)page, a, a3, a4, a5);
                list = list8;
                break;
            }
            default: {
                ResourceVersionManageServiceImpl a6;
                return a6.versionMapper.selectExactVersion(a, a2, a3, a4, a5);
            }
        }
        if (list == null || var7_15.size() == 0) {
            return null;
        }
        if (var7_15.size() > 1) {
            throw new TooManyResultsException(VersionResource.byte("4^#V*^0V+QdQ+KdH+M/Z "));
        }
        EngineVersion engineVersion = (EngineVersion)((Object)var7_15.get(0));
        Object[] objectArray = new Object[6];
        objectArray[0] = a;
        objectArray[1] = a2;
        objectArray[2] = a3;
        objectArray[3] = a4;
        objectArray[4] = a5;
        objectArray[5] = engineVersion;
        logger.debug(VersionResource.byte("M!K6V!I![dS%K!L0\u001f2Z6L-P*\u0005dM!L+J6\\!v \u0002?Bh\u001f2Z6L-P*\u0002?BjD9\u0011?Bh\u001f*P6R%SyD9\u0013dM+HyD9"), objectArray);
        return engineVersion;
    }

    public void ensureResourceExists(EngineResource a) {
        ResourceVersionManageServiceImpl a2;
        EngineResource engineResource = a;
        engineResource.setId(a2.resourceMapper.selectResourceId(engineResource));
        if (engineResource.getId() != null) {
            logger.debug(VersionResource.byte("1L!\u001f0W!\u001f!G-L0V*XdM!L+J6\\!\u0005dD9"), (Object)a);
            return;
        }
        try {
            a2.trySaveResource(a);
            return;
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            EngineResource engineResource2 = a;
            engineResource2.setId(a2.resourceMapper.selectResourceId(engineResource2));
            logger.debug(VersionResource.byte("0M-Z \u001f0PdM!K6V!I!\u001f6Z7P1M'ZdV \u0005dD9"), (Object)a);
            if (engineResource2.getId() == null) {
                VersioningException versioningException = new VersioningException(VersionResource.byte("\"^-S![dK+\u001f6Z0M-Z2ZdM!L+J6\\!\u001f-[h\u001f)^/ZdL1M!\u001f*PdQ!L0Z \u001f0M%Q7^'K-P*\u001f-LdJ7Z "), dataIntegrityViolationException);
                versioningException.coordinates().setType(a.getType());
                versioningException.coordinates().setName(a.getName());
                versioningException.coordinates().setLabel(a.getLabel());
                logger.debug(VersionResource.byte("Y%V(Z \u001f0PdZ*L1M!\u001f6Z7P1M'ZdZ<V7K7\u0005dD9"), (Object)a);
                throw versioningException;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public EngineVersion saveVersion(EngineVersion a, VersionStrategy a2) {
        ResourceVersionManageServiceImpl a3;
        if (a.getResourceId() == null) {
            throw new NullPointerException();
        }
        EngineVersion engineVersion = new EngineVersion();
        EngineVersion engineVersion2 = engineVersion;
        EngineVersion engineVersion3 = engineVersion;
        EngineVersion engineVersion4 = engineVersion;
        EngineVersion engineVersion5 = a;
        engineVersion.setResourceId(engineVersion5.getResourceId());
        engineVersion4.setContentId(engineVersion5.getContentId());
        engineVersion4.setDescription(a.getDescription());
        engineVersion3.setDataStatus(VersionResource.byte("t"));
        engineVersion3.setCreator(a3.boolean());
        engineVersion2.setCreateTime(LocalDateTime.now());
        engineVersion2.setLastEditor(a3.boolean());
        engineVersion2.setLastTime(LocalDateTime.now());
        boolean bl = false;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        switch (a2) {
            case MAJOR: {
                if (a.getMajor() == null && a.getMinor() == null && a.getPatch() == null) break;
                Object[] objectArray = new Object[7];
                objectArray[0] = a2;
                objectArray[1] = a.getMajor();
                objectArray[2] = a.getMinor();
                objectArray[3] = a.getPatch();
                objectArray[4] = n;
                objectArray[5] = n2;
                objectArray[6] = n3;
                logger.warn(VersionResource.byte("]%[dL%I!\u001f7K6^0Z#Fd^6X1R!Q0L~\u001f7K6^0Z#FyD9\u0013dV*O1K\u0012Z6L-P*\u0002?BjD9\u0011?Bd\u0002z\u001f5J!M=i!M7V+QyD9\u0011?BjD9"), objectArray);
                break;
            }
            case MINOR: {
                EngineVersion engineVersion6 = a;
                n = engineVersion6.getMajor();
                if (engineVersion6.getMinor() == null && a.getPatch() == null) break;
                Object[] objectArray = new Object[7];
                objectArray[0] = a2;
                objectArray[1] = a.getMajor();
                objectArray[2] = a.getMinor();
                objectArray[3] = a.getPatch();
                objectArray[4] = n;
                objectArray[5] = n2;
                objectArray[6] = n3;
                logger.warn(VersionResource.byte("]%[dL%I!\u001f7K6^0Z#Fd^6X1R!Q0L~\u001f7K6^0Z#FyD9\u0013dV*O1K\u0012Z6L-P*\u0002?BjD9\u0011?Bd\u0002z\u001f5J!M=i!M7V+QyD9\u0011?BjD9"), objectArray);
                break;
            }
            case PATCH: {
                EngineVersion engineVersion7 = a;
                n = engineVersion7.getMajor();
                Integer n4 = n2 = engineVersion7.getMajor() != null ? a.getMinor() : null;
                if ((a.getMajor() != null || a.getMinor() == null) && a.getPatch() == null) break;
                Object[] objectArray = new Object[7];
                objectArray[0] = a2;
                objectArray[1] = a.getMajor();
                objectArray[2] = a.getMinor();
                objectArray[3] = a.getPatch();
                objectArray[4] = n;
                objectArray[5] = n2;
                objectArray[6] = n3;
                logger.warn(VersionResource.byte("]%[dL%I!\u001f7K6^0Z#Fd^6X1R!Q0L~\u001f7K6^0Z#FyD9\u0013dV*O1K\u0012Z6L-P*\u0002?BjD9\u0011?Bd\u0002z\u001f5J!M=i!M7V+QyD9\u0011?BjD9"), objectArray);
                break;
            }
            case EXACT: {
                bl = true;
                if (a.getMajor() != null && a.getMinor() != null && a.getPatch() != null) break;
                Object[] objectArray = new Object[4];
                objectArray[0] = a2;
                objectArray[1] = a.getMajor();
                objectArray[2] = a.getMinor();
                objectArray[3] = a.getPatch();
                logger.warn(VersionResource.byte("&^ \u001f7^2ZdL0M%K!X=\u001f%M#J)Z*K7\u0005dL0M%K!X=\u0002?Bh\u001f-Q4J0i!M7V+QyD9\u0011?BjD9"), objectArray);
                break;
            }
            default: {
                throw new UnsupportedOperationException(new StringBuilder().insert(0, VersionResource.byte("1Q7J4O+M0Z \u001f7^2ZdL0M%K!X=\u0005d")).append((Object)a2).toString());
            }
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = bl;
        objectArray[1] = n;
        objectArray[2] = n2;
        objectArray[3] = n3;
        logger.debug(VersionResource.byte("\\%S'J(^0Z \u001f2Z6L-P*\u001f-Q7Z6K-P*\u001f4S%Q~\u001f-L\u0001G%\\0l0M%K!X=\u0002?Bh\u001f5J!M=i!M7V+QyD9\u0011?BjD9"), objectArray);
        if (bl) {
            return a3.boolean(engineVersion, a);
        }
        return a3.boolean(engineVersion, a, a2, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public ResourceVersionManageServiceImpl(RvmResourceMapper rvmResourceMapper, RvmVersionMapper rvmVersionMapper, RvmContentMapper rvmContentMapper, NamedLockManagerService namedLockManagerService) {
        void a;
        void a2;
        void a3;
        void a4;
        ResourceVersionManageServiceImpl a5;
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a5;
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl2 = a5;
        resourceVersionManageServiceImpl2.resourceMapper = a4;
        resourceVersionManageServiceImpl2.versionMapper = a3;
        resourceVersionManageServiceImpl.contentMapper = a2;
        resourceVersionManageServiceImpl.lockManager = a;
    }

    @Override
    public List<VersionResource> list(Coordinates a, boolean a222) {
        Iterator a222;
        ResourceVersionManageServiceImpl a3;
        logger.debug(VersionResource.byte("S-L0\u0017'P+M V*^0Z7\u0002?Bh\u001f*P\u0007P*K!Q0\u0002?Bm"), (Object)a, (Object)a222);
        if (((Coordinates)((Object)a)).getType() == null || ((Coordinates)((Object)a)).getName() == null || ((Coordinates)((Object)a)).getLabel() == null) {
            throw new NullPointerException();
        }
        EngineResource engineResource = new EngineResource();
        ResourceVersionManageServiceImpl resourceVersionManageServiceImpl = a3;
        EngineResource engineResource2 = engineResource;
        Coordinates coordinates = a;
        engineResource.setType(coordinates.getType());
        engineResource2.setName(coordinates.getName());
        engineResource2.setLabel(((Coordinates)((Object)a)).getLabel());
        engineResource.setTenantId(resourceVersionManageServiceImpl.boolean());
        Object object = resourceVersionManageServiceImpl.resourceMapper.selectResourceId(engineResource);
        if (object == null) {
            logger.debug(VersionResource.byte("Y%V(Z \u001f0PdS-L0\u0013dQ+\u001f7J'WdM!L+J6\\!\u0005dD9"), (Object)a);
            return null;
        }
        if ((object = a3.boolean((Long)object, ((Coordinates)((Object)a)).getMajor(), ((Coordinates)((Object)a)).getMinor(), ((Coordinates)((Object)a)).getPatch(), true)) == null || object.size() == 0) {
            logger.debug(VersionResource.byte("Q+\u001f)^0\\,Z \u001f2Z6L-P*\u001f6Z0M-Z2Z \u0005dD9"), (Object)a);
            return new ArrayList<VersionResource>();
        }
        if (!a222) {
            ArrayList<VersionResource> arrayList = a = object.iterator();
            while (arrayList.hasNext()) {
                EngineVersion a222 = (EngineVersion)((Object)a.next());
                a222.setContent(Optional.ofNullable(a222.getContentId()).map(arg_0 -> ((RvmContentMapper)a3.contentMapper).selectById(arg_0)).orElse(null));
                arrayList = a;
            }
        }
        a = new ArrayList<VersionResource>(object.size());
        Iterator iterator = a222 = object.iterator();
        while (iterator.hasNext()) {
            VersionResource versionResource;
            object = (EngineVersion)((Object)a222.next());
            VersionResource versionResource2 = versionResource = new VersionResource();
            Object object2 = object;
            VersionResource versionResource3 = versionResource;
            VersionResource versionResource4 = versionResource;
            EngineResource engineResource3 = engineResource;
            versionResource.setType(engineResource3.getType());
            versionResource4.setName(engineResource3.getName());
            versionResource4.setLabel(engineResource.getLabel());
            versionResource3.setMajor(((EngineVersion)((Object)object)).getMajor());
            versionResource3.setMinor(((EngineVersion)((Object)object)).getMinor());
            versionResource.setPatch(((EngineVersion)((Object)object2)).getPatch());
            versionResource2.setDescription(((EngineVersion)((Object)object2)).getDescription());
            versionResource2.setContent(Optional.of(object).map(EngineVersion::getContent).map(EngineContent::getData).orElse(null));
            iterator = a222;
            a.add(versionResource);
        }
        logger.debug(VersionResource.byte("(V7K![dI!M7V+Q7\u0005dD9"), a);
        return a;
    }
}

