/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine.oscar.util;

import com.jxdinfo.hussar.engine.metadata.enums.ConnectEnum;
import com.jxdinfo.hussar.engine.metadata.enums.SqlConnectEnum;
import com.jxdinfo.hussar.engine.metadata.model.InputColumnVO;
import com.jxdinfo.hussar.engine.metadata.util.StringUtils;
import com.jxdinfo.hussar.engine.oscar.service.OscarTransactionalExecuteService;
import com.jxdinfo.hussar.engine.oscar.util.OscarQueryConditionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class OscarQuerySingleConditionUtil {
    protected static final int DEF_SB_SIZE = 128;
    private static Logger logger = LoggerFactory.getLogger(OscarQueryConditionUtil.class);

    public OscarQuerySingleConditionUtil() {
        OscarQuerySingleConditionUtil a;
    }

    public static String cleanNoAvailConnect(String a) {
        String string = a;
        if (string.toLowerCase().contains(ConnectEnum._ANDNO.getType())) {
            string = a.replace(ConnectEnum._ANDNO.getType().toUpperCase(), OscarTransactionalExecuteService.false("3"));
            string = OscarQuerySingleConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._ORNO.getType())) {
            string = string.replace(ConnectEnum._ORNO.getType().toUpperCase(), OscarTransactionalExecuteService.false("3"));
            string = OscarQuerySingleConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._ANDAND.getType())) {
            string = a.replace(ConnectEnum._ANDAND.getType().toUpperCase(), OscarTransactionalExecuteService.false("[s^"));
            string = OscarQuerySingleConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._ANDOR.getType())) {
            string = string.replace(ConnectEnum._ANDOR.getType().toUpperCase(), OscarTransactionalExecuteService.false("rH"));
            string = OscarQuerySingleConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._OROR.getType())) {
            string = string.replace(ConnectEnum._OROR.getType().toUpperCase(), OscarTransactionalExecuteService.false("rH"));
            string = OscarQuerySingleConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._ORAND.getType())) {
            string = string.replace(ConnectEnum._ORAND.getType().toUpperCase(), OscarTransactionalExecuteService.false("[s^"));
            string = OscarQuerySingleConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._WHEREAND.getType())) {
            string = string.replace(ConnectEnum._WHEREAND.getType().toUpperCase(), OscarTransactionalExecuteService.false("Mu_o_"));
            string = OscarQuerySingleConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._WHEREOR.getType())) {
            string = string.replace(ConnectEnum._WHEREOR.getType().toUpperCase(), OscarTransactionalExecuteService.false("Mu_o_"));
            string = OscarQuerySingleConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._SIGNAND.getType())) {
            string = string.replace(ConnectEnum._SIGNAND.getType().toUpperCase(), OscarTransactionalExecuteService.false("2"));
            string = OscarQuerySingleConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._SIGNOR.getType())) {
            string = string.replace(ConnectEnum._SIGNOR.getType().toUpperCase(), OscarTransactionalExecuteService.false("2"));
            string = OscarQuerySingleConditionUtil.cleanNoAvailConnect(string);
        }
        return string;
    }

    public static String cleanEmptyBrackets(String a) {
        String string = a;
        if (string.contains(OscarTransactionalExecuteService.false("\u00153"))) {
            string = a.replace(OscarTransactionalExecuteService.false("2\u0014:"), "");
            string = OscarQuerySingleConditionUtil.cleanEmptyBrackets(string);
        }
        return string;
    }

    public static String renderQueryCon(List<InputColumnVO> a, boolean a2, String a3, Map<String, Object> a4, String a5) {
        StringBuilder stringBuilder;
        List<InputColumnVO> list;
        StringBuilder stringBuilder2;
        if (CollectionUtils.isEmpty(a4)) {
            return "";
        }
        if (CollectionUtils.isEmpty(a)) {
            return "";
        }
        StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder(128);
        if (!a2) {
            stringBuilder3.append(OscarTransactionalExecuteService.false("jRxHx:"));
            list = a;
        } else {
            stringBuilder3.append(OscarTransactionalExecuteService.false("2"));
            list = a;
        }
        for (InputColumnVO inputColumnVO : list) {
            Object object;
            if (ConnectEnum._ROW.getType().equals(inputColumnVO.getType())) {
                InputColumnVO inputColumnVO2 = inputColumnVO;
                object = inputColumnVO2.getColumnName();
                String string = inputColumnVO2.getColumnAliasDefined();
                String string2 = inputColumnVO2.getInColumnType();
                string2 = inputColumnVO2.getWhereFlag();
                a3 = inputColumnVO2.getInConnectFlag();
                if (!a4.containsKey(string) || !Objects.nonNull(a4.get(string)) || "".equals(a4.get(string).toString().trim())) continue;
                if (SqlConnectEnum._LEFT_LIKE.getKey().equalsIgnoreCase(string2) || SqlConnectEnum._RIGHT_LIKE.getKey().equalsIgnoreCase(string2) || SqlConnectEnum._FULL_LIKE.getKey().equalsIgnoreCase(string2)) {
                    if (string2.toUpperCase().contains(OscarTransactionalExecuteService.false("q_{N"))) {
                        stringBuilder2.append(OscarTransactionalExecuteService.false("8")).append((String)object).append(OscarTransactionalExecuteService.false("\u001f:")).append(OscarTransactionalExecuteService.false("VtQx:~UsY|N\u001d2\u001a?\u001a6\u001ea")).append(string).append(OscarTransactionalExecuteService.false("@3")).append(OscarTransactionalExecuteService.false(":")).append(a3.toUpperCase()).append(OscarTransactionalExecuteService.false(":"));
                        continue;
                    }
                    StringBuilder stringBuilder4 = stringBuilder2;
                    if (string2.toUpperCase().contains(OscarTransactionalExecuteService.false("Ht]uN"))) {
                        stringBuilder4.append(OscarTransactionalExecuteService.false("8")).append((String)object).append(OscarTransactionalExecuteService.false("\u001f:")).append(OscarTransactionalExecuteService.false("VtQx:~UsY|N\u001d2\u001ea")).append(string).append(OscarTransactionalExecuteService.false("@6\u001a?\u001a3")).append(OscarTransactionalExecuteService.false(":")).append(a3.toUpperCase()).append(OscarTransactionalExecuteService.false(":"));
                        continue;
                    }
                    stringBuilder4.append(OscarTransactionalExecuteService.false("8")).append((String)object).append(OscarTransactionalExecuteService.false("\u001f:")).append(OscarTransactionalExecuteService.false("VtQx:~UsY|N\u001d2\u001a?\u001a6\u001ea")).append(string).append(OscarTransactionalExecuteService.false("@6\u001a?\u001a3")).append(OscarTransactionalExecuteService.false(":")).append(a3.toUpperCase()).append(OscarTransactionalExecuteService.false(":"));
                    continue;
                }
                if (SqlConnectEnum._EQUAL.getKey().equalsIgnoreCase(string2) || SqlConnectEnum._GREAT_THAN.getKey().equalsIgnoreCase(string2) || SqlConnectEnum._LESS_THAN.getKey().equalsIgnoreCase(string2) || SqlConnectEnum._GREAT_AND_THAN.getKey().equalsIgnoreCase(string2) || SqlConnectEnum._LESS_AND_THAN.getKey().equalsIgnoreCase(string2) || SqlConnectEnum._NOT_EQUAL.getKey().equalsIgnoreCase(string2)) {
                    stringBuilder2.append(OscarTransactionalExecuteService.false("8")).append((String)object).append(OscarTransactionalExecuteService.false("8")).append(OscarTransactionalExecuteService.false(":")).append(string2.toUpperCase()).append(OscarTransactionalExecuteService.false(":\u001ea")).append(string).append(OscarTransactionalExecuteService.false("g")).append(OscarTransactionalExecuteService.false(":")).append(a3.toUpperCase()).append(OscarTransactionalExecuteService.false(":"));
                    continue;
                }
                if (SqlConnectEnum._IN.getKey().equalsIgnoreCase(string2) || SqlConnectEnum._NOT_IN.getKey().equalsIgnoreCase(string2)) {
                    if (OscarTransactionalExecuteService.false("fG").equals(a4.get(string).toString().trim())) continue;
                    stringBuilder2.append(OscarTransactionalExecuteService.false("8")).append((String)object).append(OscarTransactionalExecuteService.false("8")).append(OscarTransactionalExecuteService.false(":")).append(string2.toUpperCase()).append(OscarTransactionalExecuteService.false("\u001d2\u001ea[uO\u007f\\yUE")).append(string).append(OscarTransactionalExecuteService.false("@3")).append(OscarTransactionalExecuteService.false(":")).append(a3.toUpperCase()).append(OscarTransactionalExecuteService.false(":"));
                    continue;
                }
                stringBuilder2.append(OscarTransactionalExecuteService.false("8")).append((String)object).append(OscarTransactionalExecuteService.false("8")).append(OscarTransactionalExecuteService.false(":")).append(string2.toUpperCase()).append(OscarTransactionalExecuteService.false("\u001d2\u001ea[uO\u007f\\yUE")).append(string).append(OscarTransactionalExecuteService.false("@3")).append(OscarTransactionalExecuteService.false(":")).append(a3.toUpperCase()).append(OscarTransactionalExecuteService.false(":"));
                continue;
            }
            if (!ConnectEnum._CHILD.getType().equals(inputColumnVO.getType())) continue;
            InputColumnVO inputColumnVO3 = inputColumnVO;
            a5 = inputColumnVO3.getInConnectFlag();
            object = inputColumnVO3.getChildren();
            if (CollectionUtils.isEmpty((Collection)object)) continue;
            stringBuilder2.append(OscarQuerySingleConditionUtil.renderQueryCon((List<InputColumnVO>)object, true, a3, a4, a5));
        }
        if (!a2) {
            StringBuilder stringBuilder5 = stringBuilder2;
            stringBuilder = stringBuilder5;
            stringBuilder5.append(OscarTransactionalExecuteService.false("Mu_o_"));
        } else {
            StringBuilder stringBuilder6 = stringBuilder2;
            if (StringUtils.isEmpty((String)a5)) {
                stringBuilder6.append(OscarTransactionalExecuteService.false("3"));
                stringBuilder = stringBuilder2;
            } else {
                stringBuilder6.append(OscarTransactionalExecuteService.false("3")).append(OscarTransactionalExecuteService.false(":")).append(a5.toUpperCase()).append(OscarTransactionalExecuteService.false(":"));
                stringBuilder = stringBuilder2;
            }
        }
        return stringBuilder.toString();
    }

    public static String cleanSql(String a) {
        String string;
        String string2 = string = OscarQuerySingleConditionUtil.cleanNoAvailConnect(OscarQuerySingleConditionUtil.cleanEmptyBrackets(a));
        String string3 = string2.substring(string.length() - 3, string2.length());
        if (string3.toLowerCase().equals(ConnectEnum._OR.getType())) {
            String string4 = string;
            string = string4.substring(0, string4.length() - 3);
        }
        String string5 = string;
        String string6 = string5.substring(string5.length() - 4, string.length());
        if (string6.toLowerCase().equals(ConnectEnum._AND.getType())) {
            String string7 = string;
            string = string7.substring(0, string7.length() - 4);
        }
        String string8 = string;
        String string9 = string;
        string3 = string8.substring(string8.length() - 3, string9.length());
        string6 = string8.substring(string9.length() - 4, string.length());
        if (string8.toLowerCase().contains(ConnectEnum._ANDNO.getType()) || string.toLowerCase().contains(ConnectEnum._ORNO.getType()) || string.toLowerCase().contains(ConnectEnum._ANDAND.getType()) || string.toLowerCase().contains(ConnectEnum._ANDOR.getType()) || string.toLowerCase().contains(ConnectEnum._ORAND.getType()) || string.toLowerCase().contains(ConnectEnum._OROR.getType()) || string.toLowerCase().contains(ConnectEnum._WHEREAND.getType()) || string.toLowerCase().contains(ConnectEnum._WHEREOR.getType()) || string.toLowerCase().contains(ConnectEnum._SIGNAND.getType()) || string.toLowerCase().contains(ConnectEnum._SIGNOR.getType()) || string.contains(OscarTransactionalExecuteService.false("\u00153")) || string3.equalsIgnoreCase(ConnectEnum._OR.getType()) || string6.equalsIgnoreCase(ConnectEnum._AND.getType())) {
            string = OscarQuerySingleConditionUtil.cleanSql(string);
        }
        return string;
    }

    public static String dynamicWhereSql(List<InputColumnVO> a, Map<String, Object> a2) {
        String string = null;
        if (StringUtils.isEmpty((String)(a2 = OscarQuerySingleConditionUtil.renderQueryCon(a, false, "", a2, string))) || ((String)a2).length() <= 5) {
            return "";
        }
        if (StringUtils.isEmpty((String)((String)(a2 = OscarQuerySingleConditionUtil.cleanSql(((String)a2).substring(0, ((String)a2).length() - 5)))).split(OscarTransactionalExecuteService.false("Mu_o_"))[1].trim())) {
            return "";
        }
        return a2;
    }
}

