/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine.oracle.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.engine.metadata.dao.EngineMetadataDetailMapper;
import com.jxdinfo.hussar.engine.metadata.dao.EngineMetadataManageTableMapper;
import com.jxdinfo.hussar.engine.metadata.dao.EnginePlatformTableMapper;
import com.jxdinfo.hussar.engine.metadata.dto.EngineMetadataDetailDto;
import com.jxdinfo.hussar.engine.metadata.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.engine.metadata.exception.EngineException;
import com.jxdinfo.hussar.engine.metadata.model.EngineMetadataDetail;
import com.jxdinfo.hussar.engine.metadata.model.EngineMetadataManageTable;
import com.jxdinfo.hussar.engine.metadata.model.EngineMetadataParam;
import com.jxdinfo.hussar.engine.metadata.service.EngineDynamicDataSourceService;
import com.jxdinfo.hussar.engine.metadata.strategy.EnginePlatformTableFactory;
import com.jxdinfo.hussar.engine.metadata.util.DateUtils;
import com.jxdinfo.hussar.engine.metadata.util.IdAcquisitionUtil;
import com.jxdinfo.hussar.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.hussar.engine.metadata.util.StringUtils;
import com.jxdinfo.hussar.engine.oracle.dao.OracleTargetDataBaseMapper;
import com.jxdinfo.hussar.engine.oracle.service.OracleTransactionalExecuteService;
import com.jxdinfo.hussar.engine.oracle.service.impl.OracleMetadataManageTableDsServiceImpl;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@HussarDs(value="master")
public class OracleEngineMetadataTableServiceImpl {
    @Autowired
    private OracleTargetDataBaseMapper targetDataBaseOracleMapper;
    @Autowired
    private EngineMetadataDetailMapper generalMetadataDetailMapper;
    @Autowired
    private OracleMetadataManageTableDsServiceImpl dsService;
    private Map<String, EnginePlatformTableMapper> metadataDetailMapper = EnginePlatformTableFactory.getMappers((String)OracleMetadataManageTableDsServiceImpl.protected("\u001fq\u0006u\u0016u\u0006u6q\u0006u\u001bx"));
    @Autowired
    private SysDataSourceService sysDataSourceService;
    @Autowired
    private EngineMetadataManageTableMapper generalMetadataManageTableMapper;
    @Autowired
    private EngineDynamicDataSourceService engineDynamicDataSourceService;
    private static final Logger logger = LoggerFactory.getLogger(OracleEngineMetadataTableServiceImpl.class);

    public EngineMetadataManageTable renderBaseInfo(EngineMetadataParam a) {
        EngineMetadataParam engineMetadataParam = a;
        a = engineMetadataParam.getBaseInfo();
        List list = engineMetadataParam.getColumnInfo();
        EngineMetadataParam engineMetadataParam2 = a;
        EngineMetadataParam engineMetadataParam3 = a;
        engineMetadataParam3.setCountColumn(Long.valueOf(list.size()));
        engineMetadataParam3.setLastTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataParam2.setLastEditor(IdAcquisitionUtil.getCurrentUserId());
        engineMetadataParam2.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        if (StringUtils.isEmpty((String)engineMetadataParam2.getTableChname())) {
            EngineMetadataParam engineMetadataParam4 = a;
            engineMetadataParam4.setTableChname(engineMetadataParam4.getTableName());
        }
        if (StringUtils.isEmpty((String)a.getTableComment())) {
            EngineMetadataParam engineMetadataParam5 = a;
            engineMetadataParam5.setTableComment(engineMetadataParam5.getTableName());
        }
        if (StringUtils.isEmpty((String)a.getRemark())) {
            EngineMetadataParam engineMetadataParam6 = a;
            engineMetadataParam6.setRemark(engineMetadataParam6.getTableName());
        }
        return a;
    }

    String double(EngineMetadataParam a, List<EngineMetadataDetail> a2, String a3) throws EngineException {
        Object object;
        boolean bl;
        Object object2;
        Object object3;
        CharSequence charSequence;
        Object object4;
        OracleEngineMetadataTableServiceImpl a4;
        OracleEngineMetadataTableServiceImpl oracleEngineMetadataTableServiceImpl = a4;
        Object object5 = oracleEngineMetadataTableServiceImpl.renderBaseInfo((EngineMetadataParam)a);
        String string = object5.getDatasourceId().toString();
        Object object6 = oracleEngineMetadataTableServiceImpl.sysDataSourceService.getDatasourceById(string);
        if (object6 == null || object6.getData() == null) {
            logger.error(OracleTransactionalExecuteService.final("\u6c89\u6735\u67cd\u8bde\u5218\u654c\u6346\u6eac\u4fc9\u6053\uff24\u654c\u6346\u6eacaX\u0012GU"), (Object)string);
            throw new RuntimeException(new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.protected("\u6cb5\u677b\u67f1\u8b90\u5224\u6502\u637a\u6ee2\u4ff5\u601d\uff18\u6502\u637a\u6ee2]\u0016.")).append(string).toString());
        }
        string = (SysDataSource)object6.getData();
        if (Objects.isNull(string)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        EngineMetadataParam engineMetadataParam = a;
        a = engineMetadataParam.getColumnInfo();
        string = string.getInstantName();
        object6 = object5.getTableName();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        List list = engineMetadataParam.getDeletedCols();
        Object object7 = a.iterator();
        while (object7.hasNext()) {
            Object object8;
            object4 = (EngineMetadataDetailDto)object7.next();
            if (StringUtils.isEmpty((String)object4.getColumnChname())) {
                Object object9 = object4;
                object9.setColumnComment(object9.getColumnComment());
                object9.setColumnChname(object9.getColumnName());
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(OracleTransactionalExecuteService.final("U[nMM]UZYL"), object4.getRequired());
            hashMap.put(OracleMetadataManageTableDsServiceImpl.protected("w\u001dx\u0007y\u001cW\u001dy\u001fq\u001c`"), object4.getColumnComment());
            hashMap.put(OracleTransactionalExecuteService.final("XMZIIDH~]DIM"), object4.getDefaultValue());
            charSequence = object4.getColumnType();
            if (OracleMetadataManageTableDsServiceImpl.protected("<A?V7F").equalsIgnoreCase((String)charSequence) || OracleTransactionalExecuteService.final("lykue}d").equalsIgnoreCase((String)charSequence) || OracleMetadataManageTableDsServiceImpl.protected("Z'Y7F;W").equalsIgnoreCase((String)charSequence)) {
                object3 = new StringBuilder().insert(0, (String)charSequence).append(OracleTransactionalExecuteService.final("\u0000")).append(object4.getColumnLength()).append(OracleMetadataManageTableDsServiceImpl.protected("8")).append(object4.getPointLength()).append(OracleTransactionalExecuteService.final("\u0001")).toString();
                Object object10 = object4;
                object8 = object10;
                object10.setColumnType((String)object3);
                hashMap.put(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz&m\u0002q"), object3);
            } else if (OracleTransactionalExecuteService.final("XIHM").equalsIgnoreCase((String)charSequence) || OracleMetadataManageTableDsServiceImpl.protected("`\u001by\u0017g\u0006u\u001fd").equalsIgnoreCase((String)charSequence) || OracleTransactionalExecuteService.final("PGROHMD\\").equalsIgnoreCase((String)charSequence) || OracleMetadataManageTableDsServiceImpl.protected("\u0006q\n`").equalsIgnoreCase((String)charSequence) || OracleTransactionalExecuteService.final("^DSJ").equalsIgnoreCase((String)charSequence) || OracleMetadataManageTableDsServiceImpl.protected("\u0011x\u001dv").equalsIgnoreCase((String)charSequence) || OracleTransactionalExecuteService.final("PGRO^DSJ").equalsIgnoreCase((String)charSequence) || OracleMetadataManageTableDsServiceImpl.protected("\u001fq\u0016}\u0007y").equalsIgnoreCase((String)charSequence) || OracleTransactionalExecuteService.final("QMXAIEHMD\\").equalsIgnoreCase((String)charSequence) || OracleMetadataManageTableDsServiceImpl.protected("\u001fq\u0016}\u0007y\u0010x\u001dv").equalsIgnoreCase((String)charSequence) || OracleTransactionalExecuteService.final("HARQHMD\\").equalsIgnoreCase((String)charSequence) || OracleMetadataManageTableDsServiceImpl.protected("\u0006}\u001cm\u0010x\u001dv").equalsIgnoreCase((String)charSequence)) {
                hashMap.put(OracleTransactionalExecuteService.final("_GP]QFhQLM"), charSequence);
                object8 = object4;
            } else {
                object3 = new StringBuilder().insert(0, object4.getColumnType()).append(OracleMetadataManageTableDsServiceImpl.protected("<")).append(object4.getColumnLength()).append(OracleTransactionalExecuteService.final("\u0001")).toString();
                Object object11 = object4;
                hashMap.put(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz&m\u0002q"), object3);
                object8 = object11;
                object11.setColumnType((String)object3);
            }
            if (object8.getOperation() != null && OracleTransactionalExecuteService.final("YLU\\").equals(object4.getOperation())) {
                ArrayList arrayList5;
                block34: {
                    hashMap.put(OracleMetadataManageTableDsServiceImpl.protected("z\u0017c1{\u001ea\u001fz<u\u001fq"), object4.getColumnName());
                    object3 = a2.iterator();
                    while (object3.hasNext()) {
                        object2 = (EngineMetadataDetail)object3.next();
                        if (!object4.getOldColumnName().equals(object2.getColumnName())) continue;
                        hashMap.put(OracleTransactionalExecuteService.final("GPL\u007fGP]QFrIQM"), object2.getColumnName());
                        hashMap.put(OracleMetadataManageTableDsServiceImpl.protected("{\u001ep q\u0003a\u001bf\u0017p"), object2.getRequired());
                        hashMap.put(OracleTransactionalExecuteService.final("GPLlC"), object2.getPk());
                        object4.setCreateTime(object2.getCreateTime());
                        if (!object4.getPk().equals("1")) break;
                        arrayList5 = arrayList;
                        arrayList3.add(object2.getColumnName());
                        break block34;
                    }
                    arrayList5 = arrayList;
                }
                arrayList5.add(hashMap);
                continue;
            }
            if (object4.getOperation() != null && OracleMetadataManageTableDsServiceImpl.protected("u\u0016p").equals(object4.getOperation())) {
                Object object12 = object4;
                hashMap.put(OracleTransactionalExecuteService.final("_GP]QFrIQM"), object12.getColumnName());
                hashMap.put(OracleMetadataManageTableDsServiceImpl.protected("z\u0017c1{\u001ea\u001fz<u\u001fq"), object4.getColumnName());
                hashMap.put(OracleTransactionalExecuteService.final("GPL\u007fGP]QFrIQM"), object4.getColumnName());
                hashMap.put(OracleMetadataManageTableDsServiceImpl.protected("z\u0017c\"\u007f"), object4.getPk());
                arrayList2.add(hashMap);
                if (!object12.getPk().equals("1")) continue;
                arrayList3.add(object4.getColumnName());
                continue;
            }
            if (!object4.getPk().equals("1")) continue;
            arrayList3.add(object4.getColumnName());
        }
        object7 = new StringBuffer();
        object4 = new StringBuffer();
        boolean bl2 = bl = !arrayList3.isEmpty();
        if (HussarUtils.isEmpty(a2)) {
            Object object13;
            CharSequence charSequence2;
            ((StringBuffer)object7).append(OracleTransactionalExecuteService.final("xm\u007fd}zy\br}q\br}qjyz\u0007\b~m{ar\bompm\u007f|\u001cks}r|\u0014\u0019\u0015\bufhg\u001cfie\u001cnngq\bi{yzc|}jpmo\bk`yzy\bhi~dywriqm\u001c\u0015\u001c\u000f")).append((String)object6).append(OracleMetadataManageTableDsServiceImpl.protected("U/R]44<A?)C4&\\7ZRQ*Q1A&QR]?Y7P;U&QR36F=DR@3V>QR6")).append((String)object6).append(OracleTransactionalExecuteService.final("\n\u001b\u0013\u001cmrl\u001caz\u0013\u001cmrl\u0007\"\u0013\""));
            CharSequence charSequence3 = charSequence = new StringBuffer(OracleMetadataManageTableDsServiceImpl.protected("1F7U&QR@3V>QR6\u0006u\u0010x\u0017Z\u0013y\u00176R<"));
            ((StringBuffer)charSequence3).replace(((StringBuffer)charSequence).indexOf(OracleTransactionalExecuteService.final("\\]JPMrIQM")), ((StringBuffer)charSequence3).indexOf(OracleMetadataManageTableDsServiceImpl.protected("`\u0013v\u001eq<u\u001fq")) + OracleTransactionalExecuteService.final("\\]JPMrIQM").length(), (String)object6);
            object3 = a.iterator();
            Object object14 = object3;
            while (object14.hasNext()) {
                object2 = (EngineMetadataDetailDto)object3.next();
                charSequence2 = new StringBuffer(OracleMetadataManageTableDsServiceImpl.protected("6\u0011{\u001ea\u001fz<u\u001fqP4\u0011{\u001ea\u001fz&m\u0002qRZ=@RZ'X>46Q4U'X&4Up\u0017r\u0013a\u001e`$u\u001ea\u00173R8"));
                StringBuffer stringBuffer = charSequence2;
                stringBuffer.replace(((StringBuffer)charSequence2).indexOf(OracleTransactionalExecuteService.final("_GP]QFrIQM")), stringBuffer.indexOf(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz<u\u001fq")) + OracleTransactionalExecuteService.final("_GP]QFrIQM").length(), object2.getColumnName());
                CharSequence charSequence4 = charSequence2;
                ((StringBuffer)charSequence4).replace(((StringBuffer)charSequence2).indexOf(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz&m\u0002q")), ((StringBuffer)charSequence4).indexOf(OracleTransactionalExecuteService.final("_GP]QFhQLM")) + OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz&m\u0002q").length(), object2.getColumnType());
                if (!object2.getRequired().equals("1")) {
                    CharSequence charSequence5 = charSequence2;
                    ((StringBuffer)charSequence5).delete(((StringBuffer)charSequence2).indexOf(OracleTransactionalExecuteService.final("fs|\u001cfidp\b")), ((StringBuffer)charSequence5).indexOf(OracleMetadataManageTableDsServiceImpl.protected("Z=@RZ'X>4")) + OracleTransactionalExecuteService.final("rgh\br}pd").length() + 1);
                }
                CharSequence charSequence6 = charSequence2;
                if (StringUtils.isNotEmpty((String)object2.getDefaultValue())) {
                    ((StringBuffer)charSequence6).replace(((StringBuffer)charSequence2).indexOf(OracleMetadataManageTableDsServiceImpl.protected("\u0016q\u0014u\u0007x\u0006B\u0013x\u0007q")), ((StringBuffer)charSequence2).indexOf(OracleTransactionalExecuteService.final("XMZIIDH~]DIM")) + OracleMetadataManageTableDsServiceImpl.protected("\u0016q\u0014u\u0007x\u0006B\u0013x\u0007q").length(), object2.getDefaultValue());
                } else {
                    ((StringBuffer)charSequence6).delete(((StringBuffer)charSequence2).indexOf(OracleTransactionalExecuteService.final("lyn}}p|\u001c\u000fXMZIIDH~]DIM\u001b\b")), ((StringBuffer)charSequence2).indexOf(OracleMetadataManageTableDsServiceImpl.protected("P7R3A>@R3\u0016q\u0014u\u0007x\u0006B\u0013x\u0007qU4")) + OracleTransactionalExecuteService.final("lyn}}p|\u001c\u000fXMZIIDH~]DIM\u001b\b").length());
                }
                StringBuffer stringBuffer2 = new StringBuffer(OracleMetadataManageTableDsServiceImpl.protected("1[?Y7Z&4=ZRW=X'Y<4P`\u0013v\u001eq<u\u001fqP:Pw\u001dx\u0007y\u001cZ\u0013y\u00176R]!4Uw\u001dx\u0007y\u001cW\u001dy\u001fq\u001c`U/"));
                if (StringUtils.isNotEmpty((String)object2.getColumnComment())) {
                    StringBuffer stringBuffer3 = stringBuffer2;
                    stringBuffer3.replace(stringBuffer2.indexOf(OracleTransactionalExecuteService.final("\\]JPMrIQM")), stringBuffer3.indexOf(OracleMetadataManageTableDsServiceImpl.protected("`\u0013v\u001eq<u\u001fq")) + OracleTransactionalExecuteService.final("\\]JPMrIQM").length(), (String)object6);
                    StringBuffer stringBuffer4 = stringBuffer2;
                    stringBuffer4.replace(stringBuffer2.indexOf(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz<u\u001fq")), stringBuffer4.indexOf(OracleTransactionalExecuteService.final("_GP]QFrIQM")) + OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz<u\u001fq").length(), object2.getColumnName());
                    StringBuffer stringBuffer5 = stringBuffer2;
                    stringBuffer5.replace(stringBuffer2.indexOf(OracleTransactionalExecuteService.final("KSDIERkSEQMR\\")), stringBuffer5.indexOf(OracleMetadataManageTableDsServiceImpl.protected("w\u001dx\u0007y\u001cW\u001dy\u001fq\u001c`")) + OracleTransactionalExecuteService.final("KSDIERkSEQMR\\").length(), object2.getColumnComment());
                    ((StringBuffer)object4).append(stringBuffer2);
                }
                ((StringBuffer)charSequence).append((StringBuffer)charSequence2);
                object14 = object3;
            }
            if (bl) {
                object3 = new StringBuffer();
                Object object15 = object2 = arrayList3.iterator();
                while (object15.hasNext()) {
                    charSequence2 = (String)object2.next();
                    object15 = object2;
                    ((StringBuffer)object3).append((String)charSequence2).append(OracleMetadataManageTableDsServiceImpl.protected("8"));
                }
                Iterator<EngineMetadataDetail> iterator = object3;
                ((StringBuffer)((Object)iterator)).deleteCharAt(((StringBuffer)((Object)iterator)).length() - 1);
                ((StringBuffer)charSequence).append(OracleTransactionalExecuteService.final("lzue}ze\bwme\b\u0014\n")).append((StringBuffer)object3).append(OracleMetadataManageTableDsServiceImpl.protected("P=[/"));
                object13 = object7;
            } else {
                CharSequence charSequence7 = charSequence;
                ((StringBuffer)charSequence7).deleteCharAt(((StringBuffer)charSequence7).length() - 1);
                ((StringBuffer)charSequence).append(OracleTransactionalExecuteService.final("\u0001\u0015\u0013"));
                object13 = object7;
            }
            ((StringBuffer)object13).append((StringBuffer)charSequence);
            object3 = new StringBuffer(OracleMetadataManageTableDsServiceImpl.protected("W=Y?Q<@R[<4&U0X74P`\u0013v\u001eq<u\u001fqP4;GR3\u0006u\u0010x\u0017W\u001dy\u001fq\u001c`U/"));
            if (StringUtils.isNotEmpty((String)object5.getTableComment())) {
                Object object16 = object3;
                ((StringBuffer)object16).replace(((StringBuffer)object3).indexOf(OracleTransactionalExecuteService.final("\\]JPMrIQM")), ((StringBuffer)object16).indexOf(OracleMetadataManageTableDsServiceImpl.protected("`\u0013v\u001eq<u\u001fq")) + OracleTransactionalExecuteService.final("\\]JPMrIQM").length(), (String)object6);
                Object object17 = object3;
                ((StringBuffer)object17).replace(((StringBuffer)object3).indexOf(OracleMetadataManageTableDsServiceImpl.protected("\u0006u\u0010x\u0017W\u001dy\u001fq\u001c`")), ((StringBuffer)object17).indexOf(OracleTransactionalExecuteService.final("HI^DYkSEQMR\\")) + OracleMetadataManageTableDsServiceImpl.protected("\u0006u\u0010x\u0017W\u001dy\u001fq\u001c`").length(), object5.getTableComment());
                ((StringBuffer)object7).append((StringBuffer)object3);
            }
            Object object18 = object7;
            object = object18;
            ((StringBuffer)object18).append((StringBuffer)object4);
        } else {
            Object object19;
            Object object20;
            boolean bl3 = a4.dsService.isHavePk((String)object6, string);
            if (!((String)a3).equalsIgnoreCase((String)object6)) {
                object3 = new StringBuffer(OracleTransactionalExecuteService.final("nmriqm\u001cGPLrIQM\u001c|s\bRMKf]EY\u0013"));
                StringBuffer stringBuffer = object3;
                stringBuffer.replace(((StringBuffer)object3).indexOf(OracleMetadataManageTableDsServiceImpl.protected("{\u001ep<u\u001fq")), stringBuffer.indexOf(OracleTransactionalExecuteService.final("GPLrIQM")) + OracleMetadataManageTableDsServiceImpl.protected("{\u001ep<u\u001fq").length(), (String)a3);
                StringBuffer stringBuffer6 = object3;
                stringBuffer6.replace(((StringBuffer)object3).indexOf(OracleTransactionalExecuteService.final("FY_rIQM")), stringBuffer6.indexOf(OracleMetadataManageTableDsServiceImpl.protected("z\u0017c<u\u001fq")) + OracleTransactionalExecuteService.final("FY_rIQM").length(), (String)object6);
                ((StringBuffer)object7).append((StringBuffer)object3);
            }
            object3 = new StringBuffer(OracleMetadataManageTableDsServiceImpl.protected("3X&Q 4&U0X74P`\u0013v\u001eq<u\u001fqP4"));
            StringBuffer stringBuffer = object3;
            stringBuffer.replace(((StringBuffer)object3).indexOf(OracleTransactionalExecuteService.final("\\]JPMrIQM")), stringBuffer.indexOf(OracleMetadataManageTableDsServiceImpl.protected("`\u0013v\u001eq<u\u001fq")) + OracleTransactionalExecuteService.final("\\]JPMrIQM").length(), (String)object6);
            object2 = new StringBuffer();
            if (HussarUtils.isNotEmpty(arrayList2)) {
                Object object21 = object20 = arrayList2.iterator();
                while (object21.hasNext()) {
                    object19 = (Map)object20.next();
                    a = new StringBuffer(OracleMetadataManageTableDsServiceImpl.protected("3X&Q 4&U0X74P`\u0013v\u001eq<u\u001fqP43P64Pw\u001dx\u0007y\u001cZ\u0013y\u00176Rw\u001dx\u0007y\u001c@\u000bd\u00174<[&4<A>XRP7R3A>@R3\u0016q\u0014u\u0007x\u0006B\u0013x\u0007qU/"));
                    if ("1".equals(object19.get(OracleTransactionalExecuteService.final("FY_lC")))) {
                        Object object22 = a;
                        ((StringBuffer)object22).append(OracleMetadataManageTableDsServiceImpl.protected("u\u001e`\u0017fR`\u0013v\u001eqR6\u0006u\u0010x\u0017Z\u0013y\u00176RU6PRd\u0000}\u001fu\u0000mR\u007f\u0017mR<Pw\u001dx\u0007y\u001cZ\u0013y\u00176[/"));
                        Object object23 = a;
                        ((StringBuffer)object23).replace(((StringBuffer)a).indexOf(OracleTransactionalExecuteService.final("\\]JPMrIQM")), ((StringBuffer)object23).indexOf(OracleMetadataManageTableDsServiceImpl.protected("`\u0013v\u001eq<u\u001fq")) + OracleTransactionalExecuteService.final("\\]JPMrIQM").length(), (String)object6);
                        ((StringBuffer)object22).replace(((StringBuffer)object22).indexOf(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz<u\u001fq")), ((StringBuffer)a).indexOf(OracleTransactionalExecuteService.final("_GP]QFrIQM")) + OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz<u\u001fq").length(), (String)object19.get(OracleTransactionalExecuteService.final("_GP]QFrIQM")));
                    }
                    Object object24 = a;
                    ((StringBuffer)object24).replace(((StringBuffer)object24).indexOf(OracleMetadataManageTableDsServiceImpl.protected("`\u0013v\u001eq<u\u001fq")), ((StringBuffer)a).indexOf(OracleTransactionalExecuteService.final("\\]JPMrIQM")) + OracleMetadataManageTableDsServiceImpl.protected("`\u0013v\u001eq<u\u001fq").length(), (String)object6);
                    ((StringBuffer)a).replace(((StringBuffer)object24).indexOf(OracleTransactionalExecuteService.final("_GP]QFrIQM")), ((StringBuffer)a).indexOf(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz<u\u001fq")) + OracleTransactionalExecuteService.final("_GP]QFrIQM").length(), (String)object19.get(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz<u\u001fq")));
                    a4.private((StringBuffer)object2, (StringBuffer)object4, (String)object6, (Map<String, String>)object19, (StringBuffer)a);
                    object21 = object20;
                }
            }
            object20 = new StringBuffer();
            if (HussarUtils.isNotEmpty(arrayList)) {
                Object object25 = object19 = arrayList.iterator();
                while (object25.hasNext()) {
                    a = (Map)object19.next();
                    if (!((String)a.get(OracleTransactionalExecuteService.final("FY_\u007fGP]QFrIQM"))).equals(a.get(OracleMetadataManageTableDsServiceImpl.protected("{\u001ep1{\u001ea\u001fz<u\u001fq")))) {
                        a3 = new StringBuffer(OracleTransactionalExecuteService.final("ip|yz\u001c|}jpm\u001c\nHI^DYf]EY\n\u001czyf}ey\b\u007fgp}qf\u001cGPL\u007fGP]QFrIQM\u001c|s\bRMKkSDIERf]EY\u0013"));
                        if (HussarUtils.isNotEmpty(a.get(OracleMetadataManageTableDsServiceImpl.protected("{\u001ep1{\u001ea\u001fz<u\u001fq")))) {
                            CharSequence charSequence8 = a3;
                            ((StringBuffer)charSequence8).replace(((StringBuffer)a3).indexOf(OracleTransactionalExecuteService.final("\\]JPMrIQM")), ((StringBuffer)a3).indexOf(OracleMetadataManageTableDsServiceImpl.protected("`\u0013v\u001eq<u\u001fq")) + OracleTransactionalExecuteService.final("\\]JPMrIQM").length(), (String)object6);
                            ((StringBuffer)charSequence8).replace(((StringBuffer)charSequence8).indexOf(OracleMetadataManageTableDsServiceImpl.protected("{\u001ep1{\u001ea\u001fz<u\u001fq")), ((StringBuffer)a3).indexOf(OracleTransactionalExecuteService.final("GPL\u007fGP]QFrIQM")) + OracleMetadataManageTableDsServiceImpl.protected("{\u001ep1{\u001ea\u001fz<u\u001fq").length(), (String)a.get(OracleTransactionalExecuteService.final("GPL\u007fGP]QFrIQM")));
                            CharSequence charSequence9 = a3;
                            ((StringBuffer)charSequence9).replace(((StringBuffer)a3).indexOf(OracleMetadataManageTableDsServiceImpl.protected("z\u0017c1{\u001ea\u001fz<u\u001fq")), ((StringBuffer)charSequence9).indexOf(OracleTransactionalExecuteService.final("FY_\u007fGP]QFrIQM")) + OracleMetadataManageTableDsServiceImpl.protected("z\u0017c1{\u001ea\u001fz<u\u001fq").length(), (String)a.get(OracleTransactionalExecuteService.final("FY_\u007fGP]QFrIQM")));
                            ((StringBuffer)object20).append((StringBuffer)a3);
                        }
                    }
                    CharSequence charSequence10 = a3 = new StringBuffer(OracleMetadataManageTableDsServiceImpl.protected("3X&Q 4&U0X74P`\u0013v\u001eq<u\u001fqP4?[6]4MR6\u001cq\u0005W\u001dx\u0007y\u001cZ\u0013y\u00176Rw\u001dx\u0007y\u001c@\u000bd\u00174<[&4<A>XRP7R3A>@R3\u0016q\u0014u\u0007x\u0006B\u0013x\u0007qU/"));
                    ((StringBuffer)charSequence10).replace(((StringBuffer)a3).indexOf(OracleTransactionalExecuteService.final("\\]JPMrIQM")), ((StringBuffer)a3).indexOf(OracleMetadataManageTableDsServiceImpl.protected("`\u0013v\u001eq<u\u001fq")) + OracleTransactionalExecuteService.final("\\]JPMrIQM").length(), (String)object6);
                    ((StringBuffer)charSequence10).replace(((StringBuffer)charSequence10).indexOf(OracleMetadataManageTableDsServiceImpl.protected("z\u0017c1{\u001ea\u001fz<u\u001fq")), ((StringBuffer)a3).indexOf(OracleTransactionalExecuteService.final("FY_\u007fGP]QFrIQM")) + OracleMetadataManageTableDsServiceImpl.protected("z\u0017c1{\u001ea\u001fz<u\u001fq").length(), (String)a.get(OracleTransactionalExecuteService.final("FY_\u007fGP]QFrIQM")));
                    a.put(OracleMetadataManageTableDsServiceImpl.protected("\u001au\u0001P\u0017r"), "0");
                    a4.private((StringBuffer)object20, (StringBuffer)object4, (String)object6, (Map<String, String>)a, (StringBuffer)a3);
                    object25 = object19;
                }
            }
            object19 = new StringBuffer();
            if (HussarUtils.isNotEmpty((Object)list)) {
                a = list.iterator();
                while (a.hasNext()) {
                    a3 = (EngineMetadataDetail)a.next();
                    arrayList4.add(a3.getColumnName());
                    object5 = a2.iterator();
                    while (object5.hasNext()) {
                        string = (EngineMetadataDetail)object5.next();
                        if (!HussarUtils.equals((Object)string.getColumnName(), (Object)a3.getColumnName()) || !"1".equals(string.getPk())) continue;
                        ((StringBuffer)object19).append(OracleTransactionalExecuteService.final("ip|yz\u001c|}jpm\u001c\nHI^DYf]EY\n\u001clngl\bLZUE]ZE\bWME\u0013"));
                        Object object26 = object19;
                        ((StringBuffer)object26).replace(((StringBuffer)object19).indexOf(OracleMetadataManageTableDsServiceImpl.protected("`\u0013v\u001eq<u\u001fq")), ((StringBuffer)object26).indexOf(OracleTransactionalExecuteService.final("\\]JPMrIQM")) + OracleMetadataManageTableDsServiceImpl.protected("`\u0013v\u001eq<u\u001fq").length(), (String)object6);
                    }
                }
                Object object27 = a = arrayList4.iterator();
                while (object27.hasNext()) {
                    a3 = (String)a.next();
                    object5 = new StringBuffer(OracleTransactionalExecuteService.final("ip|yz\u001c|}jpm\u001c\nHI^DYf]EY\n\u001clngl\b\u007fgp}qf\u001c\n_GP]QFrIQM\u001e\u0013"));
                    object27 = a;
                    Object object28 = object5;
                    ((StringBuffer)object28).replace(((StringBuffer)object5).indexOf(OracleMetadataManageTableDsServiceImpl.protected("`\u0013v\u001eq<u\u001fq")), ((StringBuffer)object28).indexOf(OracleTransactionalExecuteService.final("\\]JPMrIQM")) + OracleMetadataManageTableDsServiceImpl.protected("`\u0013v\u001eq<u\u001fq").length(), (String)object6);
                    Object object29 = object5;
                    ((StringBuffer)object29).replace(((StringBuffer)object5).indexOf(OracleTransactionalExecuteService.final("_GP]QFrIQM")), ((StringBuffer)object29).indexOf(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz<u\u001fq")) + OracleTransactionalExecuteService.final("_GP]QFrIQM").length(), (String)a3);
                    ((StringBuffer)object19).append((StringBuffer)object5);
                }
            }
            Object object30 = object7;
            object = object30;
            ((StringBuffer)object30).append((StringBuffer)object19).append((StringBuffer)object2).append((StringBuffer)object20).append((StringBuffer)object4);
        }
        return String.valueOf(object);
    }

    public boolean insertView(EngineMetadataParam a) throws EngineException {
        OracleEngineMetadataTableServiceImpl a2;
        Object object;
        EngineMetadataParam engineMetadataParam = a;
        EngineMetadataManageTable engineMetadataManageTable = engineMetadataParam.getBaseInfo();
        Object object2 = engineMetadataParam.getColumnInfo();
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
        engineMetadataManageTable4.setCountColumn(Long.valueOf(object2.size()));
        engineMetadataManageTable4.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable3.setVersion(Long.valueOf(0L));
        engineMetadataManageTable3.setStatus("1");
        engineMetadataManageTable2.setViewFlag("1");
        engineMetadataManageTable2.setCharacterSet(OracleTransactionalExecuteService.final("i|z\u0010"));
        engineMetadataManageTable2.setId(IdGenerateUtils.getId());
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = (EngineMetadataDetail)object2.next();
            if (StringUtils.isEmpty((String)object.getPk())) {
                object.setPk("0");
            }
            EngineMetadataDetail engineMetadataDetail = object;
            engineMetadataDetail.setIncre("0");
            engineMetadataDetail.setRequired("0");
            if (StringUtils.isEmpty((String)object.getColumnChname())) {
                EngineMetadataDetail engineMetadataDetail2 = object;
                engineMetadataDetail2.setColumnChname(engineMetadataDetail2.getColumnName());
            }
            if (!StringUtils.isEmpty((String)object.getColumnComment())) continue;
            EngineMetadataDetail engineMetadataDetail3 = object;
            engineMetadataDetail3.setColumnComment(engineMetadataDetail3.getColumnName());
        }
        object2 = engineMetadataManageTable.getDatasourceId().toString();
        object = a2.sysDataSourceService.getDatasourceById((String)object2);
        if (object == null || object.getData() == null) {
            logger.error(OracleMetadataManageTableDsServiceImpl.protected("\u6cb5\u677b\u67f1\u8b90\u5224\u6502\u637a\u6ee2\u4ff5\u601d\uff18\u6502\u637a\u6ee2]\u0016.\ti"), object2);
            throw new RuntimeException(new StringBuilder().insert(0, OracleTransactionalExecuteService.final("\u6c89\u6735\u67cd\u8bde\u5218\u654c\u6346\u6eac\u4fc9\u6053\uff24\u654c\u6346\u6eacaX\u0012")).append((String)object2).toString());
        }
        if (Objects.isNull((SysDataSource)object.getData())) {
            logger.error(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST.getMessage());
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        object2 = IdAcquisitionUtil.getCurrentTenantId();
        if (!StringUtils.isNull((Object)(engineMetadataManageTable = a2.generalMetadataManageTableMapper.selectEngineMetadataManageTableByTableName(engineMetadataManageTable)))) {
            a2.generalMetadataManageTableMapper.deleteEngineMetadataManageTableById(engineMetadataManageTable.getId().toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.protected("G+G-\\7K?Q&U6U&U-Y3Z3S7K&U0X7.")).append(a.getBaseInfo().getId()).toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.final("{e{c`ywqmhixihice}f}oywhi~dy\u0012")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            object = a.getBaseInfo().getDatasourceId();
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.protected("!M!K:Q-Y7@3P3@3K?U<U5Q-@3V>QH.")).append((String)object2).append(OracleTransactionalExecuteService.final("\u0012")).append(object).append(OracleMetadataManageTableDsServiceImpl.protected(".")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            a2.generalMetadataDetailMapper.delColumn(engineMetadataManageTable.getId().toString());
        }
        return a2.insertTableInfo(a);
    }

    public boolean updateEngineMetadataManageTable(EngineMetadataParam a2) throws EngineException {
        Object object;
        EngineMetadataDetail engineMetadataDetail;
        OracleEngineMetadataTableServiceImpl a3;
        EngineMetadataParam engineMetadataParam = a2;
        EngineMetadataManageTable engineMetadataManageTable = engineMetadataParam.getBaseInfo();
        List list = engineMetadataParam.getColumnInfo();
        String string = engineMetadataManageTable.getDatasourceId().toString();
        Object object2 = a3.sysDataSourceService.getDatasourceById(string);
        if (object2 == null || object2.getData() == null) {
            logger.error(OracleTransactionalExecuteService.final("\u6c89\u6735\u67cd\u8bde\u5218\u654c\u6346\u6eac\u4fc9\u6053\uff24\u654c\u6346\u6eacaX\u0012GU"), (Object)string);
            throw new RuntimeException(new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.protected("\u6cb5\u677b\u67f1\u8b90\u5224\u6502\u637a\u6ee2\u4ff5\u601d\uff18\u6502\u637a\u6ee2]\u0016.")).append(string).toString());
        }
        string = (SysDataSource)object2.getData();
        if (Objects.isNull(string)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        object2 = IdAcquisitionUtil.getCurrentTenantId();
        List list2 = a3.generalMetadataDetailMapper.selectColumnInfo(engineMetadataManageTable.getId().toString());
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        engineMetadataManageTable3.setCountColumn(Long.valueOf(list.size()));
        engineMetadataManageTable3.setLastTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable2.setLastEditor(IdAcquisitionUtil.getCurrentUserId());
        engineMetadataManageTable2.setTenantId((String)object2);
        if (StringUtils.isEmpty((String)engineMetadataManageTable2.getTableChname())) {
            EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
            engineMetadataManageTable4.setTableChname(engineMetadataManageTable4.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableComment())) {
            EngineMetadataManageTable engineMetadataManageTable5 = engineMetadataManageTable;
            engineMetadataManageTable5.setTableComment(engineMetadataManageTable5.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getRemark())) {
            EngineMetadataManageTable engineMetadataManageTable6 = engineMetadataManageTable;
            engineMetadataManageTable6.setRemark(engineMetadataManageTable6.getTableName());
        }
        OracleEngineMetadataTableServiceImpl oracleEngineMetadataTableServiceImpl = a3;
        object2 = oracleEngineMetadataTableServiceImpl.generalMetadataManageTableMapper.getTableNameById(engineMetadataManageTable.getId().toString());
        String string2 = engineMetadataManageTable.getTableName();
        Serializable serializable = oracleEngineMetadataTableServiceImpl.generalMetadataManageTableMapper.getVersion(engineMetadataManageTable.getId().toString());
        engineMetadataManageTable.setVersion((Long)serializable);
        serializable = new ArrayList();
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)3);
        ArrayList<EngineMetadataDetail> arrayList2 = new ArrayList<EngineMetadataDetail>();
        ArrayList<EngineMetadataDetail> arrayList3 = new ArrayList<EngineMetadataDetail>();
        HashSet hashSet = Sets.newHashSet();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        List list3 = a2.getDeletedCols();
        Map<String, EngineMetadataDetail> map = list2.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        Object object3 = list.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        Object object4 = list3.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        block2: for (Map.Entry object5 : map.entrySet()) {
            if (object3.get(object5.getKey()) != null || object4.get(object5.getKey()) != null || !((EngineMetadataDetail)object5.getValue()).getPk().equals("1")) continue;
            hashSet.add(object5.getKey());
            engineMetadataDetail = object3.entrySet().iterator();
            while (engineMetadataDetail.hasNext()) {
                object = engineMetadataDetail.next();
                if (!((EngineMetadataDetail)object5.getValue()).getId().equals(((EngineMetadataDetail)object.getValue()).getId())) continue;
                hashSet.remove(object5.getKey());
                continue block2;
            }
        }
        map = list2.stream().collect(Collectors.toMap(EngineMetadataDetail::getId, Function.identity())).entrySet().stream().collect(Collectors.toMap(a -> Long.toString((Long)a.getKey()), Map.Entry::getValue));
        object = list.iterator();
        while (object.hasNext()) {
            HashMap hashMap;
            String string3;
            list.setDefaultValue((list = (EngineMetadataDetailDto)object.next()).getDefaultValue() == null ? "" : list.getDefaultValue());
            List list4 = list;
            list4.setLastTime(LocalDateTime.now());
            list4.setStatus(1);
            if (null != list.getOperation() && OracleTransactionalExecuteService.final("IXL").equalsIgnoreCase(list.getOperation())) {
                List list5 = list;
                list5.setId(IdGenerateUtils.getId());
                list5.setCreateTime(LocalDateTime.now());
                arrayList3.add((EngineMetadataDetail)list5);
            }
            if (list.getPk().equals("1")) {
                hashSet.add(list.getColumnName());
            }
            if ((string3 = list.getId().toString()) == null || !OracleMetadataManageTableDsServiceImpl.protected("\u0017p\u001b`").equalsIgnoreCase(list.getOperation())) continue;
            engineMetadataDetail = map.get(string3);
            List list6 = list;
            object3 = list6.getColumnComment();
            object4 = list6.getColumnName();
            if (!((String)object4).equals(engineMetadataDetail.getColumnName())) {
                hashMap = Maps.newHashMapWithExpectedSize((int)3);
                hashMap.put(OracleTransactionalExecuteService.final("GPL\u007fGP]QFrIQM"), engineMetadataDetail.getColumnName());
                hashMap.put(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz<u\u001fq"), object4);
                serializable.add(hashMap);
            }
            if (!StringUtils.isEmpty((String)object3) && !((String)object3).equals(engineMetadataDetail.getColumnComment())) {
                hashMap = Maps.newHashMapWithExpectedSize((int)3);
                hashMap.put(OracleTransactionalExecuteService.final("_GP]QFrIQM"), object4);
                hashMap.put(OracleMetadataManageTableDsServiceImpl.protected("w\u001dy\u001fq\u001c`"), object3);
                arrayList.add(hashMap);
            }
            if (!list.getRequired().equals(map.get(list.getId().toString()).getRequired())) {
                list.setNeedChangeIsRequired(true);
            }
            arrayList2.add((EngineMetadataDetail)list);
        }
        try {
            a3.dsService.editTable(engineMetadataManageTable, list2, (String)object2, string2, (List<Map<String, String>>)((Object)serializable), arrayList, arrayList2, arrayList3, hashSet, arrayList4, list3, map, string.getConnName(), 0);
        }
        catch (Exception exception) {
            logger.error(OracleTransactionalExecuteService.final("\u6558\u6352\u5ebb\u64f1\u4f74\u5f3e\u5e10"), (Throwable)exception);
            throw new EngineException(exception.getMessage());
        }
        return a3.updateTableInfo(a2);
    }

    public boolean insertTableInfo(EngineMetadataParam a3) throws EngineException {
        Object object;
        OracleEngineMetadataTableServiceImpl a2;
        Object object2 = a3.getBaseInfo();
        String string = a2.engineDynamicDataSourceService.getDatasourceType();
        try {
            EngineMetadataManageTable engineMetadataManageTable = object2;
            EngineMetadataManageTable engineMetadataManageTable2 = object2;
            engineMetadataManageTable2.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            engineMetadataManageTable.setStatus("1");
            engineMetadataManageTable2.setCreator(IdAcquisitionUtil.getCurrentUserId());
            engineMetadataManageTable.setCreateTime(LocalDateTime.now());
            engineMetadataManageTable.setLastEditor(engineMetadataManageTable.getCreator());
            engineMetadataManageTable.setLastTime(LocalDateTime.now());
            if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableChname())) {
                EngineMetadataManageTable engineMetadataManageTable3 = object2;
                engineMetadataManageTable3.setTableChname(engineMetadataManageTable3.getTableName());
            }
            if (StringUtils.isEmpty((String)object2.getTableComment())) {
                EngineMetadataManageTable engineMetadataManageTable4 = object2;
                engineMetadataManageTable4.setTableComment(engineMetadataManageTable4.getTableName());
            }
            if (StringUtils.isEmpty((String)object2.getRemark())) {
                EngineMetadataManageTable engineMetadataManageTable5 = object2;
                engineMetadataManageTable5.setRemark(engineMetadataManageTable5.getTableName());
            }
            EngineMetadataManageTable engineMetadataManageTable6 = object2;
            engineMetadataManageTable6.setRemark(engineMetadataManageTable6.getTableComment());
            a2.generalMetadataManageTableMapper.insertEngineMetadataManageTable(object2);
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.INSERT_TABLE_INFORMATION_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.INSERT_TABLE_INFORMATION_FAILED, (Throwable)exception);
        }
        List list = a3.getColumnInfo();
        a3 = list.iterator();
        Iterator iterator = a3;
        while (iterator.hasNext()) {
            object = (EngineMetadataDetail)a3.next();
            iterator = a3;
            EngineMetadataDetail engineMetadataDetail = object;
            Object object3 = object;
            object.setId(IdGenerateUtils.getId());
            object3.setTableId(object2.getId());
            engineMetadataDetail.setStatus(Integer.valueOf(1));
            object3.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
            engineMetadataDetail.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            engineMetadataDetail.setCreator(IdAcquisitionUtil.getCurrentUserId());
        }
        try {
            a3 = Lists.partition((List)list, (int)10);
            object = a3.iterator();
            while (object.hasNext()) {
                object2 = (List)object.next();
                a2.metadataDetailMapper.get(string).batchInsert((List)object2);
            }
        }
        catch (Exception a3) {
            logger.error(EngineExceptionEnum.INSERT_COLUMN_INFORMATION_FAILED.getMessage(), (Throwable)a3);
            throw new EngineException(EngineExceptionEnum.INSERT_COLUMN_INFORMATION_FAILED, (Throwable)a3);
        }
        return true;
    }

    public boolean insertEngineMetadataManageTable(EngineMetadataParam a) throws EngineException {
        String string;
        Serializable serializable;
        EngineMetadataDetail engineMetadataDetail;
        String string2;
        OracleEngineMetadataTableServiceImpl a2;
        Object object;
        EngineMetadataParam engineMetadataParam = a;
        EngineMetadataManageTable engineMetadataManageTable = engineMetadataParam.getBaseInfo();
        Object object2 = engineMetadataParam.getColumnInfo();
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
        engineMetadataManageTable.setCountColumn(Long.valueOf(object2.size()));
        engineMetadataManageTable4.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable4.setVersion(Long.valueOf(0L));
        engineMetadataManageTable3.setStatus("1");
        engineMetadataManageTable2.setCharacterSet(OracleTransactionalExecuteService.final("i|z\u0010"));
        engineMetadataManageTable3.setId(IdGenerateUtils.getId());
        if (StringUtils.isEmpty((String)engineMetadataManageTable2.getTableChname())) {
            EngineMetadataManageTable engineMetadataManageTable5 = engineMetadataManageTable;
            engineMetadataManageTable5.setTableChname(engineMetadataManageTable5.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableComment())) {
            EngineMetadataManageTable engineMetadataManageTable6 = engineMetadataManageTable;
            engineMetadataManageTable6.setTableComment(engineMetadataManageTable6.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getRemark())) {
            EngineMetadataManageTable engineMetadataManageTable7 = engineMetadataManageTable;
            engineMetadataManageTable7.setRemark(engineMetadataManageTable7.getTableName());
        }
        if ((object = a2.sysDataSourceService.getDatasourceById(string2 = engineMetadataManageTable.getDatasourceId().toString())) == null || object.getData() == null) {
            logger.error(OracleMetadataManageTableDsServiceImpl.protected("\u6cb5\u677b\u67f1\u8b90\u5224\u6502\u637a\u6ee2\u4ff5\u601d\uff18\u6502\u637a\u6ee2]\u0016.\ti"), (Object)string2);
            throw new RuntimeException(new StringBuilder().insert(0, OracleTransactionalExecuteService.final("\u6c89\u6735\u67cd\u8bde\u5218\u654c\u6346\u6eac\u4fc9\u6053\uff24\u654c\u6346\u6eacaX\u0012")).append(string2).toString());
        }
        string2 = (SysDataSource)object.getData();
        if (Objects.isNull(string2)) {
            logger.error(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST.getMessage());
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        object = IdAcquisitionUtil.getCurrentTenantId();
        Object object3 = object2 = object2.iterator();
        while (object3.hasNext()) {
            ArrayList<Map<String, String>> arrayList3;
            String string3;
            engineMetadataDetail = (EngineMetadataDetail)object2.next();
            if (engineMetadataDetail.getPk().equals("1")) {
                arrayList2.add(engineMetadataDetail.getColumnName());
            }
            serializable = new HashMap<String, String>();
            EngineMetadataDetail engineMetadataDetail2 = engineMetadataDetail;
            serializable.put(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz<u\u001fq"), engineMetadataDetail2.getColumnName());
            serializable.put(OracleTransactionalExecuteService.final("U[nMM]UZYL"), engineMetadataDetail.getRequired());
            serializable.put(OracleMetadataManageTableDsServiceImpl.protected("}\u0001]\u001cw\u0000q"), "0");
            serializable.put(OracleTransactionalExecuteService.final("KSDIERkSEQMR\\"), engineMetadataDetail.getColumnComment());
            serializable.put(OracleMetadataManageTableDsServiceImpl.protected("\u0016q\u0014u\u0007x\u0006B\u0013x\u0007q"), engineMetadataDetail.getDefaultValue());
            if (StringUtils.isEmpty((String)engineMetadataDetail2.getColumnChname())) {
                EngineMetadataDetail engineMetadataDetail3 = engineMetadataDetail;
                engineMetadataDetail3.setColumnChname(engineMetadataDetail3.getColumnName());
            }
            if (StringUtils.isEmpty((String)engineMetadataDetail.getColumnComment())) {
                EngineMetadataDetail engineMetadataDetail4 = engineMetadataDetail;
                engineMetadataDetail4.setColumnComment(engineMetadataDetail4.getColumnName());
            }
            if (engineMetadataDetail.getColumnLength() != null) {
                serializable.put(OracleTransactionalExecuteService.final("_GP]QFpMROH@"), engineMetadataDetail.getColumnLength().toString());
            }
            if (engineMetadataDetail.getPointLength() != null) {
                serializable.put(OracleMetadataManageTableDsServiceImpl.protected("d\u001d}\u001c`>q\u001cs\u0006|"), engineMetadataDetail.getPointLength().toString());
            }
            string = engineMetadataDetail.getColumnType();
            if (OracleTransactionalExecuteService.final("r}qjyz").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.protected("P7W;Y3X").equalsIgnoreCase(string) || OracleTransactionalExecuteService.final("fieyzuk").equalsIgnoreCase(string)) {
                string3 = new StringBuilder().insert(0, string).append(OracleMetadataManageTableDsServiceImpl.protected("<")).append(engineMetadataDetail.getColumnLength()).append(OracleTransactionalExecuteService.final("\u0004")).append(engineMetadataDetail.getPointLength()).append(OracleMetadataManageTableDsServiceImpl.protected("=")).toString();
                arrayList3 = arrayList;
                serializable.put(OracleTransactionalExecuteService.final("_GP]QFhQLM"), string3);
            } else if (OracleMetadataManageTableDsServiceImpl.protected("\u0016u\u0006q").equalsIgnoreCase(string) || OracleTransactionalExecuteService.final("\\UEY[HIQX").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.protected("\u001e{\u001cs\u0006q\n`").equalsIgnoreCase(string) || OracleTransactionalExecuteService.final("HMD\\").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.protected("\u0010x\u001dv").equalsIgnoreCase(string) || OracleTransactionalExecuteService.final("_DSJ").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.protected("\u001e{\u001cs\u0010x\u001dv").equalsIgnoreCase(string) || OracleTransactionalExecuteService.final("QMXAIE").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.protected("\u001fq\u0016}\u0007y\u0006q\n`").equalsIgnoreCase(string) || OracleTransactionalExecuteService.final("QMXAIE^DSJ").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.protected("\u0006}\u001cm\u0006q\n`").equalsIgnoreCase(string) || OracleTransactionalExecuteService.final("HARQ^DSJ").equalsIgnoreCase(string)) {
                serializable.put(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz&m\u0002q"), string);
                arrayList3 = arrayList;
            } else {
                string3 = new StringBuilder().insert(0, engineMetadataDetail.getColumnType()).append(OracleTransactionalExecuteService.final("\u0000")).append(engineMetadataDetail.getColumnLength()).append(OracleMetadataManageTableDsServiceImpl.protected("=")).toString();
                arrayList3 = arrayList;
                serializable.put(OracleTransactionalExecuteService.final("_GP]QFhQLM"), string3);
            }
            arrayList3.add((Map<String, String>)((Object)serializable));
            object3 = object2;
        }
        boolean bl = StringUtils.isNotEmpty(arrayList2);
        try {
            a2.dsService.createTable(engineMetadataManageTable, arrayList, arrayList2, bl, string2.getConnName());
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.CREATE_DATABASE_TABLE_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.CREATE_DATABASE_TABLE_FAILED, (Throwable)exception);
        }
        engineMetadataDetail = a2.generalMetadataManageTableMapper.selectEngineMetadataManageTableByTableName(engineMetadataManageTable);
        if (!StringUtils.isNull((Object)engineMetadataDetail)) {
            a2.generalMetadataManageTableMapper.deleteEngineMetadataManageTableById(engineMetadataDetail.getId().toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.protected("G+G-\\7K?Q&U6U&U-Y3Z3S7K&U0X7.")).append(engineMetadataDetail.getId()).toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.final("{e{c`ywqmhixihice}f}oywhi~dy\u0012")).append(engineMetadataDetail.getTableName().toUpperCase()).toString());
            serializable = engineMetadataDetail.getDatasourceId();
            string = new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.protected("!M!K:Q-Y7@3P3@3K?U<U5Q-@3V>QH.")).append((String)object).append(OracleTransactionalExecuteService.final("\u0012")).append(serializable).append(OracleMetadataManageTableDsServiceImpl.protected(".")).append(a.getBaseInfo().getTableName().toUpperCase()).toString();
            DefaultCacheUtil.evict((Object)string);
            a2.generalMetadataDetailMapper.delColumn(engineMetadataDetail.getId().toString());
        }
        return a2.insertTableInfo(a);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateTableInfoNew(EngineMetadataParam a) throws EngineException {
        OracleEngineMetadataTableServiceImpl a2;
        String string = a2.engineDynamicDataSourceService.getDatasourceType();
        Iterator iterator = String.valueOf(a.getBaseInfo().getId());
        try {
            EngineMetadataDetailDto engineMetadataDetailDto;
            OracleEngineMetadataTableServiceImpl oracleEngineMetadataTableServiceImpl = a2;
            oracleEngineMetadataTableServiceImpl.generalMetadataManageTableMapper.updateEngineMetadataManageTable(a.getBaseInfo());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.final("{e{c`ywqmhixihice}f}oywhi~dy\u0012")).append(a.getBaseInfo().getId()).toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.protected("G+G-\\7K?Q&U6U&U-Y3Z3S7K&U0X7.")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            String string2 = IdAcquisitionUtil.getCurrentTenantId();
            Object object = a.getBaseInfo().getDatasourceId();
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.final("oqowtmcey|}l}|}wqiri{mc|}jpm\u0006\u0012")).append(string2).append(OracleMetadataManageTableDsServiceImpl.protected(".")).append(object).append(OracleTransactionalExecuteService.final("\u0012")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            object = oracleEngineMetadataTableServiceImpl.generalMetadataDetailMapper.selectByTableId((String)((Object)iterator)).stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
            a2.generalMetadataDetailMapper.delColumn((String)((Object)iterator));
            a = a.getColumnInfo();
            iterator = a.iterator();
            while (iterator.hasNext()) {
                engineMetadataDetailDto = (EngineMetadataDetailDto)iterator.next();
                EngineMetadataDetail engineMetadataDetail = (EngineMetadataDetail)object.get(engineMetadataDetailDto.getColumnName());
                if (HussarUtils.isNotEmpty((Object)engineMetadataDetail)) {
                    engineMetadataDetailDto.setId(engineMetadataDetail.getId());
                    continue;
                }
                engineMetadataDetailDto.setId(IdGenerateUtils.getId());
            }
            a2.metadataDetailMapper.get(string).batchInsert((List)a);
            iterator = a.iterator();
            while (iterator.hasNext()) {
                engineMetadataDetailDto = (EngineMetadataDetailDto)iterator.next();
                DefaultCacheUtil.put((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.protected("G+G-\\7K?Q&U6U&U-P7@3]>K&U0X7.")).append(engineMetadataDetailDto.getId()).toString(), (Object)engineMetadataDetailDto, (long)3600L);
            }
            return true;
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED);
        }
    }

    public void createTable(EngineMetadataParam a) throws EngineException {
        String string;
        OracleEngineMetadataTableServiceImpl a2;
        ApiResponse apiResponse;
        EngineMetadataParam engineMetadataParam = a;
        a = engineMetadataParam.getBaseInfo();
        Object object = engineMetadataParam.getColumnInfo();
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        EngineMetadataParam engineMetadataParam2 = a;
        EngineMetadataParam engineMetadataParam3 = a;
        EngineMetadataParam engineMetadataParam4 = a;
        a.setCountColumn(Long.valueOf(object.size()));
        engineMetadataParam4.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataParam4.setVersion(Long.valueOf(0L));
        engineMetadataParam3.setStatus("1");
        engineMetadataParam2.setCharacterSet(OracleTransactionalExecuteService.final("i|z\u0010"));
        engineMetadataParam3.setId(IdGenerateUtils.getId());
        if (StringUtils.isEmpty((String)engineMetadataParam2.getTableChname())) {
            EngineMetadataParam engineMetadataParam5 = a;
            engineMetadataParam5.setTableChname(engineMetadataParam5.getTableName());
        }
        if (StringUtils.isEmpty((String)a.getTableComment())) {
            EngineMetadataParam engineMetadataParam6 = a;
            engineMetadataParam6.setTableComment(engineMetadataParam6.getTableName());
        }
        if (StringUtils.isEmpty((String)a.getRemark())) {
            EngineMetadataParam engineMetadataParam7 = a;
            engineMetadataParam7.setRemark(engineMetadataParam7.getTableName());
        }
        if ((apiResponse = a2.sysDataSourceService.getDatasourceById(string = a.getDatasourceId().toString())) == null || apiResponse.getData() == null) {
            logger.error(OracleMetadataManageTableDsServiceImpl.protected("\u6cb5\u677b\u67f1\u8b90\u5224\u6502\u637a\u6ee2\u4ff5\u601d\uff18\u6502\u637a\u6ee2]\u0016.\ti"), (Object)string);
            throw new RuntimeException(new StringBuilder().insert(0, OracleTransactionalExecuteService.final("\u6c89\u6735\u67cd\u8bde\u5218\u654c\u6346\u6eac\u4fc9\u6053\uff24\u654c\u6346\u6eacaX\u0012")).append(string).toString());
        }
        string = (SysDataSource)apiResponse.getData();
        if (Objects.isNull(string)) {
            logger.error(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST.getMessage());
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        Object object2 = object = object.iterator();
        while (object2.hasNext()) {
            ArrayList<Map<String, String>> arrayList3;
            String string2;
            apiResponse = (EngineMetadataDetail)object.next();
            if (apiResponse.getPk().equals("1")) {
                arrayList2.add(apiResponse.getColumnName());
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ApiResponse apiResponse2 = apiResponse;
            hashMap.put(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz<u\u001fq"), apiResponse2.getColumnName());
            hashMap.put(OracleTransactionalExecuteService.final("U[nMM]UZYL"), apiResponse.getRequired());
            hashMap.put(OracleMetadataManageTableDsServiceImpl.protected("}\u0001]\u001cw\u0000q"), "0");
            hashMap.put(OracleTransactionalExecuteService.final("KSDIERkSEQMR\\"), apiResponse.getColumnComment());
            hashMap.put(OracleMetadataManageTableDsServiceImpl.protected("\u0016q\u0014u\u0007x\u0006B\u0013x\u0007q"), apiResponse.getDefaultValue());
            if (StringUtils.isEmpty((String)apiResponse2.getColumnChname())) {
                ApiResponse apiResponse3 = apiResponse;
                apiResponse3.setColumnChname(apiResponse3.getColumnName());
            }
            if (StringUtils.isEmpty((String)apiResponse.getColumnComment())) {
                ApiResponse apiResponse4 = apiResponse;
                apiResponse4.setColumnComment(apiResponse4.getColumnName());
            }
            String string3 = apiResponse.getColumnType();
            if (OracleTransactionalExecuteService.final("r}qjyz").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.protected("P7W;Y3X").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.final("fieyzuk").equalsIgnoreCase(string3)) {
                string2 = new StringBuilder().insert(0, string3).append(OracleMetadataManageTableDsServiceImpl.protected("<")).append(apiResponse.getColumnLength()).append(OracleTransactionalExecuteService.final("\u0004")).append(apiResponse.getPointLength()).append(OracleMetadataManageTableDsServiceImpl.protected("=")).toString();
                arrayList3 = arrayList;
                hashMap.put(OracleTransactionalExecuteService.final("_GP]QFhQLM"), string2);
            } else if (OracleMetadataManageTableDsServiceImpl.protected("\u0016u\u0006q").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.final("\\UEY[HIQX").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.protected("\u001e{\u001cs\u0006q\n`").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.final("HMD\\").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.protected("\u0010x\u001dv").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.final("_DSJ").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.protected("\u001e{\u001cs\u0010x\u001dv").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.final("QMXAIE").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.protected("\u001fq\u0016}\u0007y\u0006q\n`").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.final("QMXAIE^DSJ").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.protected("\u0006}\u001cm\u0006q\n`").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.final("HARQ^DSJ").equalsIgnoreCase(string3)) {
                hashMap.put(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz&m\u0002q"), string3);
                arrayList3 = arrayList;
            } else {
                string2 = new StringBuilder().insert(0, apiResponse.getColumnType()).append(OracleTransactionalExecuteService.final("\u0000")).append(apiResponse.getColumnLength()).append(OracleMetadataManageTableDsServiceImpl.protected("=")).toString();
                arrayList3 = arrayList;
                hashMap.put(OracleTransactionalExecuteService.final("_GP]QFhQLM"), string2);
            }
            arrayList3.add(hashMap);
            object2 = object;
        }
        boolean bl = StringUtils.isNotEmpty(arrayList2);
        try {
            a2.dsService.createTable((EngineMetadataManageTable)a, arrayList, arrayList2, bl, string.getConnName());
            return;
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.CREATE_DATABASE_TABLE_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.CREATE_DATABASE_TABLE_FAILED, (Throwable)exception);
        }
    }

    private /* synthetic */ void private(StringBuffer a, StringBuffer a2, String a3, Map<String, String> a4, StringBuffer a5) {
        Map<String, String> map;
        block5: {
            block4: {
                block3: {
                    StringBuffer stringBuffer = a5;
                    stringBuffer.replace(a5.indexOf(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz&m\u0002q")), stringBuffer.indexOf(OracleTransactionalExecuteService.final("_GP]QFhQLM")) + OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz&m\u0002q").length(), a4.get(OracleTransactionalExecuteService.final("_GP]QFhQLM")));
                    if (HussarUtils.equals((Object)a4.get(OracleMetadataManageTableDsServiceImpl.protected("{\u001ep q\u0003a\u001bf\u0017p")), (Object)a4.get(OracleTransactionalExecuteService.final("U[nMM]UZYL")))) break block3;
                    if ("1".equals(a4.get(OracleMetadataManageTableDsServiceImpl.protected("\u001bg q\u0003a\u001bf\u0017p")))) break block4;
                    map = a4;
                    StringBuffer stringBuffer2 = a5;
                    stringBuffer2.replace(a5.indexOf(OracleTransactionalExecuteService.final("rgh\br}pd")), stringBuffer2.indexOf(OracleMetadataManageTableDsServiceImpl.protected("<[&4<A>X")) + OracleTransactionalExecuteService.final("rgh\br}pd").length(), OracleMetadataManageTableDsServiceImpl.protected("<A>X"));
                    break block5;
                }
                StringBuffer stringBuffer = a5;
                stringBuffer.replace(stringBuffer.indexOf(OracleTransactionalExecuteService.final("rgh\br}pd")), a5.indexOf(OracleMetadataManageTableDsServiceImpl.protected("<[&4<A>X")) + OracleTransactionalExecuteService.final("rgh\br}pd").length(), "");
            }
            map = a4;
        }
        if (StringUtils.isNotEmpty((String)map.get(OracleMetadataManageTableDsServiceImpl.protected("\u0016q\u0014u\u0007x\u0006B\u0013x\u0007q")))) {
            StringBuffer stringBuffer = a5;
            stringBuffer.replace(a5.indexOf(OracleTransactionalExecuteService.final("XMZIIDH~]DIM")), stringBuffer.indexOf(OracleMetadataManageTableDsServiceImpl.protected("\u0016q\u0014u\u0007x\u0006B\u0013x\u0007q")) + OracleTransactionalExecuteService.final("XMZIIDH~]DIM").length(), a4.get(OracleMetadataManageTableDsServiceImpl.protected("\u0016q\u0014u\u0007x\u0006B\u0013x\u0007q")));
        } else {
            StringBuffer stringBuffer = a5;
            stringBuffer.delete(stringBuffer.indexOf(OracleTransactionalExecuteService.final("xmziidh\b\u001bLYN]]P\\jIP]Y\u000f")), a5.indexOf(OracleMetadataManageTableDsServiceImpl.protected("6Q4U'X&4Up\u0017r\u0013a\u001e`$u\u001ea\u00173")) + OracleTransactionalExecuteService.final("xmziidh\b\u001bLYN]]P\\jIP]Y\u000f").length());
        }
        StringBuffer stringBuffer = new StringBuffer(OracleMetadataManageTableDsServiceImpl.protected("1[?Y7Z&4=ZRW=X'Y<4P`\u0013v\u001eq<u\u001fqP:Pw\u001dx\u0007y\u001cZ\u0013y\u00176R]!4Uw\u001dx\u0007y\u001cW\u001dy\u001fq\u001c`U/"));
        if (StringUtils.isNotEmpty((String)a4.get(OracleTransactionalExecuteService.final("KSDIERkSEQMR\\")))) {
            StringBuffer stringBuffer3 = stringBuffer;
            stringBuffer3.replace(stringBuffer.indexOf(OracleMetadataManageTableDsServiceImpl.protected("`\u0013v\u001eq<u\u001fq")), stringBuffer.indexOf(OracleTransactionalExecuteService.final("\\]JPMrIQM")) + OracleMetadataManageTableDsServiceImpl.protected("`\u0013v\u001eq<u\u001fq").length(), a3);
            stringBuffer3.replace(stringBuffer3.indexOf(OracleTransactionalExecuteService.final("_GP]QFrIQM")), stringBuffer.indexOf(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz<u\u001fq")) + OracleTransactionalExecuteService.final("_GP]QFrIQM").length(), a4.get(OracleMetadataManageTableDsServiceImpl.protected("z\u0017c1{\u001ea\u001fz<u\u001fq")));
            StringBuffer stringBuffer4 = stringBuffer;
            stringBuffer4.replace(stringBuffer.indexOf(OracleTransactionalExecuteService.final("KSDIERkSEQMR\\")), stringBuffer4.indexOf(OracleMetadataManageTableDsServiceImpl.protected("w\u001dx\u0007y\u001cW\u001dy\u001fq\u001c`")) + OracleTransactionalExecuteService.final("KSDIERkSEQMR\\").length(), a4.get(OracleMetadataManageTableDsServiceImpl.protected("w\u001dx\u0007y\u001cW\u001dy\u001fq\u001c`")));
            a2.append(stringBuffer);
        }
        a.append(a5);
    }

    public void editTable(EngineMetadataParam a, List<EngineMetadataDetail> a2, String a3) throws EngineException {
        String string;
        Object object;
        Object object2;
        OracleEngineMetadataTableServiceImpl a4;
        Object object3 = a;
        EngineMetadataManageTable engineMetadataManageTable = object3.getBaseInfo();
        Object object4 = object3.getColumnInfo();
        String string2 = engineMetadataManageTable.getDatasourceId().toString();
        Object object5 = a4.sysDataSourceService.getDatasourceById(string2);
        if (object5 == null || object5.getData() == null) {
            logger.error(OracleMetadataManageTableDsServiceImpl.protected("\u6cb5\u677b\u67f1\u8b90\u5224\u6502\u637a\u6ee2\u4ff5\u601d\uff18\u6502\u637a\u6ee2]\u0016.\ti"), (Object)string2);
            throw new RuntimeException(new StringBuilder().insert(0, OracleTransactionalExecuteService.final("\u6c89\u6735\u67cd\u8bde\u5218\u654c\u6346\u6eac\u4fc9\u6053\uff24\u654c\u6346\u6eacaX\u0012")).append(string2).toString());
        }
        string2 = (SysDataSource)object5.getData();
        if (Objects.isNull(string2)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        engineMetadataManageTable3.setCountColumn(Long.valueOf(object4.size()));
        engineMetadataManageTable3.setLastTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable2.setLastEditor(IdAcquisitionUtil.getCurrentUserId());
        engineMetadataManageTable2.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        if (StringUtils.isEmpty((String)engineMetadataManageTable2.getTableChname())) {
            EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
            engineMetadataManageTable4.setTableChname(engineMetadataManageTable4.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableComment())) {
            EngineMetadataManageTable engineMetadataManageTable5 = engineMetadataManageTable;
            engineMetadataManageTable5.setTableComment(engineMetadataManageTable5.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getRemark())) {
            EngineMetadataManageTable engineMetadataManageTable6 = engineMetadataManageTable;
            engineMetadataManageTable6.setRemark(engineMetadataManageTable6.getTableName());
        }
        EngineMetadataManageTable engineMetadataManageTable7 = engineMetadataManageTable;
        object5 = engineMetadataManageTable7.getTableName();
        engineMetadataManageTable7.setVersion(a4.generalMetadataManageTableMapper.getVersion(engineMetadataManageTable.getId().toString()));
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        ArrayList arrayList2 = Lists.newArrayListWithCapacity((int)3);
        ArrayList<EngineMetadataDetail> arrayList3 = new ArrayList<EngineMetadataDetail>();
        ArrayList<EngineMetadataDetail> arrayList4 = new ArrayList<EngineMetadataDetail>();
        HashSet hashSet = Sets.newHashSet();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        a = a.getDeletedCols();
        Map<String, EngineMetadataDetail> map = a2.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        EngineMetadataDetail engineMetadataDetail = object4.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        HashMap hashMap = a.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        block2: for (Map.Entry object32 : map.entrySet()) {
            if (engineMetadataDetail.get(object32.getKey()) != null || hashMap.get(object32.getKey()) != null || !((EngineMetadataDetail)object32.getValue()).getPk().equals("1")) continue;
            hashSet.add(object32.getKey());
            object2 = engineMetadataDetail.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                string = ((EngineMetadataDetailDto)object.getValue()).getOldColumnName();
                if (!((EngineMetadataDetail)object32.getValue()).getColumnName().equals(((EngineMetadataDetailDto)object.getValue()).getColumnName()) && (!"1".equals(((EngineMetadataDetailDto)object.getValue()).getPk()) || !((String)object32.getKey()).equals(string))) continue;
                hashSet.remove(object32.getKey());
                continue block2;
            }
        }
        map = a2.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        Iterator iterator = object4.iterator();
        block4: while (true) {
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                object2.setDefaultValue((object2 = (EngineMetadataDetailDto)iterator.next()).getDefaultValue() == null ? "" : object2.getDefaultValue());
                if (null != object2.getOperation() && OracleMetadataManageTableDsServiceImpl.protected("u\u0016p").equalsIgnoreCase(object2.getOperation()) && !map.containsKey(object2.getColumnName())) {
                    arrayList4.add((EngineMetadataDetail)object2);
                }
                if (object2.getPk().equals("1")) {
                    hashSet.add(object2.getColumnName());
                }
                if (object2.getOperation() == null || !OracleTransactionalExecuteService.final("YLU\\").equalsIgnoreCase(object2.getOperation())) continue block4;
                Object object6 = object2;
                object = object6.getColumnComment();
                string = object6.getColumnName();
                object4 = object6.getOldColumnName();
                engineMetadataDetail = map.get(object4);
                if (HussarUtils.isEmpty((Object)engineMetadataDetail)) {
                    logger.error(OracleMetadataManageTableDsServiceImpl.protected("\u673e\u620c\u5224\ti\u4f9c\u652d\u4e39\u5259\u76f6\u5203"), (Object)string);
                    iterator2 = iterator;
                    continue;
                }
                if (!object2.getColumnName().equalsIgnoreCase((String)object4)) {
                    hashMap = Maps.newHashMapWithExpectedSize((int)3);
                    hashMap.put(OracleTransactionalExecuteService.final("GPL\u007fGP]QFrIQM"), object4);
                    hashMap.put(OracleMetadataManageTableDsServiceImpl.protected("\u0011{\u001ea\u001fz<u\u001fq"), string);
                    arrayList.add(hashMap);
                }
                if (!StringUtils.isEmpty((String)object) && !((String)object).equals(engineMetadataDetail.getColumnComment())) {
                    hashMap = Maps.newHashMapWithExpectedSize((int)3);
                    hashMap.put(OracleTransactionalExecuteService.final("_GP]QFrIQM"), string);
                    hashMap.put(OracleMetadataManageTableDsServiceImpl.protected("w\u001dy\u001fq\u001c`"), object);
                    arrayList2.add(hashMap);
                }
                if (!object2.getRequired().equals(engineMetadataDetail.getRequired())) {
                    object2.setNeedChangeIsRequired(true);
                }
                arrayList3.add((EngineMetadataDetail)object2);
                continue block4;
            }
            break;
        }
        Iterator iterator3 = a.iterator();
        while (iterator3.hasNext()) {
            object2 = (EngineMetadataDetail)iterator3.next();
            if (map.containsKey(object2.getColumnName())) continue;
            iterator3.remove();
        }
        try {
            a4.dsService.editTable(engineMetadataManageTable, a2, a3, (String)object5, arrayList, arrayList2, arrayList3, arrayList4, hashSet, arrayList5, (List<EngineMetadataDetail>)a, map, string2.getConnName(), 1);
            return;
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(exception.getMessage());
        }
    }

    public OracleEngineMetadataTableServiceImpl() {
        OracleEngineMetadataTableServiceImpl a;
    }

    public boolean updateTableInfo(EngineMetadataParam a) throws EngineException {
        EngineMetadataDetailDto engineMetadataDetailDto;
        Object object;
        Iterator iterator;
        Object object2;
        OracleEngineMetadataTableServiceImpl a2;
        String string = a2.engineDynamicDataSourceService.getDatasourceType();
        try {
            a2.generalMetadataManageTableMapper.updateEngineMetadataManageTable(a.getBaseInfo());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.protected("G+G-\\7K?Q&U6U&U-Y3Z3S7K&U0X7.")).append(a.getBaseInfo().getId()).toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.final("{e{c`ywqmhixihice}f}oywhi~dy\u0012")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            object2 = IdAcquisitionUtil.getCurrentTenantId();
            iterator = a.getBaseInfo().getDatasourceId();
            object = new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.protected("!M!K:Q-Y7@3P3@3K?U<U5Q-@3V>QH.")).append((String)object2).append(OracleTransactionalExecuteService.final("\u0012")).append(iterator).append(OracleMetadataManageTableDsServiceImpl.protected(".")).append(a.getBaseInfo().getTableName().toUpperCase()).toString();
            DefaultCacheUtil.evict((Object)object);
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED);
        }
        object2 = a.getDeletedCols();
        if (StringUtils.isNotEmpty((Collection)a.getDeletedCols())) {
            try {
                a2.generalMetadataDetailMapper.delColInfo((List)object2);
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (EngineMetadataDetail)iterator.next();
                    DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.final("{e{c`ywqmhixihicly|}apwhi~dy\u0012")).append(object.getId()).toString());
                }
            }
            catch (Exception exception) {
                logger.error(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED.getMessage(), (Throwable)exception);
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
        iterator = a.getColumnInfo();
        object = new ArrayList();
        a = new ArrayList();
        object2 = DateUtils.getNowDate();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            engineMetadataDetailDto = (EngineMetadataDetailDto)iterator.next();
            if (engineMetadataDetailDto.getOperation() != null && OracleMetadataManageTableDsServiceImpl.protected("\u0017p\u001b`").equals(engineMetadataDetailDto.getOperation())) {
                if (null == engineMetadataDetailDto.getColumnComment() || "".equals(engineMetadataDetailDto.getColumnComment())) {
                    EngineMetadataDetailDto engineMetadataDetailDto2 = engineMetadataDetailDto;
                    engineMetadataDetailDto2.setColumnComment(engineMetadataDetailDto2.getColumnName());
                }
                if (null == engineMetadataDetailDto.getColumnChname() || "".equals(engineMetadataDetailDto.getColumnChname())) {
                    EngineMetadataDetailDto engineMetadataDetailDto3 = engineMetadataDetailDto;
                    engineMetadataDetailDto3.setColumnChname(engineMetadataDetailDto3.getColumnName());
                }
                if (null == engineMetadataDetailDto.getRemark() || "".equals(engineMetadataDetailDto.getRemark())) {
                    EngineMetadataDetailDto engineMetadataDetailDto4 = engineMetadataDetailDto;
                    engineMetadataDetailDto4.setRemark(engineMetadataDetailDto4.getColumnName());
                }
                EngineMetadataDetailDto engineMetadataDetailDto5 = engineMetadataDetailDto;
                EngineMetadataDetailDto engineMetadataDetailDto6 = engineMetadataDetailDto;
                engineMetadataDetailDto6.setLastTime(Instant.ofEpochMilli(((Date)object2).getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
                engineMetadataDetailDto5.setStatus(Integer.valueOf(1));
                engineMetadataDetailDto6.setLastEditor(IdAcquisitionUtil.getCurrentUserId());
                engineMetadataDetailDto5.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
                object.add(engineMetadataDetailDto);
                continue;
            }
            if (engineMetadataDetailDto.getOperation() == null || !OracleTransactionalExecuteService.final("IXL").equals(engineMetadataDetailDto.getOperation())) continue;
            engineMetadataDetailDto.setId(IdGenerateUtils.getId());
            if (null == engineMetadataDetailDto.getColumnComment() || "".equals(engineMetadataDetailDto.getColumnComment())) {
                EngineMetadataDetailDto engineMetadataDetailDto7 = engineMetadataDetailDto;
                engineMetadataDetailDto7.setColumnComment(engineMetadataDetailDto7.getColumnName());
            }
            if (null == engineMetadataDetailDto.getColumnChname() || "".equals(engineMetadataDetailDto.getColumnChname())) {
                EngineMetadataDetailDto engineMetadataDetailDto8 = engineMetadataDetailDto;
                engineMetadataDetailDto8.setColumnChname(engineMetadataDetailDto8.getColumnName());
            }
            if (null == engineMetadataDetailDto.getRemark() || "".equals(engineMetadataDetailDto.getRemark())) {
                EngineMetadataDetailDto engineMetadataDetailDto9 = engineMetadataDetailDto;
                engineMetadataDetailDto9.setRemark(engineMetadataDetailDto9.getColumnName());
            }
            EngineMetadataDetailDto engineMetadataDetailDto10 = engineMetadataDetailDto;
            EngineMetadataDetailDto engineMetadataDetailDto11 = engineMetadataDetailDto;
            engineMetadataDetailDto11.setStatus(Integer.valueOf(1));
            engineMetadataDetailDto10.setCreateTime(Instant.ofEpochMilli(((Date)object2).getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
            engineMetadataDetailDto11.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            engineMetadataDetailDto10.setCreator(IdAcquisitionUtil.getCurrentUserId());
            a.add(engineMetadataDetailDto);
        }
        if (StringUtils.isNotEmpty((Collection)object)) {
            iterator = object.iterator();
            while (iterator.hasNext()) {
                engineMetadataDetailDto = (EngineMetadataDetail)iterator.next();
                if (!StringUtils.isEmpty((String)engineMetadataDetailDto.getColumnLength())) continue;
                engineMetadataDetailDto.setColumnLength("0");
            }
            try {
                a2.metadataDetailMapper.get(string).batchInsert((List)object);
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    engineMetadataDetailDto = (EngineMetadataDetail)iterator.next();
                    DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.protected("G+G-\\7K?Q&U6U&U-P7@3]>K&U0X7.")).append(engineMetadataDetailDto.getId()).toString());
                }
            }
            catch (Exception exception) {
                logger.error(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED.getMessage(), (Throwable)exception);
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
        if (StringUtils.isNotEmpty((Collection)a)) {
            iterator = a.iterator();
            while (iterator.hasNext()) {
                engineMetadataDetailDto = (EngineMetadataDetail)iterator.next();
                if (!StringUtils.isEmpty((String)engineMetadataDetailDto.getColumnLength())) continue;
                engineMetadataDetailDto.setColumnLength("0");
            }
            try {
                a2.metadataDetailMapper.get(string).batchInsert((List)a);
            }
            catch (Exception exception) {
                logger.error(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED.getMessage(), (Throwable)exception);
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
        return true;
    }
}

