/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine.oracle.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.engine.metadata.dao.EngineMetadataDetailMapper;
import com.jxdinfo.hussar.engine.metadata.dao.EngineMetadataManageTableMapper;
import com.jxdinfo.hussar.engine.metadata.dao.EnginePlatformTableMapper;
import com.jxdinfo.hussar.engine.metadata.dto.EngineMetadataDetailDto;
import com.jxdinfo.hussar.engine.metadata.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.engine.metadata.exception.EngineException;
import com.jxdinfo.hussar.engine.metadata.model.EngineMetadataDetail;
import com.jxdinfo.hussar.engine.metadata.model.EngineMetadataManageTable;
import com.jxdinfo.hussar.engine.metadata.model.EngineMetadataParam;
import com.jxdinfo.hussar.engine.metadata.service.EngineDynamicDataSourceService;
import com.jxdinfo.hussar.engine.metadata.strategy.EnginePlatformTableFactory;
import com.jxdinfo.hussar.engine.metadata.util.DateUtils;
import com.jxdinfo.hussar.engine.metadata.util.IdAcquisitionUtil;
import com.jxdinfo.hussar.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.hussar.engine.metadata.util.StringUtils;
import com.jxdinfo.hussar.engine.oracle.dao.OracleTargetDataBaseMapper;
import com.jxdinfo.hussar.engine.oracle.service.OracleTransactionalExecuteService;
import com.jxdinfo.hussar.engine.oracle.service.impl.OracleMetadataManageTableDsServiceImpl;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@HussarDs(value="master")
public class OracleEngineMetadataTableServiceImpl {
    @Autowired
    private OracleMetadataManageTableDsServiceImpl dsService;
    private static final Logger logger = LoggerFactory.getLogger(OracleEngineMetadataTableServiceImpl.class);
    private Map<String, EnginePlatformTableMapper> metadataDetailMapper = EnginePlatformTableFactory.getMappers((String)OracleMetadataManageTableDsServiceImpl.case(")c0g g0g\u0000c0g-j"));
    @Autowired
    private EngineDynamicDataSourceService engineDynamicDataSourceService;
    @Autowired
    private SysDataSourceService sysDataSourceService;
    @Autowired
    private EngineMetadataManageTableMapper generalMetadataManageTableMapper;
    @Autowired
    private OracleTargetDataBaseMapper targetDataBaseOracleMapper;
    @Autowired
    private EngineMetadataDetailMapper generalMetadataDetailMapper;

    public OracleEngineMetadataTableServiceImpl() {
        OracleEngineMetadataTableServiceImpl a;
    }

    public boolean updateTableInfoNew(EngineMetadataParam a) throws EngineException {
        OracleEngineMetadataTableServiceImpl a2;
        String string = a2.engineDynamicDataSourceService.getDatasourceType();
        Object object = String.valueOf(a.getBaseInfo().getId());
        try {
            OracleEngineMetadataTableServiceImpl oracleEngineMetadataTableServiceImpl = a2;
            oracleEngineMetadataTableServiceImpl.generalMetadataManageTableMapper.updateEngineMetadataManageTable(a.getBaseInfo());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.catch("3m3k(q?y%`!p!`!k-u.u'q?`!v,qZ")).append(a.getBaseInfo().getId()).toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.case("U\u001dU\u001bN\u0001Y\tC\u0010G\u0000G\u0010G\u001bK\u0005H\u0005A\u0001Y\u0010G\u0006J\u0001<")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            String string2 = IdAcquisitionUtil.getCurrentTenantId();
            Object object2 = a.getBaseInfo().getDatasourceId();
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.catch("g9g?|%k-q4u$u4u?y!z!s%k4u\"x%\u000eZ")).append(string2).append(OracleMetadataManageTableDsServiceImpl.case("<")).append(object2).append(OracleTransactionalExecuteService.catch("Z")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            object2 = oracleEngineMetadataTableServiceImpl.generalMetadataDetailMapper.selectByTableId((String)object).stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
            a2.generalMetadataDetailMapper.delColumn((String)object);
            a = a.getColumnInfo();
            object = a.iterator();
            while (object.hasNext()) {
                EngineMetadataDetailDto engineMetadataDetailDto = (EngineMetadataDetailDto)object.next();
                EngineMetadataDetail engineMetadataDetail = (EngineMetadataDetail)object2.get(engineMetadataDetailDto.getColumnName());
                if (!HussarUtils.isNotEmpty((Object)engineMetadataDetail)) continue;
                engineMetadataDetailDto.setId(engineMetadataDetail.getId());
            }
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED);
        }
        a2.metadataDetailMapper.get(string).batchInsert((List)a);
        return true;
    }

    public boolean updateEngineMetadataManageTable(EngineMetadataParam a2) throws EngineException {
        Object object;
        EngineMetadataDetail engineMetadataDetail;
        OracleEngineMetadataTableServiceImpl a3;
        EngineMetadataParam engineMetadataParam = a2;
        EngineMetadataManageTable engineMetadataManageTable = engineMetadataParam.getBaseInfo();
        List list = engineMetadataParam.getColumnInfo();
        String string = engineMetadataManageTable.getDatasourceId().toString();
        Object object2 = a3.sysDataSourceService.getDatasourceById(string);
        if (object2 == null || object2.getData() == null) {
            logger.error(OracleTransactionalExecuteService.catch("\u6cc1\u673d\u6785\u8bd6\u5250\u6544\u630e\u6ea4\u4f81\u605b\uff6c\u6544\u630e\u6ea4)PZO\u001d"), (Object)string);
            throw new RuntimeException(new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.case("\u6ca7\u674d\u67e3\u8ba6\u5236\u6534\u6368\u6ed4\u4fe7\u602b\uff0a\u6534\u6368\u6ed4O <")).append(string).toString());
        }
        string = (SysDataSource)object2.getData();
        if (Objects.isNull(string)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        object2 = IdAcquisitionUtil.getCurrentTenantId();
        List list2 = a3.generalMetadataDetailMapper.selectColumnInfo(engineMetadataManageTable.getId().toString());
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        engineMetadataManageTable3.setCountColumn(Long.valueOf(list.size()));
        engineMetadataManageTable3.setLastTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable2.setLastEditor(IdAcquisitionUtil.getCurrentUserId());
        engineMetadataManageTable2.setTenantId((String)object2);
        if (StringUtils.isEmpty((String)engineMetadataManageTable2.getTableChname())) {
            EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
            engineMetadataManageTable4.setTableChname(engineMetadataManageTable4.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableComment())) {
            EngineMetadataManageTable engineMetadataManageTable5 = engineMetadataManageTable;
            engineMetadataManageTable5.setTableComment(engineMetadataManageTable5.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getRemark())) {
            EngineMetadataManageTable engineMetadataManageTable6 = engineMetadataManageTable;
            engineMetadataManageTable6.setRemark(engineMetadataManageTable6.getTableName());
        }
        OracleEngineMetadataTableServiceImpl oracleEngineMetadataTableServiceImpl = a3;
        object2 = oracleEngineMetadataTableServiceImpl.generalMetadataManageTableMapper.getTableNameById(engineMetadataManageTable.getId().toString());
        String string2 = engineMetadataManageTable.getTableName();
        Serializable serializable = oracleEngineMetadataTableServiceImpl.generalMetadataManageTableMapper.getVersion(engineMetadataManageTable.getId().toString());
        engineMetadataManageTable.setVersion((Long)serializable);
        serializable = new ArrayList();
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)3);
        ArrayList<EngineMetadataDetail> arrayList2 = new ArrayList<EngineMetadataDetail>();
        ArrayList<EngineMetadataDetail> arrayList3 = new ArrayList<EngineMetadataDetail>();
        HashSet hashSet = Sets.newHashSet();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        List list3 = a2.getDeletedCols();
        Map<String, EngineMetadataDetail> map = list2.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        Object object3 = list.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        Object object4 = list3.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        block2: for (Map.Entry object5 : map.entrySet()) {
            if (object3.get(object5.getKey()) != null || object4.get(object5.getKey()) != null || !((EngineMetadataDetail)object5.getValue()).getPk().equals("1")) continue;
            hashSet.add(object5.getKey());
            engineMetadataDetail = object3.entrySet().iterator();
            while (engineMetadataDetail.hasNext()) {
                object = engineMetadataDetail.next();
                if (!((EngineMetadataDetail)object5.getValue()).getId().equals(((EngineMetadataDetail)object.getValue()).getId())) continue;
                hashSet.remove(object5.getKey());
                continue block2;
            }
        }
        map = list2.stream().collect(Collectors.toMap(EngineMetadataDetail::getId, Function.identity())).entrySet().stream().collect(Collectors.toMap(a -> Long.toString((Long)a.getKey()), Map.Entry::getValue));
        object = list.iterator();
        while (object.hasNext()) {
            HashMap hashMap;
            String string3;
            list.setDefaultValue((list = (EngineMetadataDetailDto)object.next()).getDefaultValue() == null ? "" : list.getDefaultValue());
            List list4 = list;
            list4.setLastTime(LocalDateTime.now());
            list4.setStatus(1);
            if (null != list.getOperation() && OracleTransactionalExecuteService.catch("\u0001P\u0004").equalsIgnoreCase(list.getOperation())) {
                List list5 = list;
                list5.setId(IdGenerateUtils.getId());
                list5.setCreateTime(LocalDateTime.now());
                arrayList3.add((EngineMetadataDetail)list5);
            }
            if (list.getPk().equals("1")) {
                hashSet.add(list.getColumnName());
            }
            if ((string3 = list.getId().toString()) == null || !OracleMetadataManageTableDsServiceImpl.case("!b-r").equalsIgnoreCase(list.getOperation())) continue;
            engineMetadataDetail = map.get(string3);
            List list6 = list;
            object3 = list6.getColumnComment();
            object4 = list6.getColumnName();
            if (!((String)object4).equals(engineMetadataDetail.getColumnName())) {
                hashMap = Maps.newHashMapWithExpectedSize((int)3);
                hashMap.put(OracleTransactionalExecuteService.catch("\u000fX\u0004w\u000fX\u0015Y\u000ez\u0001Y\u0005"), engineMetadataDetail.getColumnName());
                hashMap.put(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\ng)c"), object4);
                serializable.add(hashMap);
            }
            if (!StringUtils.isEmpty((String)object3) && !((String)object3).equals(engineMetadataDetail.getColumnComment())) {
                hashMap = Maps.newHashMapWithExpectedSize((int)3);
                hashMap.put(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000ez\u0001Y\u0005"), object4);
                hashMap.put(OracleMetadataManageTableDsServiceImpl.case("e+k)c*r"), object3);
                arrayList.add(hashMap);
            }
            if (!list.getRequired().equals(map.get(list.getId().toString()).getRequired())) {
                list.setNeedChangeIsRequired(true);
            }
            arrayList2.add((EngineMetadataDetail)list);
        }
        try {
            a3.dsService.editTable(engineMetadataManageTable, list2, (String)object2, string2, (List<Map<String, String>>)((Object)serializable), arrayList, arrayList2, arrayList3, hashSet, arrayList4, list3, map, string.getConnName(), 0);
        }
        catch (Exception exception) {
            logger.error(OracleTransactionalExecuteService.catch("\u6510\u635a\u5ef3\u64f9\u4f3c\u5f36\u5e58"), (Throwable)exception);
            throw new EngineException(exception.getMessage());
        }
        return a3.updateTableInfo(a2);
    }

    public boolean insertTableInfo(EngineMetadataParam a3) throws EngineException {
        Object object;
        OracleEngineMetadataTableServiceImpl a2;
        Object object2 = a3.getBaseInfo();
        String string = a2.engineDynamicDataSourceService.getDatasourceType();
        try {
            EngineMetadataManageTable engineMetadataManageTable = object2;
            EngineMetadataManageTable engineMetadataManageTable2 = object2;
            engineMetadataManageTable2.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            engineMetadataManageTable.setStatus("1");
            engineMetadataManageTable2.setCreator(IdAcquisitionUtil.getCurrentUserId());
            engineMetadataManageTable.setCreateTime(LocalDateTime.now());
            engineMetadataManageTable.setLastEditor(engineMetadataManageTable.getCreator());
            engineMetadataManageTable.setLastTime(LocalDateTime.now());
            if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableChname())) {
                EngineMetadataManageTable engineMetadataManageTable3 = object2;
                engineMetadataManageTable3.setTableChname(engineMetadataManageTable3.getTableName());
            }
            if (StringUtils.isEmpty((String)object2.getTableComment())) {
                EngineMetadataManageTable engineMetadataManageTable4 = object2;
                engineMetadataManageTable4.setTableComment(engineMetadataManageTable4.getTableName());
            }
            if (StringUtils.isEmpty((String)object2.getRemark())) {
                EngineMetadataManageTable engineMetadataManageTable5 = object2;
                engineMetadataManageTable5.setRemark(engineMetadataManageTable5.getTableName());
            }
            EngineMetadataManageTable engineMetadataManageTable6 = object2;
            engineMetadataManageTable6.setRemark(engineMetadataManageTable6.getTableComment());
            a2.generalMetadataManageTableMapper.insertEngineMetadataManageTable(object2);
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.INSERT_TABLE_INFORMATION_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.INSERT_TABLE_INFORMATION_FAILED, (Throwable)exception);
        }
        List list = a3.getColumnInfo();
        a3 = list.iterator();
        Iterator iterator = a3;
        while (iterator.hasNext()) {
            object = (EngineMetadataDetail)a3.next();
            iterator = a3;
            EngineMetadataDetail engineMetadataDetail = object;
            Object object3 = object;
            object.setId(IdGenerateUtils.getId());
            object3.setTableId(object2.getId());
            engineMetadataDetail.setStatus(Integer.valueOf(1));
            object3.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
            engineMetadataDetail.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            engineMetadataDetail.setCreator(IdAcquisitionUtil.getCurrentUserId());
        }
        try {
            a3 = Lists.partition((List)list, (int)10);
            object = a3.iterator();
            while (object.hasNext()) {
                object2 = (List)object.next();
                a2.metadataDetailMapper.get(string).batchInsert((List)object2);
            }
        }
        catch (Exception a3) {
            logger.error(EngineExceptionEnum.INSERT_COLUMN_INFORMATION_FAILED.getMessage(), (Throwable)a3);
            throw new EngineException(EngineExceptionEnum.INSERT_COLUMN_INFORMATION_FAILED, (Throwable)a3);
        }
        return true;
    }

    public boolean insertView(EngineMetadataParam a) throws EngineException {
        OracleEngineMetadataTableServiceImpl a2;
        Object object;
        EngineMetadataParam engineMetadataParam = a;
        EngineMetadataManageTable engineMetadataManageTable = engineMetadataParam.getBaseInfo();
        Object object2 = engineMetadataParam.getColumnInfo();
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
        engineMetadataManageTable4.setCountColumn(Long.valueOf(object2.size()));
        engineMetadataManageTable4.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable3.setVersion(Long.valueOf(0L));
        engineMetadataManageTable3.setStatus("1");
        engineMetadataManageTable2.setViewFlag("1");
        engineMetadataManageTable2.setCharacterSet(OracleMetadataManageTableDsServiceImpl.case("\u0011R\u0002>"));
        engineMetadataManageTable2.setId(IdGenerateUtils.getId());
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = (EngineMetadataDetail)object2.next();
            if (StringUtils.isEmpty((String)object.getPk())) {
                object.setPk("0");
            }
            EngineMetadataDetail engineMetadataDetail = object;
            engineMetadataDetail.setIncre("0");
            engineMetadataDetail.setRequired("0");
            if (StringUtils.isEmpty((String)object.getColumnChname())) {
                EngineMetadataDetail engineMetadataDetail2 = object;
                engineMetadataDetail2.setColumnChname(engineMetadataDetail2.getColumnName());
            }
            if (!StringUtils.isEmpty((String)object.getColumnComment())) continue;
            EngineMetadataDetail engineMetadataDetail3 = object;
            engineMetadataDetail3.setColumnComment(engineMetadataDetail3.getColumnName());
        }
        object2 = engineMetadataManageTable.getDatasourceId().toString();
        object = a2.sysDataSourceService.getDatasourceById((String)object2);
        if (object == null || object.getData() == null) {
            logger.error(OracleTransactionalExecuteService.catch("\u6cc1\u673d\u6785\u8bd6\u5250\u6544\u630e\u6ea4\u4f81\u605b\uff6c\u6544\u630e\u6ea4)PZO\u001d"), object2);
            throw new RuntimeException(new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.case("\u6ca7\u674d\u67e3\u8ba6\u5236\u6534\u6368\u6ed4\u4fe7\u602b\uff0a\u6534\u6368\u6ed4O <")).append((String)object2).toString());
        }
        if (Objects.isNull((SysDataSource)object.getData())) {
            logger.error(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST.getMessage());
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        object2 = IdAcquisitionUtil.getCurrentTenantId();
        if (!StringUtils.isNull((Object)(engineMetadataManageTable = a2.generalMetadataManageTableMapper.selectEngineMetadataManageTableByTableName(engineMetadataManageTable)))) {
            a2.generalMetadataManageTableMapper.deleteEngineMetadataManageTableById(engineMetadataManageTable.getId().toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.catch("3m3k(q?y%`!p!`!k-u.u'q?`!v,qZ")).append(a.getBaseInfo().getId()).toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.case("U\u001dU\u001bN\u0001Y\tC\u0010G\u0000G\u0010G\u001bK\u0005H\u0005A\u0001Y\u0010G\u0006J\u0001<")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            object = a.getBaseInfo().getDatasourceId();
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.catch("g9g?|%k-q4u$u4u?y!z!s%k4u\"x%\u000eZ")).append((String)object2).append(OracleMetadataManageTableDsServiceImpl.case("<")).append(object).append(OracleTransactionalExecuteService.catch("Z")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            a2.generalMetadataDetailMapper.delColumn(engineMetadataManageTable.getId().toString());
        }
        return a2.insertTableInfo(a);
    }

    private /* synthetic */ void if(StringBuffer a, StringBuffer a2, String a3, Map<String, String> a4, StringBuffer a5) {
        Map<String, String> map;
        block5: {
            block4: {
                block3: {
                    StringBuffer stringBuffer = a5;
                    stringBuffer.replace(a5.indexOf(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000e`\u0019D\u0005")), stringBuffer.indexOf(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\u0010\u007f4c")) + OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000e`\u0019D\u0005").length(), a4.get(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\u0010\u007f4c")));
                    if (HussarUtils.equals((Object)a4.get(OracleTransactionalExecuteService.catch("\u000fX\u0004f\u0005E\u0015]\u0012Q\u0004")), (Object)a4.get(OracleMetadataManageTableDsServiceImpl.case("-u\u0016c5s-t!b")))) break block3;
                    if ("1".equals(a4.get(OracleTransactionalExecuteService.catch("]\u0013f\u0005E\u0015]\u0012Q\u0004")))) break block4;
                    map = a4;
                    StringBuffer stringBuffer2 = a5;
                    stringBuffer2.replace(a5.indexOf(OracleMetadataManageTableDsServiceImpl.case("\nI\u0010&\nS\bJ")), stringBuffer2.indexOf(OracleTransactionalExecuteService.catch("z/`@z5x,")) + OracleMetadataManageTableDsServiceImpl.case("\nI\u0010&\nS\bJ").length(), OracleTransactionalExecuteService.catch("z5x,"));
                    break block5;
                }
                StringBuffer stringBuffer = a5;
                stringBuffer.replace(stringBuffer.indexOf(OracleMetadataManageTableDsServiceImpl.case("\nI\u0010&\nS\bJ")), a5.indexOf(OracleTransactionalExecuteService.catch("z/`@z5x,")) + OracleMetadataManageTableDsServiceImpl.case("\nI\u0010&\nS\bJ").length(), "");
            }
            map = a4;
        }
        if (StringUtils.isNotEmpty((String)map.get(OracleTransactionalExecuteService.catch("P\u0005R\u0001A\f@6U\fA\u0005")))) {
            StringBuffer stringBuffer = a5;
            stringBuffer.replace(a5.indexOf(OracleMetadataManageTableDsServiceImpl.case(" c\"g1j0P%j1c")), stringBuffer.indexOf(OracleTransactionalExecuteService.catch("P\u0005R\u0001A\f@6U\fA\u0005")) + OracleMetadataManageTableDsServiceImpl.case(" c\"g1j0P%j1c").length(), a4.get(OracleTransactionalExecuteService.catch("P\u0005R\u0001A\f@6U\fA\u0005")));
        } else {
            StringBuffer stringBuffer = a5;
            stringBuffer.delete(stringBuffer.indexOf(OracleMetadataManageTableDsServiceImpl.case("\u0000C\u0002G\u0011J\u0010&cb!`%s(r\u0012g(s!!")), a5.indexOf(OracleTransactionalExecuteService.catch("p%r!a,`@\u0013\u0004Q\u0006U\u0015X\u0014b\u0001X\u0015QG")) + OracleMetadataManageTableDsServiceImpl.case("\u0000C\u0002G\u0011J\u0010&cb!`%s(r\u0012g(s!!").length());
        }
        StringBuffer stringBuffer = new StringBuffer(OracleTransactionalExecuteService.catch("w/y-q.`@{.\u0014#{,a-z@\u0016\u0014U\u0002X\u0005z\u0001Y\u0005\u0016N\u0016\u0003[\fA\rZ.U\rQB\u0014)g@\u0013\u0003[\fA\rZ#[\rY\u0005Z\u0014\u0013["));
        if (StringUtils.isNotEmpty((String)a4.get(OracleMetadataManageTableDsServiceImpl.case("e+j1k*E+k)c*r")))) {
            StringBuffer stringBuffer3 = stringBuffer;
            stringBuffer3.replace(stringBuffer.indexOf(OracleTransactionalExecuteService.catch("\u0014U\u0002X\u0005z\u0001Y\u0005")), stringBuffer.indexOf(OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c")) + OracleTransactionalExecuteService.catch("\u0014U\u0002X\u0005z\u0001Y\u0005").length(), a3);
            stringBuffer3.replace(stringBuffer3.indexOf(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\ng)c")), stringBuffer.indexOf(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000ez\u0001Y\u0005")) + OracleMetadataManageTableDsServiceImpl.case("'i(s)h\ng)c").length(), a4.get(OracleTransactionalExecuteService.catch("\u000eQ\u0017w\u000fX\u0015Y\u000ez\u0001Y\u0005")));
            StringBuffer stringBuffer4 = stringBuffer;
            stringBuffer4.replace(stringBuffer.indexOf(OracleMetadataManageTableDsServiceImpl.case("e+j1k*E+k)c*r")), stringBuffer4.indexOf(OracleTransactionalExecuteService.catch("\u0003[\fA\rZ#[\rY\u0005Z\u0014")) + OracleMetadataManageTableDsServiceImpl.case("e+j1k*E+k)c*r").length(), a4.get(OracleTransactionalExecuteService.catch("\u0003[\fA\rZ#[\rY\u0005Z\u0014")));
            a2.append(stringBuffer);
        }
        a.append(a5);
    }

    public void createTable(EngineMetadataParam a) throws EngineException {
        String string;
        OracleEngineMetadataTableServiceImpl a2;
        ApiResponse apiResponse;
        EngineMetadataParam engineMetadataParam = a;
        a = engineMetadataParam.getBaseInfo();
        Object object = engineMetadataParam.getColumnInfo();
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        EngineMetadataParam engineMetadataParam2 = a;
        EngineMetadataParam engineMetadataParam3 = a;
        EngineMetadataParam engineMetadataParam4 = a;
        a.setCountColumn(Long.valueOf(object.size()));
        engineMetadataParam4.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataParam4.setVersion(Long.valueOf(0L));
        engineMetadataParam3.setStatus("1");
        engineMetadataParam2.setCharacterSet(OracleMetadataManageTableDsServiceImpl.case("\u0011R\u0002>"));
        engineMetadataParam3.setId(IdGenerateUtils.getId());
        if (StringUtils.isEmpty((String)engineMetadataParam2.getTableChname())) {
            EngineMetadataParam engineMetadataParam5 = a;
            engineMetadataParam5.setTableChname(engineMetadataParam5.getTableName());
        }
        if (StringUtils.isEmpty((String)a.getTableComment())) {
            EngineMetadataParam engineMetadataParam6 = a;
            engineMetadataParam6.setTableComment(engineMetadataParam6.getTableName());
        }
        if (StringUtils.isEmpty((String)a.getRemark())) {
            EngineMetadataParam engineMetadataParam7 = a;
            engineMetadataParam7.setRemark(engineMetadataParam7.getTableName());
        }
        if ((apiResponse = a2.sysDataSourceService.getDatasourceById(string = a.getDatasourceId().toString())) == null || apiResponse.getData() == null) {
            logger.error(OracleTransactionalExecuteService.catch("\u6cc1\u673d\u6785\u8bd6\u5250\u6544\u630e\u6ea4\u4f81\u605b\uff6c\u6544\u630e\u6ea4)PZO\u001d"), (Object)string);
            throw new RuntimeException(new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.case("\u6ca7\u674d\u67e3\u8ba6\u5236\u6534\u6368\u6ed4\u4fe7\u602b\uff0a\u6534\u6368\u6ed4O <")).append(string).toString());
        }
        string = (SysDataSource)apiResponse.getData();
        if (Objects.isNull(string)) {
            logger.error(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST.getMessage());
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        Object object2 = object = object.iterator();
        while (object2.hasNext()) {
            ArrayList<Map<String, String>> arrayList3;
            String string2;
            apiResponse = (EngineMetadataDetail)object.next();
            if (apiResponse.getPk().equals("1")) {
                arrayList2.add(apiResponse.getColumnName());
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ApiResponse apiResponse2 = apiResponse;
            hashMap.put(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000ez\u0001Y\u0005"), apiResponse2.getColumnName());
            hashMap.put(OracleMetadataManageTableDsServiceImpl.case("-u\u0016c5s-t!b"), apiResponse.getRequired());
            hashMap.put(OracleTransactionalExecuteService.catch("\tG)Z\u0003F\u0005"), "0");
            hashMap.put(OracleMetadataManageTableDsServiceImpl.case("e+j1k*E+k)c*r"), apiResponse.getColumnComment());
            hashMap.put(OracleTransactionalExecuteService.catch("P\u0005R\u0001A\f@6U\fA\u0005"), apiResponse.getDefaultValue());
            if (StringUtils.isEmpty((String)apiResponse2.getColumnChname())) {
                ApiResponse apiResponse3 = apiResponse;
                apiResponse3.setColumnChname(apiResponse3.getColumnName());
            }
            if (StringUtils.isEmpty((String)apiResponse.getColumnComment())) {
                ApiResponse apiResponse4 = apiResponse;
                apiResponse4.setColumnComment(apiResponse4.getColumnName());
            }
            String string3 = apiResponse.getColumnType();
            if (OracleMetadataManageTableDsServiceImpl.case("\nS\tD\u0001T").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.catch("$q#}-u,").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.case("H\u0011K\u0001T\rE").equalsIgnoreCase(string3)) {
                string2 = new StringBuilder().insert(0, string3).append(OracleTransactionalExecuteService.catch("H")).append(apiResponse.getColumnLength()).append(OracleMetadataManageTableDsServiceImpl.case("*")).append(apiResponse.getPointLength()).append(OracleTransactionalExecuteService.catch("I")).toString();
                arrayList3 = arrayList;
                hashMap.put(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\u0010\u007f4c"), string2);
            } else if (OracleTransactionalExecuteService.catch("P\u0001@\u0005").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.case("r-k!u0g)v").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.catch("X\u000fZ\u0007@\u0005L\u0014").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.case("0c<r").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.catch("V\f[\u0002").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.case("'j+d").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.catch("X\u000fZ\u0007V\f[\u0002").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.case(")c o1k").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.catch("Y\u0005P\tA\r@\u0005L\u0014").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.case(")c o1k&j+d").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.catch("@\tZ\u0019@\u0005L\u0014").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.case("0o*\u007f&j+d").equalsIgnoreCase(string3)) {
                hashMap.put(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000e`\u0019D\u0005"), string3);
                arrayList3 = arrayList;
            } else {
                string2 = new StringBuilder().insert(0, apiResponse.getColumnType()).append(OracleMetadataManageTableDsServiceImpl.case(".")).append(apiResponse.getColumnLength()).append(OracleTransactionalExecuteService.catch("I")).toString();
                arrayList3 = arrayList;
                hashMap.put(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\u0010\u007f4c"), string2);
            }
            arrayList3.add(hashMap);
            object2 = object;
        }
        boolean bl = StringUtils.isNotEmpty(arrayList2);
        try {
            a2.dsService.createTable((EngineMetadataManageTable)a, arrayList, arrayList2, bl, string.getConnName());
            return;
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.CREATE_DATABASE_TABLE_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.CREATE_DATABASE_TABLE_FAILED, (Throwable)exception);
        }
    }

    public boolean insertEngineMetadataManageTable(EngineMetadataParam a) throws EngineException {
        String string;
        Serializable serializable;
        EngineMetadataDetail engineMetadataDetail;
        String string2;
        OracleEngineMetadataTableServiceImpl a2;
        Object object;
        EngineMetadataParam engineMetadataParam = a;
        EngineMetadataManageTable engineMetadataManageTable = engineMetadataParam.getBaseInfo();
        Object object2 = engineMetadataParam.getColumnInfo();
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
        engineMetadataManageTable.setCountColumn(Long.valueOf(object2.size()));
        engineMetadataManageTable4.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable4.setVersion(Long.valueOf(0L));
        engineMetadataManageTable3.setStatus("1");
        engineMetadataManageTable2.setCharacterSet(OracleTransactionalExecuteService.catch("a4rX"));
        engineMetadataManageTable3.setId(IdGenerateUtils.getId());
        if (StringUtils.isEmpty((String)engineMetadataManageTable2.getTableChname())) {
            EngineMetadataManageTable engineMetadataManageTable5 = engineMetadataManageTable;
            engineMetadataManageTable5.setTableChname(engineMetadataManageTable5.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableComment())) {
            EngineMetadataManageTable engineMetadataManageTable6 = engineMetadataManageTable;
            engineMetadataManageTable6.setTableComment(engineMetadataManageTable6.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getRemark())) {
            EngineMetadataManageTable engineMetadataManageTable7 = engineMetadataManageTable;
            engineMetadataManageTable7.setRemark(engineMetadataManageTable7.getTableName());
        }
        if ((object = a2.sysDataSourceService.getDatasourceById(string2 = engineMetadataManageTable.getDatasourceId().toString())) == null || object.getData() == null) {
            logger.error(OracleMetadataManageTableDsServiceImpl.case("\u6ca7\u674d\u67e3\u8ba6\u5236\u6534\u6368\u6ed4\u4fe7\u602b\uff0a\u6534\u6368\u6ed4O <?{"), (Object)string2);
            throw new RuntimeException(new StringBuilder().insert(0, OracleTransactionalExecuteService.catch("\u6cc1\u673d\u6785\u8bd6\u5250\u6544\u630e\u6ea4\u4f81\u605b\uff6c\u6544\u630e\u6ea4)PZ")).append(string2).toString());
        }
        string2 = (SysDataSource)object.getData();
        if (Objects.isNull(string2)) {
            logger.error(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST.getMessage());
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        object = IdAcquisitionUtil.getCurrentTenantId();
        Object object3 = object2 = object2.iterator();
        while (object3.hasNext()) {
            ArrayList<Map<String, String>> arrayList3;
            String string3;
            engineMetadataDetail = (EngineMetadataDetail)object2.next();
            if (engineMetadataDetail.getPk().equals("1")) {
                arrayList2.add(engineMetadataDetail.getColumnName());
            }
            serializable = new HashMap<String, String>();
            EngineMetadataDetail engineMetadataDetail2 = engineMetadataDetail;
            serializable.put(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\ng)c"), engineMetadataDetail2.getColumnName());
            serializable.put(OracleTransactionalExecuteService.catch("]\u0013f\u0005E\u0015]\u0012Q\u0004"), engineMetadataDetail.getRequired());
            serializable.put(OracleMetadataManageTableDsServiceImpl.case("o7O*e6c"), "0");
            serializable.put(OracleTransactionalExecuteService.catch("\u0003[\fA\rZ#[\rY\u0005Z\u0014"), engineMetadataDetail.getColumnComment());
            serializable.put(OracleMetadataManageTableDsServiceImpl.case(" c\"g1j0P%j1c"), engineMetadataDetail.getDefaultValue());
            if (StringUtils.isEmpty((String)engineMetadataDetail2.getColumnChname())) {
                EngineMetadataDetail engineMetadataDetail3 = engineMetadataDetail;
                engineMetadataDetail3.setColumnChname(engineMetadataDetail3.getColumnName());
            }
            if (StringUtils.isEmpty((String)engineMetadataDetail.getColumnComment())) {
                EngineMetadataDetail engineMetadataDetail4 = engineMetadataDetail;
                engineMetadataDetail4.setColumnComment(engineMetadataDetail4.getColumnName());
            }
            if (engineMetadataDetail.getColumnLength() != null) {
                serializable.put(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000ex\u0005Z\u0007@\b"), engineMetadataDetail.getColumnLength().toString());
            }
            if (engineMetadataDetail.getPointLength() != null) {
                serializable.put(OracleMetadataManageTableDsServiceImpl.case("v+o*r\bc*a0n"), engineMetadataDetail.getPointLength().toString());
            }
            string = engineMetadataDetail.getColumnType();
            if (OracleTransactionalExecuteService.catch("z5y\"q2").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.case("B\u0001E\rK\u0005J").equalsIgnoreCase(string) || OracleTransactionalExecuteService.catch(".a-q2}#").equalsIgnoreCase(string)) {
                string3 = new StringBuilder().insert(0, string).append(OracleMetadataManageTableDsServiceImpl.case(".")).append(engineMetadataDetail.getColumnLength()).append(OracleTransactionalExecuteService.catch("L")).append(engineMetadataDetail.getPointLength()).append(OracleMetadataManageTableDsServiceImpl.case("/")).toString();
                arrayList3 = arrayList;
                serializable.put(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000e`\u0019D\u0005"), string3);
            } else if (OracleMetadataManageTableDsServiceImpl.case(" g0c").equalsIgnoreCase(string) || OracleTransactionalExecuteService.catch("\u0014]\rQ\u0013@\u0001Y\u0010").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.case("(i*a0c<r").equalsIgnoreCase(string) || OracleTransactionalExecuteService.catch("@\u0005L\u0014").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.case("&j+d").equalsIgnoreCase(string) || OracleTransactionalExecuteService.catch("W\f[\u0002").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.case("(i*a&j+d").equalsIgnoreCase(string) || OracleTransactionalExecuteService.catch("Y\u0005P\tA\r").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.case(")c o1k0c<r").equalsIgnoreCase(string) || OracleTransactionalExecuteService.catch("Y\u0005P\tA\rV\f[\u0002").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.case("0o*\u007f0c<r").equalsIgnoreCase(string) || OracleTransactionalExecuteService.catch("@\tZ\u0019V\f[\u0002").equalsIgnoreCase(string)) {
                serializable.put(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\u0010\u007f4c"), string);
                arrayList3 = arrayList;
            } else {
                string3 = new StringBuilder().insert(0, engineMetadataDetail.getColumnType()).append(OracleTransactionalExecuteService.catch("H")).append(engineMetadataDetail.getColumnLength()).append(OracleMetadataManageTableDsServiceImpl.case("/")).toString();
                arrayList3 = arrayList;
                serializable.put(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000e`\u0019D\u0005"), string3);
            }
            arrayList3.add((Map<String, String>)((Object)serializable));
            object3 = object2;
        }
        boolean bl = StringUtils.isNotEmpty(arrayList2);
        try {
            a2.dsService.createTable(engineMetadataManageTable, arrayList, arrayList2, bl, string2.getConnName());
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.CREATE_DATABASE_TABLE_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.CREATE_DATABASE_TABLE_FAILED, (Throwable)exception);
        }
        engineMetadataDetail = a2.generalMetadataManageTableMapper.selectEngineMetadataManageTableByTableName(engineMetadataManageTable);
        if (!StringUtils.isNull((Object)engineMetadataDetail)) {
            a2.generalMetadataManageTableMapper.deleteEngineMetadataManageTableById(engineMetadataDetail.getId().toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.case("U\u001dU\u001bN\u0001Y\tC\u0010G\u0000G\u0010G\u001bK\u0005H\u0005A\u0001Y\u0010G\u0006J\u0001<")).append(engineMetadataDetail.getId()).toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.catch("3m3k(q?y%`!p!`!k-u.u'q?`!v,qZ")).append(engineMetadataDetail.getTableName().toUpperCase()).toString());
            serializable = engineMetadataDetail.getDatasourceId();
            string = new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.case("\u0017_\u0017Y\fC\u001bK\u0001R\u0005B\u0005R\u0005Y\tG\nG\u0003C\u001bR\u0005D\bC~<")).append((String)object).append(OracleTransactionalExecuteService.catch("Z")).append(serializable).append(OracleMetadataManageTableDsServiceImpl.case("<")).append(a.getBaseInfo().getTableName().toUpperCase()).toString();
            DefaultCacheUtil.evict((Object)string);
            a2.generalMetadataDetailMapper.delColumn(engineMetadataDetail.getId().toString());
        }
        return a2.insertTableInfo(a);
    }

    public EngineMetadataManageTable renderBaseInfo(EngineMetadataParam a) {
        EngineMetadataParam engineMetadataParam = a;
        a = engineMetadataParam.getBaseInfo();
        List list = engineMetadataParam.getColumnInfo();
        EngineMetadataParam engineMetadataParam2 = a;
        EngineMetadataParam engineMetadataParam3 = a;
        engineMetadataParam3.setCountColumn(Long.valueOf(list.size()));
        engineMetadataParam3.setLastTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataParam2.setLastEditor(IdAcquisitionUtil.getCurrentUserId());
        engineMetadataParam2.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        if (StringUtils.isEmpty((String)engineMetadataParam2.getTableChname())) {
            EngineMetadataParam engineMetadataParam4 = a;
            engineMetadataParam4.setTableChname(engineMetadataParam4.getTableName());
        }
        if (StringUtils.isEmpty((String)a.getTableComment())) {
            EngineMetadataParam engineMetadataParam5 = a;
            engineMetadataParam5.setTableComment(engineMetadataParam5.getTableName());
        }
        if (StringUtils.isEmpty((String)a.getRemark())) {
            EngineMetadataParam engineMetadataParam6 = a;
            engineMetadataParam6.setRemark(engineMetadataParam6.getTableName());
        }
        return a;
    }

    public boolean updateTableInfo(EngineMetadataParam a) throws EngineException {
        EngineMetadataDetailDto engineMetadataDetailDto;
        Object object;
        Iterator iterator;
        Object object2;
        OracleEngineMetadataTableServiceImpl a2;
        String string = a2.engineDynamicDataSourceService.getDatasourceType();
        try {
            a2.generalMetadataManageTableMapper.updateEngineMetadataManageTable(a.getBaseInfo());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.case("U\u001dU\u001bN\u0001Y\tC\u0010G\u0000G\u0010G\u001bK\u0005H\u0005A\u0001Y\u0010G\u0006J\u0001<")).append(a.getBaseInfo().getId()).toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.catch("3m3k(q?y%`!p!`!k-u.u'q?`!v,qZ")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            object2 = IdAcquisitionUtil.getCurrentTenantId();
            iterator = a.getBaseInfo().getDatasourceId();
            object = new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.case("\u0017_\u0017Y\fC\u001bK\u0001R\u0005B\u0005R\u0005Y\tG\nG\u0003C\u001bR\u0005D\bC~<")).append((String)object2).append(OracleTransactionalExecuteService.catch("Z")).append(iterator).append(OracleMetadataManageTableDsServiceImpl.case("<")).append(a.getBaseInfo().getTableName().toUpperCase()).toString();
            DefaultCacheUtil.evict((Object)object);
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED);
        }
        object2 = a.getDeletedCols();
        if (StringUtils.isNotEmpty((Collection)a.getDeletedCols())) {
            try {
                a2.generalMetadataDetailMapper.delColInfo((List)object2);
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (EngineMetadataDetail)iterator.next();
                    DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.catch("3m3k(q?y%`!p!`!k$q4u)x?`!v,qZ")).append(object.getId()).toString());
                }
            }
            catch (Exception exception) {
                logger.error(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED.getMessage(), (Throwable)exception);
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
        iterator = a.getColumnInfo();
        object = new ArrayList();
        a = new ArrayList();
        object2 = DateUtils.getNowDate();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            engineMetadataDetailDto = (EngineMetadataDetailDto)iterator.next();
            if (engineMetadataDetailDto.getOperation() != null && OracleMetadataManageTableDsServiceImpl.case("!b-r").equals(engineMetadataDetailDto.getOperation())) {
                if (null == engineMetadataDetailDto.getColumnComment() || "".equals(engineMetadataDetailDto.getColumnComment())) {
                    EngineMetadataDetailDto engineMetadataDetailDto2 = engineMetadataDetailDto;
                    engineMetadataDetailDto2.setColumnComment(engineMetadataDetailDto2.getColumnName());
                }
                if (null == engineMetadataDetailDto.getColumnChname() || "".equals(engineMetadataDetailDto.getColumnChname())) {
                    EngineMetadataDetailDto engineMetadataDetailDto3 = engineMetadataDetailDto;
                    engineMetadataDetailDto3.setColumnChname(engineMetadataDetailDto3.getColumnName());
                }
                if (null == engineMetadataDetailDto.getRemark() || "".equals(engineMetadataDetailDto.getRemark())) {
                    EngineMetadataDetailDto engineMetadataDetailDto4 = engineMetadataDetailDto;
                    engineMetadataDetailDto4.setRemark(engineMetadataDetailDto4.getColumnName());
                }
                EngineMetadataDetailDto engineMetadataDetailDto5 = engineMetadataDetailDto;
                EngineMetadataDetailDto engineMetadataDetailDto6 = engineMetadataDetailDto;
                engineMetadataDetailDto6.setLastTime(Instant.ofEpochMilli(((Date)object2).getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
                engineMetadataDetailDto5.setStatus(Integer.valueOf(1));
                engineMetadataDetailDto6.setLastEditor(IdAcquisitionUtil.getCurrentUserId());
                engineMetadataDetailDto5.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
                object.add(engineMetadataDetailDto);
                continue;
            }
            if (engineMetadataDetailDto.getOperation() == null || !OracleTransactionalExecuteService.catch("\u0001P\u0004").equals(engineMetadataDetailDto.getOperation())) continue;
            engineMetadataDetailDto.setId(IdGenerateUtils.getId());
            if (null == engineMetadataDetailDto.getColumnComment() || "".equals(engineMetadataDetailDto.getColumnComment())) {
                EngineMetadataDetailDto engineMetadataDetailDto7 = engineMetadataDetailDto;
                engineMetadataDetailDto7.setColumnComment(engineMetadataDetailDto7.getColumnName());
            }
            if (null == engineMetadataDetailDto.getColumnChname() || "".equals(engineMetadataDetailDto.getColumnChname())) {
                EngineMetadataDetailDto engineMetadataDetailDto8 = engineMetadataDetailDto;
                engineMetadataDetailDto8.setColumnChname(engineMetadataDetailDto8.getColumnName());
            }
            if (null == engineMetadataDetailDto.getRemark() || "".equals(engineMetadataDetailDto.getRemark())) {
                EngineMetadataDetailDto engineMetadataDetailDto9 = engineMetadataDetailDto;
                engineMetadataDetailDto9.setRemark(engineMetadataDetailDto9.getColumnName());
            }
            EngineMetadataDetailDto engineMetadataDetailDto10 = engineMetadataDetailDto;
            EngineMetadataDetailDto engineMetadataDetailDto11 = engineMetadataDetailDto;
            engineMetadataDetailDto11.setStatus(Integer.valueOf(1));
            engineMetadataDetailDto10.setCreateTime(Instant.ofEpochMilli(((Date)object2).getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
            engineMetadataDetailDto11.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            engineMetadataDetailDto10.setCreator(IdAcquisitionUtil.getCurrentUserId());
            a.add(engineMetadataDetailDto);
        }
        if (StringUtils.isNotEmpty((Collection)object)) {
            iterator = object.iterator();
            while (iterator.hasNext()) {
                engineMetadataDetailDto = (EngineMetadataDetail)iterator.next();
                if (!StringUtils.isEmpty((String)engineMetadataDetailDto.getColumnLength())) continue;
                engineMetadataDetailDto.setColumnLength("0");
            }
            try {
                a2.metadataDetailMapper.get(string).batchInsert((List)object);
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    engineMetadataDetailDto = (EngineMetadataDetail)iterator.next();
                    DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.case("U\u001dU\u001bN\u0001Y\tC\u0010G\u0000G\u0010G\u001bB\u0001R\u0005O\bY\u0010G\u0006J\u0001<")).append(engineMetadataDetailDto.getId()).toString());
                }
            }
            catch (Exception exception) {
                logger.error(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED.getMessage(), (Throwable)exception);
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
        if (StringUtils.isNotEmpty((Collection)a)) {
            iterator = a.iterator();
            while (iterator.hasNext()) {
                engineMetadataDetailDto = (EngineMetadataDetail)iterator.next();
                if (!StringUtils.isEmpty((String)engineMetadataDetailDto.getColumnLength())) continue;
                engineMetadataDetailDto.setColumnLength("0");
            }
            try {
                a2.metadataDetailMapper.get(string).batchInsert((List)a);
            }
            catch (Exception exception) {
                logger.error(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED.getMessage(), (Throwable)exception);
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
        return true;
    }

    public void editTable(EngineMetadataParam a, List<EngineMetadataDetail> a2, String a3) throws EngineException {
        String string;
        Object object;
        Object object2;
        OracleEngineMetadataTableServiceImpl a4;
        Object object3 = a;
        EngineMetadataManageTable engineMetadataManageTable = object3.getBaseInfo();
        Object object4 = object3.getColumnInfo();
        String string2 = engineMetadataManageTable.getDatasourceId().toString();
        Object object5 = a4.sysDataSourceService.getDatasourceById(string2);
        if (object5 == null || object5.getData() == null) {
            logger.error(OracleTransactionalExecuteService.catch("\u6cc1\u673d\u6785\u8bd6\u5250\u6544\u630e\u6ea4\u4f81\u605b\uff6c\u6544\u630e\u6ea4)PZO\u001d"), (Object)string2);
            throw new RuntimeException(new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.case("\u6ca7\u674d\u67e3\u8ba6\u5236\u6534\u6368\u6ed4\u4fe7\u602b\uff0a\u6534\u6368\u6ed4O <")).append(string2).toString());
        }
        string2 = (SysDataSource)object5.getData();
        if (Objects.isNull(string2)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        engineMetadataManageTable3.setCountColumn(Long.valueOf(object4.size()));
        engineMetadataManageTable3.setLastTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable2.setLastEditor(IdAcquisitionUtil.getCurrentUserId());
        engineMetadataManageTable2.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        if (StringUtils.isEmpty((String)engineMetadataManageTable2.getTableChname())) {
            EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
            engineMetadataManageTable4.setTableChname(engineMetadataManageTable4.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableComment())) {
            EngineMetadataManageTable engineMetadataManageTable5 = engineMetadataManageTable;
            engineMetadataManageTable5.setTableComment(engineMetadataManageTable5.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getRemark())) {
            EngineMetadataManageTable engineMetadataManageTable6 = engineMetadataManageTable;
            engineMetadataManageTable6.setRemark(engineMetadataManageTable6.getTableName());
        }
        EngineMetadataManageTable engineMetadataManageTable7 = engineMetadataManageTable;
        object5 = engineMetadataManageTable7.getTableName();
        engineMetadataManageTable7.setVersion(a4.generalMetadataManageTableMapper.getVersion(engineMetadataManageTable.getId().toString()));
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        ArrayList arrayList2 = Lists.newArrayListWithCapacity((int)3);
        ArrayList<EngineMetadataDetail> arrayList3 = new ArrayList<EngineMetadataDetail>();
        ArrayList<EngineMetadataDetail> arrayList4 = new ArrayList<EngineMetadataDetail>();
        HashSet hashSet = Sets.newHashSet();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        a = a.getDeletedCols();
        Map<String, EngineMetadataDetail> map = a2.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        EngineMetadataDetail engineMetadataDetail = object4.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        HashMap hashMap = a.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        block2: for (Map.Entry object32 : map.entrySet()) {
            if (engineMetadataDetail.get(object32.getKey()) != null || hashMap.get(object32.getKey()) != null || !((EngineMetadataDetail)object32.getValue()).getPk().equals("1")) continue;
            hashSet.add(object32.getKey());
            object2 = engineMetadataDetail.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                string = ((EngineMetadataDetailDto)object.getValue()).getOldColumnName();
                if (!((EngineMetadataDetail)object32.getValue()).getColumnName().equals(((EngineMetadataDetailDto)object.getValue()).getColumnName()) && (!"1".equals(((EngineMetadataDetailDto)object.getValue()).getPk()) || !((String)object32.getKey()).equals(string))) continue;
                hashSet.remove(object32.getKey());
                continue block2;
            }
        }
        map = a2.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        Iterator iterator = object4.iterator();
        block4: while (true) {
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                object2.setDefaultValue((object2 = (EngineMetadataDetailDto)iterator.next()).getDefaultValue() == null ? "" : object2.getDefaultValue());
                if (null != object2.getOperation() && OracleTransactionalExecuteService.catch("\u0001P\u0004").equalsIgnoreCase(object2.getOperation()) && !map.containsKey(object2.getColumnName())) {
                    arrayList4.add((EngineMetadataDetail)object2);
                }
                if (object2.getPk().equals("1")) {
                    hashSet.add(object2.getColumnName());
                }
                if (object2.getOperation() == null || !OracleMetadataManageTableDsServiceImpl.case("!b-r").equalsIgnoreCase(object2.getOperation())) continue block4;
                Object object6 = object2;
                object = object6.getColumnComment();
                string = object6.getColumnName();
                object4 = object6.getOldColumnName();
                engineMetadataDetail = map.get(object4);
                if (HussarUtils.isEmpty((Object)engineMetadataDetail)) {
                    logger.error(OracleTransactionalExecuteService.catch("\u674a\u624a\u5250O\u001d\u4fda\u6559\u4e7f\u522d\u76b0\u5277"), (Object)string);
                    iterator2 = iterator;
                    continue;
                }
                if (!object2.getColumnName().equalsIgnoreCase((String)object4)) {
                    hashMap = Maps.newHashMapWithExpectedSize((int)3);
                    hashMap.put(OracleMetadataManageTableDsServiceImpl.case("i(b\u0007i(s)h\ng)c"), object4);
                    hashMap.put(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000ez\u0001Y\u0005"), string);
                    arrayList.add(hashMap);
                }
                if (!StringUtils.isEmpty((String)object) && !((String)object).equals(engineMetadataDetail.getColumnComment())) {
                    hashMap = Maps.newHashMapWithExpectedSize((int)3);
                    hashMap.put(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\ng)c"), string);
                    hashMap.put(OracleTransactionalExecuteService.catch("\u0003[\rY\u0005Z\u0014"), object);
                    arrayList2.add(hashMap);
                }
                if (!object2.getRequired().equals(engineMetadataDetail.getRequired())) {
                    object2.setNeedChangeIsRequired(true);
                }
                arrayList3.add((EngineMetadataDetail)object2);
                continue block4;
            }
            break;
        }
        Iterator iterator3 = a.iterator();
        while (iterator3.hasNext()) {
            object2 = (EngineMetadataDetail)iterator3.next();
            if (map.containsKey(object2.getColumnName())) continue;
            iterator3.remove();
        }
        try {
            a4.dsService.editTable(engineMetadataManageTable, a2, a3, (String)object5, arrayList, arrayList2, arrayList3, arrayList4, hashSet, arrayList5, (List<EngineMetadataDetail>)a, map, string2.getConnName(), 1);
            return;
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(exception.getMessage());
        }
    }

    String if(EngineMetadataParam a, List<EngineMetadataDetail> a2, String a3) throws EngineException {
        Object object;
        boolean bl;
        Object object2;
        Object object3;
        CharSequence charSequence;
        Object object4;
        OracleEngineMetadataTableServiceImpl a4;
        OracleEngineMetadataTableServiceImpl oracleEngineMetadataTableServiceImpl = a4;
        Object object5 = oracleEngineMetadataTableServiceImpl.renderBaseInfo((EngineMetadataParam)a);
        String string = object5.getDatasourceId().toString();
        Object object6 = oracleEngineMetadataTableServiceImpl.sysDataSourceService.getDatasourceById(string);
        if (object6 == null || object6.getData() == null) {
            logger.error(OracleMetadataManageTableDsServiceImpl.case("\u6ca7\u674d\u67e3\u8ba6\u5236\u6534\u6368\u6ed4\u4fe7\u602b\uff0a\u6534\u6368\u6ed4O <?{"), (Object)string);
            throw new RuntimeException(new StringBuilder().insert(0, OracleTransactionalExecuteService.catch("\u6cc1\u673d\u6785\u8bd6\u5250\u6544\u630e\u6ea4\u4f81\u605b\uff6c\u6544\u630e\u6ea4)PZ")).append(string).toString());
        }
        string = (SysDataSource)object6.getData();
        if (Objects.isNull(string)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        EngineMetadataParam engineMetadataParam = a;
        a = engineMetadataParam.getColumnInfo();
        string = string.getInstantName();
        object6 = object5.getTableName();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        List list = engineMetadataParam.getDeletedCols();
        Object object7 = a.iterator();
        while (object7.hasNext()) {
            Object object8;
            object4 = (EngineMetadataDetailDto)object7.next();
            if (StringUtils.isEmpty((String)object4.getColumnChname())) {
                Object object9 = object4;
                object9.setColumnComment(object9.getColumnComment());
                object9.setColumnChname(object9.getColumnName());
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(OracleMetadataManageTableDsServiceImpl.case("-u\u0016c5s-t!b"), object4.getRequired());
            hashMap.put(OracleTransactionalExecuteService.catch("\u0003[\fA\rZ#[\rY\u0005Z\u0014"), object4.getColumnComment());
            hashMap.put(OracleMetadataManageTableDsServiceImpl.case(" c\"g1j0P%j1c"), object4.getDefaultValue());
            charSequence = object4.getColumnType();
            if (OracleTransactionalExecuteService.catch("z5y\"q2").equalsIgnoreCase((String)charSequence) || OracleMetadataManageTableDsServiceImpl.case("B\u0001E\rK\u0005J").equalsIgnoreCase((String)charSequence) || OracleTransactionalExecuteService.catch(".a-q2}#").equalsIgnoreCase((String)charSequence)) {
                object3 = new StringBuilder().insert(0, (String)charSequence).append(OracleMetadataManageTableDsServiceImpl.case(".")).append(object4.getColumnLength()).append(OracleTransactionalExecuteService.catch("L")).append(object4.getPointLength()).append(OracleMetadataManageTableDsServiceImpl.case("/")).toString();
                Object object10 = object4;
                object8 = object10;
                object10.setColumnType((String)object3);
                hashMap.put(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000e`\u0019D\u0005"), object3);
            } else if (OracleMetadataManageTableDsServiceImpl.case(" g0c").equalsIgnoreCase((String)charSequence) || OracleTransactionalExecuteService.catch("\u0014]\rQ\u0013@\u0001Y\u0010").equalsIgnoreCase((String)charSequence) || OracleMetadataManageTableDsServiceImpl.case("(i*a0c<r").equalsIgnoreCase((String)charSequence) || OracleTransactionalExecuteService.catch("@\u0005L\u0014").equalsIgnoreCase((String)charSequence) || OracleMetadataManageTableDsServiceImpl.case("&j+d").equalsIgnoreCase((String)charSequence) || OracleTransactionalExecuteService.catch("W\f[\u0002").equalsIgnoreCase((String)charSequence) || OracleMetadataManageTableDsServiceImpl.case("(i*a&j+d").equalsIgnoreCase((String)charSequence) || OracleTransactionalExecuteService.catch("Y\u0005P\tA\r").equalsIgnoreCase((String)charSequence) || OracleMetadataManageTableDsServiceImpl.case(")c o1k0c<r").equalsIgnoreCase((String)charSequence) || OracleTransactionalExecuteService.catch("Y\u0005P\tA\rV\f[\u0002").equalsIgnoreCase((String)charSequence) || OracleMetadataManageTableDsServiceImpl.case("0o*\u007f0c<r").equalsIgnoreCase((String)charSequence) || OracleTransactionalExecuteService.catch("@\tZ\u0019V\f[\u0002").equalsIgnoreCase((String)charSequence)) {
                hashMap.put(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\u0010\u007f4c"), charSequence);
                object8 = object4;
            } else {
                object3 = new StringBuilder().insert(0, object4.getColumnType()).append(OracleTransactionalExecuteService.catch("H")).append(object4.getColumnLength()).append(OracleMetadataManageTableDsServiceImpl.case("/")).toString();
                Object object11 = object4;
                hashMap.put(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000e`\u0019D\u0005"), object3);
                object8 = object11;
                object11.setColumnType((String)object3);
            }
            if (object8.getOperation() != null && OracleMetadataManageTableDsServiceImpl.case("!b-r").equals(object4.getOperation())) {
                ArrayList arrayList5;
                block34: {
                    hashMap.put(OracleTransactionalExecuteService.catch("\u000eQ\u0017w\u000fX\u0015Y\u000ez\u0001Y\u0005"), object4.getColumnName());
                    object3 = a2.iterator();
                    while (object3.hasNext()) {
                        object2 = (EngineMetadataDetail)object3.next();
                        if (!object4.getOldColumnName().equals(object2.getColumnName())) continue;
                        hashMap.put(OracleMetadataManageTableDsServiceImpl.case("i(b\u0007i(s)h\ng)c"), object2.getColumnName());
                        hashMap.put(OracleTransactionalExecuteService.catch("\u000fX\u0004f\u0005E\u0015]\u0012Q\u0004"), object2.getRequired());
                        hashMap.put(OracleMetadataManageTableDsServiceImpl.case("i(b\u0014m"), object2.getPk());
                        object4.setCreateTime(object2.getCreateTime());
                        if (!object4.getPk().equals("1")) break;
                        arrayList5 = arrayList;
                        arrayList3.add(object2.getColumnName());
                        break block34;
                    }
                    arrayList5 = arrayList;
                }
                arrayList5.add(hashMap);
                continue;
            }
            if (object4.getOperation() != null && OracleTransactionalExecuteService.catch("\u0001P\u0004").equals(object4.getOperation())) {
                Object object12 = object4;
                hashMap.put(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\ng)c"), object12.getColumnName());
                hashMap.put(OracleTransactionalExecuteService.catch("\u000eQ\u0017w\u000fX\u0015Y\u000ez\u0001Y\u0005"), object4.getColumnName());
                hashMap.put(OracleMetadataManageTableDsServiceImpl.case("i(b\u0007i(s)h\ng)c"), object4.getColumnName());
                hashMap.put(OracleTransactionalExecuteService.catch("\u000eQ\u0017d\u000b"), object4.getPk());
                arrayList2.add(hashMap);
                if (!object12.getPk().equals("1")) continue;
                arrayList3.add(object4.getColumnName());
                continue;
            }
            if (!object4.getPk().equals("1")) continue;
            arrayList3.add(object4.getColumnName());
        }
        object7 = new StringBuffer();
        object4 = new StringBuffer();
        boolean bl2 = bl = !arrayList3.isEmpty();
        if (HussarUtils.isEmpty(a2)) {
            Object object13;
            CharSequence charSequence2;
            ((StringBuffer)object7).append(OracleMetadataManageTableDsServiceImpl.case("B\u0001E\bG\u0016CdH\u0011KdH\u0011K\u0006C\u0016=dD\u0001A\rHdU\u0001J\u0001E\u0010&\u0007I\u0011H\u0010.u/dO\nR\u000b&\nS\t&\u0002T\u000bKdG\bJ\u001bR\u0005D\bC\u0017&\u0013N\u0001T\u0001&\u0010G\u0006J\u0001Y\nG\tCd;d!")).append((String)object6).append(OracleTransactionalExecuteService.catch("\u0013[\u0014)r@z5y]\u0005@`(q.\u0014%l%w5`%\u0014)y-q$}!`%\u0014Gp2{0\u00144u\"x%\u0014B")).append((String)object6).append(OracleMetadataManageTableDsServiceImpl.case("$c=dC\nBdO\u0002=dC\nB\u007f\fk\f"));
            CharSequence charSequence3 = charSequence = new StringBuffer(OracleTransactionalExecuteService.catch("w2q!`%\u00144u\"x%\u0014B@\u0001V\fQ.U\rQB\u0014H"));
            ((StringBuffer)charSequence3).replace(((StringBuffer)charSequence).indexOf(OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c")), ((StringBuffer)charSequence3).indexOf(OracleTransactionalExecuteService.catch("\u0014U\u0002X\u0005z\u0001Y\u0005")) + OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c").length(), (String)object6);
            object3 = a.iterator();
            Object object14 = object3;
            while (object14.hasNext()) {
                object2 = (EngineMetadataDetailDto)object3.next();
                charSequence2 = new StringBuffer(OracleTransactionalExecuteService.catch("BW\u000fX\u0015Y\u000ez\u0001Y\u0005\u0016@W\u000fX\u0015Y\u000e`\u0019D\u0005\u0014.{4\u0014.a,x@p%r!a,`@\u0013\u0004Q\u0006U\u0015X\u0014b\u0001X\u0015QG\u0014L"));
                StringBuffer stringBuffer = charSequence2;
                stringBuffer.replace(((StringBuffer)charSequence2).indexOf(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\ng)c")), stringBuffer.indexOf(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000ez\u0001Y\u0005")) + OracleMetadataManageTableDsServiceImpl.case("'i(s)h\ng)c").length(), object2.getColumnName());
                CharSequence charSequence4 = charSequence2;
                ((StringBuffer)charSequence4).replace(((StringBuffer)charSequence2).indexOf(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000e`\u0019D\u0005")), ((StringBuffer)charSequence4).indexOf(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\u0010\u007f4c")) + OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000e`\u0019D\u0005").length(), object2.getColumnType());
                if (!object2.getRequired().equals("1")) {
                    CharSequence charSequence5 = charSequence2;
                    ((StringBuffer)charSequence5).delete(((StringBuffer)charSequence2).indexOf(OracleMetadataManageTableDsServiceImpl.case("H\u000bRdH\u0011J\b&")), ((StringBuffer)charSequence5).indexOf(OracleTransactionalExecuteService.catch(".{4\u0014.a,x@")) + OracleMetadataManageTableDsServiceImpl.case("\nI\u0010&\nS\bJ").length() + 1);
                }
                CharSequence charSequence6 = charSequence2;
                if (StringUtils.isNotEmpty((String)object2.getDefaultValue())) {
                    ((StringBuffer)charSequence6).replace(((StringBuffer)charSequence2).indexOf(OracleTransactionalExecuteService.catch("P\u0005R\u0001A\f@6U\fA\u0005")), ((StringBuffer)charSequence2).indexOf(OracleMetadataManageTableDsServiceImpl.case(" c\"g1j0P%j1c")) + OracleTransactionalExecuteService.catch("P\u0005R\u0001A\f@6U\fA\u0005").length(), object2.getDefaultValue());
                } else {
                    ((StringBuffer)charSequence6).delete(((StringBuffer)charSequence2).indexOf(OracleMetadataManageTableDsServiceImpl.case("B\u0001@\u0005S\bRd! c\"g1j0P%j1cc&")), ((StringBuffer)charSequence2).indexOf(OracleTransactionalExecuteService.catch("$q&u5x4\u0014GP\u0005R\u0001A\f@6U\fA\u0005\u0013@")) + OracleMetadataManageTableDsServiceImpl.case("B\u0001@\u0005S\bRd! c\"g1j0P%j1cc&").length());
                }
                StringBuffer stringBuffer2 = new StringBuffer(OracleTransactionalExecuteService.catch("w/y-q.`@{.\u0014#{,a-z@\u0016\u0014U\u0002X\u0005z\u0001Y\u0005\u0016N\u0016\u0003[\fA\rZ.U\rQB\u0014)g@\u0013\u0003[\fA\rZ#[\rY\u0005Z\u0014\u0013["));
                if (StringUtils.isNotEmpty((String)object2.getColumnComment())) {
                    StringBuffer stringBuffer3 = stringBuffer2;
                    stringBuffer3.replace(stringBuffer2.indexOf(OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c")), stringBuffer3.indexOf(OracleTransactionalExecuteService.catch("\u0014U\u0002X\u0005z\u0001Y\u0005")) + OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c").length(), (String)object6);
                    StringBuffer stringBuffer4 = stringBuffer2;
                    stringBuffer4.replace(stringBuffer2.indexOf(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000ez\u0001Y\u0005")), stringBuffer4.indexOf(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\ng)c")) + OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000ez\u0001Y\u0005").length(), object2.getColumnName());
                    StringBuffer stringBuffer5 = stringBuffer2;
                    stringBuffer5.replace(stringBuffer2.indexOf(OracleMetadataManageTableDsServiceImpl.case("e+j1k*E+k)c*r")), stringBuffer5.indexOf(OracleTransactionalExecuteService.catch("\u0003[\fA\rZ#[\rY\u0005Z\u0014")) + OracleMetadataManageTableDsServiceImpl.case("e+j1k*E+k)c*r").length(), object2.getColumnComment());
                    ((StringBuffer)object4).append(stringBuffer2);
                }
                ((StringBuffer)charSequence).append((StringBuffer)charSequence2);
                object14 = object3;
            }
            if (bl) {
                object3 = new StringBuffer();
                Object object15 = object2 = arrayList3.iterator();
                while (object15.hasNext()) {
                    charSequence2 = (String)object2.next();
                    object15 = object2;
                    ((StringBuffer)object3).append((String)charSequence2).append(OracleTransactionalExecuteService.catch("L"));
                }
                Iterator<EngineMetadataDetail> iterator = object3;
                ((StringBuffer)((Object)iterator)).deleteCharAt(((StringBuffer)((Object)iterator)).length() - 1);
                ((StringBuffer)charSequence).append(OracleMetadataManageTableDsServiceImpl.case("\u0014T\rK\u0005T\u001d&\u000fC\u001d&l$")).append((StringBuffer)object3).append(OracleTransactionalExecuteService.catch("\u0016I\u001d["));
                object13 = object7;
            } else {
                CharSequence charSequence7 = charSequence;
                ((StringBuffer)charSequence7).deleteCharAt(((StringBuffer)charSequence7).length() - 1);
                ((StringBuffer)charSequence).append(OracleMetadataManageTableDsServiceImpl.case("/m="));
                object13 = object7;
            }
            ((StringBuffer)object13).append((StringBuffer)charSequence);
            object3 = new StringBuffer(OracleTransactionalExecuteService.catch("#{-y%z4\u0014/z@`!v,q@\u0016\u0014U\u0002X\u0005z\u0001Y\u0005\u0016@}3\u0014G@\u0001V\fQ#[\rY\u0005Z\u0014\u0013["));
            if (StringUtils.isNotEmpty((String)object5.getTableComment())) {
                Object object16 = object3;
                ((StringBuffer)object16).replace(((StringBuffer)object3).indexOf(OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c")), ((StringBuffer)object16).indexOf(OracleTransactionalExecuteService.catch("\u0014U\u0002X\u0005z\u0001Y\u0005")) + OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c").length(), (String)object6);
                Object object17 = object3;
                ((StringBuffer)object17).replace(((StringBuffer)object3).indexOf(OracleTransactionalExecuteService.catch("@\u0001V\fQ#[\rY\u0005Z\u0014")), ((StringBuffer)object17).indexOf(OracleMetadataManageTableDsServiceImpl.case("0g&j!E+k)c*r")) + OracleTransactionalExecuteService.catch("@\u0001V\fQ#[\rY\u0005Z\u0014").length(), object5.getTableComment());
                ((StringBuffer)object7).append((StringBuffer)object3);
            }
            Object object18 = object7;
            object = object18;
            ((StringBuffer)object18).append((StringBuffer)object4);
        } else {
            Object object19;
            Object object20;
            boolean bl3 = a4.dsService.isHavePk((String)object6, string);
            if (!((String)a3).equalsIgnoreCase((String)object6)) {
                object3 = new StringBuffer(OracleMetadataManageTableDsServiceImpl.case("\u0016C\nG\tCdi(b\ng)cdR\u000b&*c3H%k!="));
                StringBuffer stringBuffer = object3;
                stringBuffer.replace(((StringBuffer)object3).indexOf(OracleTransactionalExecuteService.catch("\u000fX\u0004z\u0001Y\u0005")), stringBuffer.indexOf(OracleMetadataManageTableDsServiceImpl.case("i(b\ng)c")) + OracleTransactionalExecuteService.catch("\u000fX\u0004z\u0001Y\u0005").length(), (String)a3);
                StringBuffer stringBuffer6 = object3;
                stringBuffer6.replace(((StringBuffer)object3).indexOf(OracleMetadataManageTableDsServiceImpl.case("h!q\ng)c")), stringBuffer6.indexOf(OracleTransactionalExecuteService.catch("\u000eQ\u0017z\u0001Y\u0005")) + OracleMetadataManageTableDsServiceImpl.case("h!q\ng)c").length(), (String)object6);
                ((StringBuffer)object7).append((StringBuffer)object3);
            }
            object3 = new StringBuffer(OracleTransactionalExecuteService.catch("u,`%f@`!v,q@\u0016\u0014U\u0002X\u0005z\u0001Y\u0005\u0016@"));
            StringBuffer stringBuffer = object3;
            stringBuffer.replace(((StringBuffer)object3).indexOf(OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c")), stringBuffer.indexOf(OracleTransactionalExecuteService.catch("\u0014U\u0002X\u0005z\u0001Y\u0005")) + OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c").length(), (String)object6);
            object2 = new StringBuffer();
            if (HussarUtils.isNotEmpty(arrayList2)) {
                Object object21 = object20 = arrayList2.iterator();
                while (object21.hasNext()) {
                    object19 = (Map)object20.next();
                    a = new StringBuffer(OracleTransactionalExecuteService.catch("u,`%f@`!v,q@\u0016\u0014U\u0002X\u0005z\u0001Y\u0005\u0016@u$p@\u0016\u0003[\fA\rZ.U\rQB\u0014\u0003[\fA\rZ4M\u0010Q@z/`@z5x,\u0014$q&u5x4\u0014GP\u0005R\u0001A\f@6U\fA\u0005\u0013["));
                    if ("1".equals(object19.get(OracleMetadataManageTableDsServiceImpl.case("h!q\u0014m")))) {
                        Object object22 = a;
                        ((StringBuffer)object22).append(OracleTransactionalExecuteService.catch("\u0001X\u0014Q\u0012\u0014\u0014U\u0002X\u0005\u0014B@\u0001V\fQ.U\rQB\u0014!p$\u0014\u0010F\tY\u0001F\u0019\u0014\u000bQ\u0019\u0014H\u0016\u0003[\fA\rZ.U\rQB\u001d["));
                        Object object23 = a;
                        ((StringBuffer)object23).replace(((StringBuffer)a).indexOf(OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c")), ((StringBuffer)object23).indexOf(OracleTransactionalExecuteService.catch("\u0014U\u0002X\u0005z\u0001Y\u0005")) + OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c").length(), (String)object6);
                        ((StringBuffer)object22).replace(((StringBuffer)object22).indexOf(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000ez\u0001Y\u0005")), ((StringBuffer)a).indexOf(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\ng)c")) + OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000ez\u0001Y\u0005").length(), (String)object19.get(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\ng)c")));
                    }
                    Object object24 = a;
                    ((StringBuffer)object24).replace(((StringBuffer)object24).indexOf(OracleTransactionalExecuteService.catch("\u0014U\u0002X\u0005z\u0001Y\u0005")), ((StringBuffer)a).indexOf(OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c")) + OracleTransactionalExecuteService.catch("\u0014U\u0002X\u0005z\u0001Y\u0005").length(), (String)object6);
                    ((StringBuffer)a).replace(((StringBuffer)object24).indexOf(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\ng)c")), ((StringBuffer)a).indexOf(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000ez\u0001Y\u0005")) + OracleMetadataManageTableDsServiceImpl.case("'i(s)h\ng)c").length(), (String)object19.get(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000ez\u0001Y\u0005")));
                    a4.if((StringBuffer)object2, (StringBuffer)object4, (String)object6, (Map<String, String>)object19, (StringBuffer)a);
                    object21 = object20;
                }
            }
            object20 = new StringBuffer();
            if (HussarUtils.isNotEmpty(arrayList)) {
                Object object25 = object19 = arrayList.iterator();
                while (object25.hasNext()) {
                    a = (Map)object19.next();
                    if (!((String)a.get(OracleMetadataManageTableDsServiceImpl.case("h!q\u0007i(s)h\ng)c"))).equals(a.get(OracleTransactionalExecuteService.catch("\u000fX\u0004w\u000fX\u0015Y\u000ez\u0001Y\u0005")))) {
                        a3 = new StringBuffer(OracleMetadataManageTableDsServiceImpl.case("G\bR\u0001TdR\u0005D\bCd$0g&j!H%k!$dT\u0001H\u0005K\u0001&\u0007I\bS\tHdi(b\u0007i(s)h\ng)cdR\u000b&*c3E+j1k*H%k!="));
                        if (HussarUtils.isNotEmpty(a.get(OracleTransactionalExecuteService.catch("\u000fX\u0004w\u000fX\u0015Y\u000ez\u0001Y\u0005")))) {
                            CharSequence charSequence8 = a3;
                            ((StringBuffer)charSequence8).replace(((StringBuffer)a3).indexOf(OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c")), ((StringBuffer)a3).indexOf(OracleTransactionalExecuteService.catch("\u0014U\u0002X\u0005z\u0001Y\u0005")) + OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c").length(), (String)object6);
                            ((StringBuffer)charSequence8).replace(((StringBuffer)charSequence8).indexOf(OracleTransactionalExecuteService.catch("\u000fX\u0004w\u000fX\u0015Y\u000ez\u0001Y\u0005")), ((StringBuffer)a3).indexOf(OracleMetadataManageTableDsServiceImpl.case("i(b\u0007i(s)h\ng)c")) + OracleTransactionalExecuteService.catch("\u000fX\u0004w\u000fX\u0015Y\u000ez\u0001Y\u0005").length(), (String)a.get(OracleMetadataManageTableDsServiceImpl.case("i(b\u0007i(s)h\ng)c")));
                            CharSequence charSequence9 = a3;
                            ((StringBuffer)charSequence9).replace(((StringBuffer)a3).indexOf(OracleTransactionalExecuteService.catch("\u000eQ\u0017w\u000fX\u0015Y\u000ez\u0001Y\u0005")), ((StringBuffer)charSequence9).indexOf(OracleMetadataManageTableDsServiceImpl.case("h!q\u0007i(s)h\ng)c")) + OracleTransactionalExecuteService.catch("\u000eQ\u0017w\u000fX\u0015Y\u000ez\u0001Y\u0005").length(), (String)a.get(OracleMetadataManageTableDsServiceImpl.case("h!q\u0007i(s)h\ng)c")));
                            ((StringBuffer)object20).append((StringBuffer)a3);
                        }
                    }
                    CharSequence charSequence10 = a3 = new StringBuffer(OracleTransactionalExecuteService.catch("u,`%f@`!v,q@\u0016\u0014U\u0002X\u0005z\u0001Y\u0005\u0016@y/p)r9\u0014BZ\u0005C#[\fA\rZ.U\rQB\u0014\u0003[\fA\rZ4M\u0010Q@z/`@z5x,\u0014$q&u5x4\u0014GP\u0005R\u0001A\f@6U\fA\u0005\u0013["));
                    ((StringBuffer)charSequence10).replace(((StringBuffer)a3).indexOf(OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c")), ((StringBuffer)a3).indexOf(OracleTransactionalExecuteService.catch("\u0014U\u0002X\u0005z\u0001Y\u0005")) + OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c").length(), (String)object6);
                    ((StringBuffer)charSequence10).replace(((StringBuffer)charSequence10).indexOf(OracleTransactionalExecuteService.catch("\u000eQ\u0017w\u000fX\u0015Y\u000ez\u0001Y\u0005")), ((StringBuffer)a3).indexOf(OracleMetadataManageTableDsServiceImpl.case("h!q\u0007i(s)h\ng)c")) + OracleTransactionalExecuteService.catch("\u000eQ\u0017w\u000fX\u0015Y\u000ez\u0001Y\u0005").length(), (String)a.get(OracleMetadataManageTableDsServiceImpl.case("h!q\u0007i(s)h\ng)c")));
                    a.put(OracleTransactionalExecuteService.catch("\\\u0001G$Q\u0006"), "0");
                    a4.if((StringBuffer)object20, (StringBuffer)object4, (String)object6, (Map<String, String>)a, (StringBuffer)a3);
                    object25 = object19;
                }
            }
            object19 = new StringBuffer();
            if (HussarUtils.isNotEmpty((Object)list)) {
                a = list.iterator();
                while (a.hasNext()) {
                    a3 = (EngineMetadataDetail)a.next();
                    arrayList4.add(a3.getColumnName());
                    object5 = a2.iterator();
                    while (object5.hasNext()) {
                        string = (EngineMetadataDetail)object5.next();
                        if (!HussarUtils.equals((Object)string.getColumnName(), (Object)a3.getColumnName()) || !"1".equals(string.getPk())) continue;
                        ((StringBuffer)object19).append(OracleMetadataManageTableDsServiceImpl.case("G\bR\u0001TdR\u0005D\bCd$0g&j!H%k!$dB\u0016I\u0014&4t-k%t=&/c=="));
                        Object object26 = object19;
                        ((StringBuffer)object26).replace(((StringBuffer)object19).indexOf(OracleTransactionalExecuteService.catch("\u0014U\u0002X\u0005z\u0001Y\u0005")), ((StringBuffer)object26).indexOf(OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c")) + OracleTransactionalExecuteService.catch("\u0014U\u0002X\u0005z\u0001Y\u0005").length(), (String)object6);
                    }
                }
                Object object27 = a = arrayList4.iterator();
                while (object27.hasNext()) {
                    a3 = (String)a.next();
                    object5 = new StringBuffer(OracleMetadataManageTableDsServiceImpl.case("G\bR\u0001TdR\u0005D\bCd$0g&j!H%k!$dB\u0016I\u0014&\u0007I\bS\tHd$'i(s)h\ng)cf="));
                    object27 = a;
                    Object object28 = object5;
                    ((StringBuffer)object28).replace(((StringBuffer)object5).indexOf(OracleTransactionalExecuteService.catch("\u0014U\u0002X\u0005z\u0001Y\u0005")), ((StringBuffer)object28).indexOf(OracleMetadataManageTableDsServiceImpl.case("r%d(c\ng)c")) + OracleTransactionalExecuteService.catch("\u0014U\u0002X\u0005z\u0001Y\u0005").length(), (String)object6);
                    Object object29 = object5;
                    ((StringBuffer)object29).replace(((StringBuffer)object5).indexOf(OracleMetadataManageTableDsServiceImpl.case("'i(s)h\ng)c")), ((StringBuffer)object29).indexOf(OracleTransactionalExecuteService.catch("W\u000fX\u0015Y\u000ez\u0001Y\u0005")) + OracleMetadataManageTableDsServiceImpl.case("'i(s)h\ng)c").length(), (String)a3);
                    ((StringBuffer)object19).append((StringBuffer)object5);
                }
            }
            Object object30 = object7;
            object = object30;
            ((StringBuffer)object30).append((StringBuffer)object19).append((StringBuffer)object2).append((StringBuffer)object20).append((StringBuffer)object4);
        }
        return String.valueOf(object);
    }
}

