/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine.oracle.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.engine.metadata.dao.EngineMetadataDetailMapper;
import com.jxdinfo.hussar.engine.metadata.dao.EngineMetadataManageTableMapper;
import com.jxdinfo.hussar.engine.metadata.dao.EnginePlatformTableMapper;
import com.jxdinfo.hussar.engine.metadata.dto.EngineMetadataDetailDto;
import com.jxdinfo.hussar.engine.metadata.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.engine.metadata.exception.EngineException;
import com.jxdinfo.hussar.engine.metadata.model.EngineMetadataDetail;
import com.jxdinfo.hussar.engine.metadata.model.EngineMetadataManageTable;
import com.jxdinfo.hussar.engine.metadata.model.EngineMetadataParam;
import com.jxdinfo.hussar.engine.metadata.service.EngineDynamicDataSourceService;
import com.jxdinfo.hussar.engine.metadata.strategy.EnginePlatformTableFactory;
import com.jxdinfo.hussar.engine.metadata.util.DateUtils;
import com.jxdinfo.hussar.engine.metadata.util.IdAcquisitionUtil;
import com.jxdinfo.hussar.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.hussar.engine.metadata.util.StringUtils;
import com.jxdinfo.hussar.engine.oracle.dao.OracleTargetDataBaseMapper;
import com.jxdinfo.hussar.engine.oracle.service.OracleTransactionalExecuteService;
import com.jxdinfo.hussar.engine.oracle.service.impl.OracleMetadataManageTableDsServiceImpl;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@HussarDs(value="master")
public class OracleEngineMetadataTableServiceImpl {
    private Map<String, EnginePlatformTableMapper> metadataDetailMapper = EnginePlatformTableFactory.getMappers((String)OracleMetadataManageTableDsServiceImpl.boolean("\u0005Y\u001c]\f]\u001c],Y\u001c]\u0001P"));
    @Autowired
    private SysDataSourceService sysDataSourceService;
    @Autowired
    private EngineDynamicDataSourceService engineDynamicDataSourceService;
    private static final Logger logger = LoggerFactory.getLogger(OracleEngineMetadataTableServiceImpl.class);
    @Autowired
    private EngineMetadataManageTableMapper generalMetadataManageTableMapper;
    @Autowired
    private EngineMetadataDetailMapper generalMetadataDetailMapper;
    @Autowired
    private OracleTargetDataBaseMapper targetDataBaseOracleMapper;
    @Autowired
    private OracleMetadataManageTableDsServiceImpl dsService;

    public void editTable(EngineMetadataParam a, List<EngineMetadataDetail> a2, String a3) throws EngineException {
        Object object;
        Object object2;
        OracleEngineMetadataTableServiceImpl a4;
        Object object3 = a;
        EngineMetadataManageTable engineMetadataManageTable = object3.getBaseInfo();
        Object object4 = object3.getColumnInfo();
        String string = engineMetadataManageTable.getDatasourceId().toString();
        Object object5 = a4.sysDataSourceService.getDatasourceById(string);
        if (object5 == null || object5.getData() == null) {
            logger.error(OracleTransactionalExecuteService.for("\u6cfb\u6740\u67bf\u8bab\u526a\u6539\u6334\u6ed9\u4fbb\u6026\uff56\u6539\u6334\u6ed9\u0013-`2'"), (Object)string);
            throw new RuntimeException(new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.boolean("\u6c9d\u6761\u67d9\u8b8a\u520c\u6518\u6352\u6ef8\u4fdd\u6007\uff30\u6518\u6352\u6ef8u\f\u0006")).append(string).toString());
        }
        string = (SysDataSource)object5.getData();
        if (Objects.isNull(string)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        engineMetadataManageTable3.setCountColumn(Long.valueOf(object4.size()));
        engineMetadataManageTable3.setLastTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable2.setLastEditor(IdAcquisitionUtil.getCurrentUserId());
        engineMetadataManageTable2.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        if (StringUtils.isEmpty((String)engineMetadataManageTable2.getTableChname())) {
            EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
            engineMetadataManageTable4.setTableChname(engineMetadataManageTable4.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableComment())) {
            EngineMetadataManageTable engineMetadataManageTable5 = engineMetadataManageTable;
            engineMetadataManageTable5.setTableComment(engineMetadataManageTable5.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getRemark())) {
            EngineMetadataManageTable engineMetadataManageTable6 = engineMetadataManageTable;
            engineMetadataManageTable6.setRemark(engineMetadataManageTable6.getTableName());
        }
        EngineMetadataManageTable engineMetadataManageTable7 = engineMetadataManageTable;
        object5 = engineMetadataManageTable7.getTableName();
        engineMetadataManageTable7.setVersion(a4.generalMetadataManageTableMapper.getVersion(engineMetadataManageTable.getId().toString()));
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        ArrayList arrayList2 = Lists.newArrayListWithCapacity((int)3);
        ArrayList<EngineMetadataDetail> arrayList3 = new ArrayList<EngineMetadataDetail>();
        ArrayList<EngineMetadataDetail> arrayList4 = new ArrayList<EngineMetadataDetail>();
        HashSet hashSet = Sets.newHashSet();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        a = a.getDeletedCols();
        Map<String, EngineMetadataDetail> map = a2.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        Object object6 = object4.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        EngineMetadataDetail engineMetadataDetail = a.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        block2: for (Map.Entry object32 : map.entrySet()) {
            if (object6.get(object32.getKey()) != null || engineMetadataDetail.get(object32.getKey()) != null || !((EngineMetadataDetail)object32.getValue()).getPk().equals("1")) continue;
            hashSet.add(object32.getKey());
            object2 = object6.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                if (!((EngineMetadataDetail)object32.getValue()).getColumnName().equals(((EngineMetadataDetail)object.getValue()).getColumnName())) continue;
                hashSet.remove(object32.getKey());
                continue block2;
            }
        }
        map = a2.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        Iterator exception = object4.iterator();
        block4: while (true) {
            Iterator iterator = exception;
            while (iterator.hasNext()) {
                HashMap hashMap;
                object2.setDefaultValue((object2 = (EngineMetadataDetailDto)exception.next()).getDefaultValue() == null ? "" : object2.getDefaultValue());
                if (null != object2.getOperation() && OracleTransactionalExecuteService.for(";->").equalsIgnoreCase(object2.getOperation())) {
                    arrayList4.add((EngineMetadataDetail)object2);
                }
                if (object2.getPk().equals("1")) {
                    hashSet.add(object2.getColumnName());
                }
                if (object2.getOperation() == null || !OracleMetadataManageTableDsServiceImpl.boolean("\rX\u0001H").equalsIgnoreCase(object2.getOperation())) continue block4;
                Object object7 = object2;
                object = object7.getColumnComment();
                object4 = object7.getColumnName();
                object6 = object7.getOldColumnName();
                engineMetadataDetail = map.get(object6);
                if (HussarUtils.isEmpty((Object)engineMetadataDetail)) {
                    logger.error(OracleTransactionalExecuteService.for("\u6770\u6237\u526a2'\u4fa7\u6563\u4e02\u5217\u76cd\u524d"), object4);
                    iterator = exception;
                    continue;
                }
                if (!object2.getColumnName().equalsIgnoreCase((String)object6)) {
                    hashMap = Maps.newHashMapWithExpectedSize((int)3);
                    hashMap.put(OracleMetadataManageTableDsServiceImpl.boolean("S\u0004X+S\u0004I\u0005R&]\u0005Y"), object6);
                    hashMap.put(OracleTransactionalExecuteService.for("*5%/$4\u0007;$?"), object4);
                    arrayList.add(hashMap);
                }
                if (!StringUtils.isEmpty((String)object) && !((String)object).equals(engineMetadataDetail.getColumnComment())) {
                    hashMap = Maps.newHashMapWithExpectedSize((int)3);
                    hashMap.put(OracleMetadataManageTableDsServiceImpl.boolean("\u000bS\u0004I\u0005R&]\u0005Y"), object4);
                    hashMap.put(OracleTransactionalExecuteService.for("9&7$?'."), object);
                    arrayList2.add(hashMap);
                }
                if (!object2.getRequired().equals(engineMetadataDetail.getRequired())) {
                    object2.setNeedChangeIsRequired(true);
                }
                arrayList3.add((EngineMetadataDetail)object2);
                continue block4;
            }
            break;
        }
        try {
            a4.dsService.editTable(engineMetadataManageTable, a2, a3, (String)object5, arrayList, arrayList2, arrayList3, arrayList4, hashSet, arrayList5, (List<EngineMetadataDetail>)a, map, string.getConnName(), 1);
            return;
        }
        catch (Exception exception2) {
            logger.error(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED.getMessage(), (Throwable)exception2);
            throw new EngineException(exception2.getMessage());
        }
    }

    public boolean updateTableInfo(EngineMetadataParam a) throws EngineException {
        EngineMetadataDetailDto engineMetadataDetailDto;
        Object object;
        Iterator iterator;
        Object object2;
        OracleEngineMetadataTableServiceImpl a2;
        String string = a2.engineDynamicDataSourceService.getDatasourceType();
        try {
            a2.generalMetadataManageTableMapper.updateEngineMetadataManageTable(a.getBaseInfo());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.for("\t\u0010\t\u0016\u0012\f\u0005\u0004\u001f\u001d\u001b\r\u001b\u001d\u001b\u0016\u0017\b\u0014\b\u001d\f\u0005\u001d\u001b\u000b\u0016\f`")).append(a.getBaseInfo().getId()).toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.boolean("o1o7t-c%y<},}<}7q)r){-c<}*p-\u0006")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            object2 = IdAcquisitionUtil.getCurrentTenantId();
            iterator = a.getBaseInfo().getDatasourceId();
            object = new StringBuilder().insert(0, OracleTransactionalExecuteService.for("\u001a\u0003\u001a\u0005\u0001\u001f\u0016\u0017\f\u000e\b\u001e\b\u000e\b\u0005\u0004\u001b\u0007\u001b\u000e\u001f\u0016\u000e\b\u0018\u0005\u001fs`")).append((String)object2).append(OracleMetadataManageTableDsServiceImpl.boolean("\u0006")).append(iterator).append(OracleTransactionalExecuteService.for("`")).append(a.getBaseInfo().getTableName().toUpperCase()).toString();
            DefaultCacheUtil.evict((Object)object);
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED);
        }
        object2 = a.getDeletedCols();
        if (StringUtils.isNotEmpty((Collection)a.getDeletedCols())) {
            try {
                a2.generalMetadataDetailMapper.delColInfo((List)object2);
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (EngineMetadataDetail)iterator.next();
                    DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.boolean("o1o7t-c%y<},}<}7x-h)u$c<}*p-\u0006")).append(object.getId()).toString());
                }
            }
            catch (Exception exception) {
                logger.error(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED.getMessage(), (Throwable)exception);
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
        iterator = a.getColumnInfo();
        object = new ArrayList();
        a = new ArrayList();
        object2 = DateUtils.getNowDate();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            engineMetadataDetailDto = (EngineMetadataDetailDto)iterator.next();
            if (engineMetadataDetailDto.getOperation() != null && OracleTransactionalExecuteService.for(",> .").equals(engineMetadataDetailDto.getOperation())) {
                if (null == engineMetadataDetailDto.getColumnComment() || "".equals(engineMetadataDetailDto.getColumnComment())) {
                    EngineMetadataDetailDto engineMetadataDetailDto2 = engineMetadataDetailDto;
                    engineMetadataDetailDto2.setColumnComment(engineMetadataDetailDto2.getColumnName());
                }
                if (null == engineMetadataDetailDto.getColumnChname() || "".equals(engineMetadataDetailDto.getColumnChname())) {
                    EngineMetadataDetailDto engineMetadataDetailDto3 = engineMetadataDetailDto;
                    engineMetadataDetailDto3.setColumnChname(engineMetadataDetailDto3.getColumnName());
                }
                if (null == engineMetadataDetailDto.getRemark() || "".equals(engineMetadataDetailDto.getRemark())) {
                    EngineMetadataDetailDto engineMetadataDetailDto4 = engineMetadataDetailDto;
                    engineMetadataDetailDto4.setRemark(engineMetadataDetailDto4.getColumnName());
                }
                EngineMetadataDetailDto engineMetadataDetailDto5 = engineMetadataDetailDto;
                EngineMetadataDetailDto engineMetadataDetailDto6 = engineMetadataDetailDto;
                engineMetadataDetailDto6.setLastTime(Instant.ofEpochMilli(((Date)object2).getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
                engineMetadataDetailDto5.setStatus(Integer.valueOf(1));
                engineMetadataDetailDto6.setLastEditor(IdAcquisitionUtil.getCurrentUserId());
                engineMetadataDetailDto5.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
                object.add(engineMetadataDetailDto);
                continue;
            }
            if (engineMetadataDetailDto.getOperation() == null || !OracleMetadataManageTableDsServiceImpl.boolean("]\fX").equals(engineMetadataDetailDto.getOperation())) continue;
            engineMetadataDetailDto.setId(IdGenerateUtils.getId());
            if (null == engineMetadataDetailDto.getColumnComment() || "".equals(engineMetadataDetailDto.getColumnComment())) {
                EngineMetadataDetailDto engineMetadataDetailDto7 = engineMetadataDetailDto;
                engineMetadataDetailDto7.setColumnComment(engineMetadataDetailDto7.getColumnName());
            }
            if (null == engineMetadataDetailDto.getColumnChname() || "".equals(engineMetadataDetailDto.getColumnChname())) {
                EngineMetadataDetailDto engineMetadataDetailDto8 = engineMetadataDetailDto;
                engineMetadataDetailDto8.setColumnChname(engineMetadataDetailDto8.getColumnName());
            }
            if (null == engineMetadataDetailDto.getRemark() || "".equals(engineMetadataDetailDto.getRemark())) {
                EngineMetadataDetailDto engineMetadataDetailDto9 = engineMetadataDetailDto;
                engineMetadataDetailDto9.setRemark(engineMetadataDetailDto9.getColumnName());
            }
            EngineMetadataDetailDto engineMetadataDetailDto10 = engineMetadataDetailDto;
            EngineMetadataDetailDto engineMetadataDetailDto11 = engineMetadataDetailDto;
            engineMetadataDetailDto11.setStatus(Integer.valueOf(1));
            engineMetadataDetailDto10.setCreateTime(Instant.ofEpochMilli(((Date)object2).getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
            engineMetadataDetailDto11.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            engineMetadataDetailDto10.setCreator(IdAcquisitionUtil.getCurrentUserId());
            a.add(engineMetadataDetailDto);
        }
        if (StringUtils.isNotEmpty((Collection)object)) {
            iterator = object.iterator();
            while (iterator.hasNext()) {
                engineMetadataDetailDto = (EngineMetadataDetail)iterator.next();
                if (!StringUtils.isEmpty((String)engineMetadataDetailDto.getColumnLength())) continue;
                engineMetadataDetailDto.setColumnLength("0");
            }
            try {
                a2.metadataDetailMapper.get(string).batchInsert((List)object);
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    engineMetadataDetailDto = (EngineMetadataDetail)iterator.next();
                    DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.for("\t\u0010\t\u0016\u0012\f\u0005\u0004\u001f\u001d\u001b\r\u001b\u001d\u001b\u0016\u001e\f\u000e\b\u0013\u0005\u0005\u001d\u001b\u000b\u0016\f`")).append(engineMetadataDetailDto.getId()).toString());
                }
            }
            catch (Exception exception) {
                logger.error(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED.getMessage(), (Throwable)exception);
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
        if (StringUtils.isNotEmpty((Collection)a)) {
            iterator = a.iterator();
            while (iterator.hasNext()) {
                engineMetadataDetailDto = (EngineMetadataDetail)iterator.next();
                if (!StringUtils.isEmpty((String)engineMetadataDetailDto.getColumnLength())) continue;
                engineMetadataDetailDto.setColumnLength("0");
            }
            try {
                a2.metadataDetailMapper.get(string).batchInsert((List)a);
            }
            catch (Exception exception) {
                logger.error(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED.getMessage(), (Throwable)exception);
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
        return true;
    }

    public boolean updateEngineMetadataManageTable(EngineMetadataParam a2) throws EngineException {
        Object object;
        EngineMetadataDetail engineMetadataDetail;
        OracleEngineMetadataTableServiceImpl a3;
        EngineMetadataParam engineMetadataParam = a2;
        EngineMetadataManageTable engineMetadataManageTable = engineMetadataParam.getBaseInfo();
        List list = engineMetadataParam.getColumnInfo();
        String string = engineMetadataManageTable.getDatasourceId().toString();
        Object object2 = a3.sysDataSourceService.getDatasourceById(string);
        if (object2 == null || object2.getData() == null) {
            logger.error(OracleMetadataManageTableDsServiceImpl.boolean("\u6c9d\u6761\u67d9\u8b8a\u520c\u6518\u6352\u6ef8\u4fdd\u6007\uff30\u6518\u6352\u6ef8u\f\u0006\u0013A"), (Object)string);
            throw new RuntimeException(new StringBuilder().insert(0, OracleTransactionalExecuteService.for("\u6cfb\u6740\u67bf\u8bab\u526a\u6539\u6334\u6ed9\u4fbb\u6026\uff56\u6539\u6334\u6ed9\u0013-`")).append(string).toString());
        }
        string = (SysDataSource)object2.getData();
        if (Objects.isNull(string)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        object2 = IdAcquisitionUtil.getCurrentTenantId();
        List list2 = a3.generalMetadataDetailMapper.selectColumnInfo(engineMetadataManageTable.getId().toString());
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        engineMetadataManageTable3.setCountColumn(Long.valueOf(list.size()));
        engineMetadataManageTable3.setLastTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable2.setLastEditor(IdAcquisitionUtil.getCurrentUserId());
        engineMetadataManageTable2.setTenantId((String)object2);
        if (StringUtils.isEmpty((String)engineMetadataManageTable2.getTableChname())) {
            EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
            engineMetadataManageTable4.setTableChname(engineMetadataManageTable4.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableComment())) {
            EngineMetadataManageTable engineMetadataManageTable5 = engineMetadataManageTable;
            engineMetadataManageTable5.setTableComment(engineMetadataManageTable5.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getRemark())) {
            EngineMetadataManageTable engineMetadataManageTable6 = engineMetadataManageTable;
            engineMetadataManageTable6.setRemark(engineMetadataManageTable6.getTableName());
        }
        OracleEngineMetadataTableServiceImpl oracleEngineMetadataTableServiceImpl = a3;
        object2 = oracleEngineMetadataTableServiceImpl.generalMetadataManageTableMapper.getTableNameById(engineMetadataManageTable.getId().toString());
        String string2 = engineMetadataManageTable.getTableName();
        Serializable serializable = oracleEngineMetadataTableServiceImpl.generalMetadataManageTableMapper.getVersion(engineMetadataManageTable.getId().toString());
        engineMetadataManageTable.setVersion((Long)serializable);
        serializable = new ArrayList();
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)3);
        ArrayList<EngineMetadataDetail> arrayList2 = new ArrayList<EngineMetadataDetail>();
        ArrayList<EngineMetadataDetail> arrayList3 = new ArrayList<EngineMetadataDetail>();
        HashSet hashSet = Sets.newHashSet();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        List list3 = a2.getDeletedCols();
        Map<String, EngineMetadataDetail> map = list2.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        Object object3 = list.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        Object object4 = list3.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        block2: for (Map.Entry object5 : map.entrySet()) {
            if (object3.get(object5.getKey()) != null || object4.get(object5.getKey()) != null || !((EngineMetadataDetail)object5.getValue()).getPk().equals("1")) continue;
            hashSet.add(object5.getKey());
            engineMetadataDetail = object3.entrySet().iterator();
            while (engineMetadataDetail.hasNext()) {
                object = engineMetadataDetail.next();
                if (!((EngineMetadataDetail)object5.getValue()).getId().equals(((EngineMetadataDetail)object.getValue()).getId())) continue;
                hashSet.remove(object5.getKey());
                continue block2;
            }
        }
        map = list2.stream().collect(Collectors.toMap(EngineMetadataDetail::getId, Function.identity())).entrySet().stream().collect(Collectors.toMap(a -> Long.toString((Long)a.getKey()), Map.Entry::getValue));
        object = list.iterator();
        while (object.hasNext()) {
            HashMap hashMap;
            String string3;
            list.setDefaultValue((list = (EngineMetadataDetailDto)object.next()).getDefaultValue() == null ? "" : list.getDefaultValue());
            List list4 = list;
            list4.setLastTime(LocalDateTime.now());
            list4.setStatus(1);
            if (null != list.getOperation() && OracleMetadataManageTableDsServiceImpl.boolean("]\fX").equalsIgnoreCase(list.getOperation())) {
                List list5 = list;
                list5.setId(IdGenerateUtils.getId());
                list5.setCreateTime(LocalDateTime.now());
                arrayList3.add((EngineMetadataDetail)list5);
            }
            if (list.getPk().equals("1")) {
                hashSet.add(list.getColumnName());
            }
            if ((string3 = list.getId().toString()) == null || !OracleTransactionalExecuteService.for(",> .").equalsIgnoreCase(list.getOperation())) continue;
            engineMetadataDetail = map.get(string3);
            List list6 = list;
            object3 = list6.getColumnComment();
            object4 = list6.getColumnName();
            if (!((String)object4).equals(engineMetadataDetail.getColumnName())) {
                hashMap = Maps.newHashMapWithExpectedSize((int)3);
                hashMap.put(OracleMetadataManageTableDsServiceImpl.boolean("S\u0004X+S\u0004I\u0005R&]\u0005Y"), engineMetadataDetail.getColumnName());
                hashMap.put(OracleTransactionalExecuteService.for("*5%/$4\u0007;$?"), object4);
                serializable.add(hashMap);
            }
            if (!StringUtils.isEmpty((String)object3) && !((String)object3).equals(engineMetadataDetail.getColumnComment())) {
                hashMap = Maps.newHashMapWithExpectedSize((int)3);
                hashMap.put(OracleMetadataManageTableDsServiceImpl.boolean("\u000bS\u0004I\u0005R&]\u0005Y"), object4);
                hashMap.put(OracleTransactionalExecuteService.for("9&7$?'."), object3);
                arrayList.add(hashMap);
            }
            if (!list.getRequired().equals(map.get(list.getId().toString()).getRequired())) {
                list.setNeedChangeIsRequired(true);
            }
            arrayList2.add((EngineMetadataDetail)list);
        }
        try {
            a3.dsService.editTable(engineMetadataManageTable, list2, (String)object2, string2, (List<Map<String, String>>)((Object)serializable), arrayList, arrayList2, arrayList3, hashSet, arrayList4, list3, map, string.getConnName(), 0);
        }
        catch (Exception exception) {
            logger.error(OracleMetadataManageTableDsServiceImpl.boolean("\u654c\u6306\u5eaf\u64a5\u4f60\u5f6a\u5e04"), (Throwable)exception);
            throw new EngineException(exception.getMessage());
        }
        return a3.updateTableInfo(a2);
    }

    public boolean updateTableInfoNew(EngineMetadataParam a) throws EngineException {
        OracleEngineMetadataTableServiceImpl a2;
        String string = a2.engineDynamicDataSourceService.getDatasourceType();
        Object object = String.valueOf(a.getBaseInfo().getId());
        try {
            OracleEngineMetadataTableServiceImpl oracleEngineMetadataTableServiceImpl = a2;
            oracleEngineMetadataTableServiceImpl.generalMetadataManageTableMapper.updateEngineMetadataManageTable(a.getBaseInfo());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.boolean("o1o7t-c%y<},}<}7q)r){-c<}*p-\u0006")).append(a.getBaseInfo().getId()).toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.for("\t\u0010\t\u0016\u0012\f\u0005\u0004\u001f\u001d\u001b\r\u001b\u001d\u001b\u0016\u0017\b\u0014\b\u001d\f\u0005\u001d\u001b\u000b\u0016\f`")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            String string2 = IdAcquisitionUtil.getCurrentTenantId();
            Object object2 = a.getBaseInfo().getDatasourceId();
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.boolean(";e;c y7q-h)x)h)c%}&}/y7h)~$yR\u0006")).append(string2).append(OracleTransactionalExecuteService.for("`")).append(object2).append(OracleMetadataManageTableDsServiceImpl.boolean("\u0006")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            object2 = oracleEngineMetadataTableServiceImpl.generalMetadataDetailMapper.selectByTableId((String)object).stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
            a2.generalMetadataDetailMapper.delColumn((String)object);
            a = a.getColumnInfo();
            object = a.iterator();
            while (object.hasNext()) {
                EngineMetadataDetailDto engineMetadataDetailDto = (EngineMetadataDetailDto)object.next();
                EngineMetadataDetail engineMetadataDetail = (EngineMetadataDetail)object2.get(engineMetadataDetailDto.getColumnName());
                if (!HussarUtils.isNotEmpty((Object)engineMetadataDetail)) continue;
                engineMetadataDetailDto.setId(engineMetadataDetail.getId());
            }
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED);
        }
        a2.metadataDetailMapper.get(string).batchInsert((List)a);
        return true;
    }

    public boolean insertTableInfo(EngineMetadataParam a3) throws EngineException {
        Object object;
        OracleEngineMetadataTableServiceImpl a2;
        Object object2 = a3.getBaseInfo();
        String string = a2.engineDynamicDataSourceService.getDatasourceType();
        try {
            EngineMetadataManageTable engineMetadataManageTable = object2;
            EngineMetadataManageTable engineMetadataManageTable2 = object2;
            engineMetadataManageTable2.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            engineMetadataManageTable.setStatus("1");
            engineMetadataManageTable2.setCreator(IdAcquisitionUtil.getCurrentUserId());
            engineMetadataManageTable.setCreateTime(LocalDateTime.now());
            engineMetadataManageTable.setLastEditor(engineMetadataManageTable.getCreator());
            engineMetadataManageTable.setLastTime(LocalDateTime.now());
            if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableChname())) {
                EngineMetadataManageTable engineMetadataManageTable3 = object2;
                engineMetadataManageTable3.setTableChname(engineMetadataManageTable3.getTableName());
            }
            if (StringUtils.isEmpty((String)object2.getTableComment())) {
                EngineMetadataManageTable engineMetadataManageTable4 = object2;
                engineMetadataManageTable4.setTableComment(engineMetadataManageTable4.getTableName());
            }
            if (StringUtils.isEmpty((String)object2.getRemark())) {
                EngineMetadataManageTable engineMetadataManageTable5 = object2;
                engineMetadataManageTable5.setRemark(engineMetadataManageTable5.getTableName());
            }
            EngineMetadataManageTable engineMetadataManageTable6 = object2;
            engineMetadataManageTable6.setRemark(engineMetadataManageTable6.getTableComment());
            a2.generalMetadataManageTableMapper.insertEngineMetadataManageTable(object2);
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.INSERT_TABLE_INFORMATION_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.INSERT_TABLE_INFORMATION_FAILED, (Throwable)exception);
        }
        List list = a3.getColumnInfo();
        a3 = list.iterator();
        Iterator iterator = a3;
        while (iterator.hasNext()) {
            object = (EngineMetadataDetail)a3.next();
            iterator = a3;
            EngineMetadataDetail engineMetadataDetail = object;
            Object object3 = object;
            object.setId(IdGenerateUtils.getId());
            object3.setTableId(object2.getId());
            engineMetadataDetail.setStatus(Integer.valueOf(1));
            object3.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
            engineMetadataDetail.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            engineMetadataDetail.setCreator(IdAcquisitionUtil.getCurrentUserId());
        }
        try {
            a3 = Lists.partition((List)list, (int)10);
            object = a3.iterator();
            while (object.hasNext()) {
                object2 = (List)object.next();
                a2.metadataDetailMapper.get(string).batchInsert((List)object2);
            }
        }
        catch (Exception a3) {
            logger.error(EngineExceptionEnum.INSERT_COLUMN_INFORMATION_FAILED.getMessage(), (Throwable)a3);
            throw new EngineException(EngineExceptionEnum.INSERT_COLUMN_INFORMATION_FAILED, (Throwable)a3);
        }
        return true;
    }

    public boolean insertView(EngineMetadataParam a) throws EngineException {
        OracleEngineMetadataTableServiceImpl a2;
        Object object;
        EngineMetadataParam engineMetadataParam = a;
        EngineMetadataManageTable engineMetadataManageTable = engineMetadataParam.getBaseInfo();
        Object object2 = engineMetadataParam.getColumnInfo();
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
        engineMetadataManageTable4.setCountColumn(Long.valueOf(object2.size()));
        engineMetadataManageTable4.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable3.setVersion(Long.valueOf(0L));
        engineMetadataManageTable3.setStatus("1");
        engineMetadataManageTable2.setViewFlag("1");
        engineMetadataManageTable2.setCharacterSet(OracleTransactionalExecuteService.for("\u001c\u000e\u000fb"));
        engineMetadataManageTable2.setId(IdGenerateUtils.getId());
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = (EngineMetadataDetail)object2.next();
            if (StringUtils.isEmpty((String)object.getPk())) {
                object.setPk("0");
            }
            EngineMetadataDetail engineMetadataDetail = object;
            engineMetadataDetail.setIncre("0");
            engineMetadataDetail.setRequired("0");
            if (StringUtils.isEmpty((String)object.getColumnChname())) {
                EngineMetadataDetail engineMetadataDetail2 = object;
                engineMetadataDetail2.setColumnChname(engineMetadataDetail2.getColumnName());
            }
            if (!StringUtils.isEmpty((String)object.getColumnComment())) continue;
            EngineMetadataDetail engineMetadataDetail3 = object;
            engineMetadataDetail3.setColumnComment(engineMetadataDetail3.getColumnName());
        }
        object2 = engineMetadataManageTable.getDatasourceId().toString();
        object = a2.sysDataSourceService.getDatasourceById((String)object2);
        if (object == null || object.getData() == null) {
            logger.error(OracleMetadataManageTableDsServiceImpl.boolean("\u6c9d\u6761\u67d9\u8b8a\u520c\u6518\u6352\u6ef8\u4fdd\u6007\uff30\u6518\u6352\u6ef8u\f\u0006\u0013A"), object2);
            throw new RuntimeException(new StringBuilder().insert(0, OracleTransactionalExecuteService.for("\u6cfb\u6740\u67bf\u8bab\u526a\u6539\u6334\u6ed9\u4fbb\u6026\uff56\u6539\u6334\u6ed9\u0013-`")).append((String)object2).toString());
        }
        if (Objects.isNull((SysDataSource)object.getData())) {
            logger.error(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST.getMessage());
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        object2 = IdAcquisitionUtil.getCurrentTenantId();
        if (!StringUtils.isNull((Object)(engineMetadataManageTable = a2.generalMetadataManageTableMapper.selectEngineMetadataManageTableByTableName(engineMetadataManageTable)))) {
            a2.generalMetadataManageTableMapper.deleteEngineMetadataManageTableById(engineMetadataManageTable.getId().toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.boolean("o1o7t-c%y<},}<}7q)r){-c<}*p-\u0006")).append(a.getBaseInfo().getId()).toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.for("\t\u0010\t\u0016\u0012\f\u0005\u0004\u001f\u001d\u001b\r\u001b\u001d\u001b\u0016\u0017\b\u0014\b\u001d\f\u0005\u001d\u001b\u000b\u0016\f`")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            object = a.getBaseInfo().getDatasourceId();
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.boolean(";e;c y7q-h)x)h)c%}&}/y7h)~$yR\u0006")).append((String)object2).append(OracleTransactionalExecuteService.for("`")).append(object).append(OracleMetadataManageTableDsServiceImpl.boolean("\u0006")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            a2.generalMetadataDetailMapper.delColumn(engineMetadataManageTable.getId().toString());
        }
        return a2.insertTableInfo(a);
    }

    public boolean insertEngineMetadataManageTable(EngineMetadataParam a) throws EngineException {
        String string;
        Serializable serializable;
        EngineMetadataDetail engineMetadataDetail;
        String string2;
        OracleEngineMetadataTableServiceImpl a2;
        Object object;
        EngineMetadataParam engineMetadataParam = a;
        EngineMetadataManageTable engineMetadataManageTable = engineMetadataParam.getBaseInfo();
        Object object2 = engineMetadataParam.getColumnInfo();
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
        engineMetadataManageTable.setCountColumn(Long.valueOf(object2.size()));
        engineMetadataManageTable4.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable4.setVersion(Long.valueOf(0L));
        engineMetadataManageTable3.setStatus("1");
        engineMetadataManageTable2.setCharacterSet(OracleTransactionalExecuteService.for("\u001c\u000e\u000fb"));
        engineMetadataManageTable3.setId(IdGenerateUtils.getId());
        if (StringUtils.isEmpty((String)engineMetadataManageTable2.getTableChname())) {
            EngineMetadataManageTable engineMetadataManageTable5 = engineMetadataManageTable;
            engineMetadataManageTable5.setTableChname(engineMetadataManageTable5.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableComment())) {
            EngineMetadataManageTable engineMetadataManageTable6 = engineMetadataManageTable;
            engineMetadataManageTable6.setTableComment(engineMetadataManageTable6.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getRemark())) {
            EngineMetadataManageTable engineMetadataManageTable7 = engineMetadataManageTable;
            engineMetadataManageTable7.setRemark(engineMetadataManageTable7.getTableName());
        }
        if ((object = a2.sysDataSourceService.getDatasourceById(string2 = engineMetadataManageTable.getDatasourceId().toString())) == null || object.getData() == null) {
            logger.error(OracleMetadataManageTableDsServiceImpl.boolean("\u6c9d\u6761\u67d9\u8b8a\u520c\u6518\u6352\u6ef8\u4fdd\u6007\uff30\u6518\u6352\u6ef8u\f\u0006\u0013A"), (Object)string2);
            throw new RuntimeException(new StringBuilder().insert(0, OracleTransactionalExecuteService.for("\u6cfb\u6740\u67bf\u8bab\u526a\u6539\u6334\u6ed9\u4fbb\u6026\uff56\u6539\u6334\u6ed9\u0013-`")).append(string2).toString());
        }
        string2 = (SysDataSource)object.getData();
        if (Objects.isNull(string2)) {
            logger.error(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST.getMessage());
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        object = IdAcquisitionUtil.getCurrentTenantId();
        Object object3 = object2 = object2.iterator();
        while (object3.hasNext()) {
            ArrayList<Map<String, String>> arrayList3;
            String string3;
            engineMetadataDetail = (EngineMetadataDetail)object2.next();
            if (engineMetadataDetail.getPk().equals("1")) {
                arrayList2.add(engineMetadataDetail.getColumnName());
            }
            serializable = new HashMap<String, String>();
            EngineMetadataDetail engineMetadataDetail2 = engineMetadataDetail;
            serializable.put(OracleMetadataManageTableDsServiceImpl.boolean("\u000bS\u0004I\u0005R&]\u0005Y"), engineMetadataDetail2.getColumnName());
            serializable.put(OracleTransactionalExecuteService.for(" )\u001b?8/ (,>"), engineMetadataDetail.getRequired().toString());
            serializable.put(OracleMetadataManageTableDsServiceImpl.boolean("U\u001bu\u0006_\u001aY"), "0");
            serializable.put(OracleTransactionalExecuteService.for("9&6<7'\u0019&7$?'."), engineMetadataDetail.getColumnComment());
            serializable.put(OracleMetadataManageTableDsServiceImpl.boolean("\fY\u000e]\u001dP\u001cj\tP\u001dY"), engineMetadataDetail.getDefaultValue());
            if (StringUtils.isEmpty((String)engineMetadataDetail2.getColumnChname())) {
                EngineMetadataDetail engineMetadataDetail3 = engineMetadataDetail;
                engineMetadataDetail3.setColumnChname(engineMetadataDetail3.getColumnName());
            }
            if (StringUtils.isEmpty((String)engineMetadataDetail.getColumnComment())) {
                EngineMetadataDetail engineMetadataDetail4 = engineMetadataDetail;
                engineMetadataDetail4.setColumnComment(engineMetadataDetail4.getColumnName());
            }
            if (engineMetadataDetail.getColumnLength() != null) {
                serializable.put(OracleTransactionalExecuteService.for("*5%/$4\u0005?'==2"), engineMetadataDetail.getColumnLength().toString());
            }
            if (engineMetadataDetail.getPointLength() != null) {
                serializable.put(OracleMetadataManageTableDsServiceImpl.boolean("L\u0007U\u0006H$Y\u0006[\u001cT"), engineMetadataDetail.getPointLength().toString());
            }
            string = engineMetadataDetail.getColumnType();
            if (OracleTransactionalExecuteService.for("4<7,( 9").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.boolean("X\r_\u0001Q\tP").equalsIgnoreCase(string) || OracleTransactionalExecuteService.for("-5<8%?").equalsIgnoreCase(string)) {
                string3 = new StringBuilder().insert(0, string).append(OracleMetadataManageTableDsServiceImpl.boolean("\u0014")).append(engineMetadataDetail.getColumnLength()).append(OracleTransactionalExecuteService.for("v")).append(engineMetadataDetail.getPointLength()).append(OracleMetadataManageTableDsServiceImpl.boolean("\u0015")).toString();
                arrayList3 = arrayList;
                serializable.put(OracleTransactionalExecuteService.for("*5%/$4\u001d#9?"), string3);
            } else if (OracleMetadataManageTableDsServiceImpl.boolean("\f]\u001cY").equalsIgnoreCase(string) || OracleTransactionalExecuteService.for("-;=?=3$?").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.boolean("\u0004S\u0006[\u001cY\u0010H").equalsIgnoreCase(string) || OracleTransactionalExecuteService.for("=?1.").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.boolean("\nP\u0007^").equalsIgnoreCase(string) || OracleTransactionalExecuteService.for("%5'=+6&8").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.boolean("\u0005Y\fU\u001dQ").equalsIgnoreCase(string) || OracleTransactionalExecuteService.for("$?-3<7=?1.").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.boolean("\u0005Y\fU\u001dQ\nP\u0007^").equalsIgnoreCase(string) || OracleTransactionalExecuteService.for("=3'#=?1.").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.boolean("\u001cU\u0006E\nP\u0007^").equalsIgnoreCase(string)) {
                serializable.put(OracleTransactionalExecuteService.for("*5%/$4\u001d#9?"), string);
                arrayList3 = arrayList;
            } else {
                string3 = new StringBuilder().insert(0, engineMetadataDetail.getColumnType()).append(OracleMetadataManageTableDsServiceImpl.boolean("\u0014")).append(engineMetadataDetail.getColumnLength()).append(OracleTransactionalExecuteService.for("s")).toString();
                arrayList3 = arrayList;
                serializable.put(OracleMetadataManageTableDsServiceImpl.boolean("\u000bS\u0004I\u0005R<E\u0018Y"), string3);
            }
            arrayList3.add((Map<String, String>)((Object)serializable));
            object3 = object2;
        }
        boolean bl = StringUtils.isNotEmpty(arrayList2);
        try {
            a2.dsService.createTable(engineMetadataManageTable, arrayList, arrayList2, bl, string2.getConnName());
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.CREATE_DATABASE_TABLE_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.CREATE_DATABASE_TABLE_FAILED, (Throwable)exception);
        }
        engineMetadataDetail = a2.generalMetadataManageTableMapper.selectEngineMetadataManageTableByTableName(engineMetadataManageTable);
        if (!StringUtils.isNull((Object)engineMetadataDetail)) {
            a2.generalMetadataManageTableMapper.deleteEngineMetadataManageTableById(engineMetadataDetail.getId().toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.for("\t\u0010\t\u0016\u0012\f\u0005\u0004\u001f\u001d\u001b\r\u001b\u001d\u001b\u0016\u0017\b\u0014\b\u001d\f\u0005\u001d\u001b\u000b\u0016\f`")).append(engineMetadataDetail.getId()).toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.boolean("o1o7t-c%y<},}<}7q)r){-c<}*p-\u0006")).append(engineMetadataDetail.getTableName().toUpperCase()).toString());
            serializable = engineMetadataDetail.getDatasourceId();
            string = new StringBuilder().insert(0, OracleTransactionalExecuteService.for("\u001a\u0003\u001a\u0005\u0001\u001f\u0016\u0017\f\u000e\b\u001e\b\u000e\b\u0005\u0004\u001b\u0007\u001b\u000e\u001f\u0016\u000e\b\u0018\u0005\u001fs`")).append((String)object).append(OracleMetadataManageTableDsServiceImpl.boolean("\u0006")).append(serializable).append(OracleTransactionalExecuteService.for("`")).append(a.getBaseInfo().getTableName().toUpperCase()).toString();
            DefaultCacheUtil.evict((Object)string);
            a2.generalMetadataDetailMapper.delColumn(engineMetadataDetail.getId().toString());
        }
        return a2.insertTableInfo(a);
    }

    public void createTable(EngineMetadataParam a) throws EngineException {
        String string;
        OracleEngineMetadataTableServiceImpl a2;
        ApiResponse apiResponse;
        EngineMetadataParam engineMetadataParam = a;
        a = engineMetadataParam.getBaseInfo();
        Object object = engineMetadataParam.getColumnInfo();
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        EngineMetadataParam engineMetadataParam2 = a;
        EngineMetadataParam engineMetadataParam3 = a;
        EngineMetadataParam engineMetadataParam4 = a;
        a.setCountColumn(Long.valueOf(object.size()));
        engineMetadataParam4.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataParam4.setVersion(Long.valueOf(0L));
        engineMetadataParam3.setStatus("1");
        engineMetadataParam2.setCharacterSet(OracleTransactionalExecuteService.for("\u001c\u000e\u000fb"));
        engineMetadataParam3.setId(IdGenerateUtils.getId());
        if (StringUtils.isEmpty((String)engineMetadataParam2.getTableChname())) {
            EngineMetadataParam engineMetadataParam5 = a;
            engineMetadataParam5.setTableChname(engineMetadataParam5.getTableName());
        }
        if (StringUtils.isEmpty((String)a.getTableComment())) {
            EngineMetadataParam engineMetadataParam6 = a;
            engineMetadataParam6.setTableComment(engineMetadataParam6.getTableName());
        }
        if (StringUtils.isEmpty((String)a.getRemark())) {
            EngineMetadataParam engineMetadataParam7 = a;
            engineMetadataParam7.setRemark(engineMetadataParam7.getTableName());
        }
        if ((apiResponse = a2.sysDataSourceService.getDatasourceById(string = a.getDatasourceId().toString())) == null || apiResponse.getData() == null) {
            logger.error(OracleMetadataManageTableDsServiceImpl.boolean("\u6c9d\u6761\u67d9\u8b8a\u520c\u6518\u6352\u6ef8\u4fdd\u6007\uff30\u6518\u6352\u6ef8u\f\u0006\u0013A"), (Object)string);
            throw new RuntimeException(new StringBuilder().insert(0, OracleTransactionalExecuteService.for("\u6cfb\u6740\u67bf\u8bab\u526a\u6539\u6334\u6ed9\u4fbb\u6026\uff56\u6539\u6334\u6ed9\u0013-`")).append(string).toString());
        }
        string = (SysDataSource)apiResponse.getData();
        if (Objects.isNull(string)) {
            logger.error(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST.getMessage());
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        Object object2 = object = object.iterator();
        while (object2.hasNext()) {
            ArrayList<Map<String, String>> arrayList3;
            String string2;
            apiResponse = (EngineMetadataDetail)object.next();
            if (apiResponse.getPk().equals("1")) {
                arrayList2.add(apiResponse.getColumnName());
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ApiResponse apiResponse2 = apiResponse;
            hashMap.put(OracleMetadataManageTableDsServiceImpl.boolean("\u000bS\u0004I\u0005R&]\u0005Y"), apiResponse2.getColumnName());
            hashMap.put(OracleTransactionalExecuteService.for(" )\u001b?8/ (,>"), apiResponse.getRequired().toString());
            hashMap.put(OracleMetadataManageTableDsServiceImpl.boolean("U\u001bu\u0006_\u001aY"), "0");
            hashMap.put(OracleTransactionalExecuteService.for("9&6<7'\u0019&7$?'."), apiResponse.getColumnComment());
            hashMap.put(OracleMetadataManageTableDsServiceImpl.boolean("\fY\u000e]\u001dP\u001cj\tP\u001dY"), apiResponse.getDefaultValue());
            if (StringUtils.isEmpty((String)apiResponse2.getColumnChname())) {
                ApiResponse apiResponse3 = apiResponse;
                apiResponse3.setColumnChname(apiResponse3.getColumnName());
            }
            if (StringUtils.isEmpty((String)apiResponse.getColumnComment())) {
                ApiResponse apiResponse4 = apiResponse;
                apiResponse4.setColumnComment(apiResponse4.getColumnName());
            }
            String string3 = apiResponse.getColumnType();
            if (OracleTransactionalExecuteService.for("4<7,( 9").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.boolean("X\r_\u0001Q\tP").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.for("-5<8%?").equalsIgnoreCase(string3)) {
                string2 = new StringBuilder().insert(0, string3).append(OracleMetadataManageTableDsServiceImpl.boolean("\u0014")).append(apiResponse.getColumnLength()).append(OracleTransactionalExecuteService.for("v")).append(apiResponse.getPointLength()).append(OracleMetadataManageTableDsServiceImpl.boolean("\u0015")).toString();
                arrayList3 = arrayList;
                hashMap.put(OracleTransactionalExecuteService.for("*5%/$4\u001d#9?"), string2);
            } else if (OracleMetadataManageTableDsServiceImpl.boolean("\f]\u001cY").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.for("-;=?=3$?").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.boolean("\u0004S\u0006[\u001cY\u0010H").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.for("=?1.").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.boolean("\nP\u0007^").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.for("%5'=+6&8").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.boolean("\u0005Y\fU\u001dQ").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.for("$?-3<7=?1.").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.boolean("\u0005Y\fU\u001dQ\nP\u0007^").equalsIgnoreCase(string3) || OracleTransactionalExecuteService.for("=3'#=?1.").equalsIgnoreCase(string3) || OracleMetadataManageTableDsServiceImpl.boolean("\u001cU\u0006E\nP\u0007^").equalsIgnoreCase(string3)) {
                hashMap.put(OracleTransactionalExecuteService.for("*5%/$4\u001d#9?"), string3);
                arrayList3 = arrayList;
            } else {
                string2 = new StringBuilder().insert(0, apiResponse.getColumnType()).append(OracleMetadataManageTableDsServiceImpl.boolean("\u0014")).append(apiResponse.getColumnLength()).append(OracleTransactionalExecuteService.for("s")).toString();
                arrayList3 = arrayList;
                hashMap.put(OracleMetadataManageTableDsServiceImpl.boolean("\u000bS\u0004I\u0005R<E\u0018Y"), string2);
            }
            arrayList3.add(hashMap);
            object2 = object;
        }
        boolean bl = StringUtils.isNotEmpty(arrayList2);
        try {
            a2.dsService.createTable((EngineMetadataManageTable)a, arrayList, arrayList2, bl, string.getConnName());
            return;
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.CREATE_DATABASE_TABLE_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.CREATE_DATABASE_TABLE_FAILED, (Throwable)exception);
        }
    }

    public OracleEngineMetadataTableServiceImpl() {
        OracleEngineMetadataTableServiceImpl a;
    }
}

