/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine.oracle.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.engine.metadata.dao.EngineMetadataDetailMapper;
import com.jxdinfo.hussar.engine.metadata.dao.EngineMetadataManageTableMapper;
import com.jxdinfo.hussar.engine.metadata.dao.EnginePlatformTableMapper;
import com.jxdinfo.hussar.engine.metadata.dto.EngineMetadataDetailDto;
import com.jxdinfo.hussar.engine.metadata.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.engine.metadata.exception.EngineException;
import com.jxdinfo.hussar.engine.metadata.model.EngineMetadataDetail;
import com.jxdinfo.hussar.engine.metadata.model.EngineMetadataManageTable;
import com.jxdinfo.hussar.engine.metadata.model.EngineMetadataParam;
import com.jxdinfo.hussar.engine.metadata.service.EngineDynamicDataSourceService;
import com.jxdinfo.hussar.engine.metadata.strategy.EnginePlatformTableFactory;
import com.jxdinfo.hussar.engine.metadata.util.DateUtils;
import com.jxdinfo.hussar.engine.metadata.util.IdAcquisitionUtil;
import com.jxdinfo.hussar.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.hussar.engine.metadata.util.StringUtils;
import com.jxdinfo.hussar.engine.oracle.dao.OracleTargetDataBaseMapper;
import com.jxdinfo.hussar.engine.oracle.service.OracleTransactionalExecuteService;
import com.jxdinfo.hussar.engine.oracle.service.impl.OracleMetadataManageTableDsServiceImpl;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@HussarDs(value="master")
public class OracleEngineMetadataTableServiceImpl {
    @Autowired
    private OracleMetadataManageTableDsServiceImpl dsService;
    private Map<String, EnginePlatformTableMapper> metadataDetailMapper = EnginePlatformTableFactory.getMappers((String)OracleTransactionalExecuteService.class("Fo_kOk_koo_kBf"));
    @Autowired
    private OracleTargetDataBaseMapper targetDataBaseOracleMapper;
    @Autowired
    private EngineDynamicDataSourceService engineDynamicDataSourceService;
    private static final Logger logger = LoggerFactory.getLogger(OracleEngineMetadataTableServiceImpl.class);
    @Autowired
    private EngineMetadataManageTableMapper generalMetadataManageTableMapper;
    @Autowired
    private SysDataSourceService sysDataSourceService;
    @Autowired
    private EngineMetadataDetailMapper generalMetadataDetailMapper;

    public boolean updateEngineMetadataManageTable(EngineMetadataParam a2) throws EngineException {
        Object object;
        EngineMetadataDetail engineMetadataDetail;
        OracleEngineMetadataTableServiceImpl a3;
        EngineMetadataParam engineMetadataParam = a2;
        EngineMetadataManageTable engineMetadataManageTable = engineMetadataParam.getBaseInfo();
        List list = engineMetadataParam.getColumnInfo();
        String string = engineMetadataManageTable.getDatasourceId().toString();
        Object object2 = a3.sysDataSourceService.getDatasourceById(string);
        if (object2 == null || object2.getData() == null) {
            logger.error(OracleMetadataManageTableDsServiceImpl.break("\u6cca\u673d\u678e\u8bd6\u525b\u6544\u6305\u6ea4\u4f8a\u605b\uff67\u6544\u6305\u6ea4\"PQO\u0016"), (Object)string);
            throw new RuntimeException(new StringBuilder().insert(0, OracleTransactionalExecuteService.class("\u6cab\u6722\u67ef\u8bc9\u523a\u655b\u6364\u6ebb\u4feb\u6044\uff06\u655b\u6364\u6ebbCO0")).append(string).toString());
        }
        string = (SysDataSource)object2.getData();
        if (Objects.isNull(string)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        object2 = IdAcquisitionUtil.getCurrentTenantId();
        List list2 = a3.generalMetadataDetailMapper.selectColumnInfo(engineMetadataManageTable.getId().toString());
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        engineMetadataManageTable3.setCountColumn(Long.valueOf(list.size()));
        engineMetadataManageTable3.setLastTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable2.setLastEditor(IdAcquisitionUtil.getCurrentUserId());
        engineMetadataManageTable2.setTenantId((String)object2);
        if (StringUtils.isEmpty((String)engineMetadataManageTable2.getTableChname())) {
            EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
            engineMetadataManageTable4.setTableChname(engineMetadataManageTable4.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableComment())) {
            EngineMetadataManageTable engineMetadataManageTable5 = engineMetadataManageTable;
            engineMetadataManageTable5.setTableComment(engineMetadataManageTable5.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getRemark())) {
            EngineMetadataManageTable engineMetadataManageTable6 = engineMetadataManageTable;
            engineMetadataManageTable6.setRemark(engineMetadataManageTable6.getTableName());
        }
        OracleEngineMetadataTableServiceImpl oracleEngineMetadataTableServiceImpl = a3;
        object2 = oracleEngineMetadataTableServiceImpl.generalMetadataManageTableMapper.getTableNameById(engineMetadataManageTable.getId().toString());
        String string2 = engineMetadataManageTable.getTableName();
        Serializable serializable = oracleEngineMetadataTableServiceImpl.generalMetadataManageTableMapper.getVersion(engineMetadataManageTable.getId().toString());
        engineMetadataManageTable.setVersion((Long)serializable);
        serializable = new ArrayList();
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)3);
        ArrayList<EngineMetadataDetail> arrayList2 = new ArrayList<EngineMetadataDetail>();
        ArrayList<EngineMetadataDetail> arrayList3 = new ArrayList<EngineMetadataDetail>();
        HashSet hashSet = Sets.newHashSet();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        List list3 = a2.getDeletedCols();
        Map<String, EngineMetadataDetail> map = list2.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        Object object3 = list.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        Object object4 = list3.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        block2: for (Map.Entry object5 : map.entrySet()) {
            if (object3.get(object5.getKey()) != null || object4.get(object5.getKey()) != null || !((EngineMetadataDetail)object5.getValue()).getPk().equals("1")) continue;
            hashSet.add(object5.getKey());
            engineMetadataDetail = object3.entrySet().iterator();
            while (engineMetadataDetail.hasNext()) {
                object = engineMetadataDetail.next();
                if (!((EngineMetadataDetail)object5.getValue()).getId().equals(((EngineMetadataDetail)object.getValue()).getId())) continue;
                hashSet.remove(object5.getKey());
                continue block2;
            }
        }
        map = list2.stream().collect(Collectors.toMap(EngineMetadataDetail::getId, Function.identity())).entrySet().stream().collect(Collectors.toMap(a -> Long.toString((Long)a.getKey()), Map.Entry::getValue));
        object = list.iterator();
        while (object.hasNext()) {
            HashMap hashMap;
            String string3;
            list.setDefaultValue((list = (EngineMetadataDetailDto)object.next()).getDefaultValue() == null ? "" : list.getDefaultValue());
            List list4 = list;
            list4.setLastTime(LocalDateTime.now());
            list4.setStatus(1);
            if (null != list.getOperation() && OracleMetadataManageTableDsServiceImpl.break("\nP\u000f").equalsIgnoreCase(list.getOperation())) {
                List list5 = list;
                list5.setId(IdGenerateUtils.getId());
                list5.setCreateTime(LocalDateTime.now());
                arrayList3.add((EngineMetadataDetail)list5);
            }
            if (list.getPk().equals("1")) {
                hashSet.add(list.getColumnName());
            }
            if ((string3 = list.getId().toString()) == null || !OracleTransactionalExecuteService.class("NnB~").equalsIgnoreCase(list.getOperation())) continue;
            engineMetadataDetail = map.get(string3);
            List list6 = list;
            object3 = list6.getColumnComment();
            object4 = list6.getColumnName();
            if (!((String)object4).equals(engineMetadataDetail.getColumnName())) {
                hashMap = Maps.newHashMapWithExpectedSize((int)3);
                hashMap.put(OracleMetadataManageTableDsServiceImpl.break("\u0004X\u000fw\u0004X\u001eY\u0005z\nY\u000e"), engineMetadataDetail.getColumnName());
                hashMap.put(OracleTransactionalExecuteService.class("HeG\u007fFdekFo"), object4);
                serializable.add(hashMap);
            }
            if (!StringUtils.isEmpty((String)object3) && !((String)object3).equals(engineMetadataDetail.getColumnComment())) {
                hashMap = Maps.newHashMapWithExpectedSize((int)3);
                hashMap.put(OracleMetadataManageTableDsServiceImpl.break("W\u0004X\u001eY\u0005z\nY\u000e"), object4);
                hashMap.put(OracleTransactionalExecuteService.class("iDgFoE~"), object3);
                arrayList.add(hashMap);
            }
            if (!list.getRequired().equals(map.get(list.getId().toString()).getRequired())) {
                list.setNeedChangeIsRequired(true);
            }
            arrayList2.add((EngineMetadataDetail)list);
        }
        try {
            a3.dsService.editTable(engineMetadataManageTable, list2, (String)object2, string2, (List<Map<String, String>>)((Object)serializable), arrayList, arrayList2, arrayList3, hashSet, arrayList4, list3, map, string.getConnName());
        }
        catch (Exception exception) {
            logger.error(OracleMetadataManageTableDsServiceImpl.break("\u651b\u635a\u5ef8\u64f9\u4f37\u5f36\u5e53"), (Throwable)exception);
            throw new EngineException(exception.getMessage());
        }
        return a3.updateTableInfo(a2);
    }

    public OracleEngineMetadataTableServiceImpl() {
        OracleEngineMetadataTableServiceImpl a;
    }

    public boolean insertEngineMetadataManageTable(EngineMetadataParam a) throws EngineException {
        String string;
        Serializable serializable;
        EngineMetadataDetail engineMetadataDetail;
        String string2;
        OracleEngineMetadataTableServiceImpl a2;
        Object object;
        EngineMetadataParam engineMetadataParam = a;
        EngineMetadataManageTable engineMetadataManageTable = engineMetadataParam.getBaseInfo();
        Object object2 = engineMetadataParam.getColumnInfo();
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
        engineMetadataManageTable.setCountColumn(Long.valueOf(object2.size()));
        engineMetadataManageTable4.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable4.setVersion(Long.valueOf(0L));
        engineMetadataManageTable3.setStatus("1");
        engineMetadataManageTable2.setCharacterSet(OracleMetadataManageTableDsServiceImpl.break("a?rS"));
        engineMetadataManageTable3.setId(IdGenerateUtils.getId());
        if (StringUtils.isEmpty((String)engineMetadataManageTable2.getTableChname())) {
            EngineMetadataManageTable engineMetadataManageTable5 = engineMetadataManageTable;
            engineMetadataManageTable5.setTableChname(engineMetadataManageTable5.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableComment())) {
            EngineMetadataManageTable engineMetadataManageTable6 = engineMetadataManageTable;
            engineMetadataManageTable6.setTableComment(engineMetadataManageTable6.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getRemark())) {
            EngineMetadataManageTable engineMetadataManageTable7 = engineMetadataManageTable;
            engineMetadataManageTable7.setRemark(engineMetadataManageTable7.getTableName());
        }
        if ((object = a2.sysDataSourceService.getDatasourceById(string2 = engineMetadataManageTable.getDatasourceId().toString())) == null || object.getData() == null) {
            logger.error(OracleTransactionalExecuteService.class("\u6cab\u6722\u67ef\u8bc9\u523a\u655b\u6364\u6ebb\u4feb\u6044\uff06\u655b\u6364\u6ebbCO0Pw"), (Object)string2);
            throw new RuntimeException(new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.break("\u6cca\u673d\u678e\u8bd6\u525b\u6544\u6305\u6ea4\u4f8a\u605b\uff67\u6544\u6305\u6ea4\"PQ")).append(string2).toString());
        }
        string2 = (SysDataSource)object.getData();
        if (Objects.isNull(string2)) {
            logger.error(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST.getMessage());
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        object = IdAcquisitionUtil.getCurrentTenantId();
        Object object3 = object2 = object2.iterator();
        while (object3.hasNext()) {
            ArrayList<Map<String, String>> arrayList3;
            String string3;
            engineMetadataDetail = (EngineMetadataDetail)object2.next();
            if (engineMetadataDetail.getPk().equals("1")) {
                arrayList2.add(engineMetadataDetail.getColumnName());
            }
            serializable = new HashMap<String, String>();
            EngineMetadataDetail engineMetadataDetail2 = engineMetadataDetail;
            serializable.put(OracleTransactionalExecuteService.class("HeG\u007fFdekFo"), engineMetadataDetail2.getColumnName());
            serializable.put(OracleMetadataManageTableDsServiceImpl.break("]\u0018f\u000eE\u001e]\u0019Q\u000f"), engineMetadataDetail.getRequired().toString());
            serializable.put(OracleTransactionalExecuteService.class("cXCEiYo"), "0");
            serializable.put(OracleMetadataManageTableDsServiceImpl.break("\b[\u0007A\u0006Z([\u0006Y\u000eZ\u001f"), engineMetadataDetail.getColumnComment());
            serializable.put(OracleTransactionalExecuteService.class("OoMk^f_\\Jf^o"), engineMetadataDetail.getDefaultValue());
            if (StringUtils.isEmpty((String)engineMetadataDetail2.getColumnChname())) {
                EngineMetadataDetail engineMetadataDetail3 = engineMetadataDetail;
                engineMetadataDetail3.setColumnChname(engineMetadataDetail3.getColumnName());
            }
            if (StringUtils.isEmpty((String)engineMetadataDetail.getColumnComment())) {
                EngineMetadataDetail engineMetadataDetail4 = engineMetadataDetail;
                engineMetadataDetail4.setColumnComment(engineMetadataDetail4.getColumnName());
            }
            if (engineMetadataDetail.getColumnLength() != null) {
                serializable.put(OracleMetadataManageTableDsServiceImpl.break("W\u0004X\u001eY\u0005x\u000eZ\f@\u0003"), engineMetadataDetail.getColumnLength().toString());
            }
            if (engineMetadataDetail.getPointLength() != null) {
                serializable.put(OracleTransactionalExecuteService.class("zDcE~goEm_b"), engineMetadataDetail.getPointLength().toString());
            }
            string = engineMetadataDetail.getColumnType();
            if (OracleMetadataManageTableDsServiceImpl.break("\u0005A\u0006Q\u0019]\b").equalsIgnoreCase(string) || OracleTransactionalExecuteService.class("nNiBgJf").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.break("P\u0004A\tX\u000e").equalsIgnoreCase(string)) {
                string3 = new StringBuilder().insert(0, string).append(OracleTransactionalExecuteService.class("\"")).append(engineMetadataDetail.getColumnLength()).append(OracleMetadataManageTableDsServiceImpl.break("G")).append(engineMetadataDetail.getPointLength()).append(OracleTransactionalExecuteService.class("#")).toString();
                arrayList3 = arrayList;
                serializable.put(OracleMetadataManageTableDsServiceImpl.break("W\u0004X\u001eY\u0005`\u0012D\u000e"), string3);
            } else if (OracleTransactionalExecuteService.class("Ok_o").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.break("P\n@\u000e@\u0002Y\u000e").equalsIgnoreCase(string) || OracleTransactionalExecuteService.class("GeEm_oS~").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.break("@\u000eL\u001f").equalsIgnoreCase(string) || OracleTransactionalExecuteService.class("IfDh").equalsIgnoreCase(string) || OracleMetadataManageTableDsServiceImpl.break("X\u0004Z\fV\u0007[\t").equalsIgnoreCase(string)) {
                serializable.put(OracleTransactionalExecuteService.class("HeG\u007fFd\u007fs[o"), string);
                arrayList3 = arrayList;
            } else {
                string3 = new StringBuilder().insert(0, engineMetadataDetail.getColumnType()).append(OracleMetadataManageTableDsServiceImpl.break("C")).append(engineMetadataDetail.getColumnLength()).append(OracleTransactionalExecuteService.class("#")).toString();
                arrayList3 = arrayList;
                serializable.put(OracleMetadataManageTableDsServiceImpl.break("W\u0004X\u001eY\u0005`\u0012D\u000e"), string3);
            }
            arrayList3.add((Map<String, String>)((Object)serializable));
            object3 = object2;
        }
        boolean bl = StringUtils.isNotEmpty(arrayList2);
        try {
            a2.dsService.createTable(engineMetadataManageTable, arrayList, arrayList2, bl, string2.getConnName());
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.CREATE_DATABASE_TABLE_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.CREATE_DATABASE_TABLE_FAILED, (Throwable)exception);
        }
        engineMetadataDetail = a2.generalMetadataManageTableMapper.selectEngineMetadataManageTableByTableName(engineMetadataManageTable);
        if (!StringUtils.isNull((Object)engineMetadataDetail)) {
            a2.generalMetadataManageTableMapper.deleteEngineMetadataManageTableById(engineMetadataDetail.getId().toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.class("YrYtBnUfO\u007fKoK\u007fKtGjDjMnU\u007fKiFn0")).append(engineMetadataDetail.getId()).toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.break("8m8k#q4y.`*p*`*k&u%u,q4`*v'qQ")).append(engineMetadataDetail.getTableName().toUpperCase()).toString());
            serializable = engineMetadataDetail.getDatasourceId();
            string = new StringBuilder().insert(0, OracleTransactionalExecuteService.class("xSxUcOtGn^jNj^jUfKeKlOt^jHgO\u00110")).append((String)object).append(OracleMetadataManageTableDsServiceImpl.break("Q")).append(serializable).append(OracleTransactionalExecuteService.class("0")).append(a.getBaseInfo().getTableName().toUpperCase()).toString();
            DefaultCacheUtil.evict((Object)string);
            a2.generalMetadataDetailMapper.delColumn(engineMetadataDetail.getId().toString());
        }
        return a2.insertTableInfo(a);
    }

    public boolean insertTableInfo(EngineMetadataParam a3) throws EngineException {
        Object object;
        OracleEngineMetadataTableServiceImpl a2;
        Object object2 = a3.getBaseInfo();
        String string = a2.engineDynamicDataSourceService.getDatasourceType();
        try {
            EngineMetadataManageTable engineMetadataManageTable = object2;
            engineMetadataManageTable.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            engineMetadataManageTable.setCreator(IdAcquisitionUtil.getCurrentUserId());
            engineMetadataManageTable.setRemark(engineMetadataManageTable.getTableComment());
            if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableChname())) {
                EngineMetadataManageTable engineMetadataManageTable2 = object2;
                engineMetadataManageTable2.setTableChname(engineMetadataManageTable2.getTableName());
            }
            if (StringUtils.isEmpty((String)object2.getTableComment())) {
                EngineMetadataManageTable engineMetadataManageTable3 = object2;
                engineMetadataManageTable3.setTableComment(engineMetadataManageTable3.getTableName());
            }
            if (StringUtils.isEmpty((String)object2.getRemark())) {
                EngineMetadataManageTable engineMetadataManageTable4 = object2;
                engineMetadataManageTable4.setRemark(engineMetadataManageTable4.getTableName());
            }
            a2.generalMetadataManageTableMapper.insertEngineMetadataManageTable(object2);
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.INSERT_TABLE_INFORMATION_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.INSERT_TABLE_INFORMATION_FAILED, (Throwable)exception);
        }
        List list = a3.getColumnInfo();
        a3 = list.iterator();
        Iterator iterator = a3;
        while (iterator.hasNext()) {
            object = (EngineMetadataDetail)a3.next();
            iterator = a3;
            EngineMetadataDetail engineMetadataDetail = object;
            Object object3 = object;
            object.setId(IdGenerateUtils.getId());
            object3.setTableId(object2.getId());
            engineMetadataDetail.setStatus(Integer.valueOf(1));
            object3.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
            engineMetadataDetail.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            engineMetadataDetail.setCreator(IdAcquisitionUtil.getCurrentUserId());
        }
        try {
            a3 = Lists.partition((List)list, (int)10);
            object = a3.iterator();
            while (object.hasNext()) {
                object2 = (List)object.next();
                a2.metadataDetailMapper.get(string).batchInsert((List)object2);
            }
        }
        catch (Exception a3) {
            logger.error(EngineExceptionEnum.INSERT_COLUMN_INFORMATION_FAILED.getMessage(), (Throwable)a3);
            throw new EngineException(EngineExceptionEnum.INSERT_COLUMN_INFORMATION_FAILED, (Throwable)a3);
        }
        return true;
    }

    public boolean insertView(EngineMetadataParam a) throws EngineException {
        OracleEngineMetadataTableServiceImpl a2;
        Object object;
        EngineMetadataParam engineMetadataParam = a;
        EngineMetadataManageTable engineMetadataManageTable = engineMetadataParam.getBaseInfo();
        Object object2 = engineMetadataParam.getColumnInfo();
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
        engineMetadataManageTable4.setCountColumn(Long.valueOf(object2.size()));
        engineMetadataManageTable4.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable3.setVersion(Long.valueOf(0L));
        engineMetadataManageTable3.setStatus("1");
        engineMetadataManageTable2.setViewFlag("1");
        engineMetadataManageTable2.setCharacterSet(OracleMetadataManageTableDsServiceImpl.break("a?rS"));
        engineMetadataManageTable2.setId(IdGenerateUtils.getId());
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = (EngineMetadataDetail)object2.next();
            if (StringUtils.isEmpty((String)object.getPk())) {
                object.setPk("0");
            }
            EngineMetadataDetail engineMetadataDetail = object;
            engineMetadataDetail.setIncre("0");
            engineMetadataDetail.setRequired("0");
            if (StringUtils.isEmpty((String)object.getColumnChname())) {
                EngineMetadataDetail engineMetadataDetail2 = object;
                engineMetadataDetail2.setColumnChname(engineMetadataDetail2.getColumnName());
            }
            if (!StringUtils.isEmpty((String)object.getColumnComment())) continue;
            EngineMetadataDetail engineMetadataDetail3 = object;
            engineMetadataDetail3.setColumnComment(engineMetadataDetail3.getColumnName());
        }
        object2 = engineMetadataManageTable.getDatasourceId().toString();
        object = a2.sysDataSourceService.getDatasourceById((String)object2);
        if (object == null || object.getData() == null) {
            logger.error(OracleTransactionalExecuteService.class("\u6cab\u6722\u67ef\u8bc9\u523a\u655b\u6364\u6ebb\u4feb\u6044\uff06\u655b\u6364\u6ebbCO0Pw"), object2);
            throw new RuntimeException(new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.break("\u6cca\u673d\u678e\u8bd6\u525b\u6544\u6305\u6ea4\u4f8a\u605b\uff67\u6544\u6305\u6ea4\"PQ")).append((String)object2).toString());
        }
        if (Objects.isNull((SysDataSource)object.getData())) {
            logger.error(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST.getMessage());
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        object2 = IdAcquisitionUtil.getCurrentTenantId();
        if (!StringUtils.isNull((Object)(engineMetadataManageTable = a2.generalMetadataManageTableMapper.selectEngineMetadataManageTableByTableName(engineMetadataManageTable)))) {
            a2.generalMetadataManageTableMapper.deleteEngineMetadataManageTableById(engineMetadataManageTable.getId().toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.class("YrYtBnUfO\u007fKoK\u007fKtGjDjMnU\u007fKiFn0")).append(a.getBaseInfo().getId()).toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.break("8m8k#q4y.`*p*`*k&u%u,q4`*v'qQ")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            object = a.getBaseInfo().getDatasourceId();
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.class("xSxUcOtGn^jNj^jUfKeKlOt^jHgO\u00110")).append((String)object2).append(OracleMetadataManageTableDsServiceImpl.break("Q")).append(object).append(OracleTransactionalExecuteService.class("0")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            a2.generalMetadataDetailMapper.delColumn(engineMetadataManageTable.getId().toString());
        }
        return a2.insertTableInfo(a);
    }

    public boolean updateTableInfo(EngineMetadataParam a) throws EngineException {
        EngineMetadataDetailDto engineMetadataDetailDto;
        Object object;
        Iterator iterator;
        Object object2;
        OracleEngineMetadataTableServiceImpl a2;
        String string = a2.engineDynamicDataSourceService.getDatasourceType();
        try {
            a2.generalMetadataManageTableMapper.updateEngineMetadataManageTable(a.getBaseInfo());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.class("YrYtBnUfO\u007fKoK\u007fKtGjDjMnU\u007fKiFn0")).append(a.getBaseInfo().getId()).toString());
            DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.break("8m8k#q4y.`*p*`*k&u%u,q4`*v'qQ")).append(a.getBaseInfo().getTableName().toUpperCase()).toString());
            object2 = IdAcquisitionUtil.getCurrentTenantId();
            iterator = a.getBaseInfo().getDatasourceId();
            object = new StringBuilder().insert(0, OracleTransactionalExecuteService.class("xSxUcOtGn^jNj^jUfKeKlOt^jHgO\u00110")).append((String)object2).append(OracleMetadataManageTableDsServiceImpl.break("Q")).append(iterator).append(OracleTransactionalExecuteService.class("0")).append(a.getBaseInfo().getTableName().toUpperCase()).toString();
            DefaultCacheUtil.evict((Object)object);
        }
        catch (Exception exception) {
            logger.error(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED.getMessage(), (Throwable)exception);
            throw new EngineException(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED);
        }
        object2 = a.getDeletedCols();
        if (StringUtils.isNotEmpty((Collection)a.getDeletedCols())) {
            try {
                a2.generalMetadataDetailMapper.delColInfo((List)object2);
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (EngineMetadataDetail)iterator.next();
                    DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.break("8m8k#q4y.`*p*`*k/q?u\"x4`*v'qQ")).append(object.getId()).toString());
                }
            }
            catch (Exception exception) {
                logger.error(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED.getMessage(), (Throwable)exception);
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
        iterator = a.getColumnInfo();
        object = new ArrayList();
        a = new ArrayList();
        object2 = DateUtils.getNowDate();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            engineMetadataDetailDto = (EngineMetadataDetailDto)iterator.next();
            if (engineMetadataDetailDto.getOperation() != null && OracleTransactionalExecuteService.class("NnB~").equals(engineMetadataDetailDto.getOperation())) {
                if (null == engineMetadataDetailDto.getColumnComment() || "".equals(engineMetadataDetailDto.getColumnComment())) {
                    EngineMetadataDetailDto engineMetadataDetailDto2 = engineMetadataDetailDto;
                    engineMetadataDetailDto2.setColumnComment(engineMetadataDetailDto2.getColumnName());
                }
                if (null == engineMetadataDetailDto.getColumnChname() || "".equals(engineMetadataDetailDto.getColumnChname())) {
                    EngineMetadataDetailDto engineMetadataDetailDto3 = engineMetadataDetailDto;
                    engineMetadataDetailDto3.setColumnChname(engineMetadataDetailDto3.getColumnName());
                }
                if (null == engineMetadataDetailDto.getRemark() || "".equals(engineMetadataDetailDto.getRemark())) {
                    EngineMetadataDetailDto engineMetadataDetailDto4 = engineMetadataDetailDto;
                    engineMetadataDetailDto4.setRemark(engineMetadataDetailDto4.getColumnName());
                }
                EngineMetadataDetailDto engineMetadataDetailDto5 = engineMetadataDetailDto;
                EngineMetadataDetailDto engineMetadataDetailDto6 = engineMetadataDetailDto;
                engineMetadataDetailDto6.setLastTime(Instant.ofEpochMilli(((Date)object2).getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
                engineMetadataDetailDto5.setStatus(Integer.valueOf(1));
                engineMetadataDetailDto6.setLastEditor(IdAcquisitionUtil.getCurrentUserId());
                engineMetadataDetailDto5.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
                object.add(engineMetadataDetailDto);
                continue;
            }
            if (engineMetadataDetailDto.getOperation() == null || !OracleMetadataManageTableDsServiceImpl.break("\nP\u000f").equals(engineMetadataDetailDto.getOperation())) continue;
            engineMetadataDetailDto.setId(IdGenerateUtils.getId());
            if (null == engineMetadataDetailDto.getColumnComment() || "".equals(engineMetadataDetailDto.getColumnComment())) {
                EngineMetadataDetailDto engineMetadataDetailDto7 = engineMetadataDetailDto;
                engineMetadataDetailDto7.setColumnComment(engineMetadataDetailDto7.getColumnName());
            }
            if (null == engineMetadataDetailDto.getColumnChname() || "".equals(engineMetadataDetailDto.getColumnChname())) {
                EngineMetadataDetailDto engineMetadataDetailDto8 = engineMetadataDetailDto;
                engineMetadataDetailDto8.setColumnChname(engineMetadataDetailDto8.getColumnName());
            }
            if (null == engineMetadataDetailDto.getRemark() || "".equals(engineMetadataDetailDto.getRemark())) {
                EngineMetadataDetailDto engineMetadataDetailDto9 = engineMetadataDetailDto;
                engineMetadataDetailDto9.setRemark(engineMetadataDetailDto9.getColumnName());
            }
            EngineMetadataDetailDto engineMetadataDetailDto10 = engineMetadataDetailDto;
            EngineMetadataDetailDto engineMetadataDetailDto11 = engineMetadataDetailDto;
            engineMetadataDetailDto11.setStatus(Integer.valueOf(1));
            engineMetadataDetailDto10.setCreateTime(Instant.ofEpochMilli(((Date)object2).getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
            engineMetadataDetailDto11.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            engineMetadataDetailDto10.setCreator(IdAcquisitionUtil.getCurrentUserId());
            a.add(engineMetadataDetailDto);
        }
        if (StringUtils.isNotEmpty((Collection)object)) {
            iterator = object.iterator();
            while (iterator.hasNext()) {
                engineMetadataDetailDto = (EngineMetadataDetail)iterator.next();
                if (!StringUtils.isEmpty((String)engineMetadataDetailDto.getColumnLength())) continue;
                engineMetadataDetailDto.setColumnLength("0");
            }
            try {
                a2.metadataDetailMapper.get(string).batchInsert((List)object);
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    engineMetadataDetailDto = (EngineMetadataDetail)iterator.next();
                    DefaultCacheUtil.evict((Object)new StringBuilder().insert(0, OracleTransactionalExecuteService.class("YrYtBnUfO\u007fKoK\u007fKtNn^jCgU\u007fKiFn0")).append(engineMetadataDetailDto.getId()).toString());
                }
            }
            catch (Exception exception) {
                logger.error(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED.getMessage(), (Throwable)exception);
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
        if (StringUtils.isNotEmpty((Collection)a)) {
            iterator = a.iterator();
            while (iterator.hasNext()) {
                engineMetadataDetailDto = (EngineMetadataDetail)iterator.next();
                if (!StringUtils.isEmpty((String)engineMetadataDetailDto.getColumnLength())) continue;
                engineMetadataDetailDto.setColumnLength("0");
            }
            try {
                a2.metadataDetailMapper.get(string).batchInsert((List)a);
            }
            catch (Exception exception) {
                logger.error(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED.getMessage(), (Throwable)exception);
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
        return true;
    }
}

