/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine.oracle.util;

import com.google.common.base.CaseFormat;
import com.jxdinfo.hussar.engine.metadata.enums.ConnectEnum;
import com.jxdinfo.hussar.engine.metadata.enums.SqlConnectEnum;
import com.jxdinfo.hussar.engine.metadata.model.InputColumnVO;
import com.jxdinfo.hussar.engine.metadata.util.StringUtils;
import com.jxdinfo.hussar.engine.oracle.service.impl.OracleMetadataManageTableDsServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class OracleQueryConditionUtil {
    private static Logger logger = LoggerFactory.getLogger(OracleQueryConditionUtil.class);

    public static String cleanEmptyBrackets(String a) {
        String string = a;
        if (string.contains(OracleMetadataManageTableDsServiceImpl.catch("pk"))) {
            string = a.replace(OracleMetadataManageTableDsServiceImpl.catch("jqb"), "");
            string = OracleQueryConditionUtil.cleanEmptyBrackets(string);
        }
        return string;
    }

    public OracleQueryConditionUtil() {
        OracleQueryConditionUtil a;
    }

    public static String cleanNoAvailConnect(String a) {
        String string = a;
        if (string.toLowerCase().contains(ConnectEnum._ANDNO.getType())) {
            string = a.replace(ConnectEnum._ANDNO.getType().toUpperCase(), OracleMetadataManageTableDsServiceImpl.catch("k"));
            string = OracleQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._ORNO.getType())) {
            string = string.replace(ConnectEnum._ORNO.getType().toUpperCase(), OracleMetadataManageTableDsServiceImpl.catch("k"));
            string = OracleQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._ANDAND.getType())) {
            string = a.replace(ConnectEnum._ANDAND.getType().toUpperCase(), OracleMetadataManageTableDsServiceImpl.catch("\u0003\u0016\u0006"));
            string = OracleQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._ANDOR.getType())) {
            string = string.replace(ConnectEnum._ANDOR.getType().toUpperCase(), OracleMetadataManageTableDsServiceImpl.catch("\u0017\u0010"));
            string = OracleQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._OROR.getType())) {
            string = string.replace(ConnectEnum._OROR.getType().toUpperCase(), OracleMetadataManageTableDsServiceImpl.catch("\u0017\u0010"));
            string = OracleQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._ORAND.getType())) {
            string = string.replace(ConnectEnum._ORAND.getType().toUpperCase(), OracleMetadataManageTableDsServiceImpl.catch("\u0003\u0016\u0006"));
            string = OracleQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._WHEREAND.getType())) {
            string = string.replace(ConnectEnum._WHEREAND.getType().toUpperCase(), OracleMetadataManageTableDsServiceImpl.catch("\u0015\u0010\u0007\n\u0007"));
            string = OracleQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._WHEREOR.getType())) {
            string = string.replace(ConnectEnum._WHEREOR.getType().toUpperCase(), OracleMetadataManageTableDsServiceImpl.catch("\u0015\u0010\u0007\n\u0007"));
            string = OracleQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._SIGNAND.getType())) {
            string = string.replace(ConnectEnum._SIGNAND.getType().toUpperCase(), OracleMetadataManageTableDsServiceImpl.catch("j"));
            string = OracleQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._SIGNOR.getType())) {
            string = string.replace(ConnectEnum._SIGNOR.getType().toUpperCase(), OracleMetadataManageTableDsServiceImpl.catch("j"));
            string = OracleQueryConditionUtil.cleanNoAvailConnect(string);
        }
        return string;
    }

    public static String dynamicWhereSql(List<InputColumnVO> a, Map<String, Object> a2) {
        String string = null;
        if (StringUtils.isEmpty((String)(a2 = OracleQueryConditionUtil.renderQueryCon(a, false, "", a2, string))) || ((String)a2).length() <= 5) {
            return "";
        }
        if (StringUtils.isEmpty((String)((String)(a2 = OracleQueryConditionUtil.cleanSql(((String)a2).substring(0, ((String)a2).length() - 5)))).split(OracleMetadataManageTableDsServiceImpl.catch("\u0015\u0010\u0007\n\u0007"))[1].trim())) {
            return "";
        }
        return a2;
    }

    public static String cleanSql(String a) {
        String string;
        String string2 = string = OracleQueryConditionUtil.cleanNoAvailConnect(OracleQueryConditionUtil.cleanEmptyBrackets(a));
        String string3 = string2.substring(string.length() - 3, string2.length());
        if (string3.toLowerCase().equals(ConnectEnum._OR.getType())) {
            String string4 = string;
            string = string4.substring(0, string4.length() - 3);
        }
        String string5 = string;
        String string6 = string5.substring(string5.length() - 4, string.length());
        if (string6.toLowerCase().equals(ConnectEnum._AND.getType())) {
            String string7 = string;
            string = string7.substring(0, string7.length() - 4);
        }
        String string8 = string;
        String string9 = string;
        string3 = string8.substring(string8.length() - 3, string9.length());
        string6 = string8.substring(string9.length() - 4, string.length());
        if (string8.toLowerCase().contains(ConnectEnum._ANDNO.getType()) || string.toLowerCase().contains(ConnectEnum._ORNO.getType()) || string.toLowerCase().contains(ConnectEnum._ANDAND.getType()) || string.toLowerCase().contains(ConnectEnum._ANDOR.getType()) || string.toLowerCase().contains(ConnectEnum._ORAND.getType()) || string.toLowerCase().contains(ConnectEnum._OROR.getType()) || string.toLowerCase().contains(ConnectEnum._WHEREAND.getType()) || string.toLowerCase().contains(ConnectEnum._WHEREOR.getType()) || string.toLowerCase().contains(ConnectEnum._SIGNAND.getType()) || string.toLowerCase().contains(ConnectEnum._SIGNOR.getType()) || string.contains(OracleMetadataManageTableDsServiceImpl.catch("pk")) || string3.equalsIgnoreCase(ConnectEnum._OR.getType()) || string6.equalsIgnoreCase(ConnectEnum._AND.getType())) {
            string = OracleQueryConditionUtil.cleanSql(string);
        }
        return string;
    }

    public static String renderQueryCon(List<InputColumnVO> a, boolean a2, String a3, Map<String, Object> a4, String a5) {
        StringBuilder stringBuilder;
        List<InputColumnVO> list;
        StringBuilder stringBuilder2;
        if (CollectionUtils.isEmpty(a4)) {
            return "";
        }
        if (CollectionUtils.isEmpty(a)) {
            return "";
        }
        StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder(128);
        if (!a2) {
            stringBuilder3.append(OracleMetadataManageTableDsServiceImpl.catch("\u000f\n\u001d\u0010\u001db"));
            list = a;
        } else {
            stringBuilder3.append(OracleMetadataManageTableDsServiceImpl.catch("j"));
            list = a;
        }
        for (InputColumnVO inputColumnVO : list) {
            Object object;
            if (ConnectEnum._ROW.getType().equals(inputColumnVO.getType())) {
                InputColumnVO inputColumnVO2 = inputColumnVO;
                object = inputColumnVO2.getTableName();
                String string = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, (String)object);
                String string2 = inputColumnVO2.getColumnName();
                String string3 = inputColumnVO2.getColumnAliasDefined();
                String string4 = inputColumnVO2.getInColumnType();
                string4 = inputColumnVO2.getWhereFlag();
                a3 = inputColumnVO2.getInConnectFlag();
                if (!a4.containsKey(string3) || !Objects.nonNull(a4.get(string3)) || "".equals(a4.get(string3).toString().trim())) continue;
                if (SqlConnectEnum._LEFT_LIKE.getKey().equalsIgnoreCase(string4) || SqlConnectEnum._RIGHT_LIKE.getKey().equalsIgnoreCase(string4) || SqlConnectEnum._FULL_LIKE.getKey().equalsIgnoreCase(string4)) {
                    if (string4.toUpperCase().contains(OracleMetadataManageTableDsServiceImpl.catch("\u0014\u0007\u001e\u0016"))) {
                        stringBuilder2.append(OracleMetadataManageTableDsServiceImpl.catch("`")).append(string).append(OracleMetadataManageTableDsServiceImpl.catch("zl")).append(OracleMetadataManageTableDsServiceImpl.catch("`")).append(string2).append(OracleMetadataManageTableDsServiceImpl.catch("zb")).append(OracleMetadataManageTableDsServiceImpl.catch("\u000e\u0011\t\u001dbxe}e$>{9")).append(string3).append(OracleMetadataManageTableDsServiceImpl.catch("?")).append(OracleMetadataManageTableDsServiceImpl.catch("b")).append(a3.toUpperCase()).append(OracleMetadataManageTableDsServiceImpl.catch("b"));
                        continue;
                    }
                    StringBuilder stringBuilder4 = stringBuilder2;
                    if (string4.toUpperCase().contains(OracleMetadataManageTableDsServiceImpl.catch("\u0010\u0011\u0005\u0010\u0016"))) {
                        stringBuilder4.append(OracleMetadataManageTableDsServiceImpl.catch("`")).append(string).append(OracleMetadataManageTableDsServiceImpl.catch("zl")).append(OracleMetadataManageTableDsServiceImpl.catch("`")).append(string2).append(OracleMetadataManageTableDsServiceImpl.catch("zb")).append(OracleMetadataManageTableDsServiceImpl.catch("\u000e\u0011\t\u001db{9")).append(string3).append(OracleMetadataManageTableDsServiceImpl.catch("%>$e}e")).append(OracleMetadataManageTableDsServiceImpl.catch("b")).append(a3.toUpperCase()).append(OracleMetadataManageTableDsServiceImpl.catch("b"));
                        continue;
                    }
                    stringBuilder4.append(OracleMetadataManageTableDsServiceImpl.catch("`")).append(string).append(OracleMetadataManageTableDsServiceImpl.catch("zl")).append(OracleMetadataManageTableDsServiceImpl.catch("`")).append(string2).append(OracleMetadataManageTableDsServiceImpl.catch("zb")).append(OracleMetadataManageTableDsServiceImpl.catch("\u000e\u0011\t\u001dbxe}e$>{9")).append(string3).append(OracleMetadataManageTableDsServiceImpl.catch("%>$e}e")).append(OracleMetadataManageTableDsServiceImpl.catch("b")).append(a3.toUpperCase()).append(OracleMetadataManageTableDsServiceImpl.catch("b"));
                    continue;
                }
                if (SqlConnectEnum._EQUAL.getKey().equalsIgnoreCase(string4) || SqlConnectEnum._GREAT_THAN.getKey().equalsIgnoreCase(string4) || SqlConnectEnum._LESS_THAN.getKey().equalsIgnoreCase(string4) || SqlConnectEnum._GREAT_AND_THAN.getKey().equalsIgnoreCase(string4) || SqlConnectEnum._LESS_AND_THAN.getKey().equalsIgnoreCase(string4) || SqlConnectEnum._NOT_EQUAL.getKey().equalsIgnoreCase(string4)) {
                    stringBuilder2.append(OracleMetadataManageTableDsServiceImpl.catch("`")).append(string).append(OracleMetadataManageTableDsServiceImpl.catch("zl")).append(OracleMetadataManageTableDsServiceImpl.catch("`")).append(string2).append(OracleMetadataManageTableDsServiceImpl.catch("`")).append(OracleMetadataManageTableDsServiceImpl.catch("b")).append(string4.toUpperCase()).append(OracleMetadataManageTableDsServiceImpl.catch("b{9")).append(string3).append(OracleMetadataManageTableDsServiceImpl.catch("?")).append(OracleMetadataManageTableDsServiceImpl.catch("b")).append(a3.toUpperCase()).append(OracleMetadataManageTableDsServiceImpl.catch("b"));
                    continue;
                }
                stringBuilder2.append(OracleMetadataManageTableDsServiceImpl.catch("`")).append(string).append(OracleMetadataManageTableDsServiceImpl.catch("zl")).append(OracleMetadataManageTableDsServiceImpl.catch("`")).append(string2).append(OracleMetadataManageTableDsServiceImpl.catch("`")).append(OracleMetadataManageTableDsServiceImpl.catch("b")).append(string4.toUpperCase()).append(OracleMetadataManageTableDsServiceImpl.catch("xj{9>-*'9!0\u001d")).append(string3).append(OracleMetadataManageTableDsServiceImpl.catch("%k")).append(OracleMetadataManageTableDsServiceImpl.catch("b")).append(a3.toUpperCase()).append(OracleMetadataManageTableDsServiceImpl.catch("b"));
                continue;
            }
            if (!ConnectEnum._CHILD.getType().equals(inputColumnVO.getType())) continue;
            InputColumnVO inputColumnVO3 = inputColumnVO;
            a5 = inputColumnVO3.getInConnectFlag();
            object = inputColumnVO3.getChildren();
            if (CollectionUtils.isEmpty((Collection)object)) continue;
            stringBuilder2.append(OracleQueryConditionUtil.renderQueryCon((List<InputColumnVO>)object, true, a3, a4, a5));
        }
        if (!a2) {
            StringBuilder stringBuilder5 = stringBuilder2;
            stringBuilder = stringBuilder5;
            stringBuilder5.append(OracleMetadataManageTableDsServiceImpl.catch("\u0015\u0010\u0007\n\u0007"));
        } else {
            StringBuilder stringBuilder6 = stringBuilder2;
            if (StringUtils.isEmpty((String)a5)) {
                stringBuilder6.append(OracleMetadataManageTableDsServiceImpl.catch("k"));
                stringBuilder = stringBuilder2;
            } else {
                stringBuilder6.append(OracleMetadataManageTableDsServiceImpl.catch("k")).append(OracleMetadataManageTableDsServiceImpl.catch("b")).append(a5.toUpperCase()).append(OracleMetadataManageTableDsServiceImpl.catch("b"));
                stringBuilder = stringBuilder2;
            }
        }
        return stringBuilder.toString();
    }
}

