/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine.oracle.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.engine.metadata.dao.EngineMetadataDetailMapper;
import com.jxdinfo.hussar.engine.metadata.dao.EngineMetadataManageTableMapper;
import com.jxdinfo.hussar.engine.metadata.dao.EnginePlatformTableMapper;
import com.jxdinfo.hussar.engine.metadata.dto.EngineMetadataDetailDto;
import com.jxdinfo.hussar.engine.metadata.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.engine.metadata.exception.EngineException;
import com.jxdinfo.hussar.engine.metadata.model.EngineMetadataDetail;
import com.jxdinfo.hussar.engine.metadata.model.EngineMetadataManageTable;
import com.jxdinfo.hussar.engine.metadata.model.EngineMetadataParam;
import com.jxdinfo.hussar.engine.metadata.service.EngineDynamicDataSourceService;
import com.jxdinfo.hussar.engine.metadata.strategy.EnginePlatformTableFactory;
import com.jxdinfo.hussar.engine.metadata.util.DateUtils;
import com.jxdinfo.hussar.engine.metadata.util.IdAcquisitionUtil;
import com.jxdinfo.hussar.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.hussar.engine.metadata.util.StringUtils;
import com.jxdinfo.hussar.engine.oracle.dao.OracleTargetDataBaseMapper;
import com.jxdinfo.hussar.engine.oracle.service.OracleTransactionalExecuteService;
import com.jxdinfo.hussar.engine.oracle.service.impl.OracleMetadataManageTableDsServiceImpl;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@HussarDs(value="master")
public class OracleEngineMetadataTableServiceImpl {
    @Autowired
    private OracleMetadataManageTableDsServiceImpl dsService;
    @Autowired
    private EngineDynamicDataSourceService engineDynamicDataSourceService;
    @Autowired
    private OracleTargetDataBaseMapper targetDataBaseOracleMapper;
    private static final Logger logger = LoggerFactory.getLogger(OracleEngineMetadataTableServiceImpl.class);
    @Autowired
    private EngineMetadataManageTableMapper generalMetadataManageTableMapper;
    @Autowired
    private EngineMetadataDetailMapper generalMetadataDetailMapper;
    private Map<String, EnginePlatformTableMapper> metadataDetailMapper = EnginePlatformTableFactory.getMappers((String)OracleTransactionalExecuteService.if("\u00023\u001b7\u000b7\u001b7+3\u001b7\u0006:"));
    @Autowired
    private SysDataSourceService sysDataSourceService;

    public OracleEngineMetadataTableServiceImpl() {
        OracleEngineMetadataTableServiceImpl a;
    }

    public boolean updateEngineMetadataManageTable(EngineMetadataParam a2) throws EngineException {
        Object object;
        EngineMetadataDetail engineMetadataDetail;
        OracleEngineMetadataTableServiceImpl a3;
        EngineMetadataParam engineMetadataParam = a2;
        EngineMetadataManageTable engineMetadataManageTable = engineMetadataParam.getBaseInfo();
        List list = engineMetadataParam.getColumnInfo();
        String string = engineMetadataManageTable.getDatasourceId().toString();
        Object object2 = a3.sysDataSourceService.getDatasourceById(string);
        if (object2 == null || object2.getData() == null) {
            logger.error(OracleTransactionalExecuteService.if("\u6cf7\u6766\u67b3\u8b8d\u5266\u651f\u6338\u6eff\u4fb7\u6000\uff5a\u651f\u6338\u6eff\u001f\u000bl\u0014+"), (Object)string);
            throw new RuntimeException(new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.case("\u6cc9\u6737\u678d\u8bdc\u5258\u654e\u6306\u6eae\u4f89\u6051\uff64\u654e\u6306\u6eae!ZR")).append(string).toString());
        }
        string = (SysDataSource)object2.getData();
        if (Objects.isNull(string)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        object2 = IdAcquisitionUtil.getCurrentTenantId();
        List list2 = a3.generalMetadataDetailMapper.selectColumnInfo(engineMetadataManageTable.getId().toString());
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        engineMetadataManageTable3.setCountColumn(Long.valueOf(list.size()));
        engineMetadataManageTable3.setLastTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable2.setLastEditor(IdAcquisitionUtil.getCurrentUserId());
        engineMetadataManageTable2.setTenantId((String)object2);
        if (StringUtils.isEmpty((String)engineMetadataManageTable2.getTableChname())) {
            EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
            engineMetadataManageTable4.setTableChname(engineMetadataManageTable4.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableComment())) {
            EngineMetadataManageTable engineMetadataManageTable5 = engineMetadataManageTable;
            engineMetadataManageTable5.setTableComment(engineMetadataManageTable5.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getRemark())) {
            EngineMetadataManageTable engineMetadataManageTable6 = engineMetadataManageTable;
            engineMetadataManageTable6.setRemark(engineMetadataManageTable6.getTableName());
        }
        OracleEngineMetadataTableServiceImpl oracleEngineMetadataTableServiceImpl = a3;
        object2 = oracleEngineMetadataTableServiceImpl.generalMetadataManageTableMapper.getTableNameById(engineMetadataManageTable.getId().toString());
        String string2 = engineMetadataManageTable.getTableName();
        Serializable serializable = oracleEngineMetadataTableServiceImpl.generalMetadataManageTableMapper.getVersion(engineMetadataManageTable.getId().toString());
        engineMetadataManageTable.setVersion((Long)serializable);
        serializable = new ArrayList();
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)3);
        ArrayList<EngineMetadataDetail> arrayList2 = new ArrayList<EngineMetadataDetail>();
        ArrayList<EngineMetadataDetail> arrayList3 = new ArrayList<EngineMetadataDetail>();
        HashSet hashSet = Sets.newHashSet();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        List list3 = a2.getDeletedCols();
        Map<String, EngineMetadataDetail> map = list2.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        Object object3 = list.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        Object object4 = list3.stream().collect(Collectors.toMap(EngineMetadataDetail::getColumnName, Function.identity()));
        block2: for (Map.Entry object5 : map.entrySet()) {
            if (object3.get(object5.getKey()) != null || object4.get(object5.getKey()) != null || !((EngineMetadataDetail)object5.getValue()).getPk().equals(OracleTransactionalExecuteService.if("g"))) continue;
            hashSet.add(object5.getKey());
            engineMetadataDetail = object3.entrySet().iterator();
            while (engineMetadataDetail.hasNext()) {
                object = engineMetadataDetail.next();
                if (!((EngineMetadataDetail)object5.getValue()).getId().equals(((EngineMetadataDetail)object.getValue()).getId())) continue;
                hashSet.remove(object5.getKey());
                continue block2;
            }
        }
        map = list2.stream().collect(Collectors.toMap(EngineMetadataDetail::getId, Function.identity())).entrySet().stream().collect(Collectors.toMap(a -> Long.toString((Long)a.getKey()), Map.Entry::getValue));
        object = list.iterator();
        while (object.hasNext()) {
            HashMap hashMap;
            String string3;
            list.setDefaultValue((list = (EngineMetadataDetailDto)object.next()).getDefaultValue() == null ? "" : list.getDefaultValue());
            List list4 = list;
            list4.setLastTime(LocalDateTime.now());
            list4.setStatus(1);
            if (null != list.getOperation() && OracleMetadataManageTableDsServiceImpl.case("\tZ\f").equalsIgnoreCase(list.getOperation())) {
                List list5 = list;
                list5.setId(IdGenerateUtils.getId());
                list5.setCreateTime(LocalDateTime.now());
                arrayList3.add((EngineMetadataDetail)list5);
            }
            if (list.getPk().equals(OracleTransactionalExecuteService.if("g"))) {
                hashSet.add(list.getColumnName());
            }
            if ((string3 = list.getId().toString()) == null || !OracleMetadataManageTableDsServiceImpl.case("[\fW\u001c").equalsIgnoreCase(list.getOperation())) continue;
            engineMetadataDetail = map.get(string3);
            List list6 = list;
            object3 = list6.getColumnComment();
            object4 = list6.getColumnName();
            if (!((String)object4).equals(engineMetadataDetail.getColumnName())) {
                hashMap = Maps.newHashMapWithExpectedSize((int)3);
                hashMap.put(OracleTransactionalExecuteService.if("9\u00032,9\u0003#\u00028!7\u00023"), engineMetadataDetail.getColumnName());
                hashMap.put(OracleMetadataManageTableDsServiceImpl.case("]\u0007R\u001dS\u0006p\tS\r"), object4);
                serializable.add(hashMap);
            }
            if (!StringUtils.isEmpty((String)object3) && !((String)object3).equals(engineMetadataDetail.getColumnComment())) {
                hashMap = Maps.newHashMapWithExpectedSize((int)3);
                hashMap.put(OracleTransactionalExecuteService.if("\f9\u0003#\u00028!7\u00023"), object4);
                hashMap.put(OracleMetadataManageTableDsServiceImpl.case("\u000bQ\u0005S\rP\u001c"), object3);
                arrayList.add(hashMap);
            }
            if (!list.getRequired().equals(map.get(list.getId().toString()).getRequired())) {
                list.setNeedChangeIsRequired(true);
            }
            arrayList2.add((EngineMetadataDetail)list);
        }
        try {
            a3.dsService.editTable(engineMetadataManageTable, list2, (String)object2, string2, (List<Map<String, String>>)((Object)serializable), arrayList, arrayList2, arrayList3, hashSet, arrayList4, list3, map, string.getConnName());
        }
        catch (Exception exception) {
            throw new EngineException(exception.getMessage());
        }
        return a3.updateTableInfo(a2);
    }

    public boolean insertView(EngineMetadataParam a) throws EngineException {
        OracleEngineMetadataTableServiceImpl a2;
        EngineMetadataDetail engineMetadataDetail;
        EngineMetadataParam engineMetadataParam = a;
        EngineMetadataManageTable engineMetadataManageTable = engineMetadataParam.getBaseInfo();
        Object object = engineMetadataParam.getColumnInfo();
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
        engineMetadataManageTable4.setCountColumn(Long.valueOf(object.size()));
        engineMetadataManageTable4.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable3.setVersion(Long.valueOf(0L));
        engineMetadataManageTable3.setStatus(OracleTransactionalExecuteService.if("g"));
        engineMetadataManageTable2.setViewFlag(OracleMetadataManageTableDsServiceImpl.case("Y"));
        engineMetadataManageTable2.setCharacterSet(OracleTransactionalExecuteService.if(":\u0002)n"));
        engineMetadataManageTable2.setId(IdGenerateUtils.getId());
        object = object.iterator();
        while (object.hasNext()) {
            EngineMetadataDetail engineMetadataDetail2 = engineMetadataDetail = (EngineMetadataDetail)object.next();
            engineMetadataDetail.setPk(OracleMetadataManageTableDsServiceImpl.case("X"));
            engineMetadataDetail2.setIncre(OracleTransactionalExecuteService.if("f"));
            engineMetadataDetail2.setRequired(OracleMetadataManageTableDsServiceImpl.case("X"));
            if (StringUtils.isEmpty((String)engineMetadataDetail2.getColumnChname())) {
                EngineMetadataDetail engineMetadataDetail3 = engineMetadataDetail;
                engineMetadataDetail3.setColumnChname(engineMetadataDetail3.getColumnName());
            }
            if (!StringUtils.isEmpty((String)engineMetadataDetail.getColumnComment())) continue;
            EngineMetadataDetail engineMetadataDetail4 = engineMetadataDetail;
            engineMetadataDetail4.setColumnComment(engineMetadataDetail4.getColumnName());
        }
        object = engineMetadataManageTable.getDatasourceId().toString();
        engineMetadataDetail = a2.sysDataSourceService.getDatasourceById((String)object);
        if (engineMetadataDetail == null || engineMetadataDetail.getData() == null) {
            logger.error(OracleTransactionalExecuteService.if("\u6cf7\u6766\u67b3\u8b8d\u5266\u651f\u6338\u6eff\u4fb7\u6000\uff5a\u651f\u6338\u6eff\u001f\u000bl\u0014+"), object);
            throw new RuntimeException(new StringBuilder().insert(0, OracleMetadataManageTableDsServiceImpl.case("\u6cc9\u6737\u678d\u8bdc\u5258\u654e\u6306\u6eae\u4f89\u6051\uff64\u654e\u6306\u6eae!ZR")).append((String)object).toString());
        }
        if (Objects.isNull((SysDataSource)engineMetadataDetail.getData())) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        object = IdAcquisitionUtil.getCurrentTenantId();
        if (!StringUtils.isNull((Object)(engineMetadataManageTable = a2.generalMetadataManageTableMapper.selectEngineMetadataManageTableByTableName(engineMetadataManageTable)))) {
            a2.generalMetadataManageTableMapper.deleteEngineMetadataManageTableById(engineMetadataManageTable.getId().toString());
            a2.generalMetadataDetailMapper.delColumn(engineMetadataManageTable.getId().toString());
        }
        return a2.insertTableInfo(a);
    }

    public boolean insertTableInfo(EngineMetadataParam a3) throws EngineException {
        OracleEngineMetadataTableServiceImpl a2;
        EngineMetadataManageTable engineMetadataManageTable = a3.getBaseInfo();
        String string = a2.engineDynamicDataSourceService.getDatasourceType();
        try {
            EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
            engineMetadataManageTable2.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            engineMetadataManageTable2.setCreator(IdAcquisitionUtil.getCurrentUserId());
            engineMetadataManageTable2.setRemark(engineMetadataManageTable2.getTableComment());
            if (StringUtils.isEmpty((String)engineMetadataManageTable2.getTableChname())) {
                EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
                engineMetadataManageTable3.setTableChname(engineMetadataManageTable3.getTableName());
            }
            if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableComment())) {
                EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
                engineMetadataManageTable4.setTableComment(engineMetadataManageTable4.getTableName());
            }
            if (StringUtils.isEmpty((String)engineMetadataManageTable.getRemark())) {
                EngineMetadataManageTable engineMetadataManageTable5 = engineMetadataManageTable;
                engineMetadataManageTable5.setRemark(engineMetadataManageTable5.getTableName());
            }
            a2.generalMetadataManageTableMapper.insertEngineMetadataManageTable(engineMetadataManageTable);
        }
        catch (Exception exception) {
            throw new EngineException(EngineExceptionEnum.INSERT_TABLE_INFORMATION_FAILED, (Throwable)exception);
        }
        List list = a3.getColumnInfo();
        a3 = list.iterator();
        Iterator iterator = a3;
        while (iterator.hasNext()) {
            EngineMetadataDetail engineMetadataDetail = (EngineMetadataDetail)a3.next();
            iterator = a3;
            EngineMetadataDetail engineMetadataDetail2 = engineMetadataDetail;
            EngineMetadataDetail engineMetadataDetail3 = engineMetadataDetail;
            engineMetadataDetail.setId(IdGenerateUtils.getId());
            engineMetadataDetail3.setTableId(engineMetadataManageTable.getId());
            engineMetadataDetail2.setStatus(Integer.valueOf(1));
            engineMetadataDetail3.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
            engineMetadataDetail2.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            engineMetadataDetail2.setCreator(IdAcquisitionUtil.getCurrentUserId());
        }
        try {
            a2.metadataDetailMapper.get(string).batchInsert(list);
        }
        catch (Exception a3) {
            throw new EngineException(EngineExceptionEnum.INSERT_COLUMN_INFORMATION_FAILED, (Throwable)a3);
        }
        return true;
    }

    public boolean updateTableInfo(EngineMetadataParam a) throws EngineException {
        ArrayList<EngineMetadataDetailDto> arrayList;
        EngineMetadataDetailDto engineMetadataDetailDto12;
        EngineMetadataParam engineMetadataParam;
        OracleEngineMetadataTableServiceImpl a2;
        String string = a2.engineDynamicDataSourceService.getDatasourceType();
        try {
            a2.generalMetadataManageTableMapper.updateEngineMetadataManageTable(a.getBaseInfo());
        }
        catch (Exception exception) {
            throw new EngineException(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED);
        }
        ArrayList<EngineMetadataDetailDto> arrayList2 = a.getDeletedCols();
        if (StringUtils.isNotEmpty((Collection)a.getDeletedCols())) {
            try {
                a2.generalMetadataDetailMapper.delColInfo((List)arrayList2);
                engineMetadataParam = a;
            }
            catch (Exception exception) {
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        } else {
            engineMetadataParam = a;
        }
        Iterator iterator = engineMetadataParam.getColumnInfo();
        a = new ArrayList();
        arrayList2 = new ArrayList<EngineMetadataDetailDto>();
        Date date = DateUtils.getNowDate();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            engineMetadataDetailDto12 = (EngineMetadataDetailDto)iterator.next();
            if (engineMetadataDetailDto12.getOperation() != null && OracleTransactionalExecuteService.if("\n2\u0006\"").equals(engineMetadataDetailDto12.getOperation())) {
                if (null == engineMetadataDetailDto12.getColumnComment() || "".equals(engineMetadataDetailDto12.getColumnComment())) {
                    EngineMetadataDetailDto engineMetadataDetailDto2 = engineMetadataDetailDto12;
                    engineMetadataDetailDto2.setColumnComment(engineMetadataDetailDto2.getColumnName());
                }
                if (null == engineMetadataDetailDto12.getColumnChname() || "".equals(engineMetadataDetailDto12.getColumnChname())) {
                    EngineMetadataDetailDto engineMetadataDetailDto3 = engineMetadataDetailDto12;
                    engineMetadataDetailDto3.setColumnChname(engineMetadataDetailDto3.getColumnName());
                }
                if (null == engineMetadataDetailDto12.getRemark() || "".equals(engineMetadataDetailDto12.getRemark())) {
                    EngineMetadataDetailDto engineMetadataDetailDto4 = engineMetadataDetailDto12;
                    engineMetadataDetailDto4.setRemark(engineMetadataDetailDto4.getColumnName());
                }
                EngineMetadataDetailDto engineMetadataDetailDto5 = engineMetadataDetailDto12;
                EngineMetadataDetailDto engineMetadataDetailDto6 = engineMetadataDetailDto12;
                engineMetadataDetailDto6.setLastTime(Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
                engineMetadataDetailDto5.setStatus(Integer.valueOf(1));
                engineMetadataDetailDto6.setLastEditor(IdAcquisitionUtil.getCurrentUserId());
                engineMetadataDetailDto5.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
                a.add(engineMetadataDetailDto12);
                continue;
            }
            if (engineMetadataDetailDto12.getOperation() == null || !OracleMetadataManageTableDsServiceImpl.case("\tZ\f").equals(engineMetadataDetailDto12.getOperation())) continue;
            engineMetadataDetailDto12.setId(IdGenerateUtils.getId());
            if (null == engineMetadataDetailDto12.getColumnComment() || "".equals(engineMetadataDetailDto12.getColumnComment())) {
                EngineMetadataDetailDto engineMetadataDetailDto7 = engineMetadataDetailDto12;
                engineMetadataDetailDto7.setColumnComment(engineMetadataDetailDto7.getColumnName());
            }
            if (null == engineMetadataDetailDto12.getColumnChname() || "".equals(engineMetadataDetailDto12.getColumnChname())) {
                EngineMetadataDetailDto engineMetadataDetailDto8 = engineMetadataDetailDto12;
                engineMetadataDetailDto8.setColumnChname(engineMetadataDetailDto8.getColumnName());
            }
            if (null == engineMetadataDetailDto12.getRemark() || "".equals(engineMetadataDetailDto12.getRemark())) {
                EngineMetadataDetailDto engineMetadataDetailDto9 = engineMetadataDetailDto12;
                engineMetadataDetailDto9.setRemark(engineMetadataDetailDto9.getColumnName());
            }
            EngineMetadataDetailDto engineMetadataDetailDto10 = engineMetadataDetailDto12;
            EngineMetadataDetailDto engineMetadataDetailDto11 = engineMetadataDetailDto12;
            engineMetadataDetailDto11.setStatus(Integer.valueOf(1));
            engineMetadataDetailDto10.setCreateTime(Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
            engineMetadataDetailDto11.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            engineMetadataDetailDto10.setCreator(IdAcquisitionUtil.getCurrentUserId());
            arrayList2.add(engineMetadataDetailDto12);
        }
        if (StringUtils.isNotEmpty((Collection)a)) {
            iterator = a.iterator();
            while (iterator.hasNext()) {
                engineMetadataDetailDto12 = (EngineMetadataDetail)iterator.next();
                if (!StringUtils.isEmpty((String)engineMetadataDetailDto12.getColumnLength())) continue;
                engineMetadataDetailDto12.setColumnLength(OracleTransactionalExecuteService.if("f"));
            }
            try {
                a2.metadataDetailMapper.get(string).batchInsert((List)a);
                arrayList = arrayList2;
            }
            catch (Exception exception) {
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        } else {
            arrayList = arrayList2;
        }
        if (StringUtils.isNotEmpty(arrayList)) {
            for (EngineMetadataDetailDto engineMetadataDetailDto12 : arrayList2) {
                if (!StringUtils.isEmpty((String)engineMetadataDetailDto12.getColumnLength())) continue;
                engineMetadataDetailDto12.setColumnLength(OracleMetadataManageTableDsServiceImpl.case("X"));
            }
            try {
                a2.metadataDetailMapper.get(string).batchInsert(arrayList2);
            }
            catch (Exception exception) {
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
        return true;
    }

    public boolean insertEngineMetadataManageTable(EngineMetadataParam a) throws EngineException {
        String string;
        OracleEngineMetadataTableServiceImpl a2;
        Object object;
        EngineMetadataParam engineMetadataParam = a;
        EngineMetadataManageTable engineMetadataManageTable = engineMetadataParam.getBaseInfo();
        Object object2 = engineMetadataParam.getColumnInfo();
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        EngineMetadataManageTable engineMetadataManageTable2 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable3 = engineMetadataManageTable;
        EngineMetadataManageTable engineMetadataManageTable4 = engineMetadataManageTable;
        engineMetadataManageTable.setCountColumn(Long.valueOf(object2.size()));
        engineMetadataManageTable4.setCreateTime(Instant.ofEpochMilli(DateUtils.getNowDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        engineMetadataManageTable4.setVersion(Long.valueOf(0L));
        engineMetadataManageTable3.setStatus(OracleMetadataManageTableDsServiceImpl.case("Y"));
        engineMetadataManageTable2.setCharacterSet(OracleTransactionalExecuteService.if(":\u0002)n"));
        engineMetadataManageTable3.setId(IdGenerateUtils.getId());
        if (StringUtils.isEmpty((String)engineMetadataManageTable2.getTableChname())) {
            EngineMetadataManageTable engineMetadataManageTable5 = engineMetadataManageTable;
            engineMetadataManageTable5.setTableChname(engineMetadataManageTable5.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getTableComment())) {
            EngineMetadataManageTable engineMetadataManageTable6 = engineMetadataManageTable;
            engineMetadataManageTable6.setTableComment(engineMetadataManageTable6.getTableName());
        }
        if (StringUtils.isEmpty((String)engineMetadataManageTable.getRemark())) {
            EngineMetadataManageTable engineMetadataManageTable7 = engineMetadataManageTable;
            engineMetadataManageTable7.setRemark(engineMetadataManageTable7.getTableName());
        }
        if ((object = a2.sysDataSourceService.getDatasourceById(string = engineMetadataManageTable.getDatasourceId().toString())) == null || object.getData() == null) {
            logger.error(OracleMetadataManageTableDsServiceImpl.case("\u6cc9\u6737\u678d\u8bdc\u5258\u654e\u6306\u6eae\u4f89\u6051\uff64\u654e\u6306\u6eae!ZRE\u0015"), (Object)string);
            throw new RuntimeException(new StringBuilder().insert(0, OracleTransactionalExecuteService.if("\u6cf7\u6766\u67b3\u8b8d\u5266\u651f\u6338\u6eff\u4fb7\u6000\uff5a\u651f\u6338\u6eff\u001f\u000bl")).append(string).toString());
        }
        string = (SysDataSource)object.getData();
        if (Objects.isNull(string)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        object = IdAcquisitionUtil.getCurrentTenantId();
        Object object3 = object2 = object2.iterator();
        while (object3.hasNext()) {
            object = (EngineMetadataDetail)object2.next();
            if (object.getPk().equals(OracleMetadataManageTableDsServiceImpl.case("Y"))) {
                arrayList2.add(object.getColumnName());
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Object object4 = object;
            hashMap.put(OracleTransactionalExecuteService.if("\f9\u0003#\u00028!7\u00023"), object4.getColumnName());
            hashMap.put(OracleMetadataManageTableDsServiceImpl.case("W\u001bl\rO\u001dW\u001a[\f"), object.getRequired().toString());
            hashMap.put(OracleTransactionalExecuteService.if("?\u001c\u001f\u00015\u001d3"), OracleMetadataManageTableDsServiceImpl.case("X"));
            hashMap.put(OracleTransactionalExecuteService.if("5\u0000:\u001a;\u0001\u0015\u0000;\u00023\u0001\""), object.getColumnComment());
            hashMap.put(OracleMetadataManageTableDsServiceImpl.case("Z\rX\tK\u0004J>_\u0004K\r"), object.getDefaultValue());
            if (StringUtils.isEmpty((String)object4.getColumnChname())) {
                Object object5 = object;
                object5.setColumnChname(object5.getColumnName());
            }
            if (StringUtils.isEmpty((String)object.getColumnComment())) {
                Object object6 = object;
                object6.setColumnComment(object6.getColumnName());
            }
            if (object.getColumnLength() != null) {
                hashMap.put(OracleTransactionalExecuteService.if("\f9\u0003#\u00028#3\u00011\u001b>"), object.getColumnLength().toString());
            }
            if (object.getPointLength() != null) {
                hashMap.put(OracleMetadataManageTableDsServiceImpl.case("\u0018Q\u0001P\u001cr\rP\u000fJ\u0000"), object.getPointLength().toString());
            }
            arrayList.add(hashMap);
            object3 = object2;
        }
        boolean bl = StringUtils.isNotEmpty(arrayList2);
        try {
            a2.dsService.createTable(engineMetadataManageTable, arrayList, arrayList2, bl, string.getConnName());
        }
        catch (Exception exception) {
            throw new EngineException(EngineExceptionEnum.CREATE_DATABASE_TABLE_FAILED, (Throwable)exception);
        }
        object = a2.generalMetadataManageTableMapper.selectEngineMetadataManageTableByTableName(engineMetadataManageTable);
        if (!StringUtils.isNull((Object)object)) {
            a2.generalMetadataManageTableMapper.deleteEngineMetadataManageTableById(object.getId().toString());
            a2.generalMetadataDetailMapper.delColumn(object.getId().toString());
        }
        return a2.insertTableInfo(a);
    }
}

