/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine.mysql.util;

import com.google.common.base.CaseFormat;
import com.jxdinfo.hussar.engine.metadata.enums.ConnectEnum;
import com.jxdinfo.hussar.engine.metadata.enums.SqlConnectEnum;
import com.jxdinfo.hussar.engine.metadata.model.InputColumnVO;
import com.jxdinfo.hussar.engine.metadata.util.StringUtils;
import com.jxdinfo.hussar.engine.mysql.service.MysqlTransactionalExecuteService;
import com.jxdinfo.hussar.engine.mysql.service.impl.MysqlMetadataManageTableDsServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MysqlQueryConditionUtil {
    protected static final int DEF_SB_SIZE = 128;
    private static Logger logger = LoggerFactory.getLogger(MysqlQueryConditionUtil.class);

    public static String cleanEmptyBrackets(String a) {
        String string = a;
        if (string.contains(MysqlTransactionalExecuteService.long("\u0016l"))) {
            string = a.replace(MysqlMetadataManageTableDsServiceImpl.double("fZn"), "");
            string = MysqlQueryConditionUtil.cleanEmptyBrackets(string);
        }
        return string;
    }

    public static String cleanNoAvailConnect(String a) {
        String string = a;
        if (string.toLowerCase().contains(ConnectEnum._ANDNO.getType())) {
            string = a.replace(ConnectEnum._ANDNO.getType().toUpperCase(), MysqlTransactionalExecuteService.long("l"));
            string = MysqlQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._ORNO.getType())) {
            string = string.replace(ConnectEnum._ORNO.getType().toUpperCase(), MysqlMetadataManageTableDsServiceImpl.double("g"));
            string = MysqlQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._ANDAND.getType())) {
            string = a.replace(ConnectEnum._ANDAND.getType().toUpperCase(), MysqlTransactionalExecuteService.long("\u0004p\u0001"));
            string = MysqlQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._ANDOR.getType())) {
            string = string.replace(ConnectEnum._ANDOR.getType().toUpperCase(), MysqlMetadataManageTableDsServiceImpl.double("<\u001c"));
            string = MysqlQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._OROR.getType())) {
            string = string.replace(ConnectEnum._OROR.getType().toUpperCase(), MysqlTransactionalExecuteService.long("q\u0017"));
            string = MysqlQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._ORAND.getType())) {
            string = string.replace(ConnectEnum._ORAND.getType().toUpperCase(), MysqlMetadataManageTableDsServiceImpl.double("\u000f=\n"));
            string = MysqlQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._WHEREAND.getType())) {
            string = string.replace(ConnectEnum._WHEREAND.getType().toUpperCase(), MysqlTransactionalExecuteService.long("\u0012v\u0000l\u0000"));
            string = MysqlQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._WHEREOR.getType())) {
            string = string.replace(ConnectEnum._WHEREOR.getType().toUpperCase(), MysqlMetadataManageTableDsServiceImpl.double("\u0019;\u000b!\u000b"));
            string = MysqlQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._SIGNAND.getType())) {
            string = string.replace(ConnectEnum._SIGNAND.getType().toUpperCase(), MysqlTransactionalExecuteService.long("m"));
            string = MysqlQueryConditionUtil.cleanNoAvailConnect(string);
        }
        if (a.toLowerCase().contains(ConnectEnum._SIGNOR.getType())) {
            string = string.replace(ConnectEnum._SIGNOR.getType().toUpperCase(), MysqlMetadataManageTableDsServiceImpl.double("f"));
            string = MysqlQueryConditionUtil.cleanNoAvailConnect(string);
        }
        return string;
    }

    public static String dynamicWhereSql(List<InputColumnVO> a, Map<String, Object> a2) {
        String string = null;
        if (StringUtils.isEmpty((String)(a2 = MysqlQueryConditionUtil.renderQueryCon(a, false, "", a2, string))) || ((String)a2).length() <= 5) {
            return "";
        }
        if (StringUtils.isEmpty((String)((String)(a2 = MysqlQueryConditionUtil.cleanSql(((String)a2).substring(0, ((String)a2).length() - 5)))).split(MysqlTransactionalExecuteService.long("\u0012v\u0000l\u0000"))[1].trim())) {
            return "";
        }
        return a2;
    }

    public static String cleanSql(String a) {
        String string;
        String string2 = string = MysqlQueryConditionUtil.cleanNoAvailConnect(MysqlQueryConditionUtil.cleanEmptyBrackets(a));
        String string3 = string2.substring(string.length() - 3, string2.length());
        if (string3.toLowerCase().equals(ConnectEnum._OR.getType())) {
            String string4 = string;
            string = string4.substring(0, string4.length() - 3);
        }
        String string5 = string;
        String string6 = string5.substring(string5.length() - 4, string.length());
        if (string6.toLowerCase().equals(ConnectEnum._AND.getType())) {
            String string7 = string;
            string = string7.substring(0, string7.length() - 4);
        }
        String string8 = string;
        String string9 = string;
        string3 = string8.substring(string8.length() - 3, string9.length());
        string6 = string8.substring(string9.length() - 4, string.length());
        if (string8.toLowerCase().contains(ConnectEnum._ANDNO.getType()) || string.toLowerCase().contains(ConnectEnum._ORNO.getType()) || string.toLowerCase().contains(ConnectEnum._ANDAND.getType()) || string.toLowerCase().contains(ConnectEnum._ANDOR.getType()) || string.toLowerCase().contains(ConnectEnum._ORAND.getType()) || string.toLowerCase().contains(ConnectEnum._OROR.getType()) || string.toLowerCase().contains(ConnectEnum._WHEREAND.getType()) || string.toLowerCase().contains(ConnectEnum._WHEREOR.getType()) || string.toLowerCase().contains(ConnectEnum._SIGNAND.getType()) || string.toLowerCase().contains(ConnectEnum._SIGNOR.getType()) || string.contains(MysqlMetadataManageTableDsServiceImpl.double("[g")) || string3.equalsIgnoreCase(ConnectEnum._OR.getType()) || string6.equalsIgnoreCase(ConnectEnum._AND.getType())) {
            string = MysqlQueryConditionUtil.cleanSql(string);
        }
        return string;
    }

    public MysqlQueryConditionUtil() {
        MysqlQueryConditionUtil a;
    }

    public static String renderQueryCon(List<InputColumnVO> a, boolean a2, String a3, Map<String, Object> a4, String a5) {
        StringBuilder stringBuilder;
        List<InputColumnVO> list;
        StringBuilder stringBuilder2;
        if (CollectionUtils.isEmpty(a4)) {
            return "";
        }
        if (CollectionUtils.isEmpty(a)) {
            return "";
        }
        StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder(128);
        if (!a2) {
            stringBuilder3.append(MysqlMetadataManageTableDsServiceImpl.double("$\u00066\u001c6n"));
            list = a;
        } else {
            stringBuilder3.append(MysqlTransactionalExecuteService.long("m"));
            list = a;
        }
        for (InputColumnVO inputColumnVO : list) {
            Object object;
            if (ConnectEnum._ROW.getType().equals(inputColumnVO.getType())) {
                InputColumnVO inputColumnVO2 = inputColumnVO;
                object = inputColumnVO2.getTableName();
                String string = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, (String)object);
                String string2 = inputColumnVO2.getColumnName();
                String string3 = inputColumnVO2.getColumnAliasDefined();
                String string4 = inputColumnVO2.getInColumnType();
                string4 = inputColumnVO2.getWhereFlag();
                a3 = inputColumnVO2.getInConnectFlag();
                if (inputColumnVO2.getWhereFlag().equalsIgnoreCase(MysqlMetadataManageTableDsServiceImpl.double("\u0015\"\u0012)"))) {
                    stringBuilder2.append(MysqlTransactionalExecuteService.long("%")).append(string2).append(MysqlMetadataManageTableDsServiceImpl.double("\u0013nNnT~Tn")).append(a3.toUpperCase(Locale.ROOT)).append(MysqlTransactionalExecuteService.long("e"));
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)string3) || !a4.containsKey(string3) || !Objects.nonNull(a4.get(string3)) || "".equals(a4.get(string3).toString().trim())) continue;
                if (SqlConnectEnum._LEFT_LIKE.getKey().equalsIgnoreCase(string4) || SqlConnectEnum._RIGHT_LIKE.getKey().equalsIgnoreCase(string4) || SqlConnectEnum._FULL_LIKE.getKey().equalsIgnoreCase(string4)) {
                    if (string4.toUpperCase().contains(MysqlMetadataManageTableDsServiceImpl.double("?\u000b5\u001a"))) {
                        stringBuilder2.append(MysqlTransactionalExecuteService.long("%")).append(string).append(MysqlMetadataManageTableDsServiceImpl.double("\u0013`")).append(MysqlTransactionalExecuteService.long("%")).append(string2).append(MysqlMetadataManageTableDsServiceImpl.double("\u0013n")).append(MysqlTransactionalExecuteService.long("\tw\u000e{e}\np\u0006\u007f\u0011\u001em\u0019`\u0019i\u001d>")).append(string3).append(MysqlMetadataManageTableDsServiceImpl.double("\u000eg")).append(MysqlTransactionalExecuteService.long("e")).append(a3.toUpperCase()).append(MysqlMetadataManageTableDsServiceImpl.double("n"));
                        continue;
                    }
                    StringBuilder stringBuilder4 = stringBuilder2;
                    if (string4.toUpperCase().contains(MysqlTransactionalExecuteService.long("\u0017w\u0002v\u0011"))) {
                        stringBuilder4.append(MysqlMetadataManageTableDsServiceImpl.double(".")).append(string).append(MysqlTransactionalExecuteService.long("^k")).append(MysqlMetadataManageTableDsServiceImpl.double(".")).append(string2).append(MysqlTransactionalExecuteService.long("^e")).append(MysqlMetadataManageTableDsServiceImpl.double("\u0002:\u00056n0\u0001=\r2\u001aSfP5")).append(string3).append(MysqlTransactionalExecuteService.long("Ci\u0019`\u0019l")).append(MysqlMetadataManageTableDsServiceImpl.double("n")).append(a3.toUpperCase()).append(MysqlTransactionalExecuteService.long("e"));
                        continue;
                    }
                    stringBuilder4.append(MysqlMetadataManageTableDsServiceImpl.double(".")).append(string).append(MysqlTransactionalExecuteService.long("^k")).append(MysqlMetadataManageTableDsServiceImpl.double(".")).append(string2).append(MysqlTransactionalExecuteService.long("^e")).append(MysqlMetadataManageTableDsServiceImpl.double("\u0002:\u00056n0\u0001=\r2\u001aSfTkTbP5")).append(string3).append(MysqlTransactionalExecuteService.long("Ci\u0019`\u0019l")).append(MysqlMetadataManageTableDsServiceImpl.double("n")).append(a3.toUpperCase()).append(MysqlTransactionalExecuteService.long("e"));
                    continue;
                }
                if (SqlConnectEnum._EQUAL.getKey().equalsIgnoreCase(string4) || SqlConnectEnum._GREAT_THAN.getKey().equalsIgnoreCase(string4) || SqlConnectEnum._LESS_THAN.getKey().equalsIgnoreCase(string4) || SqlConnectEnum._GREAT_AND_THAN.getKey().equalsIgnoreCase(string4) || SqlConnectEnum._LESS_AND_THAN.getKey().equalsIgnoreCase(string4) || SqlConnectEnum._NOT_EQUAL.getKey().equalsIgnoreCase(string4)) {
                    stringBuilder2.append(MysqlMetadataManageTableDsServiceImpl.double(".")).append(string).append(MysqlTransactionalExecuteService.long("^k")).append(MysqlMetadataManageTableDsServiceImpl.double(".")).append(string2).append(MysqlTransactionalExecuteService.long("%")).append(MysqlMetadataManageTableDsServiceImpl.double("n")).append(string4.toUpperCase()).append(MysqlTransactionalExecuteService.long("e\u001d>")).append(string3).append(MysqlMetadataManageTableDsServiceImpl.double("3")).append(MysqlTransactionalExecuteService.long("e")).append(a3.toUpperCase()).append(MysqlMetadataManageTableDsServiceImpl.double("n"));
                    continue;
                }
                if (SqlConnectEnum._IN.getKey().equalsIgnoreCase(string4) || SqlConnectEnum._NOT_IN.getKey().equalsIgnoreCase(string4)) {
                    if (MysqlTransactionalExecuteService.long("e\u0018").equals(a4.get(string3).toString().trim())) continue;
                    stringBuilder2.append(MysqlMetadataManageTableDsServiceImpl.double(".")).append(string2).append(MysqlTransactionalExecuteService.long("%")).append(MysqlMetadataManageTableDsServiceImpl.double("n")).append(string4.toUpperCase()).append(MysqlTransactionalExecuteService.long("\u001em\u001d>X*L _&V\u001a")).append(string3).append(MysqlMetadataManageTableDsServiceImpl.double("\u000eg")).append(MysqlTransactionalExecuteService.long("e")).append(a3.toUpperCase()).append(MysqlMetadataManageTableDsServiceImpl.double("n"));
                    continue;
                }
                stringBuilder2.append(MysqlTransactionalExecuteService.long("%")).append(string).append(MysqlMetadataManageTableDsServiceImpl.double("\u0013`")).append(MysqlTransactionalExecuteService.long("%")).append(string2).append(MysqlMetadataManageTableDsServiceImpl.double(".")).append(MysqlTransactionalExecuteService.long("e")).append(string4.toUpperCase()).append(MysqlMetadataManageTableDsServiceImpl.double("SfP5\u0015!\u0001+\u0012-\u001b\u0011")).append(string3).append(MysqlTransactionalExecuteService.long("Cl")).append(MysqlMetadataManageTableDsServiceImpl.double("n")).append(a3.toUpperCase()).append(MysqlTransactionalExecuteService.long("e"));
                continue;
            }
            if (!ConnectEnum._CHILD.getType().equals(inputColumnVO.getType())) continue;
            InputColumnVO inputColumnVO3 = inputColumnVO;
            a5 = inputColumnVO3.getInConnectFlag();
            object = inputColumnVO3.getChildren();
            if (CollectionUtils.isEmpty((Collection)object)) continue;
            stringBuilder2.append(MysqlQueryConditionUtil.renderQueryCon((List<InputColumnVO>)object, true, a3, a4, a5));
        }
        if (!a2) {
            StringBuilder stringBuilder5 = stringBuilder2;
            stringBuilder = stringBuilder5;
            stringBuilder5.append(MysqlMetadataManageTableDsServiceImpl.double("\u0019;\u000b!\u000b"));
        } else {
            StringBuilder stringBuilder6 = stringBuilder2;
            if (StringUtils.isEmpty((String)a5)) {
                stringBuilder6.append(MysqlTransactionalExecuteService.long("l"));
                stringBuilder = stringBuilder2;
            } else {
                stringBuilder6.append(MysqlMetadataManageTableDsServiceImpl.double("g")).append(MysqlTransactionalExecuteService.long("e")).append(a5.toUpperCase()).append(MysqlMetadataManageTableDsServiceImpl.double("n"));
                stringBuilder = stringBuilder2;
            }
        }
        return stringBuilder.toString();
    }
}

