/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine.common.util;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.engine.common.util.SpringUtils;
import com.jxdinfo.hussar.formdesign.datasource.FormDesignDataSource;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.NamedThreadLocal;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EngineTenantUtil {
    private static final NamedThreadLocal<String> LR_FALLBACK_TENANT_ID;
    private static final Pattern REGEXP_PATH_SEPARATOR;
    private static final Logger logger;
    private static final String TENANT_CODE_ATTRIBUTE = "tenantCode";

    public static String getTenantId() {
        HttpServletRequest httpServletRequest = null;
        try {
            httpServletRequest = EngineTenantUtil.finally();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return (String)LR_FALLBACK_TENANT_ID.get();
        }
        Object object = httpServletRequest.getAttribute(TENANT_CODE_ATTRIBUTE);
        if (object instanceof String) {
            return (String)object;
        }
        if (object != null) {
            logger.error(new StringBuilder().insert(0, EngineTenantUtil.class("T\u0013L\u0004v\u0000v\u0015M\u0015q\r6\u0006}\u0015L\u0004v\u0000v\u0015Q\u00050H8\u0000t\u0013}\u0000|\u00188\u0007y\bt\u0004|Ah\u0013}\u0017q\u000em\u0012t\u0018\"A")).append(object).toString());
            throw new IllegalStateException(new StringBuilder().insert(0, EngineTenantUtil.class("T\u0013L\u0004v\u0000v\u0015M\u0015q\r6\u0006}\u0015L\u0004v\u0000v\u0015Q\u00050H8\u0000t\u0013}\u0000|\u00188\u0007y\bt\u0004|Ah\u0013}\u0017q\u000em\u0012t\u0018\"A")).append(object).toString());
        }
        try {
            HttpServletRequest httpServletRequest2 = httpServletRequest;
            object = EngineTenantUtil.class("(Q(Q(Q");
            httpServletRequest2.setAttribute(TENANT_CODE_ATTRIBUTE, object);
            return object;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            httpServletRequest.setAttribute(TENANT_CODE_ATTRIBUTE, (Object)ErrorMessage.of(exception2.toString()));
            logger.error(EngineTenantUtil.class("\u83af\u53b7l\u0004v\u0000v\u0015[\u000e|\u0004\u5f1a\u5e59"), (Throwable)exception);
            throw exception2;
        }
    }

    private static /* synthetic */ String finally(HttpServletRequest httpServletRequest) {
        String string;
        try {
            HttpServletRequest a;
            string = URLDecoder.decode(a.getRequestURI(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        return Arrays.stream(REGEXP_PATH_SEPARATOR.split(string)).filter(StringUtils::isNotEmpty).findFirst().orElse(null);
    }

    public static void initializeFallbackTenantIdForThread(String string) {
        String a;
        LR_FALLBACK_TENANT_ID.set((Object)a);
    }

    public EngineTenantUtil() {
        EngineTenantUtil a;
    }

    public static FormDesignDataSource getDataSourceByTenantId(String string) {
        FormDesignDataSource formDesignDataSource;
        String a;
        SysDataSource sysDataSource = SpringUtils.getBean(SysDataSourceService.class).getByTenantCode(a);
        FormDesignDataSource formDesignDataSource2 = formDesignDataSource = new FormDesignDataSource();
        BeanUtils.copyProperties((Object)sysDataSource, (Object)formDesignDataSource2);
        return formDesignDataSource2;
    }

    public static Long getUserId() {
        return BaseSecurityUtil.getUser().getId();
    }

    private static /* synthetic */ HttpServletRequest finally() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            logger.error(EngineTenantUtil.class("T\u0013L\u0004v\u0000v\u0015M\u0015q\r6\u0002m\u0013j\u0004v\u0015J\u0004i\u0014}\u0012lI1[8\u0013}\u0010m\u0004k\u00158\bkAv\u000elAK\u0004j\u0017t\u0004l3}\u0010m\u0004k\u0015Y\u0015l\u0013q\u0003m\u0015}\u0012"));
            throw new UnsupportedOperationException(EngineTenantUtil.class("T\u0013L\u0004v\u0000v\u0015M\u0015q\r6\u0002m\u0013j\u0004v\u0015J\u0004i\u0014}\u0012lI1[8\u0013}\u0010m\u0004k\u00158\bkAv\u000elAK\u0004j\u0017t\u0004l3}\u0010m\u0004k\u0015Y\u0015l\u0013q\u0003m\u0015}\u0012"));
        }
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    static {
        logger = LoggerFactory.getLogger(EngineTenantUtil.class);
        LR_FALLBACK_TENANT_ID = new NamedThreadLocal(EngineTenantUtil.class("\rjL~\u0000t\rz\u0000{\n5\u0015}\u000fy\u000flLq\u0005"));
        REGEXP_PATH_SEPARATOR = Pattern.compile(EngineTenantUtil.class(":7=D<"));
    }

    public static String class(String string) {
        String a;
        int n = a.length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = 3 << 3;
        int cfr_ignored_0 = 1 << 3 ^ 3;
        int n4 = n2;
        int n5 = (3 ^ 5) << 4 ^ 1;
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(a.charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(a.charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    public static List<FormDesignDataSource> getDataSourceList() {
        throw new RuntimeException(EngineTenantUtil.class("/W582M1H.J5]%8/W6"));
    }

    public static FormDesignDataSource getDefaultDataSource() {
        FormDesignDataSource formDesignDataSource;
        SysDataSource sysDataSource = SpringUtils.getBean(SysDataSourceService.class).getByTenantCode(EngineTenantUtil.getTenantId());
        FormDesignDataSource formDesignDataSource2 = formDesignDataSource = new FormDesignDataSource();
        BeanUtils.copyProperties((Object)sysDataSource, (Object)formDesignDataSource2);
        return formDesignDataSource2;
    }

    private static class ErrorMessage {
        private String message;

        public static ErrorMessage of(String string) {
            String a;
            ErrorMessage errorMessage = new ErrorMessage();
            errorMessage.setMessage(a);
            return errorMessage;
        }

        public ErrorMessage() {
            ErrorMessage a;
        }

        public String toString() {
            ErrorMessage a;
            return a.message;
        }

        /*
         * WARNING - void declaration
         */
        public void setMessage(String string) {
            void a;
            a.message = a;
        }

        public String getMessage() {
            ErrorMessage a;
            return a.message;
        }
    }
}

