/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine.common.util;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.engine.common.util.SpringUtils;
import com.jxdinfo.hussar.formdesign.datasource.FormDesignDataSource;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.NamedThreadLocal;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EngineTenantUtil {
    private static final Logger logger = LoggerFactory.getLogger(EngineTenantUtil.class);
    private static final Pattern REGEXP_PATH_SEPARATOR;
    private static final String TENANT_CODE_ATTRIBUTE = "tenantCode";
    private static final NamedThreadLocal<String> LR_FALLBACK_TENANT_ID;

    public static Long getUserId() {
        return BaseSecurityUtil.getUser().getId();
    }

    public static List<FormDesignDataSource> getDataSourceList() {
        throw new RuntimeException(EngineTenantUtil.try("\u0018\t\u0002f\u0005\u0013\u0006\u0016\u0019\u0014\u0002\u0003\u0012f\u0018\t\u0001"));
    }

    static {
        LR_FALLBACK_TENANT_ID = new NamedThreadLocal(EngineTenantUtil.try(":4{ 7*:$7%=k\"#8'82{/2"));
        REGEXP_PATH_SEPARATOR = Pattern.compile(EngineTenantUtil.try("\ri\n\u001a\u000b"));
    }

    public static String getTenantId() {
        HttpServletRequest httpServletRequest = null;
        try {
            httpServletRequest = EngineTenantUtil.import();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return (String)LR_FALLBACK_TENANT_ID.get();
        }
        Object object = httpServletRequest.getAttribute(TENANT_CODE_ATTRIBUTE);
        if (object instanceof String) {
            return (String)object;
        }
        if (object != null) {
            logger.error(new StringBuilder().insert(0, EngineTenantUtil.try("\n$\u00123(7(\"\u0013\"/:h1#\"\u00123(7(\"\u000f2n\u007ff7*$#7\"/f0'?*3\"v6$# /93%*/|v")).append(object).toString());
            throw new IllegalStateException(new StringBuilder().insert(0, EngineTenantUtil.try("\n$\u00123(7(\"\u0013\"/:h1#\"\u00123(7(\"\u000f2n\u007ff7*$#7\"/f0'?*3\"v6$# /93%*/|v")).append(object).toString());
        }
        try {
            HttpServletRequest httpServletRequest2 = httpServletRequest;
            object = EngineTenantUtil.try("vfvfvf");
            httpServletRequest2.setAttribute(TENANT_CODE_ATTRIBUTE, object);
            return object;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            httpServletRequest.setAttribute(TENANT_CODE_ATTRIBUTE, (Object)ErrorMessage.of(exception2.toString()));
            logger.error(EngineTenantUtil.try("\u83f1\u538023(7(\"\u00059\"3\u5f44\u5e6e"), (Throwable)exception);
            throw exception2;
        }
    }

    public static FormDesignDataSource getDefaultDataSource() {
        FormDesignDataSource formDesignDataSource;
        SysDataSource sysDataSource = SpringUtils.getBean(SysDataSourceService.class).getByTenantCode(EngineTenantUtil.getTenantId());
        FormDesignDataSource formDesignDataSource2 = formDesignDataSource = new FormDesignDataSource();
        BeanUtils.copyProperties((Object)sysDataSource, (Object)formDesignDataSource2);
        return formDesignDataSource2;
    }

    public static String try(String string) {
        String a;
        int n = a.length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = 4 << 4 ^ 3 << 1;
        int cfr_ignored_0 = 1 << 3 ^ (2 ^ 5);
        int n4 = n2;
        int n5 = 5 << 4 ^ 3 << 1;
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(a.charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(a.charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    public EngineTenantUtil() {
        EngineTenantUtil a;
    }

    private static /* synthetic */ HttpServletRequest import() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            logger.error(EngineTenantUtil.try("\n$\u00123(7(\"\u0013\"/:h53$43(\"\u001437##%2~olf$#'335\"f?5v(92v\u001534 *32\u0004#'335\"\u0007\"2$/43\"#%"));
            throw new UnsupportedOperationException(EngineTenantUtil.try("\n$\u00123(7(\"\u0013\"/:h53$43(\"\u001437##%2~olf$#'335\"f?5v(92v\u001534 *32\u0004#'335\"\u0007\"2$/43\"#%"));
        }
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static void initializeFallbackTenantIdForThread(String string) {
        String a;
        LR_FALLBACK_TENANT_ID.set((Object)a);
    }

    private static /* synthetic */ String import(HttpServletRequest httpServletRequest) {
        String string;
        try {
            HttpServletRequest a;
            string = URLDecoder.decode(a.getRequestURI(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        return Arrays.stream(REGEXP_PATH_SEPARATOR.split(string)).filter(StringUtils::isNotEmpty).findFirst().orElse(null);
    }

    public static FormDesignDataSource getDataSourceByTenantId(String string) {
        FormDesignDataSource formDesignDataSource;
        String a;
        SysDataSource sysDataSource = SpringUtils.getBean(SysDataSourceService.class).getByTenantCode(a);
        FormDesignDataSource formDesignDataSource2 = formDesignDataSource = new FormDesignDataSource();
        BeanUtils.copyProperties((Object)sysDataSource, (Object)formDesignDataSource2);
        return formDesignDataSource2;
    }

    private static class ErrorMessage {
        private String message;

        public String getMessage() {
            ErrorMessage a;
            return a.message;
        }

        public String toString() {
            ErrorMessage a;
            return a.message;
        }

        /*
         * WARNING - void declaration
         */
        public void setMessage(String string) {
            void a;
            a.message = a;
        }

        public ErrorMessage() {
            ErrorMessage a;
        }

        public static ErrorMessage of(String string) {
            String a;
            ErrorMessage errorMessage = new ErrorMessage();
            errorMessage.setMessage(a);
            return errorMessage;
        }
    }
}

