/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine.api.util;

import com.jxdinfo.hussar.engine.api.util.ApiConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LogInfoGatherUtil {
    private static final String UNKNOWN = "unknown";
    private static final Pattern IP_ADDRESS_REGEX = Pattern.compile(ApiConstants.this("|X\u0013,F\u000b\u0010\r^By@\u000fD\u007f,F\f\u0010Ey@\u000fE\u007f\fyA\u000fI\u007f,F\fyA\u000fI\u007fY~^\nA~\u0014YB_\f\u0010+\u0012]\u0016-~\u0014^B\u0017+\u0012]\u0017-^+\u0013]\u001b-~\u0014^,FY~^\nA~\u0014YB_\f\u0010+\u0012]\u0016-~\u0014^B\u0017+\u0012]\u0017-^+\u0013]\u001b-~\u0014^,FY~^\nA~\u0014YB_\f\u0010+\u0012]\u0016-~\u0014^B\u0017+\u0012]\u0017-^+\u0013]\u001b-~\u0014^,FY\u0006"));
    private static final String LOCAL_IP_V6 = "0:0:0:0:0:0:0:1";
    private static final String LOCAL_IP = "127.0.0.1";

    public static String getHost() {
        return LogInfoGatherUtil.public().getRemoteHost();
    }

    public static String getLocalPort() {
        return String.valueOf(LogInfoGatherUtil.public().getLocalPort());
    }

    public static String getSessionId() {
        return LogInfoGatherUtil.public().getSession().getId();
    }

    public static boolean ipCheck(String a) {
        if (a != null && !a.isEmpty()) {
            return IP_ADDRESS_REGEX.matcher(a).matches();
        }
        return false;
    }

    private static /* synthetic */ HttpServletRequest public() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            throw new UnsupportedOperationException(ApiConstants.this("\u0017G\u0004p\u0015S\u0005G\u0003VJ\u0002\u001eM\u0004\u0002#G\u0002T\u001cG\u0004p\u0015S\u0005G\u0003V1V\u0004P\u0019@\u0005V\u0015Q"));
        }
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static Map<String, String> getBusinessLogInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = hashMap.put(ApiConstants.this("\u0019R"), LogInfoGatherUtil.getIp());
        HashMap<String, String> hashMap2 = hashMap;
        hashMap.put(ApiConstants.this("\u0000M\u0002V"), LogInfoGatherUtil.getPort());
        hashMap2.put(ApiConstants.this("\u0018M\u0003V"), LogInfoGatherUtil.getHost());
        hashMap.put(ApiConstants.this("N\u001fA\u0011N9R"), LogInfoGatherUtil.getLocalIp());
        hashMap.put(ApiConstants.this("N\u001fA\u0011N M\u0002V"), LogInfoGatherUtil.getLocalPort());
        hashMap.put(ApiConstants.this("N\u001fA\u0011N8M\u0003V"), LogInfoGatherUtil.getLocalHost());
        hashMap.put(ApiConstants.this("Q\u0015Q\u0003K\u001fL9F"), LogInfoGatherUtil.getSessionId());
        return hashMap2;
    }

    public static String getLocalIp() {
        return LogInfoGatherUtil.public().getLocalAddr();
    }

    public static String getIp() {
        HttpServletRequest httpServletRequest = LogInfoGatherUtil.public();
        String string = httpServletRequest.getHeader(ApiConstants.this("z]p\u0015C\u001c\u000f9r"));
        if (StringUtils.isBlank((String)string) || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader(ApiConstants.this("z]p\u0015S\u0005G\u0003V\u0015F]d\u001fP"));
        }
        if (StringUtils.isBlank((String)string) || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader(ApiConstants.this("z]d\u001fP\u0007C\u0002F\u0015F]d\u001fP"));
        }
        if (StringUtils.isBlank((String)string) || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader(ApiConstants.this("r\u0002M\b[]a\u001cK\u0015L\u0004\u000f9r"));
        }
        if (StringUtils.isBlank((String)string) || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader(ApiConstants.this("'n]r\u0002M\b[]a\u001cK\u0015L\u0004\u000f9r"));
        }
        if (StringUtils.isBlank((String)string) || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader(ApiConstants.this("8v$r/a<k5l$}9r"));
        }
        if (StringUtils.isBlank((String)string) || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader(ApiConstants.this("8v$r/z/d?p'c\"f5f/d?p"));
        }
        if (StringUtils.isBlank((String)string) || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getRemoteAddr();
        }
        String string2 = string = StringUtils.isBlank((String)string) ? null : string.split(ApiConstants.this("\u000e"))[0];
        if (LOCAL_IP_V6.equals(string)) {
            return LOCAL_IP;
        }
        if (LogInfoGatherUtil.ipCheck(string)) {
            return string;
        }
        return UNKNOWN;
    }

    public static String getPort() {
        return String.valueOf(LogInfoGatherUtil.public().getRemotePort());
    }

    public static String getLocalHost() {
        return LogInfoGatherUtil.getLocalIp();
    }

    public static String getRequestPath() {
        return LogInfoGatherUtil.public().getRequestURI();
    }

    public LogInfoGatherUtil() {
        LogInfoGatherUtil a;
    }
}

