/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine.api.util;

import com.jxdinfo.hussar.engine.api.util.ApiConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LogInfoGatherUtil {
    private static final String LOCAL_IP_V6 = "0:0:0:0:0:0:0:1";
    private static final String LOCAL_IP = "127.0.0.1";
    private static final Pattern IP_ADDRESS_REGEX = Pattern.compile(ApiConstants.catch("\u000e[a/4\bb\u000e,A\u000bC}G\r/4\u000fbF\u000bC}F\r\u000f\u000bB}J\r/4\u000f\u000bB}J\rZ\f]xB\f\u0017+A-\u000fb(`^d.\f\u0017,Ae(`^e.,(a^i.\f\u0017,/4Z\f]xB\f\u0017+A-\u000fb(`^d.\f\u0017,Ae(`^e.,(a^i.\f\u0017,/4Z\f]xB\f\u0017+A-\u000fb(`^d.\f\u0017,Ae(`^e.,(a^i.\f\u0017,/4Zt"));
    private static final String UNKNOWN = "unknown";

    public static String getLocalHost() {
        return LogInfoGatherUtil.getLocalIp();
    }

    public static String getPort() {
        return String.valueOf(LogInfoGatherUtil.float().getRemotePort());
    }

    public static String getSessionId() {
        return LogInfoGatherUtil.float().getSession().getId();
    }

    public static Map<String, String> getBusinessLogInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = hashMap.put(ApiConstants.catch("\u001a "), LogInfoGatherUtil.getIp());
        HashMap<String, String> hashMap2 = hashMap;
        hashMap.put(ApiConstants.catch("\u0003?\u0001$"), LogInfoGatherUtil.getPort());
        hashMap2.put(ApiConstants.catch("\u001b?\u0000$"), LogInfoGatherUtil.getHost());
        hashMap.put(ApiConstants.catch("<\u001c3\u0012<: "), LogInfoGatherUtil.getLocalIp());
        hashMap.put(ApiConstants.catch("<\u001c3\u0012<#?\u0001$"), LogInfoGatherUtil.getLocalPort());
        hashMap.put(ApiConstants.catch("<\u001c3\u0012<;?\u0000$"), LogInfoGatherUtil.getLocalHost());
        hashMap.put(ApiConstants.catch("#\u0016#\u00009\u001c>:4"), LogInfoGatherUtil.getSessionId());
        return hashMap2;
    }

    public LogInfoGatherUtil() {
        LogInfoGatherUtil a;
    }

    private static /* synthetic */ HttpServletRequest float() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            throw new UnsupportedOperationException(ApiConstants.catch("\u00145\u0007\u0002\u0016!\u00065\u0000$Ip\u001d?\u0007p 5\u0001&\u001f5\u0007\u0002\u0016!\u00065\u0000$2$\u0007\"\u001a2\u0006$\u0016#"));
        }
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static String getIp() {
        HttpServletRequest httpServletRequest = LogInfoGatherUtil.float();
        String string = httpServletRequest.getHeader(ApiConstants.catch("\b^\u0002\u00161\u001f}:\u0000"));
        if (StringUtils.isBlank((String)string) || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader(ApiConstants.catch("\b^\u0002\u0016!\u00065\u0000$\u00164^\u0016\u001c\""));
        }
        if (StringUtils.isBlank((String)string) || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader(ApiConstants.catch("\b^\u0016\u001c\"\u00041\u00014\u00164^\u0016\u001c\""));
        }
        if (StringUtils.isBlank((String)string) || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader(ApiConstants.catch("\u0000\u0001?\u000b)^\u0013\u001f9\u0016>\u0007}:\u0000"));
        }
        if (StringUtils.isBlank((String)string) || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader(ApiConstants.catch("$\u001c^\u0000\u0001?\u000b)^\u0013\u001f9\u0016>\u0007}:\u0000"));
        }
        if (StringUtils.isBlank((String)string) || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader(ApiConstants.catch(";\u0004'\u0000,\u0013?\u00196\u001e'\u000f:\u0000"));
        }
        if (StringUtils.isBlank((String)string) || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader(ApiConstants.catch(";\u0004'\u0000,\b,\u0016<\u0002$\u0011!\u00146\u0014,\u0016<\u0002"));
        }
        if (StringUtils.isBlank((String)string) || UNKNOWN.equalsIgnoreCase(string)) {
            string = httpServletRequest.getRemoteAddr();
        }
        String string2 = string = StringUtils.isBlank((String)string) ? null : string.split(ApiConstants.catch("|"))[0];
        if (LOCAL_IP_V6.equals(string)) {
            return LOCAL_IP;
        }
        if (LogInfoGatherUtil.ipCheck(string)) {
            return string;
        }
        return UNKNOWN;
    }

    public static String getRequestPath() {
        return LogInfoGatherUtil.float().getRequestURI();
    }

    public static String getHost() {
        return LogInfoGatherUtil.float().getRemoteHost();
    }

    public static String getLocalPort() {
        return String.valueOf(LogInfoGatherUtil.float().getLocalPort());
    }

    public static String getLocalIp() {
        return LogInfoGatherUtil.float().getLocalAddr();
    }

    public static boolean ipCheck(String string) {
        String a;
        if (a != null && !a.isEmpty()) {
            return IP_ADDRESS_REGEX.matcher(a).matches();
        }
        return false;
    }
}

