/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.CommonResourcesIdMap;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.EaiPublishBaseResources;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.factory.IPublishAuthCheckFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.factory.IPublishAuthFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.factory.IPublishResourceFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.IPublishAuthService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiCanvasConvertService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.publish.dto.EaiPublishEnhancementResources;
import com.jxdinfo.hussar.eai.atomicenhancements.api.publish.service.EaiCommonENResourcesIdMapService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.EaiWebServiceAuthDto;
import com.jxdinfo.hussar.eai.webservice.auth.api.service.IWebServiceAuthenticationService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.webservice.publish.service.impl.PublishWebserviceAuthImpl")
public class PublishWebserviceAuthImpl
implements IPublishAuthService {
    @Resource
    private IWebServiceAuthenticationService webServiceAuthenticationService;
    @Resource
    private EaiCanvasConvertService canvasConvertService;
    @Resource
    private EaiCommonENResourcesIdMapService commonENResourcesIdMapService;

    public CommonResourcesIdMap publishAuthAndGetCommonResources(String applicationCode, String appVersion, CommonResourcesIdMap commonResourcesIdMap) {
        List authCheck = IPublishAuthCheckFactory.getService((String)"webservice").authCheck(applicationCode);
        boolean withAuth = (Boolean)authCheck.get(0);
        boolean updateAuth = (Boolean)authCheck.get(1);
        boolean withLogic = (Boolean)authCheck.get(2);
        return this.publishAuthAndGetCommonResources(applicationCode, appVersion, withAuth, updateAuth, withLogic, commonResourcesIdMap);
    }

    public CommonResourcesIdMap publishAuthAndGetCommonResources(String applicationCode, String appVersion, Boolean withAuth, Boolean updateAuth, Boolean withLogic, CommonResourcesIdMap commonResourcesIdMap) {
        ApiResponse response;
        EaiWebServiceAuthDto publishing;
        if (withAuth.booleanValue() && HussarUtils.isNotEmpty((Object)(publishing = (EaiWebServiceAuthDto)(response = this.webServiceAuthenticationService.selectWebserviceTemplateInfosWithNewIds(applicationCode)).getData()))) {
            EaiPublishEnhancementResources resourcesByCanvas = this.canvasResources(publishing, appVersion, commonResourcesIdMap);
            this.commonENResourcesIdMapService.toCommonResourcesIdMap((EaiPublishBaseResources)resourcesByCanvas, commonResourcesIdMap);
            publishing.getEaiHttpTemplate().setTemplateType(null);
            if (updateAuth.booleanValue()) {
                this.webServiceAuthenticationService.updateWebserviceTemplateInfos(publishing);
            } else {
                this.webServiceAuthenticationService.saveWebserviceTemplateInfos(publishing);
            }
        }
        return commonResourcesIdMap;
    }

    private EaiPublishEnhancementResources canvasResources(EaiWebServiceAuthDto publishing, String appVersion, CommonResourcesIdMap commonResourcesIdMap) {
        EaiPublishEnhancementResources resourcesByCanvas = new EaiPublishEnhancementResources();
        CanvasInfo canvasInfo = publishing.getCanvasInfo();
        if (HussarUtils.isNotEmpty((Object)canvasInfo)) {
            Map resourceMap;
            List infos;
            String resources = canvasInfo.getCanvasResources();
            if (HussarUtils.isNotEmpty((Object)resources) && HussarUtils.isNotEmpty((Object)(infos = (resourcesByCanvas = this.canvasConvertService.getCommonResourcesByCanvas(commonResourcesIdMap, canvasInfo, resourceMap = (Map)JSON.parseObject((String)resources, (TypeReference)new TypeReference<Map<String, Integer>>(){}, (Feature[])new Feature[0]), appVersion)).getCanvas()))) {
                canvasInfo = (CanvasInfo)infos.get(infos.size() - 1);
                Long id = EngineUtil.getId();
                canvasInfo.setId(id);
                publishing.setCanvasInfo(canvasInfo);
                if (infos.size() > 1) {
                    List<CanvasInfo> logicCanvas = infos.subList(0, infos.size() - 1);
                    logicCanvas.add(canvasInfo);
                    resourcesByCanvas.setCanvas(logicCanvas);
                }
            }
            IPublishResourceFactory.getService((String)"default").publishCommonResources((EaiPublishBaseResources)resourcesByCanvas, appVersion);
            IPublishResourceFactory.getService((String)"default_logic").publishCommonResources((EaiPublishBaseResources)resourcesByCanvas, appVersion);
        }
        return resourcesByCanvas;
    }

    public void afterPropertiesSet() throws Exception {
        IPublishAuthFactory.register((String)"webservice", (IPublishAuthService)this);
    }
}

