/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.publish.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IApiCallSpecificationInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IApiVersionService;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.EaiWsApiParams;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.WebServiceAuthVerfiyDto;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiEditApiWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiEditApiWsdlService;
import com.jxdinfo.hussar.eai.webservice.publish.api.IEaiWebServiceParamsChangeService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.webservice.publish.service.impl.eaiWebServiceParamsChangeServiceImpl")
public class EaiWebServiceParamsChangeServiceImpl
implements IEaiWebServiceParamsChangeService {
    private static final String ERROR_MSG = "\u63a5\u53e3\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ERROR_NOTFOUND_MSG = "\u8bf7\u6c42\u7684\u63a5\u53e3\u4e0d\u5b58\u5728";
    private static final String BODY = "body";
    private static final String BODY_STR = "body";
    @Resource
    private IEaiResourcesInfoService eaiResourcesInfoService;
    @Resource
    private IApiCallSpecificationInfoService callSpecificationInfoService;
    @Resource
    private IEaiEditApiWsdlService eaiEditApiWsdlService;
    @Resource
    private IApiVersionService iApiVersionService;
    @Resource
    private IEaiEditApiService editApiService;

    public EaiApiVersion getEaiResourcesInfo(Object inParams, String apiCode) {
        AssertUtil.isNotEmpty((String)apiCode, (String)ERROR_MSG);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EaiResourcesInfo::getResourceVersionId, (Object)Long.valueOf(apiCode));
        EaiResourcesInfo eaiResourcesInfo = (EaiResourcesInfo)this.eaiResourcesInfoService.getOne((Wrapper)queryWrapper);
        if (ToolUtil.isEmpty((Object)eaiResourcesInfo)) {
            throw new BaseException(ERROR_NOTFOUND_MSG);
        }
        if ("1".equals(eaiResourcesInfo.getDeleteState())) {
            throw new BaseException("\u63a5\u53e3\u5df2\u4e0b\u67b6");
        }
        EaiApiVersion apiVersion = (EaiApiVersion)this.iApiVersionService.getById((Serializable)eaiResourcesInfo.getResourceVersionId());
        return apiVersion;
    }

    public WebServiceAuthVerfiyDto webserviceParams(EaiApiVersion apiVersion, Object inParams, String apiCode) {
        WebServiceAuthVerfiyDto webServiceAuthVerfiyDto = new WebServiceAuthVerfiyDto();
        webServiceAuthVerfiyDto.setApplicationCode(apiVersion.getApplicationCode());
        LambdaQueryWrapper editQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EditApi::getApiId, (Object)apiVersion.getApiVersionId());
        EditApi editApi = (EditApi)this.editApiService.getOne((Wrapper)editQueryWrapper);
        LambdaQueryWrapper wsdlQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiEditApiWsdl::getApiId, (Object)apiVersion.getApiVersionId());
        EaiEditApiWsdl eaiEditApiWsdl = (EaiEditApiWsdl)this.eaiEditApiWsdlService.getOne((Wrapper)wsdlQueryWrapper);
        EaiWsApiParams eaiWsApiTestParams = new EaiWsApiParams();
        BeanUtil.copyProperties((Object)eaiEditApiWsdl, (Object)eaiWsApiTestParams);
        webServiceAuthVerfiyDto.setWsApiParams(eaiWsApiTestParams);
        EaiApiParams obj = new EaiApiParams();
        if (HussarUtils.isNotEmpty((Object)apiVersion.getInParams())) {
            obj = ParamsConvertUtil.webServiceEaiParamsItems((Object)inParams, (String)editApi.getInParams());
        }
        webServiceAuthVerfiyDto.setBody(this.toInParams(obj.getHeader()));
        webServiceAuthVerfiyDto.setHeader(this.toInParams(obj.getBody()));
        webServiceAuthVerfiyDto.setOutMapping(ParamsConvertUtil.toEaiParamsItems((String)editApi.getOutParams()));
        webServiceAuthVerfiyDto.setCallSpecificaList(this.callSpecificationInfoService.selectCallInfoListByApiId(Long.valueOf(apiCode)));
        return webServiceAuthVerfiyDto;
    }

    private List<EaiHttpParamsDto> toInParams(Object obj) {
        if (HussarUtils.isEmpty((Object)obj)) {
            return new ArrayList<EaiHttpParamsDto>();
        }
        ArrayList<EaiHttpParamsDto> httpBody = new ArrayList<EaiHttpParamsDto>();
        if (obj instanceof Map) {
            Iterator iterator = ((Map)obj).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry1 = entry = iterator.next();
                EaiHttpParamsDto eaiHttpParamsDto = new EaiHttpParamsDto();
                eaiHttpParamsDto.setParamsNameEn(entry1.getKey() == null ? null : String.valueOf(entry1.getKey()));
                eaiHttpParamsDto.setKeyValue(entry1.getValue());
                httpBody.add(eaiHttpParamsDto);
            }
        } else {
            EaiHttpParamsDto eaiHttpParamsDto = new EaiHttpParamsDto();
            eaiHttpParamsDto.setParamsNameEn(null);
            eaiHttpParamsDto.setKeyValue(obj);
            httpBody.add(eaiHttpParamsDto);
        }
        return httpBody;
    }
}

