/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.publish.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.CommonResourcesIdMap;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishExtraService;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdlVersion;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiEditApiWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiAppWsdlVersionService;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiEditApiWsdlService;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IWsdlInfoService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.webservice.publish.service.impl.EaiWebServiceEaiPublishExtraServiceImpl")
public class EaiWebServiceEaiPublishExtraServiceImpl
implements EaiPublishExtraService {
    @Resource
    private IEaiEditApiWsdlService eaiEditApiWsdlService;
    @Resource
    IEaiAppWsdlVersionService eaiAppWsdlVersionService;
    @Resource
    IWsdlInfoService wsdlInfoService;

    public void publishExtra(List<Long> onApiIds, Map<Long, Long> apiIdMaps, String applicationCode, String appVersion, CommonResourcesIdMap commonResourcesIdMap) {
        ArrayList<EaiEditApiWsdl> eaiEditApiWsdlList = new ArrayList<EaiEditApiWsdl>();
        for (Long aLong : onApiIds) {
            LambdaQueryWrapper wsqueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiEditApiWsdl::getApiId, (Object)aLong);
            EaiEditApiWsdl eaiEditApiWsdl = (EaiEditApiWsdl)this.eaiEditApiWsdlService.getOne((Wrapper)wsqueryWrapper);
            if (!HussarUtils.isNotEmpty((Object)eaiEditApiWsdl)) continue;
            eaiEditApiWsdlList.add(eaiEditApiWsdl);
        }
        this.saveWebServiceApi(eaiEditApiWsdlList, apiIdMaps, commonResourcesIdMap);
    }

    private void saveWebServiceApi(List<EaiEditApiWsdl> eaiEditApiWsdlList, Map<Long, Long> apiIdMaps, CommonResourcesIdMap commonResourcesIdMap) {
        List<Object> wsdlIds = new ArrayList();
        for (EaiEditApiWsdl apiWsdl : eaiEditApiWsdlList) {
            Long apiId = apiIdMaps.get(apiWsdl.getApiId());
            apiWsdl.setApiId(apiId);
            apiWsdl.setId(EngineUtil.getId());
            wsdlIds.add(apiWsdl.getWsdlId());
        }
        if (HussarUtils.isEmpty(wsdlIds = wsdlIds.stream().distinct().collect(Collectors.toList()))) {
            return;
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiAppWsdl::getId, wsdlIds);
        List eaiAppWsdls = this.wsdlInfoService.list((Wrapper)queryWrapper);
        ArrayList<EaiAppWsdlVersion> eaiAppWsdlVersions = new ArrayList<EaiAppWsdlVersion>();
        HashMap<Long, Long> wsdlIdsMap = new HashMap<Long, Long>();
        for (EaiAppWsdl eaiAppWsdl : eaiAppWsdls) {
            EaiAppWsdlVersion wsdlVersion = new EaiAppWsdlVersion();
            BeanUtil.copyProperties((Object)eaiAppWsdl, (Object)wsdlVersion);
            wsdlVersion.setWsdlId(eaiAppWsdl.getId());
            Long id = EngineUtil.getId();
            wsdlVersion.setId(id);
            eaiAppWsdlVersions.add(wsdlVersion);
            wsdlIdsMap.put(eaiAppWsdl.getId(), id);
        }
        this.eaiAppWsdlVersionService.saveBatch(eaiAppWsdlVersions);
        for (EaiEditApiWsdl wsdlVersion : eaiEditApiWsdlList) {
            wsdlVersion.setWsdlId((Long)wsdlIdsMap.get(wsdlVersion.getWsdlId()));
        }
        this.eaiEditApiWsdlService.saveBatch(eaiEditApiWsdlList);
        if (HussarUtils.isNotEmpty(wsdlIdsMap)) {
            commonResourcesIdMap.setWsdlMap(wsdlIdsMap);
        }
    }
}

